/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.asset.service.impl;

import com.ejianc.business.asset.bean.AmortizeSetEntity;
import com.ejianc.business.asset.bean.AssetAmortizeEntity;
import com.ejianc.business.asset.mapper.AssetAmortizeMapper;
import com.ejianc.business.asset.service.IAmortizeSetService;
import com.ejianc.business.asset.service.IAssetAmortizeService;
import com.ejianc.business.asset.vo.AssetAmortizeDetailVO;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="assetAmortizeService")
public class AssetAmortizeServiceImpl
extends BaseServiceImpl<AssetAmortizeMapper, AssetAmortizeEntity>
implements IAssetAmortizeService {
    @Autowired
    private IAmortizeSetService amortizeSetService;

    @Override
    public void getAmortizeSet(List<AssetAmortizeDetailVO> detailList) {
        Map<Long, Long> euipmentsMap = detailList.stream().collect(Collectors.toMap(AssetAmortizeDetailVO::getEquipmentId, AssetAmortizeDetailVO::getEquipmentTypeId));
        Map<Long, AmortizeSetEntity> amortizeSetMap = this.amortizeSetService.getSet(euipmentsMap);
        for (AssetAmortizeDetailVO detailVO : detailList) {
            Long equipmentId = detailVO.getEquipmentId();
            AmortizeSetEntity amortizeSetEntity = amortizeSetMap.get(equipmentId);
            if (amortizeSetEntity != null) {
                detailVO.setAmortizeSetId(amortizeSetEntity.getId());
                detailVO.setUsePeriod(amortizeSetEntity.getUsePeriod());
                detailVO.setResidualValueRate(amortizeSetEntity.getResidualValueRate());
                continue;
            }
            detailVO.setErrMsg("\u672a\u83b7\u53d6\u5230\u8be5\u8bbe\u5907\u7684\u644a\u9500\u8bbe\u7f6e\uff01");
        }
    }

    @Override
    public void caclAmortizeMny(List<AssetAmortizeDetailVO> detailList, Date amortizeDate) {
        for (AssetAmortizeDetailVO detailVO : detailList) {
            Date lastAmortizeDate = detailVO.getLastAmortizeDate();
            Date startAmortizeDate = null;
            boolean isHasThis = false;
            if (lastAmortizeDate == null) {
                isHasThis = true;
                startAmortizeDate = detailVO.getCheckDate();
            } else {
                startAmortizeDate = lastAmortizeDate;
            }
            int thisAmortizeNum = AssetAmortizeServiceImpl.getMonthBetweenDate(startAmortizeDate, amortizeDate, isHasThis);
            detailVO.setThisAmortizeNum(Integer.valueOf(thisAmortizeNum));
            BigDecimal netWorthTax = detailVO.getNetWorthTax();
            BigDecimal residualValueTax = detailVO.getResidualValueTax();
            BigDecimal netWorth = detailVO.getNetWorth();
            BigDecimal residualValue = detailVO.getResidualValue();
            BigDecimal usedAmortizeNum = ComputeUtil.toBigDecimal((Integer)detailVO.getUsedAmortizeNum());
            BigDecimal usePeriod = ComputeUtil.toBigDecimal((Integer)detailVO.getUsePeriod());
            BigDecimal usedAmortizeNumHaveThis = ComputeUtil.safeAdd((BigDecimal)ComputeUtil.toBigDecimal((Integer)detailVO.getThisAmortizeNum()), (BigDecimal)usedAmortizeNum);
            BigDecimal picOriginalValueTax = ComputeUtil.safeDiv((BigDecimal)detailVO.getOriginalValueTax(), (BigDecimal)ComputeUtil.toBigDecimal((Integer)detailVO.getUsePeriod()));
            BigDecimal picOriginalValue = ComputeUtil.safeDiv((BigDecimal)detailVO.getOriginalValue(), (BigDecimal)ComputeUtil.toBigDecimal((Integer)detailVO.getUsePeriod()));
            BigDecimal thisAmortizeMnyTax = ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.toBigDecimal((Integer)thisAmortizeNum), (BigDecimal)picOriginalValueTax);
            BigDecimal thisAmortizeMny = ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.toBigDecimal((Integer)thisAmortizeNum), (BigDecimal)picOriginalValue);
            BigDecimal maxAmortizeMnyTax = ComputeUtil.safeSub((BigDecimal)netWorthTax, (BigDecimal)residualValueTax);
            BigDecimal maxAmortizeMny = ComputeUtil.safeSub((BigDecimal)netWorth, (BigDecimal)residualValue);
            if (ComputeUtil.isLessOrEqual((BigDecimal)maxAmortizeMnyTax, (BigDecimal)BigDecimal.ZERO)) {
                detailVO.setAmortizeMnyTax(BigDecimal.ZERO);
                detailVO.setAmortizeMny(BigDecimal.ZERO);
            } else if (ComputeUtil.isGreaterOrEqual((BigDecimal)usedAmortizeNumHaveThis, (BigDecimal)usePeriod)) {
                detailVO.setAmortizeMnyTax(ComputeUtil.safeSub((BigDecimal)netWorthTax, (BigDecimal)residualValueTax));
                detailVO.setAmortizeMny(ComputeUtil.safeSub((BigDecimal)netWorth, (BigDecimal)residualValue));
            } else if (ComputeUtil.isGreaterThan((BigDecimal)thisAmortizeMnyTax, (BigDecimal)maxAmortizeMnyTax)) {
                detailVO.setAmortizeMnyTax(maxAmortizeMnyTax);
                detailVO.setAmortizeMny(maxAmortizeMny);
            } else {
                detailVO.setAmortizeMnyTax(thisAmortizeMnyTax);
                detailVO.setAmortizeMny(thisAmortizeMny);
            }
            BigDecimal amortizeRate = ComputeUtil.bigDecimalPercent((BigDecimal)detailVO.getAmortizeMnyTax(), (BigDecimal)detailVO.getOriginalValueTax(), (int)2);
            detailVO.setAmortizeRate(amortizeRate);
        }
    }

    public static int getMonthBetweenDate(Date startDate, Date endDate, boolean isHasThis) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
        ArrayList<String> list = new ArrayList<String>();
        Calendar calendar = Calendar.getInstance();
        while (startDate.getTime() <= endDate.getTime()) {
            if (isHasThis) {
                list.add(sdf.format(startDate));
            }
            calendar.setTime(startDate);
            calendar.add(2, 1);
            startDate = calendar.getTime();
        }
        return list.size();
    }
}

