/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.asset.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.asset.bean.AssetAmortizeDetailEntity;
import com.ejianc.business.asset.bean.AssetAmortizeEntity;
import com.ejianc.business.asset.bean.AssetEntity;
import com.ejianc.business.asset.service.IAssetAmortizeService;
import com.ejianc.business.asset.service.IAssetService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="assetAmortize")
public class AssetAmortizeBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IAssetAmortizeService assetAmortizeService;
    @Autowired
    private IAssetService assetService;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        AssetAmortizeEntity assetAmortizeEntity = (AssetAmortizeEntity)((Object)this.assetAmortizeService.selectById(billId));
        List<AssetAmortizeDetailEntity> detailList = assetAmortizeEntity.getDetailList();
        if (CollectionUtils.isNotEmpty(detailList)) {
            Date amortizeDate = assetAmortizeEntity.getAmortizeDate();
            Long orgId = assetAmortizeEntity.getOrgId();
            for (AssetAmortizeDetailEntity entity : detailList) {
                Long assetId = entity.getAssetId();
                BigDecimal amortizeMnyTax = entity.getAmortizeMnyTax();
                BigDecimal amortizeMny = entity.getAmortizeMny();
                AssetEntity assetEntity = (AssetEntity)((Object)this.assetService.selectById(assetId));
                BigDecimal sumAmortizeTaxMny = ComputeUtil.safeAdd((BigDecimal)amortizeMnyTax, (BigDecimal)assetEntity.getLastAmortizeTaxMny());
                BigDecimal sumAmortizeMny = ComputeUtil.safeAdd((BigDecimal)amortizeMny, (BigDecimal)assetEntity.getLastAmortizeMny());
                BigDecimal netWorthTax = ComputeUtil.safeSub((BigDecimal)assetEntity.getOriginalValueTax(), (BigDecimal)sumAmortizeTaxMny);
                BigDecimal netWorth = ComputeUtil.safeSub((BigDecimal)assetEntity.getOriginalValue(), (BigDecimal)sumAmortizeMny);
                LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
                wrapper.eq(BaseEntity::getId, (Object)assetId);
                wrapper.eq(AssetEntity::getManageCompanyId, (Object)orgId);
                wrapper.set(AssetEntity::getLastAmortizeDate, (Object)amortizeDate);
                wrapper.set(AssetEntity::getLastAmortizeTaxMny, (Object)sumAmortizeTaxMny);
                wrapper.set(AssetEntity::getLastAmortizeMny, (Object)sumAmortizeMny);
                wrapper.set(AssetEntity::getNetWorthTax, (Object)netWorthTax);
                wrapper.set(AssetEntity::getNetWorth, (Object)netWorth);
                this.assetService.update((Wrapper)wrapper);
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        AssetAmortizeEntity assetAmortizeEntity = (AssetAmortizeEntity)((Object)this.assetAmortizeService.selectById(billId));
        List<AssetAmortizeDetailEntity> detailList = assetAmortizeEntity.getDetailList();
        if (CollectionUtils.isNotEmpty(detailList)) {
            for (AssetAmortizeDetailEntity entity : detailList) {
                Long assetId = entity.getAssetId();
                Long orgId = assetAmortizeEntity.getOrgId();
                BigDecimal amortizeMnyTax = entity.getAmortizeMnyTax();
                BigDecimal amortizeMny = entity.getAmortizeMny();
                AssetEntity assetEntity = (AssetEntity)((Object)this.assetService.selectById(assetId));
                BigDecimal sumAmortizeTaxMny = ComputeUtil.safeSub((BigDecimal)assetEntity.getLastAmortizeTaxMny(), (BigDecimal)amortizeMnyTax);
                BigDecimal sumAmortizeMny = ComputeUtil.safeSub((BigDecimal)assetEntity.getLastAmortizeMny(), (BigDecimal)amortizeMny);
                BigDecimal netWorthTax = ComputeUtil.safeSub((BigDecimal)assetEntity.getOriginalValueTax(), (BigDecimal)sumAmortizeTaxMny);
                BigDecimal netWorth = ComputeUtil.safeSub((BigDecimal)assetEntity.getOriginalValue(), (BigDecimal)sumAmortizeMny);
                LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
                wrapper.eq(BaseEntity::getId, (Object)assetId);
                wrapper.eq(AssetEntity::getManageCompanyId, (Object)orgId);
                wrapper.set(AssetEntity::getLastAmortizeDate, (Object)entity.getLastAmortizeDate());
                wrapper.set(AssetEntity::getLastAmortizeTaxMny, (Object)sumAmortizeTaxMny);
                wrapper.set(AssetEntity::getLastAmortizeMny, (Object)sumAmortizeMny);
                wrapper.set(AssetEntity::getNetWorthTax, (Object)netWorthTax);
                wrapper.set(AssetEntity::getNetWorth, (Object)netWorth);
                this.assetService.update((Wrapper)wrapper);
            }
        }
        return CommonResponse.success();
    }
}

