/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.purchaseplan.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.purchase.service.IChangeEquipmentDetailedService;
import com.ejianc.business.purchase.service.IEquipmentDetailedService;
import com.ejianc.business.purchaseplan.bean.PurchasePlanDetailedEntity;
import com.ejianc.business.purchaseplan.bean.PurchasePlanEntity;
import com.ejianc.business.purchaseplan.service.IPurchasePlanService;
import com.ejianc.business.purchaseplan.vo.PurchasePlanEnum;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="purchasePlan")
public class PurchasePlanBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IPurchasePlanService service;
    @Autowired
    private IEquipmentDetailedService detailedService;
    @Autowired
    private IChangeEquipmentDetailedService changeDetailedService;
    @Autowired
    private IBillTypeApi billTypeApi;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        PurchasePlanEntity planEntity = (PurchasePlanEntity)((Object)this.service.selectById(billId));
        List<PurchasePlanDetailedEntity> subEntityList = planEntity.getDetailList();
        if (CollectionUtils.isNotEmpty(subEntityList)) {
            List batchIds = subEntityList.stream().map(BaseEntity::getId).collect(Collectors.toList());
            QueryWrapper queryDetaile = new QueryWrapper();
            queryDetaile.in((Object)"source_id", batchIds);
            queryDetaile.eq((Object)"dr", (Object)0);
            List equipmentList = this.detailedService.list((Wrapper)queryDetaile);
            QueryWrapper queryChangeDetaile = new QueryWrapper();
            queryChangeDetaile.in((Object)"source_id", batchIds);
            queryChangeDetaile.eq((Object)"dr", (Object)0);
            List changeEquipmentList = this.changeDetailedService.list((Wrapper)queryChangeDetaile);
            if (CollectionUtils.isNotEmpty((Collection)equipmentList) || CollectionUtils.isNotEmpty((Collection)changeEquipmentList)) {
                return CommonResponse.error((String)"\u6e05\u5355\u88ab\u4e0b\u6e38\u5355\u636e\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u56de\u9000!");
            }
            if (PurchasePlanEnum.PLAN_STATE_WAIT.getPlanState().equals(planEntity.getPlanState())) {
                return CommonResponse.success();
            }
            CommonResponse resp = this.billTypeApi.checkQuote(billTypeCode, billId);
            if (!resp.isSuccess()) {
                return CommonResponse.error((String)"\u5355\u636e\u88ab\u5f15\u7528\u4e0d\u80fd\u64a4\u56de\uff01");
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }
}

