package com.ejianc.business.asset.service;

import com.ejianc.business.asset.vo.AmortizeSetVO;
import com.ejianc.business.asset.vo.AssetAmortizeDetailVO;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.asset.bean.AmortizeSetEntity;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 固定资产摊销设置
 *
 * @author generator
 */
public interface IAmortizeSetService extends IBaseService<AmortizeSetEntity> {

    AmortizeSetVO saveOrUpdate(AmortizeSetVO saveOrUpdateVO);

    String turnSwitch(AmortizeSetVO vo);

    /**
     * @param equipments key:equipmentId  value:equipmentTypeId
     * @description: 根据设备id和分类id获取对应摊销设置
     * @return: Map key:equipmentId  value:AmortizeSetEntity
     * @author songlx
     * @date: 2022/7/18
     */
    Map<Long, AmortizeSetEntity> getSet(Map<Long, Long> equipments);


}
