package com.ejianc.business.asset.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.asset.bean.AssetAllotOutEntity;
import com.ejianc.business.asset.service.IAssetAllotOutService;
import com.ejianc.business.asset.service.IAssetRecordService;
import com.ejianc.business.asset.vo.AssetAllotInVO;
import com.ejianc.business.consts.AllocatEnum;
import com.ejianc.business.consts.AllocationState;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.asset.mapper.AssetAllotInMapper;
import com.ejianc.business.asset.bean.AssetAllotInEntity;
import com.ejianc.business.asset.service.IAssetAllotInService;

import javax.servlet.http.HttpServletResponse;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 固定资产调入表
 * 
 * @author generator
 * 
 */
@Service("assetAllotInService")
public class AssetAllotInServiceImpl extends BaseServiceImpl<AssetAllotInMapper, AssetAllotInEntity> implements IAssetAllotInService{

    @Autowired
    private IAssetAllotInService service;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IAssetAllotOutService assetAllotOutService;
    @Autowired
    private IAssetRecordService assetRecordService;

    @Override
    public void excelExport(QueryParam param, HttpServletResponse response) {
/** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("equipmentNames");
        fuzzyFields.add("outProjectName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("receiverPerson");
        fuzzyFields.add("billCode");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<AssetAllotInEntity> list = service.queryList(param);
        List<AssetAllotInVO> allotInVos = BeanMapper.mapList(list, AssetAllotInVO.class);
        allotInVos.forEach(vo->{
            vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
            if(vo.getReceiveState()!=null){
                if (Integer.valueOf(AllocationState.TO_RECEIVING.getCode()).equals(vo.getReceiveState())){
                    vo.setReceiveStateName(AllocationState.TO_RECEIVING.getDescription());
                }
                else if (Integer.valueOf(AllocationState.RECEIVED.getCode()).equals(vo.getReceiveState())){
                    vo.setReceiveStateName(AllocationState.RECEIVED.getDescription());
                }
                else if (Integer.valueOf(AllocationState.REJECT.getCode()).equals(vo.getReceiveState())){
                    vo.setReceiveStateName(AllocationState.REJECT.getDescription());
                }
            }
            if (vo.getAllocatType()!=null){
                if (Integer.valueOf(AllocatEnum.ASSETS.getCode()).equals(vo.getAllocatType())){
                    vo.setAllocatTypeName(AllocatEnum.ASSETS.getDescription());
                }
                else {
                    vo.setAllocatTypeName(AllocatEnum.HOMEMADE.getDescription());
                }
            }
        });
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", allotInVos);
        ExcelExport.getInstance().export("AssetAllotIn-export.xlsx", beans, response);
    }

    @Override
    public CommonResponse<String> sureToReceive(AssetAllotInVO vo) {
        AssetAllotInEntity entity = service.selectById(vo.getId());
        if (entity == null) {
            return CommonResponse.error("没有找到该单据！");
        }
        LambdaUpdateWrapper<AssetAllotInEntity> allotinWrapper = new LambdaUpdateWrapper<>();
        allotinWrapper.eq(AssetAllotInEntity::getId, vo.getId());
        allotinWrapper.set(AssetAllotInEntity::getReceiveDate, vo.getReceiveDate());
        allotinWrapper.set(AssetAllotInEntity::getOrgId,vo.getOrgId());
        allotinWrapper.set(AssetAllotInEntity::getBillState, BillStateEnum.COMMITED_STATE.getBillStateCode());
        allotinWrapper.set(AssetAllotInEntity::getReceiveState, Integer.parseInt(AllocationState.RECEIVED.getCode()));
        allotinWrapper.set(AssetAllotInEntity::getPassDate, vo.getPassDate());
        allotinWrapper.set(AssetAllotInEntity::getReceiverPersonId, vo.getReceiverPersonId());
        allotinWrapper.set(AssetAllotInEntity::getReceiverPerson, vo.getReceiverPerson());
        boolean b = service.update(allotinWrapper);
        //会写调拨出库
        if (b) {
            LambdaUpdateWrapper<AssetAllotOutEntity> wrapper = new LambdaUpdateWrapper<>();
            wrapper.eq(AssetAllotOutEntity::getId, entity.getAllocatOutId());
            wrapper.set(AssetAllotOutEntity::getReceiveState, Integer.parseInt(AllocationState.RECEIVED.getCode()));
            wrapper.set(AssetAllotOutEntity::getReceiverPersonId, vo.getReceiverPersonId());
            wrapper.set(AssetAllotOutEntity::getReceiverPerson, vo.getReceiverPerson());
            wrapper.set(AssetAllotOutEntity::getReceiveDate, vo.getReceiveDate());
            assetAllotOutService.update(wrapper);
            //生成设备流转记录
            AssetAllotInVO allotInVO = BeanMapper.map(entity, AssetAllotInVO.class);
            assetRecordService.saveRecord(allotInVO);
        }
        return CommonResponse.success("确认收料成功！");
    }

    @Override
    public CommonResponse<String> sureToReturn(AssetAllotInVO vo) {
        AssetAllotInEntity entity = service.selectById(vo.getId());
        if (entity == null) {
            return CommonResponse.error("没有找到该单据！");
        }
        LambdaUpdateWrapper<AssetAllotInEntity> wrapper = new LambdaUpdateWrapper<>();
        wrapper.eq(AssetAllotInEntity::getId, entity.getId());
        wrapper.set(AssetAllotInEntity::getBillState, BillStateEnum.COMMITED_STATE.getBillStateCode());
        wrapper.set(AssetAllotInEntity::getReceiveState, Integer.parseInt(AllocationState.REJECT.getCode()));
        wrapper.set(AssetAllotInEntity::getReceiveDate, vo.getReceiveDate());
        wrapper.set(AssetAllotInEntity::getReceiverPersonId, vo.getReceiverPersonId());
        wrapper.set(AssetAllotInEntity::getReceiverPerson, vo.getReceiverPerson());
        wrapper.set(AssetAllotInEntity::getReturnReason, vo.getReturnReason());

        boolean update = service.update(wrapper);
        if (update) {
            //会写调拨出库 设置为自由态
            LambdaUpdateWrapper<AssetAllotOutEntity> allotOutWrapper = new LambdaUpdateWrapper<>();
            allotOutWrapper.eq(AssetAllotOutEntity::getId, entity.getAllocatOutId());
            allotOutWrapper.set(AssetAllotOutEntity::getReceiveState, Integer.parseInt(AllocationState.REJECT.getCode()));
            allotOutWrapper.set(AssetAllotOutEntity::getBillState, BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            allotOutWrapper.set(AssetAllotOutEntity::getReturnReason, vo.getReturnReason());
            allotOutWrapper.set(AssetAllotOutEntity::getReceiverPersonId, vo.getReceiverPersonId());
            allotOutWrapper.set(AssetAllotOutEntity::getReceiverPerson, vo.getReceiverPerson());
            allotOutWrapper.set(AssetAllotOutEntity::getRelationFlag, 0);//(1:是，0：否)
            assetAllotOutService.update(allotOutWrapper);
            //删除设备流转记录
            assetRecordService.delRecord(entity.getId());
        }
        return CommonResponse.success("确认收料成功！");
    }
}
