package com.ejianc.business.asset.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.acceptance.bean.PurchaseAcceptanceEntity;
import com.ejianc.business.acceptance.bean.PurchaseAcceptanceSubEntity;
import com.ejianc.business.acceptance.service.IPurchaseAcceptanceService;
import com.ejianc.business.asset.bean.AmortizeSetEntity;
import com.ejianc.business.asset.service.IAmortizeSetService;
import com.ejianc.business.asset.service.IAssetRecordService;
import com.ejianc.business.asset.vo.AssetVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.asset.mapper.AssetMapper;
import com.ejianc.business.asset.bean.AssetEntity;
import com.ejianc.business.asset.service.IAssetService;


import java.math.BigDecimal;
import java.util.*;

/**
 *  固定资产
 * 
 * @author generator
 * 
 */
@Service("assetService")
public class AssetServiceImpl extends BaseServiceImpl<AssetMapper, AssetEntity> implements IAssetService{
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IPurchaseAcceptanceService purchaseAcceptanceService;
    @Autowired
    private IAssetService assetService;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IAssetRecordService assetRecordService;
    @Autowired
    private IAmortizeSetService  amortizeSetService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private AssetMapper assetMapper;

    private static final String BILL_CODE = "ASSET_Bli_CODE";//此处需要根据实际修改
    @Override
    public void pushAsset(Long billId) {
        PurchaseAcceptanceEntity purchaseAcceptanceEntity = purchaseAcceptanceService.selectById(billId);
        AssetEntity entity = new AssetEntity();
        if (Optional.ofNullable(purchaseAcceptanceEntity).isPresent()){
            //封装数据 组织信息
            entity.setOrgId(purchaseAcceptanceEntity.getOrgId());
            entity.setOrgName(purchaseAcceptanceEntity.getOrgName());
            entity.setOrgCode(purchaseAcceptanceEntity.getOrgCode());
            entity.setParentOrgId(purchaseAcceptanceEntity.getParentOrgId());
            entity.setParentOrgName(purchaseAcceptanceEntity.getParentOrgName());
            entity.setParentOrgCode(purchaseAcceptanceEntity.getParentOrgCode());
            entity.setPropertyRightCompanyId(purchaseAcceptanceEntity.getPropertyRightCompanyId());
            entity.setPropertyRightCompany(purchaseAcceptanceEntity.getPropertyRightCompany());
            entity.setManageCompanyId(purchaseAcceptanceEntity.getManageCompanyId());
            entity.setManageCompany(purchaseAcceptanceEntity.getManageCompany());
            entity.setPropertyRightCompany(purchaseAcceptanceEntity.getPropertyRightCompany());
            //封装数据 项目信息
            entity.setProjectId(purchaseAcceptanceEntity.getProjectId());
            entity.setProjectName(purchaseAcceptanceEntity.getProjectName());
            //设置编制人
            entity.setEmployeeId(sessionManager.getUserContext().getUserId());
            entity.setEmployeeName(sessionManager.getUserContext().getUserName());
            entity.setDepartmentId(sessionManager.getUserContext().getDeptId());
            entity.setDepartmentName(sessionManager.getUserContext().getDeptName());
            List<PurchaseAcceptanceSubEntity> purchaseAcceptanceSubList = purchaseAcceptanceEntity.getPurchaseAcceptanceSubList();
            if (CollectionUtils.isNotEmpty(purchaseAcceptanceSubList)){
                //一只只能验收一台设备
                PurchaseAcceptanceSubEntity purchaseAcceptanceSubEntity = purchaseAcceptanceSubList.get(0);
                //原值 净值
                entity.setOriginalValueTax(purchaseAcceptanceSubEntity.getPurchasePrice());
                BigDecimal tax = ComputeUtil.safeMultiply(purchaseAcceptanceSubEntity.getPurchasePrice(), purchaseAcceptanceSubEntity.getTaxRate());
                BigDecimal originalValue = ComputeUtil.safeSub(purchaseAcceptanceSubEntity.getPurchasePrice(), tax);
                entity.setOriginalValue(originalValue);
                entity.setTaxRate(purchaseAcceptanceSubEntity.getTaxRate());
                entity.setNetWorth(originalValue);
                entity.setNetWorthTax(purchaseAcceptanceSubEntity.getPurchasePrice());
                //todo 残值没有设置
                //封装设备信息
                entity.setEquipmentId(purchaseAcceptanceSubEntity.getEquipmentId());
                entity.setEquipmentName(purchaseAcceptanceSubEntity.getEquipmentName());
                entity.setEquipmentCode(purchaseAcceptanceSubEntity.getEquipmentCode());
                entity.setEquipmentTypeId(purchaseAcceptanceSubEntity.getEquipmentTypeId());
                entity.setEquipmentTypeName(purchaseAcceptanceSubEntity.getEquipmentType());
                entity.setEquipmentTypeCode(purchaseAcceptanceSubEntity.getEquipmentCode());
                entity.setSpec(purchaseAcceptanceSubEntity.getSpec());
//                entity.setUnitId(purchaseAcceptanceSubEntity.getCompanyId());
                entity.setUnit(purchaseAcceptanceSubEntity.getCompany());
                entity.setEquipmentStatus(1);
                entity.setAssetStatus(0);
                //大于2000 资产类型 1:固定资产 2:普通资产
                if (purchaseAcceptanceSubEntity.getPurchasePrice().compareTo(new BigDecimal(2000))!=-1){
                  entity.setAssetType(1);
                }else {
                    entity.setAssetType(2);
                }
                Map<Long, Long> amortizeSetmap = new HashMap<>();
                amortizeSetmap.put(purchaseAcceptanceSubEntity.getEquipmentId(),purchaseAcceptanceSubEntity.getEquipmentTypeId());
                logger.info("调用固定资产摊销设置:"+JSONObject.toJSONString(entity));
                Map<Long, AmortizeSetEntity> amortizeMap = amortizeSetService.getSet(amortizeSetmap);
                AmortizeSetEntity amortizeSetEntity = amortizeMap.get(purchaseAcceptanceSubEntity.getEquipmentId());
                if (amortizeSetEntity!=null){
                    BigDecimal residualValueRate = amortizeSetEntity.getResidualValueRate();
                    entity.setResidualValueRate(residualValueRate);
                    logger.info("调用固定资产摊销设置残值率残值率:"+residualValueRate);
                    BigDecimal residualValueTax = ComputeUtil.safeMultiply(residualValueRate,
                            purchaseAcceptanceSubEntity.getPurchasePrice());
                    BigDecimal residualValue = ComputeUtil.safeMultiply(residualValueRate,
                            originalValue);
                    entity.setResidualValueTax(residualValueTax);
                    entity.setResidualValue(residualValue);
                    entity.setAmortizeType(1);
                }
            }
            entity.setFinancePushFlag(purchaseAcceptanceEntity.getFinancePushFlag());
            //// 来源 1：验收 2：期初 3：调拨
            entity.setSourceType(1);
            entity.setFinancePushState(0);
            entity.setCheckDate(purchaseAcceptanceEntity.getAcceptanceDate());
            //设备出厂指标
            entity.setProductionDate(purchaseAcceptanceEntity.getProductionDate());
            entity.setManufacturer(purchaseAcceptanceEntity.getManufacturer());
            entity.setCertificateNum(purchaseAcceptanceEntity.getCertificateNum());
            entity.setLeaveFactoryCode(purchaseAcceptanceEntity.getLeaveFactoryCode());
            entity.setRandomTool(purchaseAcceptanceEntity.getRandomTool());
            entity.setAbility(purchaseAcceptanceEntity.getAbility());
            entity.setWeight(purchaseAcceptanceEntity.getWeight());
            entity.setPower(purchaseAcceptanceEntity.getPower());
            entity.setOwnWeight(purchaseAcceptanceEntity.getOwnWeight());
            entity.setAppearanceSize(purchaseAcceptanceEntity.getAppearanceSize());
            entity.setModelExplain(purchaseAcceptanceEntity.getModelExplain());
            entity.setSupplierId(purchaseAcceptanceEntity.getSupplierId());
            entity.setSupplierName(purchaseAcceptanceEntity.getSupplierName());
            entity.setLastAmortizeDate(new Date());
            entity.setPurchaseAcceptanceId(purchaseAcceptanceEntity.getId());
            entity.setBillState(1);
            //复制附件
            AssetVO vo = BeanMapper.map(entity, AssetVO.class);
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(),vo);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        logger.info("推送设备卡片的信息:"+JSONObject.toJSONString(entity));
        boolean b = assetService.saveOrUpdate(entity, false);
        CommonResponse<String> commonResponse =
                attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(purchaseAcceptanceEntity.getId()),
                        "BT220323000000007", "photoPath", String.valueOf(entity.getId()), "EJCBT202206000070",
                        "ASSET002");
        logger.info("复制图片:"+commonResponse.isSuccess());
        logger.info("复制图片返回的内容:"+commonResponse.getData());
        //从验收过来生成设备流转记录
        if (b){
            AssetVO vo = BeanMapper.map(entity, AssetVO.class);
            logger.info("设备验收推送设备流转记录的信息:"+JSONObject.toJSONString(vo));
            assetRecordService.saveRecord(vo);
        }
    }

    @Override
    public List<AssetVO> queryAssetPage(Page<AssetVO> page, QueryWrapper wrapper,List<Long> orgIds) {
        return assetMapper.queryAssetPage(page,wrapper,orgIds);
    }
}
