/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.asset.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.acceptance.bean.PurchaseAcceptanceEntity;
import com.ejianc.business.acceptance.bean.PurchaseAcceptanceSubEntity;
import com.ejianc.business.acceptance.service.IPurchaseAcceptanceService;
import com.ejianc.business.asset.bean.AmortizeSetEntity;
import com.ejianc.business.asset.bean.AssetEntity;
import com.ejianc.business.asset.mapper.AssetMapper;
import com.ejianc.business.asset.service.IAmortizeSetService;
import com.ejianc.business.asset.service.IAssetRecordService;
import com.ejianc.business.asset.service.IAssetService;
import com.ejianc.business.asset.vo.AssetVO;
import com.ejianc.business.decorator.IAssetRecord;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="assetService")
public class AssetServiceImpl
extends BaseServiceImpl<AssetMapper, AssetEntity>
implements IAssetService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IPurchaseAcceptanceService purchaseAcceptanceService;
    @Autowired
    private IAssetService assetService;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IAssetRecordService assetRecordService;
    @Autowired
    private IAmortizeSetService amortizeSetService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private AssetMapper assetMapper;
    private static final String BILL_CODE = "ASSET_Bli_CODE";

    @Override
    public void pushAsset(Long billId) {
        PurchaseAcceptanceEntity purchaseAcceptanceEntity = (PurchaseAcceptanceEntity)((Object)this.purchaseAcceptanceService.selectById(billId));
        AssetEntity entity = new AssetEntity();
        if (Optional.ofNullable(purchaseAcceptanceEntity).isPresent()) {
            entity.setOrgId(purchaseAcceptanceEntity.getOrgId());
            entity.setOrgName(purchaseAcceptanceEntity.getOrgName());
            entity.setOrgCode(purchaseAcceptanceEntity.getOrgCode());
            entity.setParentOrgId(purchaseAcceptanceEntity.getParentOrgId());
            entity.setParentOrgName(purchaseAcceptanceEntity.getParentOrgName());
            entity.setParentOrgCode(purchaseAcceptanceEntity.getParentOrgCode());
            entity.setPropertyRightCompanyId(purchaseAcceptanceEntity.getPropertyRightCompanyId());
            entity.setPropertyRightCompany(purchaseAcceptanceEntity.getPropertyRightCompany());
            entity.setManageCompanyId(purchaseAcceptanceEntity.getManageCompanyId());
            entity.setManageCompany(purchaseAcceptanceEntity.getManageCompany());
            entity.setPropertyRightCompany(purchaseAcceptanceEntity.getPropertyRightCompany());
            entity.setProjectId(purchaseAcceptanceEntity.getProjectId());
            entity.setProjectName(purchaseAcceptanceEntity.getProjectName());
            entity.setEmployeeId(this.sessionManager.getUserContext().getUserId());
            entity.setEmployeeName(this.sessionManager.getUserContext().getUserName());
            entity.setDepartmentId(this.sessionManager.getUserContext().getDeptId());
            entity.setDepartmentName(this.sessionManager.getUserContext().getDeptName());
            List<PurchaseAcceptanceSubEntity> purchaseAcceptanceSubList = purchaseAcceptanceEntity.getPurchaseAcceptanceSubList();
            if (CollectionUtils.isNotEmpty(purchaseAcceptanceSubList)) {
                PurchaseAcceptanceSubEntity purchaseAcceptanceSubEntity = purchaseAcceptanceSubList.get(0);
                entity.setOriginalValueTax(purchaseAcceptanceSubEntity.getPurchasePrice());
                BigDecimal tax = ComputeUtil.safeMultiply((BigDecimal)purchaseAcceptanceSubEntity.getPurchasePrice(), (BigDecimal)purchaseAcceptanceSubEntity.getTaxRate());
                BigDecimal originalValue = ComputeUtil.safeSub((BigDecimal)purchaseAcceptanceSubEntity.getPurchasePrice(), (BigDecimal)tax);
                entity.setOriginalValue(originalValue);
                entity.setTaxRate(purchaseAcceptanceSubEntity.getTaxRate());
                entity.setNetWorth(originalValue);
                entity.setNetWorthTax(purchaseAcceptanceSubEntity.getPurchasePrice());
                entity.setEquipmentId(purchaseAcceptanceSubEntity.getEquipmentId());
                entity.setEquipmentName(purchaseAcceptanceSubEntity.getEquipmentName());
                entity.setEquipmentCode(purchaseAcceptanceSubEntity.getEquipmentCode());
                entity.setEquipmentTypeId(purchaseAcceptanceSubEntity.getEquipmentTypeId());
                entity.setEquipmentTypeName(purchaseAcceptanceSubEntity.getEquipmentType());
                entity.setEquipmentTypeCode(purchaseAcceptanceSubEntity.getEquipmentCode());
                entity.setSpec(purchaseAcceptanceSubEntity.getSpec());
                entity.setUnit(purchaseAcceptanceSubEntity.getCompany());
                entity.setEquipmentStatus(1);
                entity.setAssetStatus(0);
                if (purchaseAcceptanceSubEntity.getPurchasePrice().compareTo(new BigDecimal(2000)) != -1) {
                    entity.setAssetType(1);
                } else {
                    entity.setAssetType(2);
                }
                HashMap<Long, Long> amortizeSetmap = new HashMap<Long, Long>();
                amortizeSetmap.put(purchaseAcceptanceSubEntity.getEquipmentId(), purchaseAcceptanceSubEntity.getEquipmentTypeId());
                this.logger.info("\u8c03\u7528\u56fa\u5b9a\u8d44\u4ea7\u644a\u9500\u8bbe\u7f6e:" + JSONObject.toJSONString((Object)((Object)entity)));
                Map<Long, AmortizeSetEntity> amortizeMap = this.amortizeSetService.getSet(amortizeSetmap);
                AmortizeSetEntity amortizeSetEntity = amortizeMap.get(purchaseAcceptanceSubEntity.getEquipmentId());
                if (amortizeSetEntity != null) {
                    BigDecimal residualValueRate = amortizeSetEntity.getResidualValueRate();
                    entity.setResidualValueRate(residualValueRate);
                    this.logger.info("\u8c03\u7528\u56fa\u5b9a\u8d44\u4ea7\u644a\u9500\u8bbe\u7f6e\u6b8b\u503c\u7387\u6b8b\u503c\u7387:" + residualValueRate);
                    BigDecimal residualValueTax = ComputeUtil.safeMultiply((BigDecimal)residualValueRate, (BigDecimal)purchaseAcceptanceSubEntity.getPurchasePrice());
                    BigDecimal residualValue = ComputeUtil.safeMultiply((BigDecimal)residualValueRate, (BigDecimal)originalValue);
                    entity.setResidualValueTax(residualValueTax);
                    entity.setResidualValue(residualValue);
                    entity.setAmortizeType(1);
                }
            }
            entity.setFinancePushFlag(purchaseAcceptanceEntity.getFinancePushFlag());
            entity.setSourceType(1);
            entity.setFinancePushState(0);
            entity.setCheckDate(purchaseAcceptanceEntity.getAcceptanceDate());
            entity.setProductionDate(purchaseAcceptanceEntity.getProductionDate());
            entity.setManufacturer(purchaseAcceptanceEntity.getManufacturer());
            entity.setCertificateNum(purchaseAcceptanceEntity.getCertificateNum());
            entity.setLeaveFactoryCode(purchaseAcceptanceEntity.getLeaveFactoryCode());
            entity.setRandomTool(purchaseAcceptanceEntity.getRandomTool());
            entity.setAbility(purchaseAcceptanceEntity.getAbility());
            entity.setWeight(purchaseAcceptanceEntity.getWeight());
            entity.setPower(purchaseAcceptanceEntity.getPower());
            entity.setOwnWeight(purchaseAcceptanceEntity.getOwnWeight());
            entity.setAppearanceSize(purchaseAcceptanceEntity.getAppearanceSize());
            entity.setModelExplain(purchaseAcceptanceEntity.getModelExplain());
            entity.setSupplierId(purchaseAcceptanceEntity.getSupplierId());
            entity.setSupplierName(purchaseAcceptanceEntity.getSupplierName());
            entity.setLastAmortizeDate(new Date());
            entity.setPurchaseAcceptanceId(purchaseAcceptanceEntity.getId());
            entity.setBillState(1);
            AssetVO vo = (AssetVO)BeanMapper.map((Object)((Object)entity), AssetVO.class);
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)vo);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.logger.info("\u63a8\u9001\u8bbe\u5907\u5361\u7247\u7684\u4fe1\u606f:" + JSONObject.toJSONString((Object)((Object)entity)));
        boolean b = this.assetService.saveOrUpdate((Object)entity, false);
        CommonResponse commonResponse = this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(purchaseAcceptanceEntity.getId()), "BT220323000000007", "photoPath", String.valueOf(entity.getId()), "EJCBT202206000070", "ASSET002");
        this.logger.info("\u590d\u5236\u56fe\u7247:" + commonResponse.isSuccess());
        this.logger.info("\u590d\u5236\u56fe\u7247\u8fd4\u56de\u7684\u5185\u5bb9:" + (String)commonResponse.getData());
        if (b) {
            AssetVO vo = (AssetVO)BeanMapper.map((Object)((Object)entity), AssetVO.class);
            this.logger.info("\u8bbe\u5907\u9a8c\u6536\u63a8\u9001\u8bbe\u5907\u6d41\u8f6c\u8bb0\u5f55\u7684\u4fe1\u606f:" + JSONObject.toJSONString((Object)vo));
            this.assetRecordService.saveRecord((IAssetRecord)vo);
        }
    }

    @Override
    public List<AssetVO> queryAssetPage(Page<AssetVO> page, QueryWrapper wrapper, List<Long> orgIds) {
        return this.assetMapper.queryAssetPage(page, wrapper, orgIds);
    }
}

