package com.ejianc.business.asset.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.asset.bean.AmortizeSetEntity;
import com.ejianc.business.asset.mapper.AmortizeSetMapper;
import com.ejianc.business.asset.service.IAmortizeSetService;
import com.ejianc.business.asset.vo.AmortizeSetVO;
import com.ejianc.foundation.share.api.IShareEquipmentApi;
import com.ejianc.foundation.share.vo.EquipmentCategoryVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;

/**
 * 固定资产摊销设置
 *
 * @author generator
 */
@Service("amortizeSetService")
public class AmortizeSetServiceImpl extends BaseServiceImpl<AmortizeSetMapper, AmortizeSetEntity> implements IAmortizeSetService {



    @Autowired
    IShareEquipmentApi shareEquipmentApi;

    @Override
    public AmortizeSetVO saveOrUpdate(AmortizeSetVO saveOrUpdateVO) {
        // 校验同一组织下，同一分类或者同一设备唯一
        if (saveOrUpdateVO.getEnabled() == 1) {
            Integer typeFlag = saveOrUpdateVO.getTypeFlag();
            LambdaQueryWrapper<AmortizeSetEntity> lambd = new LambdaQueryWrapper<>();
            lambd.eq(AmortizeSetEntity::getOrgId, saveOrUpdateVO.getOrgId());
            lambd.eq(AmortizeSetEntity::getTypeFlag, typeFlag);
            if (typeFlag == 1) {
                lambd.eq(AmortizeSetEntity::getEquipmentTypeId, saveOrUpdateVO.getEquipmentTypeId());
            } else {
                lambd.eq(AmortizeSetEntity::getEquipmentId, saveOrUpdateVO.getEquipmentId());
            }
            lambd.ne(saveOrUpdateVO.getId() != null && saveOrUpdateVO.getId() > 0, AmortizeSetEntity::getId, saveOrUpdateVO.getId());

            int count = super.count(lambd);
            if (count > 0) {
                if (typeFlag == 1) {
                    throw new BusinessException("设备分类【" + saveOrUpdateVO.getEquipmentTypeName() + "】摊销设置已存在");
                } else {
                    throw new BusinessException("设备【名称：" + saveOrUpdateVO.getEquipmentName() + (StringUtils.isNotEmpty(saveOrUpdateVO.getSpec()) ? "，规格：" + saveOrUpdateVO.getSpec() : "") + "】摊销设置已存在");
                }
            }
        }
        AmortizeSetEntity entity = BeanMapper.map(saveOrUpdateVO, AmortizeSetEntity.class);
        this.saveOrUpdate(entity, false);
        return BeanMapper.map(entity, AmortizeSetVO.class);
    }

    @Override
    public String turnSwitch(AmortizeSetVO vo) {
        LambdaUpdateWrapper<AmortizeSetEntity> lambdUpdate = new LambdaUpdateWrapper<>();
        lambdUpdate.set(AmortizeSetEntity::getEnabled, vo.getEnabled());
        lambdUpdate.eq(AmortizeSetEntity::getId, vo.getId());
        boolean update = super.update(lambdUpdate);
        return update ? "操作成功！" : "操作失败！";

    }

    /**
     * @param equipments key:equipmentId  value:equipmentTypeId
     * @description: 根据设备id和分类id获取对应摊销设置
     * @return: Map key:equipmentId  value:AmortizeSetEntity
     * @author songlx
     * @date: 2022/7/18
     */
    @Override
    public Map<Long, AmortizeSetEntity> getSet(Map<Long, Long> equipments) {
        CommonResponse<List<EquipmentCategoryVO>> listCommonResponse = shareEquipmentApi.queryCategoryListByIds(new ArrayList<>(equipments.values()));
        HashMap<Long, List<Long>> equipTypeMap = new HashMap<>();
        if (listCommonResponse.isSuccess() && CollectionUtils.isNotEmpty(listCommonResponse.getData())) {
            List<EquipmentCategoryVO> data = listCommonResponse.getData();
            for (EquipmentCategoryVO categoryVO : data) {
                Long categoryVOId = categoryVO.getId();
                String innerCode = categoryVO.getInnerCode();
                String[] innerCodeArr = innerCode.split("\\|");
                for (int i = innerCodeArr.length - 1; i >= 0; i--) {
                    List<Long> pIds = equipTypeMap.get(categoryVOId);
                    Long pId = Long.valueOf(innerCodeArr[i]);
                    if (pIds == null) {
                        pIds = new ArrayList<>();
                        pIds.add(pId);
                        equipTypeMap.put(categoryVOId, pIds);
                    } else {
                        pIds.add(pId);
                    }
                }
            }
        }
        LambdaQueryWrapper<AmortizeSetEntity> lambdQuery = new LambdaQueryWrapper<>();
        lambdQuery.eq(AmortizeSetEntity::getOrgId, InvocationInfoProxy.getOrgId());
        lambdQuery.eq(AmortizeSetEntity::getEnabled, 1);
        List<AmortizeSetEntity> list = this.list(lambdQuery);
        Map<Long, AmortizeSetEntity> amortizeSetMap = new HashMap<>();
        for (AmortizeSetEntity amortizeSetEntity : list) {
            Long key = amortizeSetEntity.getEquipmentId() != null ? amortizeSetEntity.getEquipmentId() : amortizeSetEntity.getEquipmentTypeId();
            amortizeSetMap.put(key, amortizeSetEntity);
        }

        for (Long equipmentId : equipments.keySet()) {
            Long equipmentTypeId = equipments.get(equipmentId);
            //先根据设备匹配
            AmortizeSetEntity amortizeSetEntity = amortizeSetMap.get(equipmentId);
            if (amortizeSetEntity == null) {
                //分类匹配
                amortizeSetEntity = amortizeSetMap.get(equipmentTypeId);
                if (amortizeSetEntity == null) {
                    //上级分类匹配
                    List<Long> pIds = equipTypeMap.get(equipmentTypeId);
                    for (Long pId : pIds) {
                        amortizeSetEntity = amortizeSetMap.get(pId);
                        if (amortizeSetEntity != null) {
                            break;
                        }
                    }

                }
            }
            amortizeSetMap.put(equipmentId, amortizeSetEntity);
        }
        return amortizeSetMap;
    }

}
