/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.asset.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.asset.bean.AssetEntity;
import com.ejianc.business.asset.bean.AssetScrapDetailEntity;
import com.ejianc.business.asset.bean.AssetScrapEntity;
import com.ejianc.business.asset.service.IAssetRecordService;
import com.ejianc.business.asset.service.IAssetScrapService;
import com.ejianc.business.asset.service.IAssetService;
import com.ejianc.business.asset.vo.AssetScrapVO;
import com.ejianc.business.decorator.IAssetRecord;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="assetScrap")
public class AssetScrapBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IAssetService assetService;
    @Autowired
    private IAssetScrapService assetScrapService;
    @Autowired
    private IAssetRecordService assetRecordService;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        AssetScrapEntity assetScrapEntity = (AssetScrapEntity)((Object)this.assetScrapService.selectById(billId));
        if (assetScrapEntity != null && CollectionUtils.isNotEmpty(assetScrapEntity.getAssetScrapDetailList())) {
            List assetIds = assetScrapEntity.getAssetScrapDetailList().stream().map(AssetScrapDetailEntity::getAssetId).collect(Collectors.toList());
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.in((Object)"id", assetIds);
            queryWrapper.eq((Object)"asset_status", (Object)1);
            List assetEntities = this.assetService.list((Wrapper)queryWrapper);
            if (assetEntities.size() > 0) {
                return CommonResponse.error((String)"\u8bbe\u5907\u4fe1\u606f\u4e2d\u5b58\u5728\u8bbe\u5907\u5df2\u7ecf\u88ab\u62a5\u5e9f\u4e0d\u80fd\u518d\u88ab\u62a5\u5e9f!");
            }
            assetScrapEntity.getAssetScrapDetailList().forEach(item -> {
                LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
                wrapper.set(AssetEntity::getAssetStatus, (Object)1);
                wrapper.eq(BaseEntity::getId, (Object)item.getAssetId());
                this.assetService.update((Wrapper)wrapper);
            });
            AssetScrapVO assetScrapVO = (AssetScrapVO)BeanMapper.map((Object)((Object)assetScrapEntity), AssetScrapVO.class);
            this.assetRecordService.saveRecord((IAssetRecord)assetScrapVO);
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        AssetScrapEntity assetScrapEntity = (AssetScrapEntity)((Object)this.assetScrapService.selectById(billId));
        if (assetScrapEntity != null) {
            assetScrapEntity.getAssetScrapDetailList().forEach(item -> {
                LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
                wrapper.set(AssetEntity::getAssetStatus, (Object)0);
                wrapper.eq(BaseEntity::getId, (Object)item.getAssetId());
                this.assetService.update((Wrapper)wrapper);
            });
            this.assetRecordService.delRecord(billId);
        }
        return CommonResponse.success();
    }
}

