/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.asset.service.impl;

import com.ejianc.business.asset.bean.AmortizeSetEntity;
import com.ejianc.business.asset.bean.AssetAmortizeEntity;
import com.ejianc.business.asset.mapper.AssetAmortizeMapper;
import com.ejianc.business.asset.service.IAmortizeSetService;
import com.ejianc.business.asset.service.IAssetAmortizeService;
import com.ejianc.business.asset.vo.AssetAmortizeDetailVO;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="assetAmortizeService")
public class AssetAmortizeServiceImpl
extends BaseServiceImpl<AssetAmortizeMapper, AssetAmortizeEntity>
implements IAssetAmortizeService {
    @Autowired
    private IAmortizeSetService amortizeSetService;

    @Override
    public void getAmortizeSet(List<AssetAmortizeDetailVO> detailList, Long orgId) {
        Map<Long, Long> euipmentsMap = detailList.stream().collect(Collectors.toMap(AssetAmortizeDetailVO::getEquipmentId, AssetAmortizeDetailVO::getEquipmentTypeId, (key1, key2) -> key1));
        Map<Long, AmortizeSetEntity> amortizeSetMap = this.amortizeSetService.getSet(euipmentsMap, orgId);
        for (AssetAmortizeDetailVO detailVO : detailList) {
            Long equipmentId = detailVO.getEquipmentId();
            AmortizeSetEntity amortizeSetEntity = amortizeSetMap.get(equipmentId);
            if (amortizeSetEntity != null) {
                detailVO.setAmortizeSetId(amortizeSetEntity.getId());
                detailVO.setUsePeriod(amortizeSetEntity.getUsePeriod());
                detailVO.setResidualValueRate(amortizeSetEntity.getResidualValueRate());
                continue;
            }
            detailVO.setErrMsg("\u672a\u83b7\u53d6\u5230\u8be5\u8bbe\u5907\u7684\u644a\u9500\u8bbe\u7f6e\uff01");
        }
    }

    @Override
    public void caclAmortizeMny(List<AssetAmortizeDetailVO> detailList, Date amortizeDate) {
        for (AssetAmortizeDetailVO detailVO : detailList) {
            Date lastAmortizeDate = detailVO.getLastAmortizeDate();
            Date startAmortizeDate = null;
            boolean isHasThis = false;
            if (lastAmortizeDate == null) {
                isHasThis = true;
                startAmortizeDate = detailVO.getCheckDate();
            } else {
                startAmortizeDate = lastAmortizeDate;
            }
            int thisAmortizeNum = AssetAmortizeServiceImpl.getMonthBetweenDate(startAmortizeDate, amortizeDate, isHasThis);
            detailVO.setThisAmortizeNum(Integer.valueOf(thisAmortizeNum));
            BigDecimal netWorthTax = detailVO.getNetWorthTax();
            BigDecimal residualValueTax = detailVO.getResidualValueTax();
            BigDecimal netWorth = detailVO.getNetWorth();
            BigDecimal residualValue = detailVO.getResidualValue();
            BigDecimal usedAmortizeNum = ComputeUtil.toBigDecimal((Integer)detailVO.getUsedAmortizeNum());
            BigDecimal usePeriod = ComputeUtil.toBigDecimal((Integer)detailVO.getUsePeriod());
            BigDecimal usedAmortizeNumHaveThis = ComputeUtil.safeAdd((BigDecimal)ComputeUtil.toBigDecimal((Integer)detailVO.getThisAmortizeNum()), (BigDecimal)usedAmortizeNum);
            BigDecimal picOriginalValueTax = ComputeUtil.safeDiv((BigDecimal)detailVO.getOriginalValueTax(), (BigDecimal)ComputeUtil.toBigDecimal((Integer)detailVO.getUsePeriod()));
            BigDecimal picOriginalValue = ComputeUtil.safeDiv((BigDecimal)detailVO.getOriginalValue(), (BigDecimal)ComputeUtil.toBigDecimal((Integer)detailVO.getUsePeriod()));
            BigDecimal thisAmortizeMnyTax = ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.toBigDecimal((Integer)thisAmortizeNum), (BigDecimal)picOriginalValueTax);
            BigDecimal thisAmortizeMny = ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.toBigDecimal((Integer)thisAmortizeNum), (BigDecimal)picOriginalValue);
            BigDecimal maxAmortizeMnyTax = ComputeUtil.safeSub((BigDecimal)netWorthTax, (BigDecimal)residualValueTax);
            BigDecimal maxAmortizeMny = ComputeUtil.safeSub((BigDecimal)netWorth, (BigDecimal)residualValue);
            if (ComputeUtil.isLessOrEqual((BigDecimal)maxAmortizeMnyTax, (BigDecimal)BigDecimal.ZERO)) {
                detailVO.setAmortizeMnyTax(BigDecimal.ZERO);
                detailVO.setAmortizeMny(BigDecimal.ZERO);
            } else if (ComputeUtil.isGreaterOrEqual((BigDecimal)usedAmortizeNumHaveThis, (BigDecimal)usePeriod)) {
                detailVO.setAmortizeMnyTax(ComputeUtil.safeSub((BigDecimal)netWorthTax, (BigDecimal)residualValueTax));
                detailVO.setAmortizeMny(ComputeUtil.safeSub((BigDecimal)netWorth, (BigDecimal)residualValue));
            } else if (ComputeUtil.isGreaterThan((BigDecimal)thisAmortizeMnyTax, (BigDecimal)maxAmortizeMnyTax)) {
                detailVO.setAmortizeMnyTax(maxAmortizeMnyTax);
                detailVO.setAmortizeMny(maxAmortizeMny);
            } else {
                detailVO.setAmortizeMnyTax(thisAmortizeMnyTax);
                detailVO.setAmortizeMny(thisAmortizeMny);
            }
            BigDecimal amortizeRate = ComputeUtil.bigDecimalPercent((BigDecimal)detailVO.getAmortizeMnyTax(), (BigDecimal)detailVO.getOriginalValueTax(), (int)2);
            detailVO.setAmortizeRate(amortizeRate);
        }
    }

    public static int getMonthBetweenDate(Date d1, Date d2, boolean isHasThis) {
        Calendar c1 = Calendar.getInstance();
        Calendar c2 = Calendar.getInstance();
        c1.setTime(d1);
        c2.setTime(d2);
        int year1 = c1.get(1);
        int year2 = c2.get(1);
        int month1 = c1.get(2);
        int month2 = c2.get(2);
        int day1 = c1.get(5);
        int day2 = c2.get(5);
        int yearInterval = year1 - year2;
        if (month1 < month2 || month1 == month2 && day1 < day2) {
            --yearInterval;
        }
        int monthInterval = month1 + 12 - month2;
        if (day1 < day2) {
            --monthInterval;
        }
        int monthsDiff = Math.abs(yearInterval * 12 + (monthInterval %= 12));
        return isHasThis ? ++monthsDiff : monthsDiff;
    }
}

