package com.ejianc.business.asset.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.acceptance.vo.PurchaseAcceptanceVO;
import com.ejianc.business.asset.bean.*;
import com.ejianc.business.asset.service.*;
import com.ejianc.business.utils.DateUtil;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.DateFormater;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.beans.factory.annotation.Autowired;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

@Service("assetAmortize")
public class AssetAmortizeBpmServiceImpl implements ICommonBusinessService {

    @Autowired
    private IBillTypeApi billTypeApi;

    @Autowired
    private IAssetAmortizeService assetAmortizeService;


    @Autowired
    private IAssetService assetService;

    @Autowired
    private IAssetAllotOutDetailService assetAllotOutDetailService;


    @Autowired
    private IAssetScrapDetailService assetScrapDetailService;


    @Autowired
    private IHandleDetailService handleDetailService;


    /**
     * 提交前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    ;

    /**
     * 提交完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 有审批流的撤回前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {

        return CommonResponse.success();
    }

    ;

    /**
     * 有审批流的撤回后回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    ;

    /**
     * 审批节点审批中时节点审批前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    ;

    /**
     * 终审审核前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 终审审核完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        // 审核完成回写资产卡片摊销金额
        AssetAmortizeEntity assetAmortizeEntity = assetAmortizeService.selectById(billId);
        List<AssetAmortizeDetailEntity> detailList = assetAmortizeEntity.getDetailList();
        if (CollectionUtils.isNotEmpty(detailList)) {
            Date amortizeDate = assetAmortizeEntity.getAmortizeDate();
            Long projectId = assetAmortizeEntity.getProjectId();
            for (AssetAmortizeDetailEntity entity : detailList) {
                Long assetId = entity.getAssetId();
                BigDecimal amortizeMnyTax = entity.getAmortizeMnyTax();
                BigDecimal amortizeMny = entity.getAmortizeMny();


                AssetEntity assetEntity = assetService.selectById(assetId);
                BigDecimal sumAmortizeTaxMny = ComputeUtil.safeAdd(amortizeMnyTax, assetEntity.getLastAmortizeTaxMny());
                BigDecimal sumAmortizeMny = ComputeUtil.safeAdd(amortizeMny, assetEntity.getLastAmortizeMny());
                BigDecimal netWorthTax = ComputeUtil.safeSub(assetEntity.getOriginalValueTax(), sumAmortizeTaxMny);
                BigDecimal netWorth = ComputeUtil.safeSub(assetEntity.getOriginalValue(), sumAmortizeMny);

                LambdaUpdateWrapper<AssetEntity> wrapper = new LambdaUpdateWrapper<>();
                wrapper.eq(AssetEntity::getId, assetId);
                wrapper.eq(AssetEntity::getProjectId, projectId);
                wrapper.set(AssetEntity::getLastAmortizeDate, amortizeDate);
                wrapper.set(AssetEntity::getLastAmortizeTaxMny, sumAmortizeTaxMny);
                wrapper.set(AssetEntity::getLastAmortizeMny, sumAmortizeMny);
                wrapper.set(AssetEntity::getNetWorthTax, netWorthTax);
                wrapper.set(AssetEntity::getNetWorth, netWorth);
                assetService.update(wrapper);
            }
        }
        return CommonResponse.success();
    }

    /**
     * 弃审前事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        // 参数是单据类型编码字符串 根据需求是否打开下面代码
        /**CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
         if(!resp.isSuccess()){
         return CommonResponse.error("无法撤回！"+resp.getMsg());
         }*/
        AssetAmortizeEntity assetAmortizeEntity = assetAmortizeService.selectById(billId);
        List<AssetAmortizeDetailEntity> detailList = assetAmortizeEntity.getDetailList();
        Date createTime = assetAmortizeEntity.getCreateTime();
        if (CollectionUtils.isNotEmpty(detailList)) {
            List<Long> assetIds = detailList.stream().map(AssetAmortizeDetailEntity::getAssetId).collect(Collectors.toList());
            LambdaQueryWrapper<AssetAllotOutDetailEntity> outQuery = new LambdaQueryWrapper<>();
            outQuery.in(AssetAllotOutDetailEntity::getAssetId, assetIds);
            outQuery.ge(AssetAllotOutDetailEntity::getCreateTime, createTime);
            int count = assetAllotOutDetailService.count(outQuery);
            if (count > 0) {
                return CommonResponse.error("设备明细存在后续调出单，不允许弃审！");
            }

            LambdaQueryWrapper<AssetScrapDetailEntity> scrapQuery = new LambdaQueryWrapper<>();
            scrapQuery.in(AssetScrapDetailEntity::getAssetId, assetIds);
            scrapQuery.ge(AssetScrapDetailEntity::getCreateTime, createTime);
            int c = assetScrapDetailService.count(scrapQuery);
            if (c > 0) {
                return CommonResponse.error("设备明细存在后续报废单，不允许弃审！");
            }

            LambdaQueryWrapper<HandleDetailEntity> handQuery = new LambdaQueryWrapper<>();
            handQuery.in(HandleDetailEntity::getAssetId, assetIds);
            handQuery.ge(HandleDetailEntity::getCreateTime, createTime);
            int ct = handleDetailService.count(handQuery);
            if (ct > 0) {
                return CommonResponse.error("设备明细存在后续处置单，不允许弃审！");
            }
        }


        Long orgId = assetAmortizeEntity.getOrgId();
        Date amortizeDate = assetAmortizeEntity.getAmortizeDate();
        LambdaQueryWrapper<AssetAmortizeEntity> qu = new LambdaQueryWrapper<>();
        qu.eq(AssetAmortizeEntity::getOrgId, orgId);
        qu.gt(AssetAmortizeEntity::getAmortizeDate, DateUtil.format(amortizeDate, DateUtil.DATE));
        int count = assetAmortizeService.count(qu);
        if (count > 0) {
            return CommonResponse.error("该摊销单位已有后续的摊销单，不允许弃审！");
        }
        return CommonResponse.success();
    }

    /**
     * 弃审后事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        // 弃审后回写资产卡片摊销金额
        AssetAmortizeEntity assetAmortizeEntity = assetAmortizeService.selectById(billId);
        List<AssetAmortizeDetailEntity> detailList = assetAmortizeEntity.getDetailList();
        if (CollectionUtils.isNotEmpty(detailList)) {
            for (AssetAmortizeDetailEntity entity : detailList) {
                Long assetId = entity.getAssetId();
                Long projectId = assetAmortizeEntity.getProjectId();
                BigDecimal amortizeMnyTax = entity.getAmortizeMnyTax();
                BigDecimal amortizeMny = entity.getAmortizeMny();

                AssetEntity assetEntity = assetService.selectById(assetId);
                BigDecimal sumAmortizeTaxMny = ComputeUtil.safeSub(assetEntity.getLastAmortizeTaxMny(), amortizeMnyTax);
                BigDecimal sumAmortizeMny = ComputeUtil.safeSub(assetEntity.getLastAmortizeMny(), amortizeMny);
                BigDecimal netWorthTax = ComputeUtil.safeSub(assetEntity.getOriginalValueTax(), sumAmortizeTaxMny);
                BigDecimal netWorth = ComputeUtil.safeSub(assetEntity.getOriginalValue(), sumAmortizeMny);

                LambdaUpdateWrapper<AssetEntity> wrapper = new LambdaUpdateWrapper<>();
                wrapper.eq(AssetEntity::getId, assetId);
                wrapper.eq(AssetEntity::getProjectId, projectId);
                wrapper.set(AssetEntity::getLastAmortizeDate, entity.getLastAmortizeDate());
                wrapper.set(AssetEntity::getLastAmortizeTaxMny, sumAmortizeTaxMny);
                wrapper.set(AssetEntity::getLastAmortizeMny, sumAmortizeMny);
                wrapper.set(AssetEntity::getNetWorthTax, netWorthTax);
                wrapper.set(AssetEntity::getNetWorth, netWorth);
                assetService.update(wrapper);
            }
        }
        return CommonResponse.success();
    }

}
