package com.ejianc.business.purchaseplan.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.purchase.bean.ChangeEquipmentDetailedEntity;
import com.ejianc.business.purchase.bean.EquipmentDetailedEntity;
import com.ejianc.business.purchase.bean.PurchaseRecordDetaileEntity;
import com.ejianc.business.purchase.service.IChangeEquipmentDetailedService;
import com.ejianc.business.purchase.service.IEquipmentDetailedService;
import com.ejianc.business.purchase.service.IPurchaseRecordDetaileService;
import com.ejianc.business.purchaseplan.bean.PurchasePlanDetailedEntity;
import com.ejianc.business.purchaseplan.bean.PurchasePlanEntity;
import com.ejianc.business.purchaseplan.service.IPurchasePlanDetailedService;
import com.ejianc.business.purchaseplan.service.IPurchasePlanService;
import com.ejianc.business.purchaseplan.vo.PurchasePlanEnum;
import com.ejianc.foundation.support.api.IBillTypeApi;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.List;
import java.util.stream.Collectors;

@Service("purchasePlan") 
public class PurchasePlanBpmServiceImpl implements ICommonBusinessService {
	@Autowired
	private IPurchasePlanService service;
	@Autowired
	private IEquipmentDetailedService detailedService;
	@Autowired
	private IChangeEquipmentDetailedService changeDetailedService;
	@Autowired
	private IBillTypeApi billTypeApi;
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		PurchasePlanEntity planEntity = service.selectById(billId);

		List<PurchasePlanDetailedEntity> subEntityList = planEntity.getDetailList();
		if(CollectionUtils.isNotEmpty(subEntityList)){
			List<Long> batchIds = subEntityList.stream().map(PurchasePlanDetailedEntity::getId).collect(Collectors.toList());
			QueryWrapper<EquipmentDetailedEntity> queryDetaile = new QueryWrapper<EquipmentDetailedEntity>();
			queryDetaile.in("source_id", batchIds);
			queryDetaile.eq("dr", 0);
			List<EquipmentDetailedEntity> equipmentList = detailedService.list(queryDetaile);

			QueryWrapper<ChangeEquipmentDetailedEntity> queryChangeDetaile = new QueryWrapper<ChangeEquipmentDetailedEntity>();
			queryChangeDetaile.in("source_id", batchIds);
			queryChangeDetaile.eq("dr", 0);
			List<ChangeEquipmentDetailedEntity> changeEquipmentList = changeDetailedService.list(queryChangeDetaile);

			if(CollectionUtils.isNotEmpty(equipmentList) || CollectionUtils.isNotEmpty(changeEquipmentList)){
				return CommonResponse.error("清单被下游单据引用，不允许回退!");
			}
			// 如果是待采购，则不判断是否引用
			if (PurchasePlanEnum.PLAN_STATE_WAIT.getPlanState().equals(planEntity.getPlanState())) {
				return CommonResponse.success();
			}
			CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
			if (!resp.isSuccess()) {
//			return CommonResponse.error("无法撤回！" + resp.getMsg());
				return CommonResponse.error("单据被引用不能撤回！");
			}
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
