/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.asset.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.asset.bean.AssetAmortizeFinanceEntity;
import com.ejianc.business.asset.service.IAssetAmortizeFinanceService;
import com.ejianc.business.asset.vo.AssetAmortizeFinanceDetailVO;
import com.ejianc.business.asset.vo.AssetAmortizeFinanceVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"assetAmortizeFinance"})
public class AssetAmortizeFinanceController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "ASSET_AMORTIZE_CW_CODE";
    @Autowired
    private IAssetAmortizeFinanceService service;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/test"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<AssetAmortizeFinanceDetailVO>> test(@RequestParam String projectId, List<String> period) {
        ArrayList<AssetAmortizeFinanceDetailVO> assetAmortizeFinanceDetailVOS = new ArrayList<AssetAmortizeFinanceDetailVO>();
        AssetAmortizeFinanceDetailVO detailVO = new AssetAmortizeFinanceDetailVO();
        detailVO.setFinanceTypeCode("caiwucs");
        detailVO.setFinanceTypeName("caiwucs");
        detailVO.setDetailAmortizeDate(DateFormatUtils.format((Date)new Date(), (String)"yyyy-mm"));
        detailVO.setDetailAmortizeMny(new BigDecimal("100"));
        assetAmortizeFinanceDetailVOS.add(detailVO);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", assetAmortizeFinanceDetailVOS);
    }

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<AssetAmortizeFinanceVO> saveOrUpdate(@RequestBody AssetAmortizeFinanceVO saveOrUpdateVO) {
        AssetAmortizeFinanceVO vo = this.service.saveOrUpdate(saveOrUpdateVO);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<AssetAmortizeFinanceVO> queryDetail(Long id) {
        AssetAmortizeFinanceEntity entity = (AssetAmortizeFinanceEntity)((Object)this.service.selectById(id));
        AssetAmortizeFinanceVO vo = (AssetAmortizeFinanceVO)BeanMapper.map((Object)((Object)entity), AssetAmortizeFinanceVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<AssetAmortizeFinanceVO> vos) {
        this.service.delete(vos);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<AssetAmortizeFinanceVO>> queryList(@RequestBody QueryParam param) {
        Object value;
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("billCode", "projectName", "employeeName", "categoryName"));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("parentOrgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("orgId", new Parameter("in", departmentIds));
        }
        Parameter amortizeDatePara = (Parameter)param.getParams().get("amortizeDate");
        if (amortizeDatePara != null && (value = amortizeDatePara.getValue()) != null) {
            String[] split = String.valueOf(value).split(",");
            String[] splitStart = split[0].split("-");
            String[] splitEnd = split[1].split("-");
            amortizeDatePara.setValue((Object)(splitStart[0] + "-" + splitStart[1] + "-01," + splitEnd[0] + "-" + splitEnd[1] + "-31"));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), AssetAmortizeFinanceVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        Object value;
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("billCode", "projectName", "employeeName", "categoryName"));
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("parentOrgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("orgId", new Parameter("in", departmentIds));
        }
        Parameter amortizeDatePara = (Parameter)param.getParams().get("amortizeDate");
        if (amortizeDatePara != null && (value = amortizeDatePara.getValue()) != null) {
            String[] split = String.valueOf(value).split(",");
            String[] splitStart = split[0].split("-");
            String[] splitEnd = split[1].split("-");
            amortizeDatePara.setValue((Object)(splitStart[0] + "-" + splitStart[1] + "-01," + splitEnd[0] + "-" + splitEnd[1] + "-31"));
        }
        List list = this.service.queryList(param);
        List assetAmortizeFinanceVOS = BeanMapper.mapList((Iterable)list, AssetAmortizeFinanceVO.class);
        assetAmortizeFinanceVOS.forEach(t -> t.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)t.getBillState()).getDescription()));
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", assetAmortizeFinanceVOS);
        ExcelExport.getInstance().export("AssetAmortizeFinance-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refAssetAmortizeFinanceData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<AssetAmortizeFinanceVO>> refAssetAmortizeFinanceData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), AssetAmortizeFinanceVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/getLastAmortizeDate"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> getLastAmortizeDate(Long projectId, Long billId) {
        List list;
        String lastAmortizeDate = null;
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(AssetAmortizeFinanceEntity::getProjectId, (Object)projectId);
        wrapper.orderByDesc(BaseEntity::getCreateTime);
        if (null != billId) {
            wrapper.ne(BaseEntity::getId, (Object)billId);
        }
        if (CollectionUtils.isNotEmpty((Collection)(list = this.service.list((Wrapper)wrapper)))) {
            lastAmortizeDate = ((AssetAmortizeFinanceEntity)((Object)list.get(0))).getAmortizeDate();
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u4e0a\u6b21\u644a\u9500\u5468\u671f\u6210\u529f\uff01", lastAmortizeDate);
    }

    @RequestMapping(value={"/checkParams"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ParamsCheckVO> checkParams(@RequestBody AssetAmortizeFinanceVO vo) {
        return CommonResponse.success((String)"\u53c2\u6570\u6821\u9a8c\u6210\u529f\uff01", (Object)this.service.checkParams(vo));
    }

    @RequestMapping(value={"/pushCost"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<AssetAmortizeFinanceVO> pushCost(@RequestBody AssetAmortizeFinanceVO vo) {
        return this.service.pushCost(vo);
    }
}

