package com.ejianc.business.asset.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.asset.bean.AssetAmortizeFinanceDetailEntity;
import com.ejianc.business.asset.vo.AssetAmortizeFinanceDetailVO;
import com.ejianc.business.asset.vo.AssetAmortizeFinanceVO;
import com.ejianc.business.financeintegration.PMPayApply.api.IPMGDZCSJApi;
import com.ejianc.business.financeintegration.PMPayApply.vo.PMGDZCSJUPVO;
import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.business.procost.enums.SourceTypeEnum;
import com.ejianc.business.procost.vo.CostDetailVO;
import com.ejianc.business.targetcost.vo.ParamsCheckDsVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import jdk.nashorn.internal.scripts.JO;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.asset.mapper.AssetAmortizeFinanceMapper;
import com.ejianc.business.asset.bean.AssetAmortizeFinanceEntity;
import com.ejianc.business.asset.service.IAssetAmortizeFinanceService;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 固定资产摊销（财务）
 * 
 * @author generator
 * 
 */
@Service("assetAmortizeFinanceService")
public class AssetAmortizeFinanceServiceImpl extends BaseServiceImpl<AssetAmortizeFinanceMapper, AssetAmortizeFinanceEntity> implements IAssetAmortizeFinanceService{
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "ASSET_AMORTIZE_CW_CODE";//此处需要根据实际修改

    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private ICostDetailApi costDetailApi;
    @Autowired
    private IPMGDZCSJApi ipmgdzcsjApi;
    @Autowired
    private IParamConfigApi paramConfigApi;
    private static final String CHECK_PARAM_CODE = "P-ogZh3516";

    /*
    * 保存修改
    * */
    @Override
    public AssetAmortizeFinanceVO saveOrUpdate(AssetAmortizeFinanceVO saveOrUpdateVO) {
        AssetAmortizeFinanceEntity entity = BeanMapper.map(saveOrUpdateVO, AssetAmortizeFinanceEntity.class);

        LambdaQueryWrapper<AssetAmortizeFinanceEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(AssetAmortizeFinanceEntity::getProjectId, saveOrUpdateVO.getProjectId());
        queryWrapper.ne(saveOrUpdateVO.getId() != null, AssetAmortizeFinanceEntity::getId, saveOrUpdateVO.getId());
        queryWrapper.notIn(AssetAmortizeFinanceEntity::getBillState, Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        int count = super.count(queryWrapper);
        if (count > 0) {
            throw new BusinessException("该摊销单位下存在未生效的摊销单！");
        }
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
//                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            entity.setProportionFlag("0");// 分摊状态(1:是，0：否)
            entity.setRelationFlag("0");// 关联状态(1:是，0：否)
        }
        List<AssetAmortizeFinanceDetailVO> detailList = saveOrUpdateVO.getAssetAmortizeFinanceDetailList();
        if (CollectionUtils.isNotEmpty(detailList)) {
            List<String> del = new ArrayList<>();
            List<String> add = new ArrayList<>();
            Set<String> categoryName = new HashSet<>();
            for (AssetAmortizeFinanceDetailVO detailVO : detailList) {
                String[] split = detailVO.getDetailAmortizeDate().split("-");
                if (!"del".equals(detailVO.getRowState())){
                    categoryName.add(detailVO.getFinanceTypeName());
                    if (null==detailVO.getId()){
                        add.add(split[0]+split[1]);
                    }
                }else{
                    del.add(split[0]+split[1]);
                }
            }
            String categoryNameStr = StringUtils.join(categoryName.toArray(), ",");
            if (StringUtils.isNotEmpty(categoryNameStr) && categoryNameStr.length() > 1000) {
                categoryNameStr = categoryNameStr.substring(0, 1000);
            }
            entity.setCategoryName(categoryNameStr);
            this.updatePeriod(entity.getProjectId(),del,AssetAmortizeFinanceVO.PM_SF);
            this.updatePeriod(entity.getProjectId(),add,AssetAmortizeFinanceVO.PM_ZY);
        }
        super.saveOrUpdate(entity, false);
        AssetAmortizeFinanceVO vo = BeanMapper.map(entity, AssetAmortizeFinanceVO.class);
        return vo;
    }
    // 占用/释放财务取数   cwFlag : 是否PM引用 Y/N
    public void updatePeriod(Long projectId, List<String> periods ,String cwFlag){
        if(CollectionUtils.isNotEmpty(periods) && null!=projectId && null!=cwFlag){
            PMGDZCSJUPVO pmgdzcsjupvo = new PMGDZCSJUPVO();
            pmgdzcsjupvo.setProjectId(String.valueOf(projectId));
            pmgdzcsjupvo.setPeriod(periods);
            pmgdzcsjupvo.setCwFlag(cwFlag);
            logger.info((AssetAmortizeFinanceVO.PM_ZY.equals(cwFlag)?"占用":"释放")+"财务取数,入参：{}", JSONObject.toJSONString(pmgdzcsjupvo));
            CommonResponse<Boolean> booleanCommonResponse = ipmgdzcsjApi.updateFlag(pmgdzcsjupvo);
            logger.info((AssetAmortizeFinanceVO.PM_ZY.equals(cwFlag)?"占用":"释放")+"财务取数,结果：{}", JSONObject.toJSONString(booleanCommonResponse));
            if(!booleanCommonResponse.isSuccess()){
                throw new BusinessException(booleanCommonResponse.getMsg());
            }
            if(!booleanCommonResponse.getData()){
                throw new BusinessException((AssetAmortizeFinanceVO.PM_ZY.equals(cwFlag)?"占用":"释放")+"财务取数失败！");
            }
        }
    }

/*
* 删除
* */
    @Override
    public void delete(List<AssetAmortizeFinanceVO> vos) {
        if(vos.size()>1){
            throw new BusinessException("不支持批量删除！");
        }
        AssetAmortizeFinanceEntity entity = super.selectById(vos.get(0).getId());
        List<AssetAmortizeFinanceDetailEntity> assetAmortizeFinanceDetailList = entity.getAssetAmortizeFinanceDetailList();
        if(CollectionUtils.isNotEmpty(assetAmortizeFinanceDetailList)){
            List<String> del = new ArrayList<>();
            for (AssetAmortizeFinanceDetailEntity detailEntity : assetAmortizeFinanceDetailList) {
                String[] split = detailEntity.getDetailAmortizeDate().split("-");
                del.add(split[0]+split[1]);
            }
            this.updatePeriod(entity.getProjectId(),del,AssetAmortizeFinanceVO.PM_SF);
        }
        super.removeByIds(vos.stream().map(AssetAmortizeFinanceVO::getId).collect(Collectors.toList()),true);
    }

/*
* 关联保存*/
    @Override
    public CommonResponse<AssetAmortizeFinanceVO> pushCost(AssetAmortizeFinanceVO vo) {
        AssetAmortizeFinanceEntity entity = super.selectById(vo.getId());
        if (CollectionUtils.isNotEmpty(entity.getAssetAmortizeFinanceDetailList())) {
            List<AssetAmortizeFinanceDetailEntity> detailEntityList = BeanMapper.mapList(vo.getAssetAmortizeFinanceDetailList(), AssetAmortizeFinanceDetailEntity.class);
            entity.setAssetAmortizeFinanceDetailList(detailEntityList);
        }
        super.saveOrUpdate(entity, false);
        //推送数据
        this.costPush(entity);
        return CommonResponse.success(BeanMapper.map(entity, AssetAmortizeFinanceVO.class));
    }
/*
* 推送实际成本*/
    @Override
    public void costPush(AssetAmortizeFinanceEntity entity) {
        logger.info("开始costPush");
        List<AssetAmortizeFinanceDetailEntity> detailList = entity.getAssetAmortizeFinanceDetailList();
        String newRelationFlag = "1";
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty( detailList)) {
            for (AssetAmortizeFinanceDetailEntity  detailEntity :  detailList) {
                if (null ==  detailEntity.getSubjectId() || null ==  detailEntity.getWbsId()) {
                    newRelationFlag = "0";
                    break;
                }
            }
        }
        if (ListUtil.isEmpty( detailList)) {
            newRelationFlag = "0";
        }
        //判断之前的单据是否关联
        String oldRelationFlag = entity.getRelationFlag();
        //之前已关联
        if ("1".equals(oldRelationFlag)) {
            if ("1".equals(newRelationFlag)) {
                saveCost(entity);
            }
            if (!"1".equals(newRelationFlag)) {
                //删除成本中心之前的数据
                logger.info("删除成本中心之前的数据-领料出库Id---{}",entity.getId());
                CommonResponse<String> commonResponse = costDetailApi.deleteSubject(entity.getId());
                logger.info("结果"+JSONObject.toJSONString(commonResponse));
                if(!commonResponse.isSuccess()){
                    throw new BusinessException(commonResponse.getMsg());
                }
            }
        }
        //之前未关联
        if ("0".equals(oldRelationFlag)) {
            if ("1".equals(newRelationFlag)) {
                //税率
                saveCost(entity);
            }
        }
        //更新是否关联
        LambdaUpdateWrapper<AssetAmortizeFinanceEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.in(AssetAmortizeFinanceEntity::getId, entity.getId());
        updateWrapper.set(AssetAmortizeFinanceEntity::getRelationFlag, newRelationFlag);//(1:是，0：否)
        super.update(updateWrapper);
        entity.setRelationFlag(newRelationFlag);
    }

    private void saveCost(AssetAmortizeFinanceEntity entity) {
        String linkUrl = "/ejc-proequipmentp-frontend/#/assetAmortizeFinance/card?id=" + entity.getId();
        String billName = SourceTypeEnum.固定资产摊销_财务.getTypeName();
        List<CostDetailVO> costDetailVOList = new ArrayList<>();
        List<AssetAmortizeFinanceDetailEntity> detailList = entity.getAssetAmortizeFinanceDetailList();
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(detailList)) {
            for (AssetAmortizeFinanceDetailEntity detailEntity : detailList) {
                CostDetailVO costDetailVO = new CostDetailVO();
                costDetailVO.setSourceBillCode(entity.getBillCode());
                costDetailVO.setSourceBillName(billName);
                costDetailVO.setSourceBillUrl(linkUrl);
                costDetailVO.setSubjectId(detailEntity.getSubjectId());
                costDetailVO.setSubjectId(detailEntity.getSubjectId());
                costDetailVO.setSubjectCode(detailEntity.getSubjectCode());
                costDetailVO.setSubjectName(detailEntity.getSubjectName());
//                costDetailVO.setNum();
                costDetailVO.setWbsId(detailEntity.getWbsId());
                costDetailVO.setWbsCode(detailEntity.getWbsCode());
                costDetailVO.setWbsName(detailEntity.getWbsName());
                costDetailVO.setSourceId(entity.getId());
                costDetailVO.setSourceDetailId(detailEntity.getId());
                costDetailVO.setHappenTaxMny(detailEntity.getDetailAmortizeMny());
                costDetailVO.setHappenMny(detailEntity.getDetailAmortizeMny());
                costDetailVO.setHappenDate(entity.getBillDate());
                costDetailVO.setCreateUserName(sessionManager.getUserContext().getUserName());
                costDetailVO.setSourceType("ZCTX_CW");
                costDetailVO.setSourceTabType("ZCTX_CW_DETAIL");
                costDetailVO.setProjectId(entity.getProjectId());
                costDetailVOList.add(costDetailVO);
            }
        }

        //成本中心
        if (ListUtil.isNotEmpty(costDetailVOList)) {
            logger.info("推送数据--------"+JSONObject.toJSONString(costDetailVOList));
            CommonResponse<String> stringCommonResponse = costDetailApi.saveSubject(costDetailVOList);
            logger.info("推送结果--------"+JSONObject.toJSONString(stringCommonResponse));
            if (stringCommonResponse.isSuccess()) {
            } else {
                throw new BusinessException(stringCommonResponse.getMsg());
            }
        }
    }

    //单据参数控制 合并方法
    @Override
    public ParamsCheckVO checkParams(AssetAmortizeFinanceVO vo){
        List<ParamsCheckVO> paramsCheckVOS = new ArrayList<>();
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        /*参数控制区*/
//        paramsCheckVOS.addAll(this.checkParamsRatio(vo));
        /*--end---参数控制区*/
        Map<String, List<ParamsCheckDsVO>> map = new HashMap<>();
        String[] paramsArray = {"alert", "warn", "none"};
        if(CollectionUtils.isNotEmpty(paramsCheckVOS)){
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if(map.containsKey(warnType)){
                    List<ParamsCheckDsVO> checkDsVOS = map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType,checkDsVOS);
                }else {
                    map.put(warnType,checkVO.getDataSource());
                }
            }
        }
        for (String s : paramsArray) {
            if(map.containsKey(s)){
                paramsCheckVO.setWarnType(s);
                paramsCheckVO.setDataSource(map.get(s));
                if(CollectionUtils.isEmpty(paramsCheckVO.getDataSource())){
                    paramsCheckVO.setWarnType("none");
                }else {
                    return paramsCheckVO;
                }
            }
        }
        return paramsCheckVO;
    }
    //项目累计摊销总金额/项目预估摊销总金额 比例
    @Override
    public List<ParamsCheckVO> checkParamsRatio(AssetAmortizeFinanceVO vo) {
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        List<ParamsCheckVO> paramsCheckVOList = new ArrayList<>();
        CommonResponse<List<BillParamVO>> billParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(CHECK_PARAM_CODE, vo.getOrgId());
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            List<BillParamVO> data = billParamByCode.getData();
            logger.info("比例控制信息返回："+ JSONObject.toJSONString(data));
            if(CollectionUtils.isNotEmpty(data)){
                for (BillParamVO datum : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    List<ParamsCheckDsVO> checkDsVOS = new ArrayList<>();
                    BigDecimal roleValue = datum.getRoleValue();
//                    BigDecimal totalSettleTaxMny = null==vo.getCurrentAssetAmortizeFinanceTaxMny()?BigDecimal.ZERO:vo.getCurrentAssetAmortizeFinanceTaxMny();
//                    BigDecimal settleTaxMny = null==vo.getAssetAmortizeFinanceTaxMny()?BigDecimal.ZERO:vo.getAssetAmortizeFinanceTaxMny();
//                    BigDecimal comMny = ComputeUtil.safeDiv(ComputeUtil.safeMultiply(contractEntity.getContractTaxMny(), roleValue), new BigDecimal("100")).setScale(2, BigDecimal.ROUND_HALF_UP);
//                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
//                    if (totalSettleTaxMny.compareTo(comMny) > 0) {
//                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
//                        paramsCheckDsVO.setOrgName(datum.getOrgName());
//                        paramsCheckDsVO.setWarnItem("合同超结");
//                        paramsCheckDsVO.setWarnName("累计结算金额大于合同金额");
//                        StringBuffer stringBuffer = new StringBuffer();
//                        stringBuffer.append("本次结算金额：").append(settleTaxMny.toString())
//                                .append("元，含本次累计结算金额：").append(totalSettleTaxMny)
//                                .append("元，合同金额*").append(roleValue).append("%:").append(comMny)
//                                .append("元。超出金额：").append(ComputeUtil.safeSub(totalSettleTaxMny, comMny)).append("元");
//                        paramsCheckDsVO.setContent(stringBuffer.toString());
//                        checkDsVOS.add(paramsCheckDsVO);
//                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOList.add(paramsCheckVO);
                }
            }

        } else {
            logger.info(billParamByCode.getMsg());
            throw new BusinessException("获取控制参数失败");
        }

        return paramsCheckVOList;
    }
}
