/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.asset.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.asset.bean.AssetAmortizeFinanceDetailEntity;
import com.ejianc.business.asset.bean.AssetAmortizeFinanceEntity;
import com.ejianc.business.asset.mapper.AssetAmortizeFinanceMapper;
import com.ejianc.business.asset.service.IAssetAmortizeFinanceService;
import com.ejianc.business.asset.vo.AssetAmortizeFinanceDetailVO;
import com.ejianc.business.asset.vo.AssetAmortizeFinanceVO;
import com.ejianc.business.financeintegration.PMPayApply.api.IPMGDZCSJApi;
import com.ejianc.business.financeintegration.PMPayApply.vo.PMGDZCSJUPVO;
import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.business.procost.enums.SourceTypeEnum;
import com.ejianc.business.procost.vo.CostDetailVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="assetAmortizeFinanceService")
public class AssetAmortizeFinanceServiceImpl
extends BaseServiceImpl<AssetAmortizeFinanceMapper, AssetAmortizeFinanceEntity>
implements IAssetAmortizeFinanceService {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "ASSET_AMORTIZE_CW_CODE";
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private ICostDetailApi costDetailApi;
    @Autowired
    private IPMGDZCSJApi ipmgdzcsjApi;
    @Autowired
    private IParamConfigApi paramConfigApi;
    private static final String CHECK_PARAM_CODE = "P-ogZh3516";

    @Override
    public AssetAmortizeFinanceVO saveOrUpdate(AssetAmortizeFinanceVO saveOrUpdateVO) {
        List detailList;
        AssetAmortizeFinanceEntity entity = (AssetAmortizeFinanceEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, AssetAmortizeFinanceEntity.class));
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(AssetAmortizeFinanceEntity::getProjectId, (Object)saveOrUpdateVO.getProjectId());
        queryWrapper.ne(saveOrUpdateVO.getId() != null, BaseEntity::getId, (Object)saveOrUpdateVO.getId());
        queryWrapper.notIn(AssetAmortizeFinanceEntity::getBillState, Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        int count = super.count((Wrapper)queryWrapper);
        if (count > 0) {
            throw new BusinessException("\u8be5\u644a\u9500\u5355\u4f4d\u4e0b\u5b58\u5728\u672a\u751f\u6548\u7684\u644a\u9500\u5355\uff01");
        }
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setBillCode((String)billCode.getData());
            entity.setProportionFlag("0");
            entity.setRelationFlag("0");
        }
        if (CollectionUtils.isNotEmpty((Collection)(detailList = saveOrUpdateVO.getAssetAmortizeFinanceDetailList()))) {
            ArrayList<String> del = new ArrayList<String>();
            ArrayList<String> add = new ArrayList<String>();
            HashSet<String> categoryName = new HashSet<String>();
            for (AssetAmortizeFinanceDetailVO detailVO : detailList) {
                String[] split = detailVO.getDetailAmortizeDate().split("-");
                if (!"del".equals(detailVO.getRowState())) {
                    categoryName.add(detailVO.getFinanceTypeName());
                    if (null != detailVO.getId()) continue;
                    add.add(split[0] + split[1]);
                    continue;
                }
                del.add(split[0] + split[1]);
            }
            String categoryNameStr = StringUtils.join((Object[])categoryName.toArray(), (String)",");
            if (StringUtils.isNotEmpty((CharSequence)categoryNameStr) && categoryNameStr.length() > 1000) {
                categoryNameStr = categoryNameStr.substring(0, 1000);
            }
            entity.setCategoryName(categoryNameStr);
            this.updatePeriod(entity.getProjectId(), del, "N");
            this.updatePeriod(entity.getProjectId(), add, "Y");
        }
        super.saveOrUpdate((Object)entity, false);
        AssetAmortizeFinanceVO vo = (AssetAmortizeFinanceVO)BeanMapper.map((Object)((Object)entity), AssetAmortizeFinanceVO.class);
        return vo;
    }

    public void updatePeriod(Long projectId, List<String> periods, String cwFlag) {
        if (CollectionUtils.isNotEmpty(periods) && null != projectId && null != cwFlag) {
            PMGDZCSJUPVO pmgdzcsjupvo = new PMGDZCSJUPVO();
            pmgdzcsjupvo.setProjectId(String.valueOf(projectId));
            pmgdzcsjupvo.setPeriod(periods);
            pmgdzcsjupvo.setCwFlag(cwFlag);
            this.logger.info(("Y".equals(cwFlag) ? "\u5360\u7528" : "\u91ca\u653e") + "\u8d22\u52a1\u53d6\u6570,\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)pmgdzcsjupvo));
            CommonResponse booleanCommonResponse = this.ipmgdzcsjApi.updateFlag(pmgdzcsjupvo);
            this.logger.info(("Y".equals(cwFlag) ? "\u5360\u7528" : "\u91ca\u653e") + "\u8d22\u52a1\u53d6\u6570,\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)booleanCommonResponse));
            if (!booleanCommonResponse.isSuccess()) {
                throw new BusinessException(booleanCommonResponse.getMsg());
            }
            if (!((Boolean)booleanCommonResponse.getData()).booleanValue()) {
                throw new BusinessException(("Y".equals(cwFlag) ? "\u5360\u7528" : "\u91ca\u653e") + "\u8d22\u52a1\u53d6\u6570\u5931\u8d25\uff01");
            }
        }
    }

    @Override
    public void delete(List<AssetAmortizeFinanceVO> vos) {
        if (vos.size() > 1) {
            throw new BusinessException("\u4e0d\u652f\u6301\u6279\u91cf\u5220\u9664\uff01");
        }
        AssetAmortizeFinanceEntity entity = (AssetAmortizeFinanceEntity)((Object)super.selectById((Serializable)vos.get(0).getId()));
        List<AssetAmortizeFinanceDetailEntity> assetAmortizeFinanceDetailList = entity.getAssetAmortizeFinanceDetailList();
        if (CollectionUtils.isNotEmpty(assetAmortizeFinanceDetailList)) {
            ArrayList<String> del = new ArrayList<String>();
            for (AssetAmortizeFinanceDetailEntity detailEntity : assetAmortizeFinanceDetailList) {
                String[] split = detailEntity.getDetailAmortizeDate().split("-");
                del.add(split[0] + split[1]);
            }
            this.updatePeriod(entity.getProjectId(), del, "N");
        }
        super.removeByIds((Collection)vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
    }

    @Override
    public CommonResponse<AssetAmortizeFinanceVO> pushCost(AssetAmortizeFinanceVO vo) {
        AssetAmortizeFinanceEntity entity = (AssetAmortizeFinanceEntity)((Object)super.selectById((Serializable)vo.getId()));
        if (CollectionUtils.isNotEmpty(entity.getAssetAmortizeFinanceDetailList())) {
            List detailEntityList = BeanMapper.mapList((Iterable)vo.getAssetAmortizeFinanceDetailList(), AssetAmortizeFinanceDetailEntity.class);
            entity.setAssetAmortizeFinanceDetailList(detailEntityList);
        }
        super.saveOrUpdate((Object)entity, false);
        this.costPush(entity);
        return CommonResponse.success((Object)BeanMapper.map((Object)((Object)entity), AssetAmortizeFinanceVO.class));
    }

    @Override
    public void costPush(AssetAmortizeFinanceEntity entity) {
        String oldRelationFlag;
        this.logger.info("\u5f00\u59cbcostPush");
        List<AssetAmortizeFinanceDetailEntity> detailList = entity.getAssetAmortizeFinanceDetailList();
        String newRelationFlag = "1";
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(detailList)) {
            for (AssetAmortizeFinanceDetailEntity detailEntity : detailList) {
                if (null != detailEntity.getSubjectId() && null != detailEntity.getWbsId()) continue;
                newRelationFlag = "0";
                break;
            }
        }
        if (ListUtil.isEmpty(detailList)) {
            newRelationFlag = "0";
        }
        if ("1".equals(oldRelationFlag = entity.getRelationFlag())) {
            if ("1".equals(newRelationFlag)) {
                this.saveCost(entity);
            }
            if (!"1".equals(newRelationFlag)) {
                this.logger.info("\u5220\u9664\u6210\u672c\u4e2d\u5fc3\u4e4b\u524d\u7684\u6570\u636e-\u9886\u6599\u51fa\u5e93Id---{}", (Object)entity.getId());
                CommonResponse commonResponse = this.costDetailApi.deleteSubject(entity.getId());
                this.logger.info("\u7ed3\u679c" + JSONObject.toJSONString((Object)commonResponse));
                if (!commonResponse.isSuccess()) {
                    throw new BusinessException(commonResponse.getMsg());
                }
            }
        }
        if ("0".equals(oldRelationFlag) && "1".equals(newRelationFlag)) {
            this.saveCost(entity);
        }
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.in(BaseEntity::getId, new Object[]{entity.getId()});
        updateWrapper.set(AssetAmortizeFinanceEntity::getRelationFlag, (Object)newRelationFlag);
        super.update((Wrapper)updateWrapper);
        entity.setRelationFlag(newRelationFlag);
    }

    private void saveCost(AssetAmortizeFinanceEntity entity) {
        String linkUrl = "/ejc-proequipmentp-frontend/#/assetAmortizeFinance/card?id=" + entity.getId();
        String billName = SourceTypeEnum.\u56fa\u5b9a\u8d44\u4ea7\u644a\u9500_\u8d22\u52a1.getTypeName();
        ArrayList<CostDetailVO> costDetailVOList = new ArrayList<CostDetailVO>();
        List<AssetAmortizeFinanceDetailEntity> detailList = entity.getAssetAmortizeFinanceDetailList();
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(detailList)) {
            for (AssetAmortizeFinanceDetailEntity detailEntity : detailList) {
                CostDetailVO costDetailVO = new CostDetailVO();
                costDetailVO.setSourceBillCode(entity.getBillCode());
                costDetailVO.setSourceBillName(billName);
                costDetailVO.setSourceBillUrl(linkUrl);
                costDetailVO.setSubjectId(detailEntity.getSubjectId());
                costDetailVO.setSubjectId(detailEntity.getSubjectId());
                costDetailVO.setSubjectCode(detailEntity.getSubjectCode());
                costDetailVO.setSubjectName(detailEntity.getSubjectName());
                costDetailVO.setWbsId(detailEntity.getWbsId());
                costDetailVO.setWbsCode(detailEntity.getWbsCode());
                costDetailVO.setWbsName(detailEntity.getWbsName());
                costDetailVO.setSourceId(entity.getId());
                costDetailVO.setSourceDetailId(detailEntity.getId());
                costDetailVO.setHappenTaxMny(detailEntity.getDetailAmortizeMny());
                costDetailVO.setHappenMny(detailEntity.getDetailAmortizeMny());
                costDetailVO.setHappenDate(entity.getBillDate());
                costDetailVO.setCreateUserName(this.sessionManager.getUserContext().getUserName());
                costDetailVO.setSourceType("ZCTX_CW");
                costDetailVO.setSourceTabType("ZCTX_CW_DETAIL");
                costDetailVO.setProjectId(entity.getProjectId());
                costDetailVOList.add(costDetailVO);
            }
        }
        if (ListUtil.isNotEmpty(costDetailVOList)) {
            this.logger.info("\u63a8\u9001\u6570\u636e--------" + JSONObject.toJSONString(costDetailVOList));
            CommonResponse stringCommonResponse = this.costDetailApi.saveSubject(costDetailVOList);
            this.logger.info("\u63a8\u9001\u7ed3\u679c--------" + JSONObject.toJSONString((Object)stringCommonResponse));
            if (!stringCommonResponse.isSuccess()) {
                throw new BusinessException(stringCommonResponse.getMsg());
            }
        }
    }

    @Override
    public ParamsCheckVO checkParams(AssetAmortizeFinanceVO vo) {
        ArrayList paramsCheckVOS = new ArrayList();
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        HashMap<String, List> map = new HashMap<String, List>();
        String[] paramsArray = new String[]{"alert", "warn", "none"};
        if (CollectionUtils.isNotEmpty(paramsCheckVOS)) {
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if (map.containsKey(warnType)) {
                    List checkDsVOS = (List)map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType, checkDsVOS);
                    continue;
                }
                map.put(warnType, checkVO.getDataSource());
            }
        }
        for (String s : paramsArray) {
            if (!map.containsKey(s)) continue;
            paramsCheckVO.setWarnType(s);
            paramsCheckVO.setDataSource((List)map.get(s));
            if (CollectionUtils.isEmpty((Collection)paramsCheckVO.getDataSource())) {
                paramsCheckVO.setWarnType("none");
                continue;
            }
            return paramsCheckVO;
        }
        return paramsCheckVO;
    }

    @Override
    public List<ParamsCheckVO> checkParamsRatio(AssetAmortizeFinanceVO vo) {
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ArrayList<ParamsCheckVO> paramsCheckVOList = new ArrayList<ParamsCheckVO>();
        CommonResponse billParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId(CHECK_PARAM_CODE, vo.getOrgId());
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            List data = (List)billParamByCode.getData();
            this.logger.info("\u6bd4\u4f8b\u63a7\u5236\u4fe1\u606f\u8fd4\u56de\uff1a" + JSONObject.toJSONString((Object)data));
            if (CollectionUtils.isNotEmpty((Collection)data)) {
                for (BillParamVO datum : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    ArrayList checkDsVOS = new ArrayList();
                    BigDecimal roleValue = datum.getRoleValue();
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOList.add(paramsCheckVO);
                }
            }
        } else {
            this.logger.info(billParamByCode.getMsg());
            throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
        }
        return paramsCheckVOList;
    }
}

