package com.ejianc.business.purchase.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.contractbase.api.IParamCheckApi;
import com.ejianc.business.contractbase.filing.enums.FilingStatusEnum;
import com.ejianc.business.promaterial.contract.vo.ContractChangeVO;
import com.ejianc.business.purchase.bean.*;
import com.ejianc.business.purchase.enums.ChangeStatusEnum;
import com.ejianc.business.purchase.enums.DraftTypeEnum;
import com.ejianc.business.purchase.enums.PerformanceStatusEnum;
import com.ejianc.business.purchase.enums.SignatureStatusEnum;
import com.ejianc.business.purchase.mapper.ChangePurchaseContractMapper;
import com.ejianc.business.purchase.service.IChangePurchaseContractService;
import com.ejianc.business.purchase.service.IContractChangeAsyncService;
import com.ejianc.business.purchase.service.IPurchaseContractRecordService;
import com.ejianc.business.purchase.service.IPurchaseContractService;
import com.ejianc.business.purchase.vo.*;
import com.ejianc.business.signaturemanage.api.ISignatureCommonApi;
import com.ejianc.business.signaturemanage.vo.WatermarkVO;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.ParamsCheckDsVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.business.vo.util.TreeNodeBUtil;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

import static java.math.BigDecimal.ROUND_HALF_DOWN;

/**
 * 购置合同-变更表
 *
 * @author generator
 */
@Service("changePurchaseContractService")
public class ChangePurchaseContractServiceImpl extends BaseServiceImpl<ChangePurchaseContractMapper, ChangePurchaseContractEntity> implements IChangePurchaseContractService {

    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IParamCheckApi paramCheckApi;

    @Autowired
    private IPurchaseContractService contractService;

    @Autowired
    private IPurchaseContractRecordService recordService;

    @Autowired
    private IChangePurchaseContractService changeService;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private PurchaseContractClauseServiceImpl contractClauseService;

    @Autowired
    private PurchaseContractPaymentClauseServiceImpl contractPaymentService;

    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IExecutionApi executionApi;

    private static final String linkUrl = "ejc-proequipmentp-frontend/#/machineryPurchaseContract/card?id=";//此处需要根据实际修改

    private static final String changeLinkUrl = "ejc-proequipmentp-frontend/#/machineryPurchaseContract/contractChangeCard?id=";//此处需要根据实际修改

    private static final String BILL_TYPE = "BT220323000000001";//合同单据编码

    private static final String CHANGE_BILL_TYPE = "BT220323000000002";//变更合同单据编码
    @Autowired
    private IParamConfigApi paramConfigApi;

    private static final String CHECK_PARAM_CODE = "P-z3M80967";//变更金额控制

    private static final String WATERMARK_CHECK_PARAM_NAME = "P-00a9W886";

    @Autowired
    ISignatureCommonApi signatureCommonApi;

    @Autowired
    private IContractChangeAsyncService contractChangeAsyncService;

    /**
     * @param id
     * @Description saveOrUpdate 查询当前合同下变更列表
     */
    @Override
    public ChangePurchaseContractVO queryDetailRecord(Long id) {
        PurchaseContractEntity contractEntity = contractService.selectById(id);
        ChangePurchaseContractVO changeVO = new ChangePurchaseContractVO();
        changeVO.setId(id);
        changeVO.setBaseTaxMny(contractEntity.getBaseTaxMny() == null ? BigDecimal.ZERO : contractEntity.getBaseTaxMny());
        //现合同金额（含税）
        changeVO.setContractTaxMny(contractEntity.getContractTaxMny() == null ? BigDecimal.ZERO : contractEntity.getContractTaxMny());

        QueryParam param = new QueryParam();
        param.getParams().put("contract_id", new Parameter(QueryParam.EQ, id));
//        param.getParams().put("contract_performance_state", new Parameter(QueryParam.EQ, PerformanceStatusEnum.履约中.getCode()));
        param.getOrderMap().put("change_date", QueryParam.DESC);
        param.getOrderMap().put("create_time", QueryParam.DESC);
        Map<String, Object> resp = new HashMap<>();
        QueryWrapper wrapper = changeToQueryWrapper(param);
        wrapper.select("sum(change_mny) as sumChangeMoney, count(*) as changeNum");
        resp = super.getMap(wrapper);

        //设置变更详情
        changeVO.setChangeList(BeanMapper.mapList(queryList(param), ChangePurchaseContractVO.class));

        BigDecimal sumChangeMoney = null != resp.get("sumChangeMoney") ? new BigDecimal(resp.get("sumChangeMoney").toString()) : BigDecimal.ZERO;
        BigDecimal changeAmtRate = BigDecimal.ZERO;
        if (null != contractEntity.getBaseTaxMny() && contractEntity.getBaseTaxMny().compareTo(BigDecimal.ZERO) > 0) {
            changeAmtRate = (sumChangeMoney.divide(contractEntity.getBaseTaxMny(), 8, ROUND_HALF_DOWN)).multiply(new BigDecimal(100));
        }

        changeVO.setAllChangeMny(sumChangeMoney);
        Long changeNum = (Long) resp.get("changeNum");
        changeVO.setChangeNum(changeNum != null ? Integer.valueOf(String.valueOf(changeNum)) : 0);
        changeVO.setChangeMnyRate(changeAmtRate);
        //区分是否主合同的变更合同
        changeVO.setSupplementFlag(contractEntity.getSupplementFlag());
        changeVO.setAddType(contractEntity.getAddType());

        //判断能否新增变更
        if (SignatureStatusEnum.已签章.getCode().equals(contractEntity.getSignatureStatus())
                && (BillStateEnum.PASSED_STATE.getBillStateCode().equals(contractEntity.getBillState())
                || BillStateEnum.COMMITED_STATE.getBillStateCode().equals(contractEntity.getBillState()))
                && (!(PerformanceStatusEnum.已解除.getCode().equals(contractEntity.getContractPerformanceState()) || PerformanceStatusEnum.已冻结.getCode().equals(contractEntity.getContractPerformanceState())|| PerformanceStatusEnum.已封账.getCode().equals(contractEntity.getContractPerformanceState())))) {
            changeVO.setEditFlag(this.editChangeFlag(id));
        }
        return changeVO;
    }

    /**
     * 查询能否变更
     *
     * @param contractId
     * @return
     */
    @Override
    public Boolean editChangeFlag(Long contractId) {
         /*
            一个主合同仅有一个未生效得补充协议
            单据生效： 当单据审批通过，且签章状态为已签章
            自由态也不能新增
         */
        LambdaQueryWrapper<ChangePurchaseContractEntity> lambda = new LambdaQueryWrapper<>();
        lambda.eq(ChangePurchaseContractEntity::getContractId, contractId);
        lambda.and(l -> l.ne(ChangePurchaseContractEntity::getSignatureStatus, SignatureStatusEnum.已签章.getCode()).or(c -> c.notIn(ChangePurchaseContractEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode())));
        List<ChangePurchaseContractEntity> changeList = super.list(lambda);
        if (changeList.size() > 0) {
            return false;
        }
        return true;
    }

    /**
     * @param contractId
     * @Author yangst
     * @Description 新增根据合同主键查询变更合同需要的主合同字段
     */
    @Override
    public ChangePurchaseContractVO addConvertByConId(Long contractId, Long changeId) {
        PurchaseContractEntity contractEntity = contractService.selectById(contractId);
//        if(ChangeStatusEnum.变更中.getCode().equals(contractEntity.getChangeStatus()) && null == changeId) {
//            return queryDetail(contractEntity.getChangeId());
//        }
        ChangePurchaseContractVO changeVO = BeanMapper.map(contractEntity, ChangePurchaseContractVO.class);
        changeVO.setBillState(null);
        changeVO.setBeforeChangeMny(contractEntity.getContractMny());
        changeVO.setBeforeChangeTaxMny(contractEntity.getContractTaxMny());
        changeVO.setBeforeContractName(contractEntity.getContractName());
        changeVO.setChangeDraftType(DraftTypeEnum.上传合同.getCode().toString());
        changeVO.setContractId(contractId);
        changeVO.setChangeVersion(contractEntity.getChangeVersion() == null ? 1 : contractEntity.getChangeVersion() + 1);
        changeVO.setSignatureStatus(SignatureStatusEnum.未签章.getCode());
        contractEntity.setChangingMny(BigDecimal.ZERO);
        contractEntity.setChangingTaxMny(BigDecimal.ZERO);
        changeVO.setCreateUserCode(null);
        changeVO.setCreateTime(null);
        changeVO.setUpdateUserCode(null);
        changeVO.setUpdateTime(null);
        changeVO.setChangeDate(new Date());
        changeVO.setId(null);
        changeVO.setCommitDate(null);
        changeVO.setCommitUserCode(null);
        changeVO.setCommitUserName(null);
        changeVO.setEffectiveDate(null);
        changeVO.setChangeFileId(null);
        changeVO.setChangeFilePath(null);
        changeVO.setWatermarkContractFileId(null); // 水印设置为null
        changeVO.setChangeFilingStatus(FilingStatusEnum.未归档.getTypeCode());

        //设置明细表字段
        resetSub(changeVO);

        return changeVO;
    }

    @Override
    public ChangePurchaseContractVO queryDetail(Long id) {
        Map<String, LinkedHashMap<String, String>> orderMap = new HashMap<>();
        LinkedHashMap<String, String> orderParams = new LinkedHashMap<>();
        orderMap.put("detailList", orderParams);
        orderMap.put("otherCostList", orderParams);

        ChangePurchaseContractEntity changeEntity = super.selectById(id, orderMap);
        ChangePurchaseContractVO changeVO = new ChangePurchaseContractVO();
        if (null != changeEntity) {
            changeVO = BeanMapper.map(changeEntity, ChangePurchaseContractVO.class);
        }

//        if (CollectionUtils.isNotEmpty(changeVO.getDetailList())) {
//            for (ChangeEquipmentDetailedVO detail : changeVO.getDetailList()) {
//                detail.setDocId(detail.getId());
//                detail.setDocId(detail.getParentId() != null ? detail.getParentId() : null);
//            }
//            changeVO.setDetailList(TreeNodeBUtil.buildTree(changeVO.getDetailList()));
//        }

        return changeVO;
    }

    private void resetSub(ChangePurchaseContractVO changeVO) {
        //设置明细表字段
        List<ChangeEquipmentDetailedVO> changeDetailList = changeVO.getDetailList();
        if (CollectionUtils.isNotEmpty(changeDetailList)) {
            changeDetailList.forEach(changeDetailVO -> {
                changeDetailVO.setSrcTblId(changeDetailVO.getId());
                changeDetailVO.setBeforeChangeNum(BigDecimal.valueOf(changeDetailVO.getPurchaseNum()));
                changeDetailVO.setBeforeChangePrice(changeDetailVO.getPurchasePrice());
                changeDetailVO.setBeforeChangeRate(changeDetailVO.getTaxRate());
                changeDetailVO.setParentId(changeDetailVO.getParentId() != null ? changeDetailVO.getParentId() : null);
                changeDetailVO.setRowState("edit");
                changeDetailVO.setId(null);
            });
        }
        changeVO.setDetailList(changeDetailList);
        //其他费用
        List<ChangeOtherDetailedVO> changeOtherCostVOList = changeVO.getOtherCostList();
        if (CollectionUtils.isNotEmpty(changeOtherCostVOList)) {
            changeOtherCostVOList.forEach(changeOtherCostVO -> {
                changeOtherCostVO.setSrcTblId(changeOtherCostVO.getId());
                changeOtherCostVO.setBeforeChangeNum(BigDecimal.valueOf(changeOtherCostVO.getNum()));
                changeOtherCostVO.setBeforeChangePrice(changeOtherCostVO.getTaxPrice());
                changeOtherCostVO.setBeforeChangeRate(changeOtherCostVO.getTaxRate());
                changeOtherCostVO.setRowState("edit");
                changeOtherCostVO.setId(null);
            });
        }
        //清单
        List<ChangePurchaseContractClauseVO> changeClauseList = changeVO.getClauseList();
        if (CollectionUtils.isNotEmpty(changeClauseList)) {
            changeClauseList.forEach(changeClauseVO -> {
                changeClauseVO.setRowState("add");
                changeClauseVO.setId(null);
            });
        }

        //付款阶段
        List<ChangePurchasePaymentClauseVO> payList = changeVO.getPaymentList();
        if (CollectionUtils.isNotEmpty(payList)) {
            payList.forEach(item -> {
                item.setRowState("add");
            });
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ChangePurchaseContractVO insertOrUpdate(ChangePurchaseContractVO changeVO, Boolean isControl) {
        //获取主合同当前合同文件Id
        PurchaseContractEntity contract = contractService.selectById(changeVO.getContractId());
        //将主合同原合同文件从attachId中删除，否改文件会被该写到变更合同中
        if (CollectionUtils.isNotEmpty(changeVO.getAttachIds()) && null != contract.getContractFileId()) {
            changeVO.getAttachIds().remove(contract.getContractFileId());
        }

        ChangePurchaseContractEntity changeEntity = BeanMapper.map(changeVO, ChangePurchaseContractEntity.class);
        if(changeEntity.getFilingRef() == null){
            changeEntity.setFilingRef(0);
        }


        //变更合同只能存在一条未生效的
        //查询语句，主合同id一致，且变更id不同，单据状态不为已通过或已提交的，或签章状态不为已签章的
        LambdaQueryWrapper<ChangePurchaseContractEntity> lambdachange = Wrappers.<ChangePurchaseContractEntity>lambdaQuery();
        lambdachange.eq(ChangePurchaseContractEntity::getContractId, changeVO.getContractId());
        if (changeVO.getId() != null) {
            lambdachange.ne(ChangePurchaseContractEntity::getId, changeVO.getId());
        }
        lambdachange.and(l -> l.ne(ChangePurchaseContractEntity::getSignatureStatus, SignatureStatusEnum.已签章.getCode()).or(c -> c.notIn(ChangePurchaseContractEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode())));
        int num = super.count(lambdachange);
        if (num > 0) {
            throw new BusinessException("该合同已存在未生效的变更单!");
        }

        if (changeEntity.getId() == null) {
            changeEntity.setSignatureStatus(SignatureStatusEnum.未签章.getCode());
            changeEntity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            changeEntity.setContractPerformanceState(PerformanceStatusEnum.未签订.getCode());
            //校验编码是否重复
            if (StringUtils.isBlank(changeEntity.getBillCode()) || contract.getBillCode().equals(changeEntity.getBillCode())) {
                if (changeEntity.getChangeVersion() < 10) {
                    changeEntity.setBillCode(contract.getBillCode() + "-1-0" + changeEntity.getChangeVersion());
                }
                else {
                    changeEntity.setBillCode(contract.getBillCode() + "-1-" + changeEntity.getChangeVersion());
                }
            }
            else {
                //校验编码唯一
                if (checkSameBillCode(changeEntity)) {
                    throw new BusinessException("编码重复，不允许保存!");
                }
            }
        }
        else {
            //校验编码是否重复
            ChangePurchaseContractEntity dbEntity = super.selectById(changeEntity.getId());
            if (StringUtils.isBlank(changeEntity.getBillCode())) {
                changeEntity.setBillCode(dbEntity.getBillCode());
            }
            else if (!dbEntity.getBillCode().equals(changeEntity.getBillCode()) && checkSameBillCode(changeEntity)) {
                //校验编码唯一
                throw new BusinessException("编码重复，不允许保存!");
            }
        }
        if (!isControl){
            // 合同变更保存前校验
            contractService.checkContract(changeVO.getContractId(), changeVO.getId());
        }

        //保存前清空主键和父主键，重新生成
        List<ChangeEquipmentDetailedEntity> beforeDetails = changeEntity.getDetailList();
//        if(CollectionUtils.isNotEmpty(beforeDetails)){
//            Map<String, Long> idMap = new HashMap<>();
//            for(ChangeEquipmentDetailedEntity detail : beforeDetails){
//                if(null == changeVO.getId() || null == detail.getId()) {
//                    detail.setId(IdWorker.getId());
//                }
//                idMap.put(detail.getDocId().toString(), detail.getId());
//                detail.setParentId(null);
//            }
//            for (ChangeEquipmentDetailedEntity detail : beforeDetails) {
//                if (StringUtils.isNotEmpty(detail.getDocId().toString())) {
//                    detail.setParentId(idMap.get(detail.getDocId().toString()));
//                }
//            }
//        }
        //目标成本删除之前数据
        //判断是否是第一次变更
        //集采时不推成本执行数据
        if (changeVO.getId() == null && !isControl) {
            QueryWrapper<ChangePurchaseContractEntity> wrapper = new QueryWrapper<>();
            wrapper.eq("contract_id", changeVO.getContractId()).eq("dr",0).orderByDesc("create_time");
            List<ChangePurchaseContractEntity> list = changeService.list(wrapper);
            List<TotalExecutionVO> totalExecutionVOList = new ArrayList<>();
            ExecutionVO executionVO1;
            //判断是否有过变更
            if (list.size() > 0) {
                executionVO1 = contractService.targetCost(BeanMapper.map(list.get(0), PurchaseContractVO.class), CHANGE_BILL_TYPE, changeLinkUrl);
            }
            else {
                PurchaseContractEntity contractEntity = contractService.selectById(changeVO.getContractId());
                executionVO1 = contractService.targetCost(BeanMapper.map(contractEntity, PurchaseContractVO.class), BILL_TYPE, linkUrl);
            }
            //目标成本推送
            totalExecutionVOList.add(executionVO1.getTotalVO());
            logger.info("目标成本推送数据" + JSON.toJSONString(totalExecutionVOList));
            CommonResponse<String> response = executionApi.aggDel(totalExecutionVOList);
            if (!response.isSuccess()) {
                throw new BusinessException("目标成本推送失败," + response.getMsg());
            }
        }
//        if (this.isInsertContractChange(changeEntity)) {
//            changeEntity.setId(null);
//        }
        if (!isControl){
            changeService.saveOrUpdate(changeEntity, false);
            //变更信息回写主合同
            saveWriteContract(changeEntity);
            //目标成本推送
            ExecutionVO executionVO = contractService.targetCost(BeanMapper.map(changeEntity, PurchaseContractVO.class),CHANGE_BILL_TYPE, changeLinkUrl);
            logger.info("目标成本推送数据" + JSON.toJSONString(executionVO));
            CommonResponse<String> response = executionApi.aggPush(executionVO);
            if (!response.isSuccess()) {
                throw new BusinessException("目标成本推送失败," + response.getMsg());
            }
        }
        if (null ==changeEntity.getId() && isControl) {
            changeEntity.setId(IdWorker.getId());
            return BeanMapper.map(changeEntity,ChangePurchaseContractVO.class);
        }
        return queryDetail(changeEntity.getId());
    }
//    /**
//     * 是否合同变更新增
//     *
//     * @param
//     * @return 是否新增
//     */
//    private boolean isInsertContractChange(ChangePurchaseContractEntity contractChangeVO) {
//        return contractChangeVO.getId() == null || contractChangeVO.getId() == 0;
//    }

    /**
     * 校验变更合同的编码是否重复
     *
     * @param changeEntity
     * @return
     */
    private boolean checkSameBillCode(ChangePurchaseContractEntity changeEntity) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        LambdaQueryWrapper<ChangePurchaseContractEntity> lambda = new LambdaQueryWrapper<>();
        lambda.eq(ChangePurchaseContractEntity::getBillCode, changeEntity.getBillCode());
        lambda.eq(ChangePurchaseContractEntity::getTenantId, tenantId);
        if (null != changeEntity.getId() && changeEntity.getId() > 0) {
            lambda.ne(ChangePurchaseContractEntity::getId, changeEntity.getId());
        }
        return super.list(lambda).size() > 0;
    }

    /**
     * 查询变更对比
     *
     * @param id
     * @param
     * @return
     */
    @Override
    public Map<String, Object> queryChangeCompare(Long id) {
        /*
            当前变更合同如果未提交，则和主合同对比
            如果提交，则和合同记录表对比
         */
        LinkedHashMap<String, String> orderByParams = new LinkedHashMap<>();
//        orderByParams.put("treeIndex", QueryParam.ASC);
//        Map<String, LinkedHashMap<String, String>> orders = new HashMap<>();
//        orders.put("detailList", orderByParams);
//        ChangeEntity changeEntity = super.selectById(id, orders);
//        ChangeCompareVO changeCompareVO = BeanMapper.map(changeEntity, ChangeCompareVO.class);
//        ContractEntity contractEntity = contractService.selectById(changeEntity.getContractId());
//
//        ChangeCompareVO beforeChangeVO = new ChangeCompareVO();
//        if (BillStateEnum.PASSED_STATE.getBillStateCode().equals(changeEntity.getBillState())) {
//            //若变更单已审批通过，则查询最新的合同记录
//            LambdaQueryWrapper<RecordEntity> lambda = Wrappers.<RecordEntity>lambdaQuery();
//            lambda.eq(RecordEntity::getChangeId, id)
//                    .eq(RecordEntity::getContractId, changeEntity.getContractId())
//                    .orderByDesc(RecordEntity::getCreateTime);
//            List<RecordEntity> recordList = recordService.list(lambda);
//            if (recordList != null && recordList.size() > 0 && recordList.get(0) != null){
//                beforeChangeVO = BeanMapper.map(recordList.get(0), ChangeCompareVO.class);
//            }
//        }else {
//            beforeChangeVO = BeanMapper.map(contractEntity, ChangeCompareVO.class);
//        }
//
//        Map<String, Object> returnMap = new HashMap<>();
//        if (changeCompareVO != null && beforeChangeVO != null){
//            //设置明细内容
//            if (CollectionUtils.isNotEmpty(changeCompareVO.getDetailList())) {
//                changeCompareVO.setDetailList(TreeNodeBUtil.buildTree(changeCompareVO.getDetailList().stream().filter(detail -> null != detail.getChangeType()).collect(Collectors.toList())));
//            }
//
//            //设置其他花费内容
//            if (CollectionUtils.isNotEmpty(changeCompareVO.getOtherCostList())){
//                changeCompareVO.setOtherCostList(
//                        changeCompareVO.getOtherCostList().stream().filter(cost -> null != cost.getChangeType()).collect(Collectors.toList())
//                );
//            }
//
//            //设置合同条款
//            List<ChangeClauseVO> newClauses = new ArrayList<>();
//            Map<Long, ChangeClauseVO> beforeClauseMap = beforeChangeVO.getClauseList().stream().collect(Collectors.toMap(ChangeClauseVO::getSrcTblId, clause -> clause, (v1,v2) ->v2));
//            if(CollectionUtils.isNotEmpty(changeCompareVO.getClauseList())) {
//
//                changeCompareVO.getClauseList().stream().forEach(clause -> {
//                    if(clause.getSrcTblId() == null) {
//                        //没有来源则说明为新增项
//                        clause.setChangeType(ChangePaymentVO.CHANGE_TYPE_ADD);
//                    } else if(beforeClauseMap.containsKey(clause.getSrcTblId())) {
//                        if(!beforeClauseMap.get(clause.getSrcTblId()).getClauseContent().equals(clause.getClauseContent())) {
//                            //若内容有变更
//                            clause.setBeforeChangeClauseContent((beforeClauseMap.get(clause.getSrcTblId()).getClauseContent()));
//                            clause.setChangeType(ChangePaymentVO.CHANGE_TYPE_CONTENT_CHANGE);
//                            newClauses.add(clause);
//                        }
//
//                        beforeClauseMap.remove(clause.getSrcTblId());
//                    }
//                });
//            }
//            if(MapUtils.isNotEmpty(beforeClauseMap)) {
//                //若原始条款有剩余项，则说这些项变更时被删除
//                beforeClauseMap.values().forEach(c -> {
//                    c.setChangeType(ChangePaymentVO.CHANGE_TYPE_DEL);
//                    newClauses.add(c);
//                });
//            }
//            changeCompareVO.setClauseList(newClauses);
//
//            //设置合同付款阶段
//            List<ChangePaymentVO> newPayList = new ArrayList<>();
//
//            Map<Long, ChangePaymentVO> beforePayMap = beforeChangeVO.getPaymentList().stream().collect(Collectors.toMap(ChangePaymentVO::getSrcTblId, item -> item, (v1,v2) ->v2));
//            if(CollectionUtils.isNotEmpty(changeCompareVO.getClauseList())) {
//                ChangePaymentVO beforeItem = null;
//                for(ChangePaymentVO curItem : changeCompareVO.getPaymentList()) {
//                    if(curItem.getSrcTblId() == null) {
//                        //没有来源则说明为新增项
//                        curItem.setChangeType(ChangePaymentVO.CHANGE_TYPE_ADD);
//                    } else if(beforeClauseMap.containsKey(curItem.getSrcTblId())) {
//                        beforeItem = beforePayMap.get(curItem.getSrcTblId());
//                        if(!beforeItem.getPaymentName().equals(curItem.getPaymentName()) || !beforeItem.getPaymentScale().equals(curItem.getPaymentScale())) {
//                            curItem.setBeforePaymentName(beforeItem.getBeforePaymentName());
//                            curItem.setBeforePaymentScale(beforeItem.getBeforePaymentScale());
//                            curItem.setChangeType(ChangePaymentVO.CHANGE_TYPE_CONTENT_CHANGE);
//                            newPayList.add(curItem);
//                        }
//                        beforeClauseMap.remove(curItem.getSrcTblId());
//                    }
//                }
//            }
//            if(MapUtils.isNotEmpty(beforePayMap)) {
//                //若原始条款有剩余项，则说这些项变更时被删除
//                beforePayMap.values().forEach(c -> {
//                    c.setChangeType(ChangePaymentVO.CHANGE_TYPE_DEL);
//                    newPayList.add(c);
//                });
//            }
//            changeCompareVO.setPaymentList(newPayList);
//
//            returnMap.put("newData", changeCompareVO);
//            returnMap.put("oldData", beforeChangeVO);
//        }
        return null;
    }

    /**
     * 保存回写合同
     *
     * @param changeEntity
     */
    private void saveWriteContract(ChangePurchaseContractEntity changeEntity) {
        /*
            回写主合同，两个金额六个变更
         */
        LambdaUpdateWrapper<PurchaseContractEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.set(PurchaseContractEntity::getChangeId, changeEntity.getId());
        if (null != changeEntity.getChangeMny() && null != changeEntity.getChangeTax()) {
            updateWrapper.set(PurchaseContractEntity::getChangingMny, changeEntity.getContractTaxMny());
        }
        updateWrapper.set(PurchaseContractEntity::getChangingTaxMny, changeEntity.getChangeMny());

        updateWrapper.set(PurchaseContractEntity::getChangeCode, changeEntity.getBillCode());
        updateWrapper.set(PurchaseContractEntity::getChangeVersion, changeEntity.getChangeVersion());
        updateWrapper.set(PurchaseContractEntity::getChangeStatus, ChangeStatusEnum.变更中.getCode());
        updateWrapper.set(PurchaseContractEntity::getChangeDate, changeEntity.getChangeDate());
        updateWrapper.set(PurchaseContractEntity::getChangeDraftType, changeEntity.getChangeDraftType());
        updateWrapper.set(PurchaseContractEntity::getChangeContractSignatureStatus, Integer.valueOf(changeEntity.getSignatureStatus()));
        updateWrapper.set(PurchaseContractEntity::getChangeFileId, changeEntity.getChangeFileId());
        updateWrapper.set(PurchaseContractEntity::getChangeContractName, changeEntity.getContractName());

        updateWrapper.eq(PurchaseContractEntity::getId, changeEntity.getContractId());

        contractService.update(contractService.selectById(changeEntity.getContractId()), updateWrapper, false);
    }

    @Override
    public CommonResponse<String> deleteById(Long changeBillId) {
        ChangePurchaseContractEntity entity = super.selectById(changeBillId);
            //目标成本推送
            //删除数据
            List<TotalExecutionVO> totalExecutionVOList = new ArrayList<>();
            List<PurchaseContractEntity> contractEntityList = new ArrayList<>();
            ExecutionVO executionVO = contractService.targetCost(BeanMapper.map(entity, PurchaseContractVO.class),CHANGE_BILL_TYPE,changeLinkUrl);
            totalExecutionVOList.add(executionVO.getTotalVO());
            contractEntityList.add(contractService.selectById(entity.getContractId()));

            logger.info("目标成本删除数据" + JSON.toJSONString(totalExecutionVOList));
            CommonResponse<String> response = executionApi.aggDel(totalExecutionVOList);
            if (!response.isSuccess()) {
                throw new BusinessException("目标成本推送失败," + response.getMsg());
            }
            //推送上一版数据
            for (PurchaseContractEntity contractEntity : contractEntityList) {
                //目标成本推送
                ExecutionVO executionVO1;
                List<ChangePurchaseContractEntity> contractChangeEntityList = changeService.list(new QueryWrapper<ChangePurchaseContractEntity>().eq("contract_id", contractEntity.getId()).eq("dr",0).orderByDesc("create_time"));
                if (contractChangeEntityList.size() > 1) {
                    executionVO1 = contractService.targetCost(BeanMapper.map(contractChangeEntityList.get(1), PurchaseContractVO.class),CHANGE_BILL_TYPE,changeLinkUrl);
                }
                else {
                    executionVO1 = contractService.targetCost(BeanMapper.map(contractEntity, PurchaseContractVO.class),BILL_TYPE,linkUrl);
                }
                logger.info("目标成本推送数据" + JSON.toJSONString(executionVO1));
                CommonResponse<String> response1 = executionApi.aggPush(executionVO1);
                if (!response1.isSuccess()) {
                    throw new BusinessException("目标成本推送失败," + response1.getMsg());
                }
            }

        //合同变更只有详情页有删除
        PurchaseContractEntity contractEntity = contractService.selectById(entity.getContractId());

        QueryWrapper<ChangePurchaseContractEntity> query = new QueryWrapper<>();
        query.eq("contract_id", contractEntity.getId());
        query.eq("dr", BaseVO.DR_UNDELETE);
        query.ne("id", changeBillId);
        int count = super.count(query);

        contractEntity.setChangeVersion(contractEntity.getChangeVersion() - 1);
        contractEntity.setChangeStatus(count > 0 ? ChangeStatusEnum.已变更.getCode() : ChangeStatusEnum.未变更.getCode());
        //修改变更中金额
        contractEntity.setChangingMny(BigDecimal.ZERO);
        contractEntity.setChangingTaxMny(BigDecimal.ZERO);
        contractEntity.setChangeCode(null);
        contractEntity.setChangeId(null);
        contractEntity.setChangeDate(null);
        contractEntity.setChangeDraftType(null);
        contractEntity.setChangeContractSignatureStatus(null);
        contractEntity.setChangeFileId(null);
        contractEntity.setChangeContractName(null);
        contractService.update(contractEntity, new QueryWrapper<PurchaseContractEntity>().eq("id", contractEntity.getId()), false);

        super.removeById(changeBillId, false);
        return CommonResponse.success("删除成功！");
    }

    @Override
    public ChangePurchaseContractVO queryChangeRecord(Long contractId, Long changeId) {
        PurchaseContractEntity contractEntity = contractService.selectById(contractId);

        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contract_id", new Parameter(QueryParam.EQ, contractEntity.getId()));
        queryParam.getParams().put("change_id", new Parameter(QueryParam.EQ, changeId));
        queryParam.getOrderMap().put("createTime", QueryParam.DESC);
        List<PurchaseContractRecordEntity> recordList = recordService.queryList(queryParam);
        ChangePurchaseContractVO changeVO = new ChangePurchaseContractVO();
        if (CollectionUtils.isNotEmpty(recordList)) {
            changeVO = BeanMapper.map(recordList.get(0), ChangePurchaseContractVO.class);
        }

        if (changeVO != null) {
            resetSub(changeVO);
        }

        return changeVO;
    }


    /**
     * 变更单据生效创建记录文件并回写主合同
     *
     * @param changeBillId
     * @param billTypeCode
     * @return
     */
    @Override
    public CommonResponse<String> effectiveSaveWriteContract(Long changeBillId, String billTypeCode, Boolean commitState,Boolean filingFlag ) {
        CommonResponse<String> resp = null;
        /**更新变更的审批时间  begin */
        ChangePurchaseContractEntity changeEntity = this.selectById(changeBillId);
        if (commitState) {
            changeEntity.setCommitDate(new Date());
            changeEntity.setCommitUserCode(sessionManager.getUserContext().getUserCode());
            changeEntity.setCommitUserName(sessionManager.getUserContext().getUserName());
        }
//
//        logger.info("进入变更终审！变更表数据------------->: {}", JSONObject.toJSONString(changeEntity));
//
        /**复制合同表数据到记录表 begin */
        PurchaseContractVO contractVO = contractService.queryDetail(changeEntity.getContractId());
        //获取当前合同记录数
        QueryWrapper<PurchaseContractRecordEntity> countQuery = new QueryWrapper<>();
        countQuery.eq("contract_id", contractVO.getId());
        countQuery.eq("dr", BaseVO.DR_UNDELETE);
        int curRecordVersion = recordService.count(countQuery);

        Map<Long, Integer> contIdVersionMap = new HashMap<>();
        PurchaseContractRecordEntity recordEntity = BeanMapper.map(contractVO, PurchaseContractRecordEntity.class);
        recordEntity.setContractId(recordEntity.getId());
        recordEntity.setChangeVersion(curRecordVersion + 1);
        recordEntity.setId(null);
        logger.info("变更前主合同数据: {}", JSONObject.toJSONString(contractVO));
        logger.info("变更前主合同子表detail数据: {}", JSONObject.toJSONString(contractVO.getDetailList()));
        logger.info("记录表从主合同表复制的数据: {}", JSONObject.toJSONString(recordEntity));
        logger.info("记录表从主合同表复制的数据的子表detail数据: {}", JSONObject.toJSONString(recordEntity.getDetailList()));

        if (CollectionUtils.isNotEmpty(recordEntity.getDetailList())) {
            recordEntity.getDetailList().forEach(vo -> {
                contIdVersionMap.put(vo.getId(), vo.getVersion());
                vo.setSrcTblId(vo.getId());
                vo.setId(null);
            });
        }
        if (CollectionUtils.isNotEmpty(recordEntity.getClauseList())) {
            recordEntity.getClauseList().forEach(vo -> {
                vo.setSrcTblId(vo.getId());
                vo.setId(null);
            });
        }
        if (CollectionUtils.isNotEmpty(recordEntity.getOtherCostList())) {
            recordEntity.getOtherCostList().forEach(vo -> {
                vo.setSrcTblId(vo.getId());
                vo.setId(null);
            });
        }
        if (CollectionUtils.isNotEmpty(recordEntity.getPaymentList())) {
            recordEntity.getPaymentList().forEach(vo -> {
                vo.setSrcTblId(vo.getId());
                vo.setId(null);
            });
        }

        logger.info("记录表从主合同表复制的子表detail数据，设置id后的值: {}", JSONObject.toJSONString(recordEntity.getDetailList()));
        recordService.saveOrUpdate(recordEntity, false);
        logger.info("审批-变更记录表保存主合同数据成功！");
        //根据实体RefCode查询实体单据类型

        //原合同附件、起草附件同步到记录单据中
        resp = attachmentApi.copyFilesFromSourceBillToTargetBill(contractVO.getId().toString(), "BT220323000000001", "BT220323000000001",
                recordEntity.getId().toString(), "BT220323000000003", "BT220323000000003");//附件
        logger.info("resp---{}", JSONObject.toJSONString(resp));
        resp = attachmentApi.copyFilesFromSourceBillToTargetBill(contractVO.getId().toString(), "BT220323000000001", "attachMgr",
                recordEntity.getId().toString(), "BT220323000000003", "attachMgr");//附件
        logger.info("resp---{}", JSONObject.toJSONString(resp));
//        /**复制合同表数据到记录表 end */

        /**更新变更表主表数据到原合同 begin */
        logger.info("更新变更数据到主合同表,contractVO---------------->: {}", JSONObject.toJSONString(contractVO));
        PurchaseContractEntity contractEntity = BeanMapper.map(contractVO, PurchaseContractEntity.class);
        //基本信息
        contractEntity.setContractName(changeEntity.getContractName());
        contractEntity.setFirstPartyId(changeEntity.getFirstPartyId());
        contractEntity.setFirstPartyName(changeEntity.getFirstPartyName());
        contractEntity.setSupplierId(changeEntity.getSupplierId());
        contractEntity.setSupplierName(changeEntity.getSupplierName());
        contractEntity.setSignDate(changeEntity.getSignDate());
        contractEntity.setSignPlace(changeEntity.getSignPlace());
        contractEntity.setTaxRate(changeEntity.getTaxRate());
        contractEntity.setDraftType(changeEntity.getDraftType());
        contractEntity.setContractFilePath(changeEntity.getContractFilePath());
        contractEntity.setContractFileId(changeEntity.getContractFileId());
        contractEntity.setContractTemplateId(changeEntity.getContractTemplateId());
        contractEntity.setContractTemplateName(changeEntity.getContractTemplateName());
        contractEntity.setContractFileVersionId(changeEntity.getContractFileVersionId());
        contractEntity.setContractFileVersion(changeEntity.getContractFileVersion());
        contractEntity.setFirstPartyPhone(changeEntity.getFirstPartyPhone());
        contractEntity.setSupplierPhone(changeEntity.getSupplierPhone());
        contractEntity.setSupplierEmployee(changeEntity.getSupplierEmployee());
        contractEntity.setProjectAddress(changeEntity.getProjectAddress());
        contractEntity.setInvoiceTypeId(changeEntity.getInvoiceTypeId());
        contractEntity.setInvoiceTypeName(changeEntity.getInvoiceTypeName());

        //款项
        contractEntity.setContractTaxMny(changeEntity.getContractTaxMny());
        contractEntity.setContractMny(changeEntity.getContractMny());
        contractEntity.setContractTax(changeEntity.getContractTax());
        contractEntity.setEquipmentMny(changeEntity.getEquipmentMny());
        contractEntity.setEquipmentTaxMny(changeEntity.getEquipmentTaxMny());
        contractEntity.setEquipmentTax(changeEntity.getEquipmentTax());
        contractEntity.setOtherMny(changeEntity.getOtherMny());
        contractEntity.setOtherTaxMny(changeEntity.getOtherMny());
        contractEntity.setOtherTax(changeEntity.getOtherTax());

		/*
			起草方式为线下签订，则变更合同为已签章，直接生效。主合同状态改为已变更
			起草方式为线上起草、上传合同，则主合同状态改为变更单据已生效
		 */
        contractEntity.setChangeStatus(ChangeStatusEnum.已变更.getCode());
        contractEntity.setChangeContractSignatureStatus(Integer.valueOf(SignatureStatusEnum.已签章.getCode()));
        //清空变更单信息
        contractEntity.setChangingMny(null);
        contractEntity.setChangingTaxMny(null);

        logger.info("1212-进入变更终审审核完回调------>合同提交，线下签订直接修改签章状态");
        //设置变更合同生效状态
        changeEntity.setSignatureStatus(SignatureStatusEnum.已签章.getCode());
        changeEntity.setContractPerformanceState(PerformanceStatusEnum.履约中.getCode());
        //合同已生效，添加生效时间
        changeEntity.setEffectiveDate(new Date());

        if (filingFlag){
            changeEntity.setChangeFilingStatus(FilingStatusEnum.已归档.getTypeCode());
            changeEntity.setFilingRef(0);
        }


        //同步变更单附件（不包含变更变更附件）到原合同
        resp = attachmentApi.copyFilesFromSourceBillToTargetBill(changeBillId.toString(), "BT220323000000002", "BT220323000000002",
                contractEntity.getId().toString(), "BT220323000000001", "BT220323000000001");//附件
        logger.info("resp---{}", JSONObject.toJSONString(resp));

        //变更单更新
        changeService.saveOrUpdate(changeEntity);
        logger.info("更新变更表合同状态和数据,changeEntity---------->： {}", JSONObject.toJSONString(changeEntity));

        /**更新变更表主表数据到原合同 end */

        /**更新变更子表数据到原合同子表 begin */
        logger.info("更新变更表数据到主合同开始----------->" + contractEntity.getChangeStatus());
        PurchaseContractEntity contractChangeEntity = BeanMapper.map(changeEntity, PurchaseContractEntity.class);
        List<ChangeEquipmentDetailedEntity> changeDetailList = changeEntity.getDetailList();
        Map<Long, Long> changDetailIdMap = new HashMap<>();
		/*
			变更详情表和合同详情表有一个字段不一样
			变更详情表里 来源子表主键 srcTblId
			合同详情表里 变更子表主键 changeBid
		 */
        if (CollectionUtils.isNotEmpty(changeDetailList)) {
            changeDetailList.forEach(changeDetailEntity -> {
                //设置id和来源子表主键对应map
                changDetailIdMap.put(changeDetailEntity.getId(), changeDetailEntity.getSrcTblId());
            });
        }

        List<EquipmentDetailedEntity> contractDetailList = contractChangeEntity.getDetailList();
        if (CollectionUtils.isNotEmpty(contractDetailList)) {
            Long contractBid = null;
            for (EquipmentDetailedEntity contractDetailEntity : contractDetailList) {
                contractBid = changDetailIdMap.get(contractDetailEntity.getId());

                contractDetailEntity.setContractId(changeEntity.getContractId());
                //设置变更子表主键
                contractDetailEntity.setChangeBid(contractDetailEntity.getId());
                //设置父级Id
                if (null != contractDetailEntity.getParentId()) {
                    contractDetailEntity.setParentId(changDetailIdMap.get(contractDetailEntity.getParentId()));
                }

                //合同子表对应变更子表主键
                contractDetailEntity.setId(contractBid);
                contractDetailEntity.setVersion(contIdVersionMap.get(contractBid));
                contractDetailEntity.setChangeType(null);
            }
        }
        contractEntity.setDetailList(contractDetailList);

        //其他费用表
        List<ChangeOtherDetailedEntity> changeOtherCostList = changeEntity.getOtherCostList();
        Map<Long, Long> changOtherCostIdMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(changeOtherCostList)) {
            changeOtherCostList.forEach(changeOtherCostEntity -> {
                //设置id和来源子表主键对应map
                changOtherCostIdMap.put(changeOtherCostEntity.getId(), changeOtherCostEntity.getSrcTblId());
            });
        }
        List<OtherDetailedEntity> contractOtherCostList = contractChangeEntity.getOtherCostList();
        if (CollectionUtils.isNotEmpty(contractOtherCostList)) {
            Long contractBid = null;
            for (OtherDetailedEntity contractOtherCostEntity : contractOtherCostList) {
                contractBid = changOtherCostIdMap.get(contractOtherCostEntity.getId());
                //设置变更子表主键
                contractOtherCostEntity.setChangeBid(contractOtherCostEntity.getId());
                //合同子表对应变更子表主键
                contractOtherCostEntity.setId(contractBid);
                contractOtherCostEntity.setVersion(contIdVersionMap.get(contractBid));
                contractOtherCostEntity.setContractId(contractEntity.getId());
            }
        }
        contractEntity.setOtherCostList(contractOtherCostList);

        //先删除合同条款表
        List<PurchaseContractClauseEntity> contractClauseList = contractEntity.getClauseList();
        List<PurchaseContractClauseEntity> contractChangeClauseList = contractChangeEntity.getClauseList();
        if (CollectionUtils.isNotEmpty(contractClauseList)) {
            logger.info("删除合同条款子表数据: {}", JSONObject.toJSONString(contractClauseList));
            contractClauseService.deleteByIds(contractClauseList.stream().map(PurchaseContractClauseEntity::getId).collect(Collectors.toList()));

            contractChangeClauseList.forEach(clauseEntity -> {
                clauseEntity.setChangeBid(clauseEntity.getId());
                clauseEntity.setId(null);
                clauseEntity.setRowState("add");
                clauseEntity.setContractId(contractEntity.getId());
            });
        }
        contractEntity.setClauseList(contractChangeClauseList);

        //合同付款阶段
        List<PurchaseContractPaymentClauseEntity> contractPayList = contractEntity.getPaymentList();
        List<PurchaseContractPaymentClauseEntity> pList = contractChangeEntity.getPaymentList();
        if (CollectionUtils.isNotEmpty(contractPayList)) {
            logger.info("删除合同付款阶段子表数据: {}", JSONObject.toJSONString(contractPayList));
            contractPaymentService.deleteByIds(contractPayList.stream().map(PurchaseContractPaymentClauseEntity::getId).collect(Collectors.toList()));

            pList.forEach(item -> {
                item.setChangeBid(item.getId());
                item.setId(null);
                item.setRowState("add");
                item.setContractId(contractEntity.getId());
            });
        }
        contractEntity.setPaymentList(pList);
        contractService.saveOrUpdate(contractEntity, false);
        // 推送合同池
        contractService.pushContract(BeanMapper.map(contractEntity, PurchaseContractVO.class));
        logger.info("更新合同表数据成功,contractEntity---------->: {}", JSONObject.toJSONString(contractEntity));

        /**更新变更子表数据到原合同子表 end */
        return CommonResponse.success("变更单生效，回写合同成功！");
    }

    /**
     * 文件复制
     *
     * @param srcBillId           源单据Id
     * @param srcBillTypeCode     源单据类型
     * @param targetBillId        目标单据Id
     * @param targetBillTypeCode  目标单据类型
     * @param srcAttachSourceType 源单据附件业务类型
     * @return
     */
    private CommonResponse copyFile(String srcBillId, String srcBillTypeCode, String targetBillId, String targetBillTypeCode, String srcAttachSourceType, boolean copyContractFile) {

        //同步合同附件列表
        CommonResponse copyContractAttachResp = attachmentApi.copyFilesFromSourceBillToTargetBill(srcBillId, srcBillTypeCode,
                srcAttachSourceType, targetBillId, targetBillTypeCode, srcAttachSourceType);
        if (!copyContractAttachResp.isSuccess()) {
            logger.info("同步合同文件失败--------------->srcBillId-{},srcBillTypeCode-{},srcSourceType-{},targetBillId-{},targetBillTypeCode-{},targetSourceType-{},：{}"
                    , srcBillId, srcBillTypeCode, "BT220323000000003", targetBillId, targetBillTypeCode, "BT220323000000003", copyContractAttachResp.getMsg());
            logger.info("同步附件管理中的附件失败--------------->失败信息------------>：{}", copyContractAttachResp.getMsg());
            return CommonResponse.error("审批失败，同步附件失败，错误信息：" + copyContractAttachResp.getMsg());
        }

        if (copyContractFile) {
            //同步合同文件
            CommonResponse copyContractFileResp = attachmentApi.copyFilesFromSourceBillToTargetBill(srcBillId, srcBillTypeCode, "BT220323000000001",
                    targetBillId, targetBillTypeCode, "BT220323000000003");
            if (!copyContractFileResp.isSuccess()) {
                logger.info("同步合同文件失败--------------->srcBillId-{},srcBillTypeCode-{},srcSourceType-{},targetBillId-{},targetBillTypeCode-{},targetSourceType-{},：{}"
                        , srcBillId, srcBillTypeCode, "BT220323000000001", targetBillId, targetBillTypeCode, "BT220323000000003", copyContractFileResp.getMsg());
                return CommonResponse.error("审批失败，同步合同文件失败，错误信息：" + copyContractFileResp.getMsg());
            }
        }

        return null;
    }

    @Override
    public ParamsCheckVO targetCostCtrl(ChangePurchaseContractVO changeContractVO) {
        ChangePurchaseContractVO contractVO1 = insertOrUpdate(changeContractVO,true);

        QueryWrapper<ChangePurchaseContractEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("contract_id", contractVO1.getContractId()).eq("dr",0).orderByDesc("create_time");
        List<ChangePurchaseContractEntity> list = changeService.list(wrapper);
        if (list.size() > 0) {
            contractVO1.setMainContractId(list.get(0).getId());
        }else {
            contractVO1.setMainContractId(changeContractVO.getContractId());
        }

        ExecutionVO executionVO = contractService.targetCost(BeanMapper.map(contractVO1, PurchaseContractVO.class),CHANGE_BILL_TYPE, changeLinkUrl);
        logger.error("目标成本推送控制" + JSONObject.toJSONString(executionVO));
        CommonResponse<ParamsCheckVO> response = executionApi.ctrlCheckVO(executionVO);
        ParamsCheckVO paramsCheckVO = checkParams(changeContractVO, response.getData());
        return paramsCheckVO;
    }

    @Override
    public ParamsCheckVO viewTargetCostCtrlInfo(Long id) {
        ChangePurchaseContractVO contractVO = queryDetail(id);
        ExecutionVO executionVO = contractService.targetCost(BeanMapper.map(contractVO, PurchaseContractVO.class),CHANGE_BILL_TYPE, changeLinkUrl);
        logger.error("ss" + JSONObject.toJSONString(executionVO));
        CommonResponse<ParamsCheckVO> response = executionApi.ctrlCheckVO(executionVO);
        ParamsCheckVO paramsCheckVO = checkParams(contractVO, response.getData());
        return paramsCheckVO;
    }

    //单据参数控制
    @Override
    public ParamsCheckVO checkParams(ChangePurchaseContractVO vo, ParamsCheckVO paramsCheckVO2){
        List<ParamsCheckVO> paramsCheckVOS = new ArrayList<>();
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        /*添加参数控制区域---*/
        if(CollectionUtils.isNotEmpty(this.checkParamsConstruction(vo))){
            paramsCheckVOS.addAll(this.checkParamsConstruction(vo));//施工合同控制
        }
        paramsCheckVOS.addAll(this.checkParamsMny(vo));//合同金额控制变更金额
        if(paramsCheckVO2!=null){//组合成本参数
            paramsCheckVOS.add(paramsCheckVO2);
        }
        /*添加参数控制区域---*/
        Map<String, List<ParamsCheckDsVO>> map = new HashMap<>();
        String[] paramsArray = {"alert", "warn", "none"};
        if(org.apache.commons.collections.CollectionUtils.isNotEmpty(paramsCheckVOS)){
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if(map.containsKey(warnType)){
                    List<ParamsCheckDsVO> checkDsVOS = map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType,checkDsVOS);
                }else {
                    map.put(warnType,checkVO.getDataSource());
                }
            }
        }
        for (String s : paramsArray) {
            if(map.containsKey(s)){
                paramsCheckVO.setWarnType(s);
                paramsCheckVO.setDataSource(map.get(s));
                if(org.apache.commons.collections.CollectionUtils.isEmpty(paramsCheckVO.getDataSource())){
                    paramsCheckVO.setWarnType("none");
                }else {
                    return paramsCheckVO;
                }
            }
        }
        return paramsCheckVO;
    }
    //施工合同参数控制
    @Override
    public List<ParamsCheckVO> checkParamsConstruction(ChangePurchaseContractVO vo) {
        CommonResponse<List<ParamsCheckVO>> response = paramCheckApi.paramsCheck(vo.getProjectId(), vo.getContractId(), vo.getContractTaxMny(),vo.getOrgId());
        logger.info("施工合同控制信息返回："+JSONObject.toJSONString(response.getData()));
        if(!response.isSuccess()){
            throw new BusinessException("获取施工参数控制信息失败!"+response.getMsg());
        }
        return response.getData();
    }
    /**
     * 单据管控-累计变更金额大于合同金额
     * @return
     */
    @Override
    public List<ParamsCheckVO> checkParamsMny(ChangePurchaseContractVO vo) {
        BigDecimal changeMoney  = vo.getChangeMny()==null?BigDecimal.ZERO:vo.getChangeMny();
        BigDecimal contractTaxMny = vo.getBaseTaxMny()==null?BigDecimal.ZERO:vo.getBaseTaxMny();//初始合同金额
        BigDecimal totalChangeMoney =  changeMoney;//累计变更金额  默认赋值本次
        //查询累计变更金额
        QueryWrapper<ChangePurchaseContractEntity> query = new QueryWrapper<>();
        query.eq("contract_id", vo.getContractId());
        query.eq("dr", BaseVO.DR_UNDELETE);
        query.in("bill_state",1,3);
        query.eq("signature_status",SignatureStatusEnum.已签章.getCode());
        List<ChangePurchaseContractEntity> list = this.list(query);
        if(org.apache.commons.collections.CollectionUtils.isNotEmpty(list)){
            for (ChangePurchaseContractEntity changeEntity : list) {
                totalChangeMoney = ComputeUtil.safeAdd(changeEntity.getChangeMny(),totalChangeMoney);//累加变更金额
            }
        }
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        List<ParamsCheckVO> paramsCheckVOList = new ArrayList<>();
//        CommonResponse<BillParamVO> billParamByCode = paramConfigApi.getBillParamByCode(CHECK_PARAM_CODE);
        CommonResponse<List<BillParamVO>> billParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(CHECK_PARAM_CODE,vo.getOrgId());
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            List<BillParamVO> data = billParamByCode.getData();
            if(org.apache.commons.collections.CollectionUtils.isNotEmpty(data)){
                for (BillParamVO datum : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    List<ParamsCheckDsVO> checkDsVOS = new ArrayList<>();
                    BigDecimal roleValue = datum.getRoleValue();
                    BigDecimal comMny = ComputeUtil.safeDiv(ComputeUtil.safeMultiply(contractTaxMny, roleValue), new BigDecimal("100")).setScale(2, BigDecimal.ROUND_HALF_UP);
                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    if (totalChangeMoney.compareTo(comMny) > 0) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setOrgName(datum.getOrgName());
                        paramsCheckDsVO.setWarnItem("变更超合同金额");
                        paramsCheckDsVO.setWarnName("累计变更金额大于合同金额");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("本次变更金额：").append(changeMoney.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("元，含本次累计变更金额：").append(totalChangeMoney.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("元，合同金额*").append(roleValue).append("%:").append(comMny.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("元。超出金额：").append(ComputeUtil.safeSub(totalChangeMoney, comMny).setScale(2, BigDecimal.ROUND_HALF_UP)).append("元");
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOList.add(paramsCheckVO);
                }
            }
        } else {
            logger.info(billParamByCode.getMsg());
            throw new BusinessException("获取控制参数失败");
        }
        return paramsCheckVOList;
    }


    /**
     * 根据变更合同id给水印文件赋值
     *
     * @param id 变更合同id
     */
    @Override
    public void asyncWatermarkById(Long id) {
        ChangePurchaseContractEntity changeEntity = super.selectById(id);
        logger.info("开始获取水印参数信息，变更合同id：{}--------", id);
        // 水印系统参数
        CommonResponse<ParamRegisterSetVO> response = paramConfigApi.getByCode(WATERMARK_CHECK_PARAM_NAME);
        logger.info("获取水印系统参数请求结果：{}", JSONObject.toJSONString(response));
        if (!response.isSuccess() || response.getData() == null) {
            throw new BusinessException("获取水印系统参数请求失败，失败原因：" + response.getMsg());
        }
        String valueData = response.getData().getValueData();
        Assert.hasText(valueData, "获取的水印系统参数不能为空!");

        // 是否限制： 0:不限制，1:限制
        if ("0".equals(valueData)) {
            String billType = "BT220323000000002";
            String sourceType = "purchaseContract";
            // 转换水印参数配置：默认规则
            WatermarkVO watermarkVO = signatureCommonApi.fetchWatermarkConfig(changeEntity.getChangeFileId(), changeEntity.getId(),
                    changeEntity.getBillCode(), billType, sourceType);
            Assert.notNull(watermarkVO, "获取水印系统参数失败!");
            // 获取上下文并异步调用添加水印
            HttpServletRequest request = ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();
            HashMap<String, String> headers = new HashMap<>();
            headers.put("authority", request.getHeader("authority"));
            headers.put("ejc-token", request.getHeader("ejc-token"));
            contractChangeAsyncService.fetchWatermarkAttachment(headers, watermarkVO);
        }
    }
}
