package com.ejianc.business.estimate.controller;

import java.io.Serializable;

import com.ejianc.business.estimate.bean.PurchaseEstimateDetailedEntity;
import com.ejianc.business.estimate.service.IPurchaseEstimateDetailedService;
import com.ejianc.business.estimate.vo.PurchaseEstimateDetailedVO;
import com.ejianc.business.proequipmentcorppur.purchaseplan.vo.PurchasePlanDetailedVO;
import com.ejianc.business.proequipmentcorppur.purchaseplan.vo.PurchasePlanEnum;
import com.ejianc.business.proequipmentcorppur.purchaseplan.vo.PurchasePlanVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.CollectionUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.estimate.bean.PurchaseEstimateEntity;
import com.ejianc.business.estimate.service.IPurchaseEstimateService;
import com.ejianc.business.estimate.vo.PurchaseEstimateVO;

/**
 * 购置计划(新)
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("purchaseEstimate")
public class PurchaseEstimateController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改
    @Autowired
    private IPurchaseEstimateService service;
    @Autowired
    private IPurchaseEstimateDetailedService estimateDetailedService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IProjectPoolApi projectPoolApi;
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<PurchaseEstimateVO> saveOrUpdate(@RequestBody PurchaseEstimateVO saveOrUpdateVO) {
    	PurchaseEstimateEntity entity = BeanMapper.map(saveOrUpdateVO, PurchaseEstimateEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdates(entity);
    	PurchaseEstimateVO vo = BeanMapper.map(entity, PurchaseEstimateVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PurchaseEstimateVO> queryDetail(Long id) {
    	PurchaseEstimateEntity entity = service.selectById(id);
    	PurchaseEstimateVO vo = BeanMapper.map(entity, PurchaseEstimateVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PurchaseEstimateVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (PurchaseEstimateVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(PurchaseEstimateVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<PurchaseEstimateVO>> queryList(@RequestBody QueryParam param) {

        param.getFuzzyFields().add("planName");
        param.getFuzzyFields().add("employee");
        param.getFuzzyFields().add("orgName");
        param.getFuzzyFields().add("planYear");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (!param.getParams().containsKey("orgId")) {
            /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
            UserContext userContextCache = sessionManager.getUserContext();
            //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
            String authOrgIds = userContextCache.getAuthOrgIds();
            List<OrgVO> orgVOList = null;
            if (StringUtils.isNotBlank(authOrgIds)) {//移动端查询
                orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
            }
            else {//pc端查询
                orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
            }
            //普通组织 id
            List<Long> commonOrgIds = new ArrayList<>();
            //项目部 id
            List<Long> departmentIds = new ArrayList<>();
            orgVOList.stream().forEach(org -> {
                if (5 == org.getOrgType()) {
                    //项目部
                    departmentIds.add(org.getId());
                }
                else {
                    //普通组织
                    commonOrgIds.add(org.getId());
                }
            });
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(commonOrgIds)) {
                /** 要求主表有orgId字段，保存单据所属组织 */
                param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, commonOrgIds));
            }
            else if (org.apache.commons.collections.CollectionUtils.isNotEmpty(departmentIds)) {
                /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
                param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
            }
            /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        }

        IPage<PurchaseEstimateEntity> page = service.queryPage(param, false);
        IPage<PurchaseEstimateVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), PurchaseEstimateVO.class));
        pageData.getRecords().forEach(t->t.setPlanStateName(PurchasePlanEnum.getDescriptionByStateCode(t.getPlanState())));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        param.getFuzzyFields().add("planName");
        param.getFuzzyFields().add("employee");
        param.getFuzzyFields().add("orgName");
        param.getFuzzyFields().add("planYear");
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        List<PurchaseEstimateEntity> list = service.queryList(param);
        List<PurchaseEstimateVO> voList = new ArrayList<>();
        if(list.size()>0){
            voList = BeanMapper.mapList(list, PurchaseEstimateVO.class);
            for (PurchaseEstimateVO vo: voList){
                vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
            }
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", voList);
        ExcelExport.getInstance().export("purchasePlan-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refPurchaseEstimateData", method = RequestMethod.GET)
    @ResponseBody
    public List<PurchaseEstimateVO> refPurchaseEstimateData(@RequestParam(required = false) String searchText,
                                                    @RequestParam(required = false) String condition) {
        Long orgId = null;
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            orgId = _con.getLong("orgId");
        }
        if (orgId == null) {
            throw new BusinessException("采购单位id必须传！");
        }
        List<PurchaseEstimateVO> dataList = service.queryPlanListByOrgId(orgId);
        SimpleDateFormat sim  = new SimpleDateFormat("yyyy");
        if (CollectionUtil.isNotEmpty(dataList)) {
            for (PurchaseEstimateVO vo : dataList) {
                vo.setName(vo.getBillCode() + "-" + vo.getEmployee()+"-"+sim.format(vo.getPlanYear()));
            }
        }
        return dataList;
    }


    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refPurchaseEstimateDataByProjectId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<PurchaseEstimateVO>> refPurchaseEstimateDataByProjectId(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                                String condition,
                                                                                String searchObject,
                                                                                String searchText) {
        QueryParam params = new QueryParam();
        params.setPageSize(pageSize);
        params.setPageIndex(pageNumber);
        params.setSearchText(searchText);
        params.setSearchObject(searchObject);
        /** 租户隔离 */
        Long projectId = null;
        Long orgId = null;
        params.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            projectId = _con.getLong("projectId");
            orgId = _con.getLong("orgId");
        }
        params.getParams().put("billState", new Parameter(QueryParam.IN, Arrays.asList(1,3)));
        params.getParams().put("planState", new Parameter(QueryParam.EQ, 0));
        if (projectId != null) {
//            params.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
            CommonResponse<List<Long>> projectResponse = projectPoolApi.queryProjectIdsByParentProjectId(projectId);
            if (!projectResponse.isSuccess()) {
                throw new BusinessException("查询项目信息失败！");
            }
            params.getParams().put("projectId", new Parameter(QueryParam.IN, projectResponse.getData()));
        }
        if (orgId !=null){
            CommonResponse<OrgVO> orgResp = iOrgApi.getOneById(orgId);
            OrgVO orgVO = orgResp.getData();
            /** 数据隔离，如果查询组织为项目部，查询orgId，否则查询parentOrgId本下 */
            if (OrgVO.ORG_TYPE_DEPARTMENT.equals(orgVO.getOrgType())) {
                params.getParams().put("orgId", new Parameter(QueryParam.EQ, orgId));
            }
            else {
                params.getParams().put("parentOrgId", new Parameter(QueryParam.IN, iOrgApi
                        .findChildrenByParentIdWithoutProjectDept(orgId).getData().stream().map(OrgVO::getId)
                        .collect(Collectors.toList())));
            }
        }
//        if (CollectionUtil.isNotEmpty(list)) {
//            for(PurchasePlanEntity entity : list){
//                idList.add(entity.getId());
//            }
//        }
//        if(CollectionUtil.isNotEmpty(idList)){
//            param.getParams().put("planId",new Parameter(QueryParam.IN,idList));
//            param.getParams().put("doc_id",new Parameter(QueryParam.NE,null));
//            param.getParams().put("doc_category_id",new Parameter(QueryParam.NE,null));
//        }else{
//            return null;
//        }
        IPage<PurchaseEstimateEntity> page = service.queryPage(params, false);
        IPage<PurchaseEstimateVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), PurchaseEstimateVO.class));
        // 查询采购清单
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(pageData.getRecords())) {
            List<PurchaseEstimateVO> batPlanVOList = pageData.getRecords();
            List<String> idList = batPlanVOList.stream().map(PurchaseEstimateVO::getId).map(String::valueOf)
                    .collect(Collectors.toList());
            // 查询子表
            QueryParam detailParam = new QueryParam();
            detailParam.getParams().put("planId", new Parameter(QueryParam.IN, idList));
            detailParam.getParams().put("doc_id",new Parameter(QueryParam.NE,null));
            List<PurchaseEstimateDetailedEntity> detailEntityList = estimateDetailedService.queryList(detailParam);
            List<PurchaseEstimateDetailedVO> detailVOList = BeanMapper.mapList(detailEntityList, PurchaseEstimateDetailedVO.class);
            Map<Long, List<PurchaseEstimateDetailedVO>> detailMap = new HashMap<>();
            List<PurchaseEstimateDetailedVO> mapList;
            // 按照planID对子表结果分组
            for (PurchaseEstimateDetailedVO vo : detailVOList) {
                if (detailMap.containsKey(vo.getEstimateId())) {
                    detailMap.get(vo.getEstimateId()).add(vo);
                }
                else {
                    mapList = new ArrayList<>();
                    mapList.add(vo);
                    detailMap.put(vo.getEstimateId(), mapList);
                }
            }
            // 将采购计划清单添加到采购计划中
            batPlanVOList.forEach(batPlanVO -> {
                batPlanVO.setDetailList(detailMap.get(batPlanVO.getId()));
            });
        }

        return CommonResponse.success("查询参照数据成功！", pageData);
    }
}
