/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.estimate.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.estimate.bean.PurchaseEstimateDetailedEntity;
import com.ejianc.business.estimate.bean.PurchaseEstimateEntity;
import com.ejianc.business.estimate.mapper.PurchaseEstimateMapper;
import com.ejianc.business.estimate.service.IPurchaseEstimateService;
import com.ejianc.business.estimate.vo.PurchaseEstimateVO;
import com.ejianc.business.proequipmentcorppur.purchaseplan.vo.PurchasePlanEnum;
import com.ejianc.business.promaterial.plan.vo.BatPlanEnum;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.CollectionUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service(value="purchaseEstimateService")
public class PurchaseEstimateServiceImpl
extends BaseServiceImpl<PurchaseEstimateMapper, PurchaseEstimateEntity>
implements IPurchaseEstimateService {
    @Override
    public void saveOrUpdates(PurchaseEstimateEntity entity) {
        List<PurchaseEstimateDetailedEntity> listbs = entity.getDetailList();
        if (CollectionUtil.isNotEmpty(listbs)) {
            HashMap<Long, Long> idMap = new HashMap<Long, Long>();
            for (PurchaseEstimateDetailedEntity cdEntity : listbs) {
                cdEntity.setPlanCode(entity.getBillCode());
                cdEntity.setRemainingNum(cdEntity.getPlanNum());
                cdEntity.setAppliedNum(0L);
                if (null != cdEntity.getParentId()) continue;
                idMap.put(cdEntity.getDocCategoryId(), cdEntity.getId());
            }
            for (PurchaseEstimateDetailedEntity cdEntity : listbs) {
                if (null != cdEntity.getParentId()) {
                    cdEntity.setParentId((Long)idMap.get(cdEntity.getDocCategoryId()));
                    cdEntity.setTid(cdEntity.getId());
                    continue;
                }
                cdEntity.setTid(cdEntity.getId());
            }
        }
        super.saveOrUpdate((Object)entity, false);
    }

    @Override
    public List<PurchaseEstimateVO> queryPlanListByOrgId(Long orgId) {
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"org_id", (Object)orgId);
        List entityList = super.list((Wrapper)query);
        List list = BeanMapper.mapList((Iterable)entityList, PurchaseEstimateVO.class);
        return list;
    }

    @Override
    public Boolean checkSameBillCode(PurchaseEstimateVO contractVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.eq(PurchaseEstimateEntity::getBillCode, (Object)contractVO.getBillCode());
        lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
        if (null != contractVO.getId() && contractVO.getId() > 0L) {
            lambda.ne(BaseEntity::getId, (Object)contractVO.getId());
        }
        return super.list((Wrapper)lambda).size() > 0;
    }

    @Override
    public void updateBatPlanByQuoteType(List<String> idList, Integer planState) {
        List entityList;
        if (StringUtils.isEmpty((CharSequence)PurchasePlanEnum.getDescriptionByStateCode((Integer)planState))) {
            throw new BusinessException("\u8ba1\u5212\u72b6\u6001\u9519\u8bef");
        }
        if (CollectionUtils.isNotEmpty(idList) && CollectionUtils.isNotEmpty((Collection)(entityList = (List)super.listByIds(idList)))) {
            for (PurchaseEstimateEntity entity : entityList) {
                if (BatPlanEnum.PLAN_STATE_OVER.getPlanState().equals(entity.getPlanState())) {
                    throw new BusinessException("\u91c7\u8d2d\u8ba1\u5212\u7f16\u7801\u3010" + entity.getBillCode() + "\u3011\u5df2\u91c7\u8d2d\u5b8c\u6210\uff01");
                }
                entity.setPlanState(planState);
            }
            super.saveOrUpdateBatch((Collection)entityList);
        }
    }

    @Override
    public List<PurchaseEstimateVO> queryEstimateListByProjectId(Long projectId) {
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"project_id", (Object)projectId);
        List entityList = super.list((Wrapper)query);
        List list = BeanMapper.mapList((Iterable)entityList, PurchaseEstimateVO.class);
        return list;
    }
}

