package com.ejianc.business.purchase.service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.purchase.bean.PurchaseContractRelieveEntity;

/**
 * 购置合同-合同解除表
 * 
 * @author generator
 * 
 */
public interface IPurchaseContractRelieveService extends IBaseService<PurchaseContractRelieveEntity> {
    /**
     * 根据合同编号查询是否可以新增合同解除单据
     *
     * @param contractId 合同id
     * @return Boolean 是否可以新增
     */
    Boolean isCanRelieve(Long contractId);
    /**
     * 更新合同解除单据签章状态和合同状态
     *
     * @param billId  合同解除单据id
     * @param status  签章状态
     * @param refCode 唯一标识
     * @return 结果数据
     */
    CommonResponse<String> relieveContract(String billId, String status, String refCode);
}
