package com.ejianc.business.estimate.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 购置计划(新)
 * 
 * @author generator
 * 
 */
 @TableName("ejc_proequipment_purchase_estimate")
public class PurchaseEstimateEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_state")
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="plan_year")
    private Date planYear; // 计划年度
    @TableField(value="plan_total_mny")
    private BigDecimal planTotalMny; // 计划购置总金额
    @TableField(value="employee")
    private String employee; // 经办人
    @TableField(value="employee_id")
    private Long employeeId; // 经办人id
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="org_id")
    private Long orgId; // 采购组织id
    @TableField(value="org_name")
    private String orgName; // 采购组织名称
    @TableField(value="org_code")
    private String orgCode; // 采购组织编码
    @TableField(value="plan_name")
    private String planName; // 采购计划名称
    @TableField(value="handle_date")
    private Date handleDate; // 经办日期
    @TableField(value="project_id")
    private Long projectId; // 项目id
    @TableField(value="project_code")
    private String projectCode; // 项目编号
    @TableField(value="project_name")
    private String projectName; // 
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 项目部上级组织Id
    @TableField(value="parent_org_name")
    private String parentOrgName; // 
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 项目部上级组织编码
    @TableField(value="plan_state")
    private Integer planState; // 招标状态:0-待招标,1-招标中，2-已招标


    /**
     * 采购计划-计划清单明细实体
     */
    @TableField(exist = false)
    @SubEntity(serviceName = "purchaseEstimateDetailedService", pidName = "estimateId")
    private List<PurchaseEstimateDetailedEntity> detailList = new ArrayList<>();


    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Date getPlanYear() {
        return planYear;
    }

    public void setPlanYear(Date planYear) {
        this.planYear = planYear;
    }
    public BigDecimal getPlanTotalMny() {
        return planTotalMny;
    }

    public void setPlanTotalMny(BigDecimal planTotalMny) {
        this.planTotalMny = planTotalMny;
    }
    public String getEmployee() {
        return employee;
    }

    public void setEmployee(String employee) {
        this.employee = employee;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getPlanName() {
        return planName;
    }

    public void setPlanName(String planName) {
        this.planName = planName;
    }
    public Date getHandleDate() {
        return handleDate;
    }

    public void setHandleDate(Date handleDate) {
        this.handleDate = handleDate;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public Integer getPlanState() {
        return planState;
    }

    public void setPlanState(Integer planState) {
        this.planState = planState;
    }

    public List<PurchaseEstimateDetailedEntity> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<PurchaseEstimateDetailedEntity> detailList) {
        this.detailList = detailList;
    }
}
