package com.ejianc.business.asset.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.asset.bean.AssetAmortizeEntity;
import com.ejianc.business.asset.service.IAssetAmortizeService;
import com.ejianc.business.asset.service.IAssetRecordService;
import com.ejianc.business.asset.vo.AssetAmortizeDetailVO;
import com.ejianc.business.asset.vo.AssetAmortizeVO;
import com.ejianc.business.consts.AssetAmortizeEnum;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IShareEquipmentApi;
import com.ejianc.foundation.share.vo.EquipmentVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 固定资产摊销
 *
 * @author generator
 */
@Controller
@RequestMapping("assetAmortize")
@Api(value = "固定资产摊销", tags = {"固定资产摊销"})
public class AssetAmortizeController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IShareEquipmentApi shareEquipmentApi;

    private static final String BILL_CODE = "ASSET_AMORTIZE_CODE";

    @Autowired
    private IAssetAmortizeService service;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IAssetRecordService assetRecordService;

    @RequestMapping(value = "/test", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Boolean> test() {
        AssetAmortizeVO assetAmortizeVO = new AssetAmortizeVO();
        assetAmortizeVO.setId(1L);
        AssetAmortizeDetailVO assetAmortizeDetailVO = new AssetAmortizeDetailVO();
        assetAmortizeDetailVO.setAssetName("ceshi");
        assetAmortizeDetailVO.setEquipmentName("测试啊");
        assetAmortizeVO.setDetailList(Arrays.asList(assetAmortizeDetailVO));
        return CommonResponse.success("查询详情数据成功！", assetRecordService.saveRecord(assetAmortizeVO));
    }

    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<AssetAmortizeVO> saveOrUpdate(@ApiParam(name = "saveOrUpdateVO", required = true) @RequestBody AssetAmortizeVO saveOrUpdateVO) {
        AssetAmortizeEntity entity = BeanMapper.map(saveOrUpdateVO, AssetAmortizeEntity.class);
        LambdaQueryWrapper<AssetAmortizeEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(AssetAmortizeEntity::getOrgId, saveOrUpdateVO.getOrgId());
        queryWrapper.ne(saveOrUpdateVO.getId() != null, AssetAmortizeEntity::getId, saveOrUpdateVO.getId());
        queryWrapper.notIn(AssetAmortizeEntity::getBillState, Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        int count = service.count(queryWrapper);
        if (count > 0) {
            throw new BusinessException("该摊销单位下存在未生效的摊销单！");
        }

        if (entity.getId() == null || entity.getId() == 0) {
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
                entity.setProportionFlag("0"); // 初始化标识
                entity.setRelationFlag("0"); // 初始化标识
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        List<AssetAmortizeDetailVO> detailList = saveOrUpdateVO.getDetailList();
        if (CollectionUtils.isNotEmpty(detailList)) {
            Set<String> categoryName = new HashSet<>();
            for (AssetAmortizeDetailVO detailVO : detailList) {
                if (!"del".equals(detailVO.getRowState()))
                    categoryName.add(detailVO.getEquipmentTypeName());
            }
            String categoryNameStr = StringUtils.join(categoryName.toArray(), ",");
            if (StringUtils.isNotEmpty(categoryNameStr) && categoryNameStr.length() > 1000) {
                categoryNameStr = categoryNameStr.substring(0, 1000);
            }
            entity.setCategoryName(categoryNameStr);
        }
        service.saveOrUpdate(entity, false);
        AssetAmortizeVO vo = BeanMapper.map(entity, AssetAmortizeVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }


    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<AssetAmortizeVO> queryDetail(@RequestParam Long id) {
        AssetAmortizeEntity entity = service.selectById(id);
        AssetAmortizeVO vo = BeanMapper.map(entity, AssetAmortizeVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }


    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<AssetAmortizeVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (AssetAmortizeVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(AssetAmortizeVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }


    @ApiOperation("查询列表")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<AssetAmortizeVO>> queryList(@RequestBody QueryParam param) {
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("billCode", "orgName", "employeeName", "categoryName"));
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        UserContext userContextCache = sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if (StringUtils.isNotBlank(authOrgIds)) {//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        } else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
        }
        Parameter amortizeDatePara = param.getParams().get("amortizeDate");
        if (amortizeDatePara != null) {
            Object value = amortizeDatePara.getValue();
            if (value != null) {
                String[] split = String.valueOf(value).split(",");
                amortizeDatePara.setValue(split[0] + "-01," + split[1] + "-31");
            }
        }
        IPage<AssetAmortizeEntity> page = service.queryPage(param, false);
        IPage<AssetAmortizeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<AssetAmortizeVO> assetAmortizeVOS = BeanMapper.mapList(page.getRecords(), AssetAmortizeVO.class);
        assetAmortizeVOS.forEach(t -> t.setSourceTypeName(AssetAmortizeEnum.getNameByCode(t.getSourceType())));
        pageData.setRecords(assetAmortizeVOS);
        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    @ApiOperation("导出")
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageIndex(1);
        param.setPageSize(-1);
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("billCode", "orgName", "employeeName", "categoryName"));
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        UserContext userContextCache = sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if (StringUtils.isNotBlank(authOrgIds)) {//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        } else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
        }
        List<AssetAmortizeEntity> list = service.queryList(param);
        List<AssetAmortizeVO> assetAmortizeVOS = BeanMapper.mapList(list, AssetAmortizeVO.class);
        assetAmortizeVOS.forEach(
                t -> {
                    t.setBillStateName(BillStateEnum.getEnumByStateCode(t.getBillState()).getDescription());
                    t.setSourceTypeName(AssetAmortizeEnum.getNameByCode(t.getSourceType()));
                }

        );
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", assetAmortizeVOS);
        ExcelExport.getInstance().export("AssetAmortize-export.xlsx", beans, response);
    }


    @ApiOperation("参照")
    @RequestMapping(value = "/refAssetAmortizeData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<AssetAmortizeVO>> refAssetAmortizeData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                       String condition,
                                                                       String searchObject,
                                                                       String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<AssetAmortizeEntity> page = service.queryPage(param, false);
        IPage<AssetAmortizeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), AssetAmortizeVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }


    /**
     * @param orgId
     * @description: 查上次摊销周期
     * @return: com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     * @author songlx
     * @date: 2022/7/12
     */
    @RequestMapping(value = "/getLastAmortizeDate", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> getLastAmortizeDate(Long projectId, Long billId) {
        QueryWrapper<AssetAmortizeEntity> assetAmortizeEntityQueryWrapper = new QueryWrapper<>();
        assetAmortizeEntityQueryWrapper.select("date_format( MAX( amortize_date ), '%Y-%m' ) lastDate");
        assetAmortizeEntityQueryWrapper.eq("project_id", projectId);
        assetAmortizeEntityQueryWrapper.eq(billId != null, "id", billId);
        Map<String, Object> map = service.getMap(assetAmortizeEntityQueryWrapper);
        Object lastDate = map != null ? map.get("lastDate") : null;
        String lastAmortizeDate = lastDate != null ? String.valueOf(lastDate) : null;
        return CommonResponse.success("查询上次摊销周期成功！", lastAmortizeDate);
    }


    /**
     * @param assetAmortizeVO
     * @description: 根据材料清单获取本次摊销金额和成本科目
     * @return: com.ejianc.framework.core.response.CommonResponse<com.ejianc.business.asset.vo.AssetAmortizeVO>
     * @author songlx
     * @date: 2022/7/15
     */
    @ApiOperation("根据材料清单获取本次摊销金额")
    @RequestMapping(value = "/getAmortizeMnyAndSubject", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<AssetAmortizeVO> getAmortizeMnyAndSubject(@ApiParam(name = "assetAmortizeVO", required = true) @RequestBody AssetAmortizeVO assetAmortizeVO) {
        Date amortizeDate = assetAmortizeVO.getAmortizeDate();

        List<AssetAmortizeDetailVO> detailList = assetAmortizeVO.getDetailList();
        if (CollectionUtils.isEmpty(detailList)) {
            return CommonResponse.success("未选择在场设备！", assetAmortizeVO);
        }
        // 获取设备的摊销设置
        service.getAmortizeSet(detailList, assetAmortizeVO.getOrgId());
        //计算本次摊销金额
        service.caclAmortizeMny(detailList, amortizeDate);
        //查询成科目
        if(CollectionUtils.isNotEmpty(assetAmortizeVO.getIdList())){
            CommonResponse<List<EquipmentVO>> listCommonResponse = shareEquipmentApi.queryEquipmentItemByIds(assetAmortizeVO.getIdList());
            if(listCommonResponse.isSuccess()){
                List<EquipmentVO> data = listCommonResponse.getData();
                for (EquipmentVO equipmentVO : data) {
                    for (AssetAmortizeDetailVO detailVO : detailList) {
                        if(equipmentVO.getId().equals(detailVO.getEquipmentId())){
                            if(equipmentVO.getSubjectId()!=null){
                                detailVO.setSubjectId(equipmentVO.getSubjectId());
                                detailVO.setSubjectName(equipmentVO.getSubjectName());
                                detailVO.setSubjectCode(equipmentVO.getCode());
                            }
                        }
                    }
                }
            }
        }
        assetAmortizeVO.setDetailList(detailList);
        return CommonResponse.success("根据材料清单获取本次摊销金额！", assetAmortizeVO);
    }

/**
 * 成本改造
 * 关联保存接口
 * @param
 * @return
 */
    @RequestMapping(value = "/pushCost", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<AssetAmortizeVO> pushCost(AssetAmortizeVO assetAmortizeVO){
        return service.pushCost(assetAmortizeVO);
    }
}
