/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.purchase.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.purchase.bean.ChangePurchaseContractEntity;
import com.ejianc.business.purchase.bean.PurchaseContractEntity;
import com.ejianc.business.purchase.enums.SignatureStatusEnum;
import com.ejianc.business.purchase.service.IChangePurchaseContractService;
import com.ejianc.business.purchase.service.IPurchaseContractService;
import com.ejianc.business.purchase.vo.PurchaseContractVO;
import com.ejianc.business.signaturemanage.api.ISignatureManageApi;
import com.ejianc.business.signaturemanage.vo.SignMgrPreviewVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/purchaseContractFileUpdate/"})
public class PurchaseContractFileController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IPurchaseContractService contractService;
    @Autowired
    private ISignatureManageApi signatureManageApi;
    @Autowired
    private IChangePurchaseContractService changeService;

    @PostMapping(value={"updateFileInfo"})
    public CommonResponse<JSONObject> updateFileInfo(@RequestBody JSONObject updateData) {
        JSONObject resp = new JSONObject();
        this.logger.info("@@@@@@@@@@@@@", (Object)updateData.getLong("billId"));
        PurchaseContractEntity contract = (PurchaseContractEntity)((Object)this.contractService.selectById(updateData.getLong("billId")));
        contract.setContractFileId(updateData.getLong("fileId"));
        contract.setContractFilePath(updateData.getString("fileOnlinePath"));
        contract.setContractFileSyncFlag(true);
        this.contractService.saveOrUpdate((Object)contract, false);
        resp.put("message", (Object)"\u5408\u540c\u6587\u4ef6\u4fe1\u606f\u66f4\u65b0\u6210\u529f");
        resp.put("billData", (Object)contract);
        return CommonResponse.success((String)"\u5408\u540c\u6587\u4ef6\u4fe1\u606f\u66f4\u65b0\u6210\u529f\uff01", (Object)resp);
    }

    @GetMapping(value={"getSignedFileInfo"})
    public CommonResponse<JSONObject> getSignedFileInfo(@RequestParam(value="billId") Long billId, @RequestParam(value="billType") String billType) {
        JSONObject resp = new JSONObject();
        CommonResponse signResp = this.signatureManageApi.previewContract(billId, Arrays.asList(SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode()));
        if (!signResp.isSuccess()) {
            this.logger.error("\u83b7\u53d6\u5355\u636eid-{}\uff0cbillType-{}\u7b7e\u7ae0\u6587\u4ef6\u4fe1\u606f\u5931\u8d25: {}", new Object[]{billId, billType, signResp.getMsg()});
            return CommonResponse.error((String)"\u83b7\u53d6\u5408\u540c\u7b7e\u7ae0\u6587\u4ef6\u4fe1\u606f\u5931\u8d25!");
        }
        List fileList = (List)signResp.getData();
        if (CollectionUtils.isEmpty((Collection)fileList)) {
            return CommonResponse.error((String)"\u4e3a\u83b7\u53d6\u5230\u5408\u540c\u7b7e\u7ae0\u6587\u4ef6\u4fe1\u606f\uff01");
        }
        SignMgrPreviewVO signedFileInfo = (SignMgrPreviewVO)((List)signResp.getData()).get(0);
        if ("contract".equals(billType)) {
            PurchaseContractEntity contract = (PurchaseContractEntity)((Object)this.contractService.selectById(billId));
            contract.setSignedFileId(signedFileInfo.getFileId());
            this.contractService.saveOrUpdate((Object)contract, false);
        } else {
            ChangePurchaseContractEntity contractChange = (ChangePurchaseContractEntity)((Object)this.changeService.selectById(billId));
            contractChange.setSignedFileId(signedFileInfo.getFileId());
            this.changeService.saveOrUpdate((Object)contractChange, false);
        }
        resp.put("fileId", (Object)signedFileInfo.getFileId());
        resp.put("filePath", (Object)signedFileInfo.getFilePath());
        resp.put("fileTruePath", (Object)signedFileInfo.getTruePath());
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)resp);
    }

    @GetMapping(value={"getBillDataJson"})
    public CommonResponse<PurchaseContractVO> getBillDataJson(@RequestParam Long id) {
        this.logger.info("\u5230\u4e86\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002");
        PurchaseContractEntity contract = (PurchaseContractEntity)((Object)this.contractService.selectById(id));
        PurchaseContractVO vo = (PurchaseContractVO)BeanMapper.map((Object)((Object)contract), PurchaseContractVO.class);
        DecimalFormat priceFmt = new DecimalFormat("#,###.####");
        DecimalFormat mnyFmt = new DecimalFormat("#,###.00");
        if (CollectionUtils.isNotEmpty((Collection)vo.getDetailList())) {
            vo.getDetailList().forEach(item -> {
                item.setPurchasePriceStr(null != item.getPurchasePrice() ? priceFmt.format(item.getPurchasePrice()) : priceFmt.format(BigDecimal.ZERO));
                item.setPurchaseAmountStr(null != item.getPurchaseAmount() ? priceFmt.format(item.getPurchaseAmount()) : priceFmt.format(BigDecimal.ZERO));
                item.setEstimateAmortizeMnyStr(null != item.getEstimateAmortizeMny() ? mnyFmt.format(item.getEstimateAmortizeMny()) : mnyFmt.format(BigDecimal.ZERO));
                item.setTaxRateStr(null != item.getTaxRate() ? mnyFmt.format(item.getTaxRate()) : mnyFmt.format(BigDecimal.ZERO));
                item.setPurchasePricetNoTaxStr(null != item.getPurchasePricetNoTax() ? mnyFmt.format(item.getPurchasePricetNoTax()) : mnyFmt.format(BigDecimal.ZERO));
                item.setPurchaseAmountNoTaxStr(null != item.getPurchaseAmountNoTax() ? mnyFmt.format(item.getPurchaseAmountNoTax()) : mnyFmt.format(BigDecimal.ZERO));
                item.setTaxMnyStr(null != item.getTaxMny() ? priceFmt.format(item.getTaxMny()) : priceFmt.format(BigDecimal.ZERO));
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)vo.getOtherCostList())) {
            vo.getOtherCostList().forEach(item -> {
                item.setTaxPriceStr(null != item.getTaxPrice() ? priceFmt.format(item.getTaxPrice()) : priceFmt.format(BigDecimal.ZERO));
                item.setTaxRateStr(null != item.getTaxRate() ? priceFmt.format(item.getTaxRate()) : priceFmt.format(BigDecimal.ZERO));
                item.setAmountStr(null != item.getAmount() ? mnyFmt.format(item.getAmount()) : mnyFmt.format(BigDecimal.ZERO));
                item.setNotTaxPriceStr(null != item.getNotTaxPrice() ? mnyFmt.format(item.getNotTaxPrice()) : mnyFmt.format(BigDecimal.ZERO));
                item.setNotTaxAmountStr(null != item.getNotTaxAmount() ? mnyFmt.format(item.getNotTaxAmount()) : mnyFmt.format(BigDecimal.ZERO));
                item.setTaxMnyStr(null != item.getTaxMny() ? mnyFmt.format(item.getTaxMny()) : mnyFmt.format(BigDecimal.ZERO));
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)vo.getPaymentList())) {
            vo.getPaymentList().forEach(item -> item.setPaymentContentStr(null != item.getPaymentContent() ? priceFmt.format(item.getPaymentContent()) : priceFmt.format(BigDecimal.ZERO)));
        }
        return CommonResponse.success((Object)vo);
    }
}

