package com.ejianc.business.estimate.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.estimate.bean.PurchaseEstimateDetailedEntity;
import com.ejianc.business.estimate.bean.PurchaseEstimateEntity;
import com.ejianc.business.estimate.service.IPurchaseEstimateDetailedService;
import com.ejianc.business.estimate.service.IPurchaseEstimateService;
import com.ejianc.business.purchase.bean.ChangeEquipmentDetailedEntity;
import com.ejianc.business.purchaseplan.bean.PurchasePlanDetailedEntity;
import com.ejianc.business.purchaseplan.service.IPurchasePlanDetailedService;
import com.ejianc.business.purchaseplan.service.IPurchasePlanService;
import com.ejianc.business.purchaseplan.service.impl.PurchasePlanBpmServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.List;

@Service("purchaseEstimate") 
public class PurchaseEstimateBpmServiceImpl implements ICommonBusinessService {
	@Autowired
	private IPurchaseEstimateService service;
	@Autowired
	private IPurchasePlanDetailedService purchasePlanDetailedService;
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		PurchaseEstimateEntity estimateEntity =service.selectById(billId);
		List<PurchaseEstimateDetailedEntity> list =estimateEntity.getDetailList();
		for (PurchaseEstimateDetailedEntity estimateDetailedEntity:list){
			QueryWrapper<PurchasePlanDetailedEntity> queryWrapper = new QueryWrapper<PurchasePlanDetailedEntity>();
			queryWrapper.eq("source_id", estimateDetailedEntity.getId());
			queryWrapper.eq("dr", 0);
			List<PurchasePlanDetailedEntity> planList =purchasePlanDetailedService.list(queryWrapper);
			if(CollectionUtils.isNotEmpty(planList) ){
				return CommonResponse.error("清单被下游单据引用，不允许回退!");
			}
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
