package com.ejianc.business.purchase.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.purchase.bean.ChangePurchaseContractEntity;
import com.ejianc.business.purchase.bean.PurchaseContractEntity;
import com.ejianc.business.purchase.enums.SignatureStatusEnum;
import com.ejianc.business.purchase.service.IChangePurchaseContractService;
import com.ejianc.business.purchase.service.IPurchaseContractService;
import com.ejianc.business.purchase.vo.PurchaseContractVO;
import com.ejianc.business.rent.vo.RentContractVO;
import com.ejianc.business.signaturemanage.api.ISignatureManageApi;
import com.ejianc.business.signaturemanage.vo.SignMgrPreviewVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.List;

/**
 * 合同文件管理控制
 *
 * @author CJ
 * @Description: 合同文件管理控制
 * @date 2021/11/26 14:16
 */
@RestController
@RequestMapping("/purchaseContractFileUpdate/")
public class PurchaseContractFileController {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IPurchaseContractService contractService;


    @Autowired
    private ISignatureManageApi signatureManageApi;

    @Autowired
    private IChangePurchaseContractService changeService;

    /**
     * 合同附件信息更新
     *
     * @param updateData {
     *                   billId 单据Id
     *                   sourceType 单据业务类型
     *                   billType 单据类型
     *                   fileId 文件Id
     *                   fileSize 文件大小（以B为单位）
     *                   fileName 文件名称
     *                   fileOnlinePath 文件在线预览地址
     *                   imgServerPath 文件服务地址
     *                   formatPathStr 文件格式化地址
     *                   }
     * @return
     */
    @PostMapping(value = "updateFileInfo")
    public CommonResponse<JSONObject> updateFileInfo(@RequestBody JSONObject updateData) {
        JSONObject resp = new JSONObject();
        logger.info("@@@@@@@@@@@@@", updateData.getLong("billId"));
        PurchaseContractEntity contract = contractService.selectById(updateData.getLong("billId"));
        contract.setContractFileId(updateData.getLong("fileId"));
        //contract.setContractFileHighlightId(updateData.getLong("fileId"));
        contract.setContractFilePath(updateData.getString("fileOnlinePath"));
        //contract.setContractFileHighlightPath(updateData.getString("fileOnlinePath"));
        //将合同文件同步状态设置为已同步
        contract.setContractFileSyncFlag(true);
        contractService.saveOrUpdate(contract, false);


        resp.put("message", "合同文件信息更新成功");
        resp.put("billData", contract);
        return CommonResponse.success("合同文件信息更新成功！", resp);
    }

    /**
     * 获取合同签章完的文件信息
     *
     * @param billId   合同Id
     * @param billType 单据类型：contract-主合同/变更协议, contractChange-合同变更、协议变更
     * @return
     */
    @GetMapping(value = "getSignedFileInfo")
    public CommonResponse<JSONObject> getSignedFileInfo(@RequestParam(value = "billId") Long billId, @RequestParam(value = "billType") String billType) {
        JSONObject resp = new JSONObject();
        CommonResponse<List<SignMgrPreviewVO>> signResp = signatureManageApi.previewContract(billId, Arrays.asList(new String[]{SignatureStatusEnum.已签章.getCode()}));
        if (!signResp.isSuccess()) {
            logger.error("获取单据id-{}，billType-{}签章文件信息失败: {}", billId, billType, signResp.getMsg());
            return CommonResponse.error("获取合同签章文件信息失败!");
        }

        List<SignMgrPreviewVO> fileList = signResp.getData();
        if (CollectionUtils.isEmpty(fileList)) {
            return CommonResponse.error("为获取到合同签章文件信息！");
        }

        SignMgrPreviewVO signedFileInfo = signResp.getData().get(0);
        if ("contract".equals(billType)) {
            PurchaseContractEntity contract = contractService.selectById(billId);
            contract.setSignedFileId(signedFileInfo.getFileId());
            contractService.saveOrUpdate(contract, false);
        } else {
            ChangePurchaseContractEntity contractChange = changeService.selectById(billId);
            contractChange.setSignedFileId(signedFileInfo.getFileId());
            changeService.saveOrUpdate(contractChange, false);
        }

        resp.put("fileId", signedFileInfo.getFileId());
        resp.put("filePath", signedFileInfo.getFilePath());
        resp.put("fileTruePath", signedFileInfo.getTruePath());

        return CommonResponse.success("查询成功！", resp);
    }

    @GetMapping(value = "getBillDataJson")
    public CommonResponse<PurchaseContractVO> getBillDataJson(@RequestParam Long id) {
        logger.info("到了。。。。。。。。。。id{}",id);
        PurchaseContractEntity contract = contractService.selectById(id);
        PurchaseContractVO vo = BeanMapper.map(contract, PurchaseContractVO.class);

        DecimalFormat priceFmt = new DecimalFormat("#,###.####");
        DecimalFormat mnyFmt = new DecimalFormat("#,###.00");
        if (CollectionUtils.isNotEmpty(vo.getDetailList())) {
            vo.getDetailList().forEach(item -> {
                item.setPurchasePriceStr(null != item.getPurchasePrice() ? priceFmt.format(item.getPurchasePrice()) : priceFmt.format(BigDecimal.ZERO));
                item.setPurchaseAmountStr(null != item.getPurchaseAmount() ? priceFmt.format(item.getPurchaseAmount()) : priceFmt.format(BigDecimal.ZERO));
                item.setEstimateAmortizeMnyStr(null != item.getEstimateAmortizeMny() ? mnyFmt.format(item.getEstimateAmortizeMny()) : mnyFmt.format(BigDecimal.ZERO));
                item.setTaxRateStr(null != item.getTaxRate() ? mnyFmt.format(item.getTaxRate()) : mnyFmt.format(BigDecimal.ZERO));
                item.setPurchasePricetNoTaxStr(null != item.getPurchasePricetNoTax() ? mnyFmt.format(item.getPurchasePricetNoTax()) : mnyFmt.format(BigDecimal.ZERO));
                item.setPurchaseAmountNoTaxStr(null != item.getPurchaseAmountNoTax() ? mnyFmt.format(item.getPurchaseAmountNoTax()) : mnyFmt.format(BigDecimal.ZERO));
                item.setTaxMnyStr(null != item.getTaxMny() ? priceFmt.format(item.getTaxMny()) : priceFmt.format(BigDecimal.ZERO));
            });
        }
        if (CollectionUtils.isNotEmpty(vo.getOtherCostList())) {
            vo.getOtherCostList().forEach(item -> {
                item.setTaxPriceStr(null != item.getTaxPrice() ? priceFmt.format(item.getTaxPrice()) : priceFmt.format(BigDecimal.ZERO));
                item.setTaxRateStr(null != item.getTaxRate() ? priceFmt.format(item.getTaxRate()) : priceFmt.format(BigDecimal.ZERO));
                item.setAmountStr(null != item.getAmount() ? mnyFmt.format(item.getAmount()) : mnyFmt.format(BigDecimal.ZERO));
                item.setNotTaxPriceStr(null != item.getNotTaxPrice() ? mnyFmt.format(item.getNotTaxPrice()) : mnyFmt.format(BigDecimal.ZERO));
                item.setNotTaxAmountStr(null != item.getNotTaxAmount() ? mnyFmt.format(item.getNotTaxAmount()) : mnyFmt.format(BigDecimal.ZERO));
                item.setTaxMnyStr(null != item.getTaxMny() ? mnyFmt.format(item.getTaxMny()) : mnyFmt.format(BigDecimal.ZERO));

            });
        }
        if (CollectionUtils.isNotEmpty(vo.getPaymentList())) {
            vo.getPaymentList().forEach(item -> {
                item.setPaymentContentStr(null != item.getPaymentContent() ? priceFmt.format(item.getPaymentContent()) : priceFmt.format(BigDecimal.ZERO));

            });
        }

        return CommonResponse.success(vo);
    }
}