/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.purchase.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.contractbase.api.ITemplateCategoryApi;
import com.ejianc.business.contractbase.filing.enums.FilingStatusEnum;
import com.ejianc.business.contractbase.pool.enums.ContractPerformanceStateEnum;
import com.ejianc.business.contractbase.vo.TemplateCategoryVO;
import com.ejianc.business.purchase.bean.PurchaseContractEntity;
import com.ejianc.business.purchase.enums.SignatureStatusEnum;
import com.ejianc.business.purchase.service.IEquipmentDetailedService;
import com.ejianc.business.purchase.service.IPurchaseContractService;
import com.ejianc.business.purchase.vo.EquipmentDetailedVO;
import com.ejianc.business.purchase.vo.PurchaseContractVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.CollectionUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"purchaseContract"})
public class PurchaseContractController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String PURCHASE_CONTRACT = "BT220323000000001";
    @Autowired
    private IPurchaseContractService service;
    @Autowired
    private IEquipmentDetailedService equipmentDetailedService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private ITemplateCategoryApi templateCategoryApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<PurchaseContractVO> saveOrUpdate(@RequestBody PurchaseContractVO saveOrUpdateVO, HttpServletRequest req) {
        String authority = req.getHeader("authority");
        PurchaseContractVO vo = this.service.insertOrUpdate(saveOrUpdateVO, authority, false);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/pushContract"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<PurchaseContractVO> pushContract(@RequestParam Long id) {
        PurchaseContractEntity contractEntity = (PurchaseContractEntity)((Object)this.service.selectById(id));
        PurchaseContractVO map = (PurchaseContractVO)BeanMapper.map((Object)((Object)contractEntity), PurchaseContractVO.class);
        this.service.pushContract(map);
        return CommonResponse.success((String)"\u540c\u6b65\u5408\u540c\u6c60\u6210\u529f");
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<PurchaseContractVO> queryDetail(Long id) {
        PurchaseContractVO vo = this.service.queryDetail(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PurchaseContractVO> vos) {
        return this.service.deleteByIds(vos);
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("firstPartyName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("commitUserName");
        fuzzyFields.add("billCode");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        List orgVOList = null;
        orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        orgVOList.stream().forEach(org -> commonOrgIds.add(org.getId()));
        if (!CollectionUtils.isNotEmpty(commonOrgIds)) {
            JSONObject page = new JSONObject();
            return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
        }
        param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        LinkedHashMap orderMap = new LinkedHashMap();
        if (null != param.getOrderMap().get("createTime")) {
            orderMap.put("main_contract_create_date", param.getOrderMap().get("createTime"));
        } else {
            orderMap.put("main_contract_create_date", "desc");
        }
        orderMap.put("supplement_flag", "asc");
        orderMap.put("create_time", "desc");
        param.setOrderMap(orderMap);
        IPage pageData = this.service.queryPage(param, false);
        Map<String, Object> contractAmountMap = this.service.countContractAmount(param);
        JSONObject page = new JSONObject();
        page.put("records", (Object)BeanMapper.mapList((Iterable)pageData.getRecords(), PurchaseContractVO.class));
        page.put("total", (Object)pageData.getTotal());
        page.put("current", (Object)pageData.getCurrent());
        page.put("size", (Object)pageData.getSize());
        page.put("pages", (Object)pageData.getPages());
        page.put("sumMnyMap", contractAmountMap);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @RequestMapping(value={"/querySupplementRecord"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<PurchaseContractVO> querySupplementRecord(Long id) {
        PurchaseContractVO vo = this.service.querySupplementRecord(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/saveOrUpdateSupplement"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<PurchaseContractVO> saveOrUpdateSupplement(@RequestBody PurchaseContractVO supplement) {
        if (supplement.getMainContractId() == null) {
            return CommonResponse.error((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u4e3b\u5408\u540c\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        PurchaseContractVO vo = this.service.saveOrUpdateSupplement(supplement, false);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/addConvertByConId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<PurchaseContractVO> addConvertByConId(Long contractId) {
        PurchaseContractVO vo = this.service.addConvertByConId(contractId);
        return CommonResponse.success((String)"\u65b0\u589e\u8f6c\u6362\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(org.apache.commons.lang3.StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/addSupplementFlag"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> addSupplementFlag(Long id) {
        Boolean flag = this.service.addSupplementFlag(id);
        if (flag.booleanValue()) {
            boolean filingFlag = this.service.checkContractFiling(id);
            if (!filingFlag) {
                return CommonResponse.error((String)"\u5408\u540c\u672a\u5f52\u6863\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e\u8865\u5145\u534f\u8bae\uff01");
            }
            return CommonResponse.success((String)"\u6821\u9a8c\u901a\u8fc7\uff0c\u8be5\u5408\u540c\u53ef\u4ee5\u65b0\u589e\u8865\u5145\u534f\u8bae\uff01");
        }
        return CommonResponse.error((String)"\u5f53\u524d\u5408\u540c\u5b58\u5728\u672a\u751f\u6548\u7684\u8865\u5145\u534f\u8bae\uff0c\u4e0d\u80fd\u65b0\u589e\uff01");
    }

    @RequestMapping(value={"/signatureProcess"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> signatureProcess(Long id) {
        PurchaseContractEntity contractEntity = (PurchaseContractEntity)((Object)this.service.selectById(id));
        if (contractEntity != null) {
            contractEntity.setSignatureStatus(SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode());
            contractEntity.setEffectiveDate(new Date());
            this.service.saveOrUpdate((Object)contractEntity);
        }
        return CommonResponse.success();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        HashMap beans = new HashMap();
        param.setPageSize(-1);
        CommonResponse<JSONObject> commonResponse = this.queryList(param);
        List contractVOList = new ArrayList();
        if (null != commonResponse.getData() && null != (contractVOList = (List)((JSONObject)commonResponse.getData()).get((Object)"records")) && contractVOList.size() > 0) {
            contractVOList.forEach(vo -> {
                if (StringUtils.isBlank((String)vo.getContractPerformanceState().toString())) {
                    vo.setContractPerformanceState(ContractPerformanceStateEnum.\u672a\u7b7e\u8ba2.getStateName());
                } else {
                    vo.setContractPerformanceState(ContractPerformanceStateEnum.getByStateCode((String)vo.getContractPerformanceState().toString()).getStateName());
                }
                if (StringUtils.isBlank((String)vo.getSignatureStatus())) {
                    vo.setSignatureStatus(SignatureStatusEnum.\u672a\u7b7e\u7ae0.getDescription());
                } else {
                    vo.setSignatureStatus(SignatureStatusEnum.getEnumByCode(vo.getSignatureStatus()).getDescription());
                }
                vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
            });
        }
        beans.put("records", contractVOList);
        ExcelExport.getInstance().export("purchaseContract-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refPurchaseContractData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<PurchaseContractVO>> refPurchaseContractData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        String valueData = this.service.getContractFilingCode();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getOrderMap().put("mainContractCreateDate", "desc");
        Long projectId = null;
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            projectId = _con.getLong("projectId");
            if ("1".equals(valueData)) {
                if (_con.containsKey((Object)"filingType") && "1".equals(_con.getString("filingType"))) {
                    param.getParams().put("filingStatus", new Parameter("eq", (Object)FilingStatusEnum.\u5df2\u5f52\u6863.getTypeCode()));
                }
            } else if ("2".equals(valueData)) {
                param.getParams().put("filingStatus", new Parameter("eq", (Object)FilingStatusEnum.\u5df2\u5f52\u6863.getTypeCode()));
            }
        } else if ("2".equals(valueData)) {
            param.getParams().put("filingStatus", new Parameter("eq", (Object)FilingStatusEnum.\u5df2\u5f52\u6863.getTypeCode()));
        }
        if (projectId != null) {
            param.getParams().put("projectId", new Parameter("eq", (Object)projectId));
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        list.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        param.getParams().put("billState", new Parameter("in", list));
        param.getParams().put("signatureStatus", new Parameter("eq", (Object)SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode()));
        param.getParams().put("contractPerformanceState", new Parameter("eq", (Object)ContractPerformanceStateEnum.\u5c65\u7ea6\u4e2d.getStateCode()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), PurchaseContractVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/refEquipmentDetailedData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<EquipmentDetailedVO>> refEquipmentDetailedData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        Long contractId = null;
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("equipmentName");
        fuzzyFields.add("equipmentType");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            contractId = _con.getLong("cId");
        }
        if (contractId == null) {
            throw new BusinessException("\u8bf7\u9009\u62e9\u5408\u540c");
        }
        param.getParams().put("contractId", new Parameter("eq", (Object)contractId));
        IPage page = this.equipmentDetailedService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List list = BeanMapper.mapList((Iterable)page.getRecords(), EquipmentDetailedVO.class);
        ArrayList<EquipmentDetailedVO> newList = new ArrayList<EquipmentDetailedVO>();
        if (CollectionUtil.isNotEmpty((Collection)list)) {
            for (EquipmentDetailedVO vo : list) {
                if (vo.getAcceptanceQuantity() == null || vo.getAcceptanceQuantity() == 0) {
                    vo.setAcceptanceQuantity(Integer.valueOf(0));
                    vo.setSurplusNum(Integer.valueOf(vo.getPurchaseNum().intValue()));
                    newList.add(vo);
                    continue;
                }
                int num = vo.getPurchaseNum().intValue() - vo.getAcceptanceQuantity();
                if (num <= 0) continue;
                vo.setSurplusNum(Integer.valueOf(num));
                newList.add(vo);
            }
        }
        pageData.setRecords(newList);
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @GetMapping(value={"/getContractFileMgrInfo"})
    @ResponseBody
    public CommonResponse<JSONObject> getContractFileMgrInfo(@RequestParam(value="contractId") Long contractId) {
        JSONObject resp = new JSONObject();
        PurchaseContractEntity contractEntity = (PurchaseContractEntity)((Object)this.service.selectById(contractId));
        CommonResponse categoryResp = this.templateCategoryApi.queryTmplCategoryById(contractEntity.getContractCategoryId());
        if (!categoryResp.isSuccess()) {
            this.logger.error("\u6839\u636e\u5408\u540c\u7c7b\u522bI\u7684-{}\u67e5\u8be2\u5bf9\u5e94\u5408\u540c\u7c7b\u522b\u4fe1\u606f\u5931\u8d25, \u539f\u56e0\uff1a{}", (Object)contractEntity.getContractCategoryId(), (Object)categoryResp.getMsg());
            return CommonResponse.error((String)"\u67e5\u8be2\u5408\u540c\u7c7b\u522b\u4fe1\u606f\u5931\u8d25");
        }
        TemplateCategoryVO category = (TemplateCategoryVO)categoryResp.getData();
        resp.put("contactId", (Object)contractEntity.getId());
        resp.put("contractBillTypeCode", (Object)PURCHASE_CONTRACT);
        resp.put("contractCategoryId", (Object)category.getId());
        resp.put("boBillType", (Object)category.getBillTypeCode());
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)resp);
    }

    @RequestMapping(value={"/targetCostCtrl"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ParamsCheckVO> targetCostCtrl(@RequestBody PurchaseContractVO contractVO, HttpServletRequest req) {
        String authority = req.getHeader("authority");
        return CommonResponse.success((String)"\u53c2\u6570\u6821\u9a8c\u6210\u529f\uff01", (Object)this.service.targetCostCtrl(contractVO, authority));
    }

    @GetMapping(value={"/viewTargetCostCtrlInfo"})
    @ResponseBody
    public CommonResponse<ParamsCheckVO> viewTargetCostCtrlInfo(@RequestParam(value="id") Long id) {
        return CommonResponse.success((String)"\u53c2\u6570\u6821\u9a8c\u6210\u529f\uff01", (Object)this.service.viewTargetCostCtrlInfo(id));
    }

    @RequestMapping(value={"/pushTargetCost"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> pushTargetCost(Long id) {
        return this.service.pushTargetCost(id);
    }

    @RequestMapping(value={"/asyncWatermarkById"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> asyncWatermarkById(@RequestParam(value="id") Long id) {
        this.service.asyncWatermarkById(id);
        return CommonResponse.success((String)"\u6c34\u5370\u6dfb\u52a0\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/checkContractFiling"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> checkContractFiling(Long id) {
        boolean filingFlag = this.service.checkContractFiling(id);
        if (filingFlag) {
            return CommonResponse.success((String)"\u6821\u9a8c\u901a\u8fc7\uff01");
        }
        return CommonResponse.error((String)"\u5f53\u524d\u5408\u540c\u65e0\u6cd5\u65b0\u589e");
    }
}

