package com.ejianc.business.pricelib.controller;

import java.io.Serializable;

import com.alibaba.fastjson.JSONArray;
import com.ejianc.business.pricelib.service.IPriceContractService;
import com.ejianc.business.pricelib.vo.*;
import com.ejianc.business.utils.DateUtils;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IPriceDepotParamSetApi;
import com.ejianc.foundation.share.consts.PrinceDepotEnum;
import com.ejianc.foundation.share.vo.dto.PriceDepotParamSetDTO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.pricelib.service.IPriceContractCollectService;

/**
 * 设备购置价格库-根据清单id汇总表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("priceContractCollect")
public class PriceContractCollectController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IPriceContractCollectService service;


    /**
     * @Description shelfGoods 价格库列表数据到历史表定时任务
     */
    @RequestMapping(value = "/savePriceContractCollect", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> savePriceContractCollect(HttpServletRequest request) {
        service.savePriceContractToHistoryByTiming();
        return CommonResponse.success("价格库列表数据到历史表定时任务处理成功");
    }


    //查询多个档案清单历史价格
    @PostMapping("/getPriceContractByDocIds")
    @ResponseBody
    public CommonResponse<List<PriceContractCollectVO>> getPriceContractByDocIds(@RequestBody List<Long> docIds){
        logger.info("档案id集合【{}】", docIds);
        List<PriceContractCollectVO> PriceContractCollectVOList = service.getPriceContractByDocIds(docIds);
        return CommonResponse.success("查询成功！",PriceContractCollectVOList);
    }

}
