package com.ejianc.business.pricelib.mapper;

import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.business.pricelib.vo.PriceGuideDetailEntity;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;

/**
 * 设备采购指导价价格明细子实体
 * 
 * @author generator
 * 
 */
@Mapper
public interface PriceGuideDetailMapper extends BaseCrudMapper<PriceGuideDetailEntity> {
    @Select({
            "<script>",
            "SELECT d.* FROM ejc_proequipment_price_guide g,ejc_proequipment_price_guide_detail d WHERE g.id = d.guide_id AND g.bill_state in (1,3) AND g.flag = 0 AND g.dr = 0 AND d.doc_id IN",
            "<foreach collection='docIdList' item='docId' open='(' separator=',' close=')'>",
            "#{docId}",
            "</foreach>",
            "ORDER BY g.publish_date DESC",
            "</script>"
    })
    List<PriceGuideDetailEntity> queryPriceGuideDetailByDocIds(@Param("docIdList") List<Long> docIdList);
}
