package com.ejianc.business.estimate.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.estimate.bean.PurchaseEstimateDetailedEntity;
import com.ejianc.business.estimate.vo.PurchaseEstimateVO;
import com.ejianc.business.proequipmentcorppur.purchaseplan.vo.PurchasePlanEnum;
import com.ejianc.business.proequipmentcorppur.purchaseplan.vo.PurchasePlanVO;
import com.ejianc.business.promaterial.plan.vo.BatPlanEnum;
import com.ejianc.business.purchaseplan.bean.PurchasePlanDetailedEntity;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.CollectionUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.estimate.mapper.PurchaseEstimateMapper;
import com.ejianc.business.estimate.bean.PurchaseEstimateEntity;
import com.ejianc.business.estimate.service.IPurchaseEstimateService;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 购置计划(新)
 * 
 * @author generator
 * 
 */
@Service("purchaseEstimateService")
public class PurchaseEstimateServiceImpl extends BaseServiceImpl<PurchaseEstimateMapper, PurchaseEstimateEntity> implements IPurchaseEstimateService{
    @Override
    public void saveOrUpdates(PurchaseEstimateEntity entity) {

        List<PurchaseEstimateDetailedEntity> listbs = entity.getDetailList();
        if(CollectionUtil.isNotEmpty(listbs)) {
            Map<Long, Long> idMap = new HashMap<>();
            for (PurchaseEstimateDetailedEntity cdEntity : listbs) {
                //设置计划编码
                cdEntity.setPlanCode(entity.getBillCode());
                //设置剩余可申请数量
                cdEntity.setRemainingNum(cdEntity.getPlanNum());
                //初始化已申请数量
                cdEntity.setAppliedNum(0L);
                if (null == cdEntity.getParentId()) {
                    idMap.put(cdEntity.getDocCategoryId(), cdEntity.getId());
                }
            }
            for (PurchaseEstimateDetailedEntity cdEntity : listbs) {
                if (null != cdEntity.getParentId()) {
                    cdEntity.setParentId(idMap.get(cdEntity.getDocCategoryId()));
                    cdEntity.setTid(cdEntity.getId());
                } else {
                    cdEntity.setTid(cdEntity.getId());
                }
            }
        }
        super.saveOrUpdate(entity, false);
    }

    @Override
    public List<PurchaseEstimateVO> queryPlanListByOrgId(Long orgId) {
        QueryWrapper<PurchaseEstimateEntity> query = new QueryWrapper<>();
        query.eq("org_id", orgId);
        List<PurchaseEstimateEntity> entityList = super.list(query);
        List<PurchaseEstimateVO> list = BeanMapper.mapList(entityList, PurchaseEstimateVO.class);
        return list;
    }

    /**
     * 检查单据是否存在相同编码
     * @param contractVO
     * @return
     */
    @Override
    public Boolean checkSameBillCode(PurchaseEstimateVO contractVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        LambdaQueryWrapper<PurchaseEstimateEntity> lambda = new LambdaQueryWrapper<>();
        lambda.eq(PurchaseEstimateEntity::getBillCode, contractVO.getBillCode());
        lambda.eq(PurchaseEstimateEntity::getTenantId, tenantId);
        if (null != contractVO.getId() && contractVO.getId() > 0) {
            lambda.ne(PurchaseEstimateEntity::getId, contractVO.getId());
        }
        return super.list(lambda).size() > 0;
    }

    @Override
    public void updateBatPlanByQuoteType(List<String> idList, Integer planState) {
        if (StringUtils.isEmpty(PurchasePlanEnum.getDescriptionByStateCode(planState))) {
            throw new BusinessException("计划状态错误");
        }
        // 批量更改
        if (CollectionUtils.isNotEmpty(idList)) {
            List<PurchaseEstimateEntity> entityList = (List<PurchaseEstimateEntity>) super.listByIds(idList);
            if (CollectionUtils.isNotEmpty(entityList)) {
                for (PurchaseEstimateEntity entity : entityList) {
                    // 采购完成不允许做其他操作
                    if (BatPlanEnum.PLAN_STATE_OVER.getPlanState().equals(entity.getPlanState())) {
                        throw new BusinessException("采购计划编码【" + entity.getBillCode() + "】已采购完成！");
                    }
                    entity.setPlanState(planState);
                }
                super.saveOrUpdateBatch(entityList);
            }
        }
    }

    @Override
    public List<PurchaseEstimateVO> queryEstimateListByProjectId(Long projectId) {
        QueryWrapper<PurchaseEstimateEntity> query = new QueryWrapper<>();
        query.eq("project_id", projectId);
        query.in("bill_state", 1,3);
        List<PurchaseEstimateEntity> entityList = super.list(query);
        List<PurchaseEstimateVO> list = BeanMapper.mapList(entityList, PurchaseEstimateVO.class);
        return list;
    }
}
