package com.ejianc.business.settlement.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.contractbase.pool.enums.ContractPerformanceStateEnum;
import com.ejianc.business.purchase.bean.PurchaseContractEntity;
import com.ejianc.business.purchase.service.IPurchaseContractService;
import com.ejianc.business.settlement.bean.PurchaseSettlementEntity;
import com.ejianc.business.settlement.service.IPurchaseSettlementService;
import com.ejianc.business.settlement.vo.BillPushStatusEnum;
import com.ejianc.business.settlement.vo.PurchaseSettlementVO;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.List;

@Service("purchaseSettlement")
public class PurchaseSettlementBpmServiceImpl implements ICommonBusinessService {

    @Autowired
    private IBillTypeApi billTypeApi;
	private Logger logger = LoggerFactory.getLogger(this.getClass());
	@Autowired
	private IPurchaseContractService contractService;//合同
	@Autowired
	private IPurchaseSettlementService service;//合同
	private static final String BILL_TYPE = "EJCBT202204000012";//

	@Value("${common.env.base-host}")
	private String BaseHost;
	@Autowired
	private IExecutionApi executionApi;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//结算单  根据 合同状态校验
		PurchaseSettlementEntity entity = service.selectById(billId);
		if(entity.getContractId()!=null){
			PurchaseContractEntity contractEntity = contractService.selectById(entity.getContractId());
			if(ContractPerformanceStateEnum.已冻结.getStateCode().equals(contractEntity.getContractPerformanceState()) || ContractPerformanceStateEnum.已作废.getStateCode().equals(contractEntity.getContractPerformanceState())){
				throw new BusinessException("合同{"+contractEntity.getContractName()+"},状态为："+ ContractPerformanceStateEnum.getByStateCode(contractEntity.getContractPerformanceState()).getStateName()+"不可进行此操作！");
			}
		}
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {

		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		//结算单  根据 合同状态校验
		PurchaseSettlementEntity entity = service.selectById(billId);
		if(entity.getContractId()!=null){
			PurchaseContractEntity contractEntity = contractService.selectById(entity.getContractId());
			if(ContractPerformanceStateEnum.已冻结.getStateCode().equals(contractEntity.getContractPerformanceState()) || ContractPerformanceStateEnum.已作废.getStateCode().equals(contractEntity.getContractPerformanceState())){
				throw new BusinessException("合同{"+contractEntity.getContractName()+"},状态为："+ ContractPerformanceStateEnum.getByStateCode(contractEntity.getContractPerformanceState()).getStateName()+"不可进行此操作！");
			}
		}
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//结算单  根据 合同状态校验
		PurchaseSettlementEntity entity = service.selectById(billId);
		if(entity.getContractId()!=null){
			PurchaseContractEntity contractEntity = contractService.selectById(entity.getContractId());
			if(ContractPerformanceStateEnum.已冻结.getStateCode().equals(contractEntity.getContractPerformanceState()) || ContractPerformanceStateEnum.已作废.getStateCode().equals(contractEntity.getContractPerformanceState())){
				throw new BusinessException("合同{"+contractEntity.getContractName()+"},状态为："+ ContractPerformanceStateEnum.getByStateCode(contractEntity.getContractPerformanceState()).getStateName()+"不可进行此操作！");
			}
		}
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
			logger.info("审批通过业务开始！");
			//结算单
			PurchaseSettlementEntity entity = service.selectById(billId);
			//推送结算池所用vo
			PurchaseSettlementVO settlementVO = BeanMapper.map(entity, PurchaseSettlementVO.class);
			//修改合同状态  结算类型，0-过程,1-最终
			if(entity.getContractId()!=null && entity.getSignatureType()==1){
				PurchaseContractEntity contractEntity = contractService.selectById(entity.getContractId());
				contractEntity.setContractPerformanceState(ContractPerformanceStateEnum.已终止.getStateCode());
				contractService.saveOrUpdate(contractEntity);
				logger.info("修改合同状态！"+JSONObject.toJSONString(contractEntity));
			}
			//推送合同池
			service.updateContractPoolSettle(settlementVO, true);
			//推送结算池
			boolean pool = service.pushSettleToPool(settlementVO);
			if(!pool){
				throw new BusinessException("推送结算池失败");
			}

			// 最终结算推送目标成本
//				String linkUrl = BaseHost + "ejc-proequipmentp-frontend/#/settlementList/settlementCard/card?id=" + entity.getId();;
//				ExecutionVO executionVO = service.targetCost(BeanMapper.map(entity, PurchaseSettlementVO.class),linkUrl,entity.getSettlementType());
//				logger.info("目标成本推送数据" + JSON.toJSONString(executionVO));
//				CommonResponse<String> response = executionApi.aggPush(executionVO);
//				if (!response.isSuccess()) {
//					throw new BusinessException("目标成本推送失败," + response.getMsg());
//				}

			//推送供方  推送供方放到最后
			Boolean pushFlag = service.pushBillToSupCenter(entity,billTypeCode);
			logger.info("获取推送供方结果--"+pushFlag);
			if(!pushFlag){
				entity.setBillPushFlag(BillPushStatusEnum.未成功推送.getStatus());
			}else{
				entity.setBillPushFlag(BillPushStatusEnum.推送成功.getStatus());
			}
			service.updateById(entity);
			return CommonResponse.success("审批通过逻辑操作完成");
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO 查询调差单  billTypeCode：调差单单据编号  billId：调差单id
		//结算单
		PurchaseSettlementEntity entity = service.selectById(billId);
		if(entity.getSignStatus()==1){
			throw new BusinessException("已签字不能撤回！");
		}
		if(entity.getContractId()!=null){
			LambdaQueryWrapper<PurchaseSettlementEntity> lambda = new LambdaQueryWrapper<>();
			lambda.eq(PurchaseSettlementEntity::getContractId, entity.getContractId());
			lambda.orderByDesc(PurchaseSettlementEntity::getCreateTime);
			List<PurchaseSettlementEntity> list = service.list(lambda);
			PurchaseSettlementEntity settlementEntity = list.get(0);
			if(!entity.getId().equals(settlementEntity.getId())){
				throw new BusinessException("只能撤回最新的结算单！");
			}
		}
		// 删除目标成本
//		List<TotalExecutionVO> totalExecutionVOList = new ArrayList<>();
//		ExecutionVO executionVO = service.targetCost(BeanMapper.map(entity, PurchaseSettlementVO.class),"");
//		totalExecutionVOList.add(executionVO.getTotalVO());
//		CommonResponse<String> response1 = executionApi.aggDel(totalExecutionVOList);
//		if (!response1.isSuccess()){
//			throw new BusinessException("目标成本删除失败！");
//		}

		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		// 参数是单据类型编码字符串 根据需求是否打开下面代码
		/**CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
		 if(!resp.isSuccess()){
		 return CommonResponse.error("无法撤回！"+resp.getMsg());
		 }*/
		PurchaseSettlementEntity entity = service.selectById(billId);
		//修改合同状态  结算类型，0-过程,1-最终
		if(entity.getContractId()!=null && entity.getSignatureType()==1){
			PurchaseContractEntity contractEntity = contractService.selectById(entity.getContractId());
			contractEntity.setContractPerformanceState(ContractPerformanceStateEnum.履约中.getStateCode());
			contractService.saveOrUpdate(contractEntity);
			logger.info("修改合同状态！"+JSONObject.toJSONString(contractEntity));
		}
		//推送合同池
		service.updateContractPoolSettle(BeanMapper.map(entity, PurchaseSettlementVO.class), false);
		//结算池撤回
		boolean pool = service.delSettleFromPool(billId);
		if(!pool){
			throw new BusinessException("弃审推送结算池失败！");
		}
		//供方撤回
		if(BillPushStatusEnum.推送成功.getStatus().equals(entity.getBillPushFlag())) {
			logger.info("供方撤回---");
			logger.info("该结算单状态---{}",entity.getSettlementType());
			CommonResponse<String> response = service.updatePushBill(entity, billTypeCode);
			if(!response.isSuccess()){
				throw new BusinessException("弃审推送供方失败！");
			}
			entity.setBillPushFlag(BillPushStatusEnum.未成功推送.getStatus());
			service.updateById(entity);
			logger.info("供方撤回成功---"+JSONObject.toJSONString(entity));
		}
		return CommonResponse.success();
	}

}
