package com.ejianc.business.asset.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.asset.bean.AssetAllotOutDetailEntity;
import com.ejianc.business.asset.vo.AssetAllotOutVO;
import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.business.procost.enums.SourceTypeEnum;
import com.ejianc.business.procost.vo.CostDetailVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.asset.mapper.AssetAllotOutMapper;
import com.ejianc.business.asset.bean.AssetAllotOutEntity;
import com.ejianc.business.asset.service.IAssetAllotOutService;

import java.util.ArrayList;
import java.util.List;

/**
 * 固定资产调出表
 * 
 * @author generator
 * 
 */
@Service("assetAllotOutService")
public class AssetAllotOutServiceImpl extends BaseServiceImpl<AssetAllotOutMapper, AssetAllotOutEntity> implements IAssetAllotOutService{
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    // 推送成本需要调用的接口 start
    @Autowired
    private ICostDetailApi costDetailApi;

    @Autowired
    private SessionManager sessionManager;

    @Override
    public CommonResponse<AssetAllotOutVO> pushCost(AssetAllotOutVO allotOutVO) {
        AssetAllotOutEntity allotOutEntity = baseMapper.selectById(allotOutVO.getId());
        if(CollectionUtils.isNotEmpty(allotOutVO.getAssetAllotOutDetailList())){
            List<AssetAllotOutDetailEntity> allotOutDetailEntitys = BeanMapper.mapList(allotOutVO.getAssetAllotOutDetailList(), AssetAllotOutDetailEntity.class);
            allotOutEntity.setAssetAllotOutDetailList(allotOutDetailEntitys);
        }
        super.saveOrUpdate(allotOutEntity, false);
        //推送数据
        this.costPush(allotOutEntity);
        return CommonResponse.success(BeanMapper.map(allotOutEntity, AssetAllotOutVO.class));
    }

    @Override
    public void costPush(AssetAllotOutEntity allotOutEntity) {
        logger.info("开始costPush");
        List<AssetAllotOutDetailEntity> allotOutDetailEntities = allotOutEntity.getAssetAllotOutDetailList();
        String newRelationFlag = "1";
        if(CollectionUtils.isNotEmpty(allotOutDetailEntities)){
            for (AssetAllotOutDetailEntity entity : allotOutDetailEntities) {
                if (null == entity.getSubjectId() || null == entity.getWbsId()) {
                    newRelationFlag = "0";
                    logger.info("getSubjectId"+entity.getSubjectId());
                    logger.info("getWbsId"+entity.getWbsId());
                    break;
                }
            }
        }
        if (ListUtil.isEmpty(allotOutDetailEntities)) {
            newRelationFlag = "0";
        }
        logger.info("newRelationFlag"+newRelationFlag);
        //先删后增
        saveCost(allotOutEntity,1);//生效状态 0-未生效，1-生效
        //更新是否关联
        LambdaUpdateWrapper<AssetAllotOutEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.in(AssetAllotOutEntity::getId, allotOutEntity.getId());
        updateWrapper.set(AssetAllotOutEntity::getRelationFlag, newRelationFlag);//(1:是，0：否)
        super.update(updateWrapper);
    }

    @Override
    public void saveCost(AssetAllotOutEntity allotOutEntity,Integer effectiveStatus) {
        //明细
        List<CostDetailVO> costDetailVOList = new ArrayList<>();
        List<AssetAllotOutDetailEntity> allotOutDetailList = allotOutEntity.getAssetAllotOutDetailList();
        if(CollectionUtils.isNotEmpty(allotOutDetailList)){
            for (AssetAllotOutDetailEntity entity : allotOutDetailList) {
                CostDetailVO costDetailVO = new CostDetailVO();
                costDetailVO.setSubjectId(entity.getSubjectId());
                costDetailVO.setSubjectCode(entity.getSubjectCode());
                costDetailVO.setSubjectName(entity.getSubjectName());
                costDetailVO.setWbsId(entity.getWbsId());
                costDetailVO.setWbsCode(entity.getWbsCode());
                costDetailVO.setWbsName(entity.getWbsName());
                costDetailVO.setSourceId(entity.getAllocatId());
                costDetailVO.setSourceDetailId(entity.getId());
                costDetailVO.setHappenTaxMny(entity.getAllocatDiffTaxMny());
                costDetailVO.setHappenMny(entity.getAllocatDiffMny());
                costDetailVO.setHappenDate(allotOutEntity.getOutDate());
                costDetailVO.setCreateUserName(sessionManager.getUserContext().getUserName());
                costDetailVO.setSourceType("ASSET_ALLOT_OUT");
                costDetailVO.setSourceTabType("ASSET_ALLOT_OUT_SUB");
                costDetailVO.setProjectId(allotOutEntity.getProjectId());
                costDetailVO.setEffectiveStatus(effectiveStatus);//生效状态 0-未生效，1-生效
                //新加的
                costDetailVO.setSourceBillCode(allotOutEntity.getBillCode());
                costDetailVO.setSourceBillName(SourceTypeEnum.固定资产设备调出.getTypeName());
                costDetailVO.setSourceBillUrl("/ejc-proequipmentp-frontend/#/assetAllotOut/assetAllotOutCard?id="+allotOutEntity.getId());
                costDetailVOList.add(costDetailVO);
            }
        }

        //成本中心
        if (ListUtil.isNotEmpty(costDetailVOList)) {
            logger.info("推送数据--------"+JSONObject.toJSONString(costDetailVOList));
            CommonResponse<String> stringCommonResponse = costDetailApi.saveSubject(costDetailVOList);
            logger.info("推送结果--------"+JSONObject.toJSONString(stringCommonResponse));
            if (stringCommonResponse.isSuccess()) {
            } else {
                throw new BusinessException(stringCommonResponse.getMsg());
            }
        }

    }


}
