/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.asset.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.asset.bean.AssetAllotOutDetailEntity;
import com.ejianc.business.asset.bean.AssetAllotOutEntity;
import com.ejianc.business.asset.mapper.AssetAllotOutMapper;
import com.ejianc.business.asset.service.IAssetAllotOutService;
import com.ejianc.business.asset.vo.AssetAllotOutVO;
import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.business.procost.enums.SourceTypeEnum;
import com.ejianc.business.procost.vo.CostDetailVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="assetAllotOutService")
public class AssetAllotOutServiceImpl
extends BaseServiceImpl<AssetAllotOutMapper, AssetAllotOutEntity>
implements IAssetAllotOutService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ICostDetailApi costDetailApi;
    @Autowired
    private SessionManager sessionManager;

    @Override
    public CommonResponse<AssetAllotOutVO> pushCost(AssetAllotOutVO allotOutVO) {
        AssetAllotOutEntity allotOutEntity = (AssetAllotOutEntity)((Object)((AssetAllotOutMapper)this.baseMapper).selectById(allotOutVO.getId()));
        if (CollectionUtils.isNotEmpty((Collection)allotOutVO.getAssetAllotOutDetailList())) {
            List allotOutDetailEntitys = BeanMapper.mapList((Iterable)allotOutVO.getAssetAllotOutDetailList(), AssetAllotOutDetailEntity.class);
            allotOutEntity.setAssetAllotOutDetailList(allotOutDetailEntitys);
        }
        super.saveOrUpdate((Object)allotOutEntity, false);
        this.costPush(allotOutEntity);
        return CommonResponse.success((Object)BeanMapper.map((Object)((Object)allotOutEntity), AssetAllotOutVO.class));
    }

    @Override
    public void costPush(AssetAllotOutEntity allotOutEntity) {
        this.logger.info("\u5f00\u59cbcostPush");
        List<AssetAllotOutDetailEntity> allotOutDetailEntities = allotOutEntity.getAssetAllotOutDetailList();
        String newRelationFlag = "1";
        if (CollectionUtils.isNotEmpty(allotOutDetailEntities)) {
            for (AssetAllotOutDetailEntity entity : allotOutDetailEntities) {
                if (null != entity.getSubjectId() && null != entity.getWbsId()) continue;
                newRelationFlag = "0";
                this.logger.info("getSubjectId" + entity.getSubjectId());
                this.logger.info("getWbsId" + entity.getWbsId());
                break;
            }
        }
        if (ListUtil.isEmpty(allotOutDetailEntities)) {
            newRelationFlag = "0";
        }
        this.logger.info("newRelationFlag" + newRelationFlag);
        this.saveCost(allotOutEntity, 1);
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.in(BaseEntity::getId, new Object[]{allotOutEntity.getId()});
        updateWrapper.set(AssetAllotOutEntity::getRelationFlag, (Object)newRelationFlag);
        super.update((Wrapper)updateWrapper);
    }

    @Override
    public void saveCost(AssetAllotOutEntity allotOutEntity, Integer effectiveStatus) {
        ArrayList<CostDetailVO> costDetailVOList = new ArrayList<CostDetailVO>();
        List<AssetAllotOutDetailEntity> allotOutDetailList = allotOutEntity.getAssetAllotOutDetailList();
        if (CollectionUtils.isNotEmpty(allotOutDetailList)) {
            for (AssetAllotOutDetailEntity entity : allotOutDetailList) {
                CostDetailVO costDetailVO = new CostDetailVO();
                costDetailVO.setSubjectId(entity.getSubjectId());
                costDetailVO.setSubjectCode(entity.getSubjectCode());
                costDetailVO.setSubjectName(entity.getSubjectName());
                costDetailVO.setWbsId(entity.getWbsId());
                costDetailVO.setWbsCode(entity.getWbsCode());
                costDetailVO.setWbsName(entity.getWbsName());
                costDetailVO.setSourceId(entity.getAllocatId());
                costDetailVO.setSourceDetailId(entity.getId());
                costDetailVO.setHappenTaxMny(entity.getAllocatDiffTaxMny());
                costDetailVO.setHappenMny(entity.getAllocatDiffMny());
                costDetailVO.setHappenDate(allotOutEntity.getOutDate());
                costDetailVO.setCreateUserName(this.sessionManager.getUserContext().getUserName());
                costDetailVO.setSourceType("ASSET_ALLOT_OUT");
                costDetailVO.setSourceTabType("ASSET_ALLOT_OUT_SUB");
                costDetailVO.setProjectId(allotOutEntity.getProjectId());
                costDetailVO.setEffectiveStatus(effectiveStatus);
                costDetailVO.setSourceBillCode(allotOutEntity.getBillCode());
                costDetailVO.setSourceBillName(SourceTypeEnum.\u56fa\u5b9a\u8d44\u4ea7\u8bbe\u5907\u8c03\u51fa.getTypeName());
                costDetailVO.setSourceBillUrl("/ejc-proequipmentp-frontend/#/assetAllotOut/assetAllotOutCard?id=" + allotOutEntity.getId());
                costDetailVOList.add(costDetailVO);
            }
        }
        if (ListUtil.isNotEmpty(costDetailVOList)) {
            this.logger.info("\u63a8\u9001\u6570\u636e--------" + JSONObject.toJSONString(costDetailVOList));
            CommonResponse stringCommonResponse = this.costDetailApi.saveSubject(costDetailVOList);
            this.logger.info("\u63a8\u9001\u7ed3\u679c--------" + JSONObject.toJSONString((Object)stringCommonResponse));
            if (!stringCommonResponse.isSuccess()) {
                throw new BusinessException(stringCommonResponse.getMsg());
            }
        }
    }
}

