package com.ejianc.business.pricelib.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.pricelib.bean.PriceGuideDetailEntity;
import com.ejianc.business.pricelib.vo.PriceGuideDetailVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.pricelib.bean.PriceGuideEntity;
import com.ejianc.business.pricelib.service.IPriceGuideService;
import com.ejianc.business.pricelib.vo.PriceGuideVO;

/**
 * 设备采购指导价主实体
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("priceGuide")
public class PriceGuideController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "PURCHASE_GUIDE_PRICE";//专业分包指导价编码

    @Autowired
    private IPriceGuideService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<PriceGuideVO> saveOrUpdate(@RequestBody PriceGuideVO saveOrUpdateVO) {
        PriceGuideEntity entity = BeanMapper.map(saveOrUpdateVO, PriceGuideEntity.class);
        if (entity.getId() == null || entity.getId() == 0) {
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            }
            else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        service.saveOrUpdate(entity, false);
        PriceGuideVO vo = BeanMapper.map(service.selectById(entity.getId()), PriceGuideVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PriceGuideVO> queryDetail(Long id) {
        PriceGuideEntity entity = service.selectById(id);
        PriceGuideVO vo = BeanMapper.map(entity, PriceGuideVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PriceGuideVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (PriceGuideVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(PriceGuideVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<PriceGuideVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("theme");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));


        //查询本上范围内的指导价
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse<List<OrgVO>> orgResp = iOrgApi.findParentsByOrgId(orgId);
        if(!orgResp.isSuccess()) {
            logger.error("分页查询失败，获取当前本上组织信息失败, {}", orgResp.getMsg());
            return CommonResponse.error("查询失败，获取组织信息失败！");
        }

//        Boolean topOrgFlag = false;
//        CommonResponse<OrgVO> orgVO = iOrgApi.getOneById(orgId);
//        if(!orgResp.isSuccess()) {
//            logger.error("分页查询失败，获取当前本上组织信息失败, {}", orgResp.getMsg());
//            return CommonResponse.error("查询失败，获取组织信息失败！");
//        }else {
//            if (null == orgVO.getData().getParentId()){
//                topOrgFlag = true;
//            }
//        }

        List<Long> orgIdList = orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList());
        param.getParams().put("orgId", new Parameter(QueryParam.IN, orgIdList));


        IPage<PriceGuideEntity> page = service.queryPage(param,false);
        IPage<PriceGuideVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), PriceGuideVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("theme");
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        List<PriceGuideEntity> list = service.queryList(param);
        List<PriceGuideVO> guideVOS = BeanMapper.mapList(list, PriceGuideVO.class);
        //todo:字段翻译等等
        guideVOS.stream().forEach(item -> {
            item.setFlagName(item.getFlag() == 0 ? "启用" : "禁用");
            item.setBillStateName(BillStateEnum.getEnumByStateCode(item.getBillState()).getDescription());
        });
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", guideVOS);

        String exportFileName = "purchasePriceGuide-export.xlsx";
        ExcelExport.getInstance().export(exportFileName, beans, response);
    }


    /**
     * @Description saveOrUpdate 启停用
     */
    @RequestMapping(value = "/startUpdate", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PriceGuideVO> startUpdate(@RequestParam Long id, Integer state) {
        PriceGuideEntity priceGuideEntity = service.selectById(id);
        priceGuideEntity.setFlag(state);
        service.saveOrUpdate(priceGuideEntity, false);
        PriceGuideVO vo = BeanMapper.map(priceGuideEntity, PriceGuideVO.class);
        return CommonResponse.success("启用停用状态调整成功！",vo);
    }


    /**
     * @Description saveOrUpdate 复制子表
     */
    @RequestMapping(value = "/copyDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<PriceGuideDetailVO>> copyDetail(@RequestParam Long id) {
        PriceGuideEntity priceGuideEntity = service.selectById(id);
        List<PriceGuideDetailEntity> detailList = priceGuideEntity.getPriceGuideDetailList();
        //将id设置为空
        detailList.forEach(detail -> {
            detail.setId(IdWorker.getId());
            detail.setRowState("add");
            detail.setVersion(null);
            detail.setCreateTime(null);
            detail.setUpdateTime(null);
            detail.setCreateUserCode(null);
            detail.setUpdateUserCode(null);
        });
        return CommonResponse.success("复制子表成功！",BeanMapper.mapList(detailList, PriceGuideDetailVO.class));
    }
}
