/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.asset.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.asset.bean.AmortizeSetEntity;
import com.ejianc.business.asset.bean.AssetAmortizeDetailEntity;
import com.ejianc.business.asset.bean.AssetAmortizeEntity;
import com.ejianc.business.asset.mapper.AssetAmortizeMapper;
import com.ejianc.business.asset.service.IAmortizeSetService;
import com.ejianc.business.asset.service.IAssetAmortizeService;
import com.ejianc.business.asset.vo.AssetAmortizeDetailVO;
import com.ejianc.business.asset.vo.AssetAmortizeVO;
import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.business.procost.enums.SourceTypeEnum;
import com.ejianc.business.procost.vo.CostDetailVO;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.vo.CostCtrlDetailVO;
import com.ejianc.business.targetcost.vo.CostCtrlVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="assetAmortizeService")
public class AssetAmortizeServiceImpl
extends BaseServiceImpl<AssetAmortizeMapper, AssetAmortizeEntity>
implements IAssetAmortizeService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ICostDetailApi costDetailApi;
    @Autowired
    private IAmortizeSetService amortizeSetService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IExecutionApi executionApi;

    @Override
    public void getAmortizeSet(List<AssetAmortizeDetailVO> detailList, Long orgId) {
        Map<Long, Long> euipmentsMap = detailList.stream().collect(Collectors.toMap(AssetAmortizeDetailVO::getEquipmentId, AssetAmortizeDetailVO::getEquipmentTypeId, (key1, key2) -> key1));
        Map<Long, AmortizeSetEntity> amortizeSetMap = this.amortizeSetService.getSet(euipmentsMap, orgId);
        for (AssetAmortizeDetailVO detailVO : detailList) {
            Long equipmentId = detailVO.getEquipmentId();
            AmortizeSetEntity amortizeSetEntity = amortizeSetMap.get(equipmentId);
            if (amortizeSetEntity != null) {
                detailVO.setAmortizeSetId(amortizeSetEntity.getId());
                detailVO.setUsePeriod(amortizeSetEntity.getUsePeriod());
                detailVO.setResidualValueRate(amortizeSetEntity.getResidualValueRate());
                continue;
            }
            detailVO.setErrMsg("\u672a\u83b7\u53d6\u5230\u8be5\u8bbe\u5907\u7684\u644a\u9500\u8bbe\u7f6e\uff01");
        }
    }

    @Override
    public ParamsCheckVO checkParams(AssetAmortizeVO vo) {
        ArrayList<ParamsCheckVO> paramsCheckVOS = new ArrayList<ParamsCheckVO>();
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        CostCtrlVO costCtrlVO = this.sjCost(vo);
        if (null != costCtrlVO) {
            CommonResponse costResponse = this.executionApi.ctrlCost(costCtrlVO);
            if (!costResponse.isSuccess()) {
                throw new BusinessException("\u6210\u672c\u79d1\u76ee\u63a7\u5236\u5931\u8d25," + costResponse.getMsg());
            }
            ParamsCheckVO costRes = (ParamsCheckVO)costResponse.getData();
            if (null != costRes) {
                paramsCheckVOS.add(costRes);
            }
        }
        HashMap<String, List> map = new HashMap<String, List>();
        String[] paramsArray = new String[]{"alert", "warn", "none"};
        if (CollectionUtils.isNotEmpty(paramsCheckVOS)) {
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if (map.containsKey(warnType)) {
                    List checkDsVOS = (List)map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType, checkDsVOS);
                    continue;
                }
                map.put(warnType, checkVO.getDataSource());
            }
        }
        for (String s : paramsArray) {
            if (!map.containsKey(s)) continue;
            paramsCheckVO.setWarnType(s);
            paramsCheckVO.setDataSource((List)map.get(s));
            if (CollectionUtils.isEmpty((Collection)paramsCheckVO.getDataSource())) {
                paramsCheckVO.setWarnType("none");
                continue;
            }
            return paramsCheckVO;
        }
        return paramsCheckVO;
    }

    public CostCtrlVO sjCost(AssetAmortizeVO vo) {
        List feeList = vo.getDetailList();
        if (CollectionUtils.isNotEmpty((Collection)feeList)) {
            HashMap<Long, CostCtrlDetailVO> map = new HashMap<Long, CostCtrlDetailVO>();
            for (AssetAmortizeDetailVO assetAmortizeDetailVO : feeList) {
                CostCtrlDetailVO costCtrlDetailVO;
                BigDecimal feeTaxMny;
                if (null == assetAmortizeDetailVO.getSubjectId()) continue;
                BigDecimal feeMny = assetAmortizeDetailVO.getAmortizeMny() == null ? BigDecimal.ZERO : assetAmortizeDetailVO.getAmortizeMny();
                BigDecimal bigDecimal = feeTaxMny = assetAmortizeDetailVO.getAmortizeMnyTax() == null ? BigDecimal.ZERO : assetAmortizeDetailVO.getAmortizeMnyTax();
                if (map.containsKey(assetAmortizeDetailVO.getSubjectId())) {
                    costCtrlDetailVO = (CostCtrlDetailVO)map.get(assetAmortizeDetailVO.getSubjectId());
                    BigDecimal mny = costCtrlDetailVO.getMny() == null ? BigDecimal.ZERO : costCtrlDetailVO.getMny();
                    BigDecimal taxMny = costCtrlDetailVO.getTaxMny() == null ? BigDecimal.ZERO : costCtrlDetailVO.getTaxMny();
                    costCtrlDetailVO.setMny(mny.add(feeMny));
                    costCtrlDetailVO.setTaxMny(taxMny.add(feeTaxMny));
                    continue;
                }
                costCtrlDetailVO = new CostCtrlDetailVO();
                costCtrlDetailVO.setSubjectId(assetAmortizeDetailVO.getSubjectId());
                costCtrlDetailVO.setMny(feeMny);
                costCtrlDetailVO.setTaxMny(feeTaxMny);
                map.put(costCtrlDetailVO.getSubjectId(), costCtrlDetailVO);
            }
            if (null != map && map.size() > 0) {
                CostCtrlVO ctrlVO = new CostCtrlVO();
                ctrlVO.setOrgId(vo.getOrgId());
                ctrlVO.setProjectId(vo.getProjectId());
                ctrlVO.setDetailList(new ArrayList(map.values()));
                return ctrlVO;
            }
            return null;
        }
        return null;
    }

    @Override
    public void caclAmortizeMny(List<AssetAmortizeDetailVO> detailList, Date amortizeDate) {
        for (AssetAmortizeDetailVO detailVO : detailList) {
            if (detailVO.getErrMsg() != null) continue;
            Date lastAmortizeDate = detailVO.getLastAmortizeDate();
            Date startAmortizeDate = null;
            boolean isHasThis = false;
            if (lastAmortizeDate == null) {
                isHasThis = true;
                startAmortizeDate = detailVO.getCheckDate();
            } else {
                startAmortizeDate = lastAmortizeDate;
            }
            int thisAmortizeNum = AssetAmortizeServiceImpl.getMonthBetweenDate(startAmortizeDate, amortizeDate, isHasThis);
            detailVO.setThisAmortizeNum(Integer.valueOf(thisAmortizeNum));
            BigDecimal netWorthTax = detailVO.getNetWorthTax();
            BigDecimal residualValueTax = detailVO.getResidualValueTax();
            BigDecimal netWorth = detailVO.getNetWorth();
            BigDecimal residualValue = detailVO.getResidualValue();
            BigDecimal usedAmortizeNum = ComputeUtil.toBigDecimal((Integer)detailVO.getUsedAmortizeNum());
            BigDecimal usePeriod = ComputeUtil.toBigDecimal((Integer)detailVO.getUsePeriod());
            BigDecimal usedAmortizeNumHaveThis = ComputeUtil.safeAdd((BigDecimal)ComputeUtil.toBigDecimal((Integer)detailVO.getThisAmortizeNum()), (BigDecimal)usedAmortizeNum);
            BigDecimal picOriginalValueTax = ComputeUtil.safeDiv((BigDecimal)detailVO.getOriginalValueTax(), (BigDecimal)ComputeUtil.toBigDecimal((Integer)detailVO.getUsePeriod()));
            BigDecimal picOriginalValue = ComputeUtil.safeDiv((BigDecimal)detailVO.getOriginalValue(), (BigDecimal)ComputeUtil.toBigDecimal((Integer)detailVO.getUsePeriod()));
            BigDecimal thisAmortizeMnyTax = ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.toBigDecimal((Integer)thisAmortizeNum), (BigDecimal)picOriginalValueTax);
            BigDecimal thisAmortizeMny = ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.toBigDecimal((Integer)thisAmortizeNum), (BigDecimal)picOriginalValue);
            BigDecimal maxAmortizeMnyTax = ComputeUtil.safeSub((BigDecimal)netWorthTax, (BigDecimal)residualValueTax);
            BigDecimal maxAmortizeMny = ComputeUtil.safeSub((BigDecimal)netWorth, (BigDecimal)residualValue);
            if (ComputeUtil.isLessOrEqual((BigDecimal)maxAmortizeMnyTax, (BigDecimal)BigDecimal.ZERO)) {
                detailVO.setAmortizeMnyTax(BigDecimal.ZERO);
                detailVO.setAmortizeMny(BigDecimal.ZERO);
            } else if (ComputeUtil.isGreaterOrEqual((BigDecimal)usedAmortizeNumHaveThis, (BigDecimal)usePeriod)) {
                detailVO.setAmortizeMnyTax(ComputeUtil.safeSub((BigDecimal)netWorthTax, (BigDecimal)residualValueTax));
                detailVO.setAmortizeMny(ComputeUtil.safeSub((BigDecimal)netWorth, (BigDecimal)residualValue));
            } else if (ComputeUtil.isGreaterThan((BigDecimal)thisAmortizeMnyTax, (BigDecimal)maxAmortizeMnyTax)) {
                detailVO.setAmortizeMnyTax(maxAmortizeMnyTax);
                detailVO.setAmortizeMny(maxAmortizeMny);
            } else {
                detailVO.setAmortizeMnyTax(thisAmortizeMnyTax);
                detailVO.setAmortizeMny(thisAmortizeMny);
            }
            BigDecimal amortizeRate = ComputeUtil.bigDecimalPercent((BigDecimal)detailVO.getAmortizeMnyTax(), (BigDecimal)detailVO.getOriginalValueTax(), (int)2);
            detailVO.setAmortizeRate(amortizeRate);
        }
    }

    @Override
    public void costPush(AssetAmortizeEntity assetAmortizeEntity) {
        this.logger.info("\u5f00\u59cbcostPush");
        List<AssetAmortizeDetailEntity> detailList = assetAmortizeEntity.getDetailList();
        String newRelationFlag = "1";
        if (CollectionUtils.isNotEmpty(detailList)) {
            for (AssetAmortizeDetailEntity entity : detailList) {
                if (null != entity.getSubjectId() && null != entity.getWbsId()) continue;
                newRelationFlag = "0";
                this.logger.info("getSubjectId" + entity.getSubjectId());
                this.logger.info("getWbsId" + entity.getWbsId());
                break;
            }
        }
        if (ListUtil.isEmpty(detailList)) {
            newRelationFlag = "0";
        }
        this.logger.info("newRelationFlag" + newRelationFlag);
        this.saveCost(assetAmortizeEntity, 1);
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.in(BaseEntity::getId, new Object[]{assetAmortizeEntity.getId()});
        updateWrapper.set(AssetAmortizeEntity::getRelationFlag, (Object)newRelationFlag);
        super.update((Wrapper)updateWrapper);
    }

    @Override
    public void saveCost(AssetAmortizeEntity assetAmortizeEntity, Integer effectiveStatus) {
        ArrayList<CostDetailVO> costDetailVOList = new ArrayList<CostDetailVO>();
        List<AssetAmortizeDetailEntity> detailList = assetAmortizeEntity.getDetailList();
        if (CollectionUtils.isNotEmpty(detailList)) {
            for (AssetAmortizeDetailEntity entity : detailList) {
                CostDetailVO costDetailVO = new CostDetailVO();
                costDetailVO.setSubjectId(entity.getSubjectId());
                costDetailVO.setSubjectCode(entity.getSubjectCode());
                costDetailVO.setSubjectName(entity.getSubjectName());
                costDetailVO.setWbsId(entity.getWbsId());
                costDetailVO.setWbsCode(entity.getWbsCode());
                costDetailVO.setWbsName(entity.getWbsName());
                costDetailVO.setSourceId(entity.getPid());
                costDetailVO.setSourceDetailId(entity.getId());
                costDetailVO.setHappenTaxMny(entity.getAmortizeMnyTax());
                costDetailVO.setHappenMny(entity.getAmortizeMny());
                costDetailVO.setHappenDate(assetAmortizeEntity.getBillDate());
                costDetailVO.setCreateUserName(this.sessionManager.getUserContext().getUserName());
                costDetailVO.setSourceType("ASSET_AMORTIZE");
                costDetailVO.setSourceTabType("ASSET_AMORTIZE_SUB");
                costDetailVO.setProjectId(assetAmortizeEntity.getProjectId());
                costDetailVO.setSourceBillCode(assetAmortizeEntity.getBillCode());
                costDetailVO.setSourceBillName(SourceTypeEnum.\u56fa\u5b9a\u8d44\u4ea7\u644a\u9500.getTypeName());
                costDetailVO.setSourceBillUrl("/ejc-proequipmentp-frontend/#/assetAmortize/card?id=" + assetAmortizeEntity.getId());
                costDetailVO.setEffectiveStatus(effectiveStatus);
                costDetailVOList.add(costDetailVO);
            }
        }
        if (ListUtil.isNotEmpty(costDetailVOList)) {
            this.logger.info("\u63a8\u9001\u6570\u636e--------" + JSONObject.toJSONString(costDetailVOList));
            CommonResponse stringCommonResponse = this.costDetailApi.saveSubject(costDetailVOList);
            this.logger.info("\u63a8\u9001\u7ed3\u679c--------" + JSONObject.toJSONString((Object)stringCommonResponse));
            if (!stringCommonResponse.isSuccess()) {
                throw new BusinessException(stringCommonResponse.getMsg());
            }
        }
    }

    @Override
    public CommonResponse<AssetAmortizeVO> pushCost(AssetAmortizeVO assetAmortizeVO) {
        AssetAmortizeEntity assetAmortizeEntity = (AssetAmortizeEntity)((Object)((AssetAmortizeMapper)this.baseMapper).selectById(assetAmortizeVO.getId()));
        if (CollectionUtils.isNotEmpty((Collection)assetAmortizeVO.getDetailList())) {
            List assetAmortizeDetailEntities = BeanMapper.mapList(assetAmortizeEntity.getDetailList(), AssetAmortizeDetailEntity.class);
            assetAmortizeEntity.setDetailList(assetAmortizeDetailEntities);
        }
        super.saveOrUpdate((Object)assetAmortizeEntity, false);
        this.costPush(assetAmortizeEntity);
        return CommonResponse.success((Object)BeanMapper.map((Object)((Object)assetAmortizeEntity), AssetAmortizeVO.class));
    }

    public static int getMonthBetweenDate(Date d1, Date d2, boolean isHasThis) {
        Calendar c1 = Calendar.getInstance();
        Calendar c2 = Calendar.getInstance();
        c1.setTime(d1);
        c2.setTime(d2);
        int year1 = c1.get(1);
        int year2 = c2.get(1);
        int month1 = c1.get(2);
        int month2 = c2.get(2);
        int day1 = c1.get(5);
        int day2 = c2.get(5);
        int yearInterval = year1 - year2;
        if (month1 < month2 || month1 == month2 && day1 < day2) {
            --yearInterval;
        }
        int monthInterval = month1 + 12 - month2;
        if (day1 < day2) {
            --monthInterval;
        }
        int monthsDiff = Math.abs(yearInterval * 12 + (monthInterval %= 12));
        return isHasThis ? ++monthsDiff : monthsDiff;
    }
}

