package com.ejianc.business.asset.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.asset.bean.HandleDetailEntity;
import com.ejianc.business.asset.vo.AssetAllotOutDetailVO;
import com.ejianc.business.asset.vo.HandleDetailVO;
import com.ejianc.business.asset.vo.HandleVO;
import com.ejianc.business.asset.vo.HandleVO;
import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.business.procost.enums.SourceTypeEnum;
import com.ejianc.business.procost.vo.CostDetailVO;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.vo.CostCtrlDetailVO;
import com.ejianc.business.targetcost.vo.CostCtrlVO;
import com.ejianc.business.targetcost.vo.ParamsCheckDsVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.asset.mapper.HandleMapper;
import com.ejianc.business.asset.bean.HandleEntity;
import com.ejianc.business.asset.service.IHandleService;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 *  设备处置
 * 
 * @author generator
 * 
 */
@Service("handleService")
public class HandleServiceImpl extends BaseServiceImpl<HandleMapper, HandleEntity> implements IHandleService{

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private ICostDetailApi costDetailApi;

    @Autowired
    private IExecutionApi executionApi;


    @Override
    public CommonResponse<HandleVO> pushCost(HandleVO handleVO) {
        HandleEntity handleEntity = baseMapper.selectById(handleVO.getId());
        if (CollectionUtils.isNotEmpty(handleVO.getHandleDetailList())) {
            List<HandleDetailEntity> handleDetailEntities = BeanMapper.mapList(handleVO.getHandleDetailList(), HandleDetailEntity.class);
            handleEntity.setHandleDetailList(handleDetailEntities);
        }
        super.saveOrUpdate(handleEntity, false);
        //推送数据
        this.costPush(handleEntity);
        return CommonResponse.success(BeanMapper.map(handleVO, HandleVO.class));
    }

    @Override
    public void costPush(HandleEntity handleEntity) {
        logger.info("开始costPush");
        List<HandleDetailEntity> allotOutDetailEntities = handleEntity.getHandleDetailList();
        String newRelationFlag = "1";
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(allotOutDetailEntities)) {
            for (HandleDetailEntity entity : allotOutDetailEntities) {
                if (null == entity.getSubjectId() || null == entity.getWbsId()) {
                    newRelationFlag = "0";
                    logger.info("getSubjectId"+entity.getSubjectId());
                    logger.info("getWbsId"+entity.getWbsId());
                    break;
                }
            }
        }
        if (ListUtil.isEmpty(allotOutDetailEntities)) {
            newRelationFlag = "0";
        }
        logger.info("newRelationFlag"+newRelationFlag);
        //先删后增
        saveCost(handleEntity,1);//生效状态 0-未生效，1-生效
        //更新是否关联
        LambdaUpdateWrapper<HandleEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.in(HandleEntity::getId, handleEntity.getId());
        updateWrapper.set(HandleEntity::getRelationFlag, newRelationFlag);//(1:是，0：否)
        super.update(updateWrapper);

    }
    @Override
    public void saveCost(HandleEntity handleEntity,Integer effectiveStatus) {
        //明细
        List<CostDetailVO> costDetailVOList = new ArrayList<>();
        List<HandleDetailEntity> handleDetailList = handleEntity.getHandleDetailList();
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(handleDetailList)) {
            for (HandleDetailEntity entity : handleDetailList) {
                CostDetailVO costDetailVO = new CostDetailVO();
                costDetailVO.setSubjectId(entity.getSubjectId());
                costDetailVO.setSubjectCode(entity.getSubjectCode());
                costDetailVO.setSubjectName(entity.getSubjectName());
                costDetailVO.setWbsId(entity.getWbsId());
                costDetailVO.setWbsCode(entity.getWbsCode());
                costDetailVO.setWbsName(entity.getWbsName());
                costDetailVO.setSourceId(entity.getHandleId());
                costDetailVO.setSourceDetailId(entity.getId());
                costDetailVO.setHappenTaxMny(entity.getHandleDiffTaxMny());
                costDetailVO.setHappenMny(entity.getHandleTaxMny());
                costDetailVO.setHappenDate(handleEntity.getHandleDate());
                costDetailVO.setCreateUserName(sessionManager.getUserContext().getUserName());
                costDetailVO.setSourceType("ASSET_HANDLE");
                costDetailVO.setSourceTabType("ASSET_HANDLE_SUB");
                costDetailVO.setProjectId(handleEntity.getProjectId());
                costDetailVO.setEffectiveStatus(effectiveStatus);//生效状态 0-未生效，1-生效
                //新加的
                costDetailVO.setSourceBillCode(handleEntity.getBillCode());
                costDetailVO.setSourceBillName(SourceTypeEnum.固定资产设备处置.getTypeName());
                costDetailVO.setSourceBillUrl("/ejc-proequipmentp-frontend/#/handle/handleCard?id="+handleEntity.getId());
                costDetailVOList.add(costDetailVO);
            }
        }

        //成本中心
        if (ListUtil.isNotEmpty(costDetailVOList)) {
            logger.info("推送数据--------"+JSONObject.toJSONString(costDetailVOList));
            CommonResponse<String> stringCommonResponse = costDetailApi.saveSubject(costDetailVOList);
            logger.info("推送结果--------"+JSONObject.toJSONString(stringCommonResponse));
            if (stringCommonResponse.isSuccess()) {
            } else {
                throw new BusinessException(stringCommonResponse.getMsg());
            }
        }
    }

    
    @Override
    public ParamsCheckVO checkParams(HandleVO vo) {
        List<ParamsCheckVO> paramsCheckVOS = new ArrayList<>();
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        //--成本科目控制
        CostCtrlVO costCtrlVO = this.sjCost(vo);
        if(null!=costCtrlVO){
            CommonResponse<ParamsCheckVO> costResponse = executionApi.ctrlCost(costCtrlVO);
            if (!costResponse.isSuccess()) {
                throw new BusinessException("成本科目控制失败," + costResponse.getMsg());
            }
            ParamsCheckVO costRes = costResponse.getData();
            if(null!=costRes){
                paramsCheckVOS.add(costRes);
            }
        }
        Map<String, List<ParamsCheckDsVO>> map = new HashMap<>();
        String[] paramsArray = {"alert", "warn", "none"};
        if (CollectionUtils.isNotEmpty(paramsCheckVOS)) {
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if (map.containsKey(warnType)) {
                    List<ParamsCheckDsVO> checkDsVOS = map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType, checkDsVOS);
                }
                else {
                    map.put(warnType, checkVO.getDataSource());
                }
            }
        }
        for (String s : paramsArray) {
            if(map.containsKey(s)){
                paramsCheckVO.setWarnType(s);
                paramsCheckVO.setDataSource(map.get(s));
                if(CollectionUtils.isEmpty(paramsCheckVO.getDataSource())){
                    paramsCheckVO.setWarnType("none");
                }else {
                    return paramsCheckVO;
                }
            }
        }
        return paramsCheckVO;
    }

    public CostCtrlVO sjCost(HandleVO vo){
        List<HandleDetailVO> feeList = vo.getHandleDetailList();
        if(CollectionUtils.isNotEmpty(feeList)){
            Map<Long, CostCtrlDetailVO> map = new HashMap<>();
            for(HandleDetailVO handleDetailVO:feeList){
                if(null!=handleDetailVO.getSubjectId()){
                    BigDecimal feeMny = handleDetailVO.getHandleDiffMny()==null?BigDecimal.ZERO:handleDetailVO.getHandleDiffMny();
                    BigDecimal feeTaxMny = handleDetailVO.getHandleDiffTaxMny()==null?BigDecimal.ZERO:handleDetailVO.getHandleDiffTaxMny();
                    if(map.containsKey(handleDetailVO.getSubjectId())){
                        CostCtrlDetailVO costCtrlDetailVO = map.get(handleDetailVO.getSubjectId());
                        BigDecimal mny = costCtrlDetailVO.getMny()==null?BigDecimal.ZERO:costCtrlDetailVO.getMny();
                        BigDecimal taxMny = costCtrlDetailVO.getTaxMny()==null?BigDecimal.ZERO:costCtrlDetailVO.getTaxMny();
                        costCtrlDetailVO.setMny(mny.add(feeMny));
                        costCtrlDetailVO.setTaxMny(taxMny.add(feeTaxMny));
                    }else{
                        CostCtrlDetailVO costCtrlDetailVO = new CostCtrlDetailVO();
                        costCtrlDetailVO.setSubjectId(handleDetailVO.getSubjectId());
                        costCtrlDetailVO.setMny(feeMny);
                        costCtrlDetailVO.setTaxMny(feeTaxMny);
                        map.put(costCtrlDetailVO.getSubjectId(),costCtrlDetailVO);
                    }
                }
            }
            if(null != map && map.size() > 0){
                CostCtrlVO ctrlVO = new CostCtrlVO();
                ctrlVO.setOrgId(vo.getOrgId());
                ctrlVO.setProjectId(vo.getProjectId());
                ctrlVO.setDetailList(new ArrayList<>(map.values()));
                return ctrlVO;
            }else{
                return null;
            }
        }
        return null;
    }
}
