package com.ejianc.business.purchase.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.contractbase.pool.enums.ContractPerformanceStateEnum;
import com.ejianc.business.purchase.bean.PurchaseContractEntity;
import com.ejianc.business.purchase.bean.PurchaseContractRelieveEntity;
import com.ejianc.business.purchase.enums.SignatureStatusEnum;
import com.ejianc.business.purchase.mapper.PurchaseContractRelieveMapper;
import com.ejianc.business.purchase.service.IPurchaseContractRelieveService;
import com.ejianc.business.purchase.service.IPurchaseContractService;
import com.ejianc.business.purchase.vo.PurchaseContractVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

/**
 * 购置合同-合同解除表
 * 
 * @author generator
 * 
 */
@Service("purchaseContractRelieveService")
public class PurchaseContractRelieveServiceImpl extends BaseServiceImpl<PurchaseContractRelieveMapper, PurchaseContractRelieveEntity> implements IPurchaseContractRelieveService{

    @Autowired
    private IPurchaseContractRelieveService service;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    /**
     * 主合同信息
     */
    @Autowired
    private IPurchaseContractService contractService;


    /**
     * 根据合同编号查询是否可以新增合同解除单据
     *
     * @param contractId 合同id
     * @return Boolean 是否可以新增
     */
    @Override
    public Boolean isCanRelieve(Long contractId) {
        // 添加校验
        QueryParam param = new QueryParam();
        param.getParams().put("contract_id", new Parameter(QueryParam.EQ, contractId));
        List<PurchaseContractRelieveEntity> list = service.queryList(param);
        return list.isEmpty();
    }

    /**
     * 更新合同解除单据签章状态和合同状态
     *
     * @param billId  合同解除单据id
     * @param status  签章状态
     * @param refCode 唯一标识
     * @return 结果数据
     */
    @Override
    public CommonResponse<String> relieveContract(String billId, String status, String refCode) {
        logger.info("更新合同解除单据签章状态和合同状态，入参：id:{}，signatureStatus：{}，refCode：{}", billId, status, refCode);
        Integer id = Integer.valueOf(billId);
        PurchaseContractRelieveEntity purchaseContractRelieveEntity = super.selectById(id);
        purchaseContractRelieveEntity.setSignatureStatus(status);
        // 合同信息
        PurchaseContractEntity purchaseContractEntity = contractService.selectById(purchaseContractRelieveEntity.getContractId());
        if (purchaseContractEntity == null) {
            throw new BusinessException("合同信息为空！");
        }
        logger.info("修改合同信息-----{}", JSONObject.toJSONString(purchaseContractEntity));
        // 签章状态：4-已签章，履约中允许解除（冻结及其他状态不能解除）
        if (SignatureStatusEnum.已签章.getCode().equals(status)
                && ContractPerformanceStateEnum.履约中.getStateCode().equals(purchaseContractEntity.getContractPerformanceState())) {
            // 更新合同解除单据生效时间
            purchaseContractRelieveEntity.setEffectiveDate(new Date());
            // 更新合同状态为已解除
            purchaseContractEntity.setContractPerformanceState(ContractPerformanceStateEnum.已作废.getStateCode());
            contractService.saveOrUpdate(purchaseContractEntity, false);
            // 推送合同池
            contractService.pushContract(BeanMapper.map(purchaseContractEntity, PurchaseContractVO.class));

            logger.info("合同已解除！");
        }
        super.saveOrUpdate(purchaseContractRelieveEntity, false);
        return CommonResponse.success("合同解除单据签章状态更新成功！");
    }
}
