package com.ejianc.business.purchase.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.contractbase.api.ICommonSNAPI;
import com.ejianc.business.contractbase.api.IParamCheckApi;
import com.ejianc.business.contractbase.filing.enums.FilingStatusEnum;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.contractbase.pool.enums.ContractPerformanceStateEnum;
import com.ejianc.business.contractbase.pool.enums.ContractPropertyEnum;
import com.ejianc.business.contractbase.pool.enums.ContractTypeEnum;
import com.ejianc.business.contractbase.vo.CommonSNVO;
import com.ejianc.business.contractpub.util.BeanConvertorUtil;
import com.ejianc.business.promaterial.contract.vo.ContractDetailVO;
import com.ejianc.business.purchase.bean.*;
import com.ejianc.business.purchase.enums.ChangeStatusEnum;
import com.ejianc.business.purchase.enums.DraftTypeEnum;
import com.ejianc.business.purchase.enums.SignatureStatusEnum;
import com.ejianc.business.purchase.mapper.PurchaseContractMapper;
import com.ejianc.business.purchase.service.*;
import com.ejianc.business.purchase.vo.EquipmentDetailedVO;
import com.ejianc.business.purchase.vo.PurchaseContractVO;
import com.ejianc.business.settlement.vo.*;
import com.ejianc.business.signaturemanage.api.ISignatureCommonApi;
import com.ejianc.business.signaturemanage.vo.WatermarkVO;
import com.ejianc.business.targetcost.api.IDutyApi;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.business.targetcost.enums.DocTypeEnum;
import com.ejianc.business.targetcost.vo.*;
import com.ejianc.business.tender.api.ITenderEquipmentApi;
import com.ejianc.business.tender.common.vo.SignContractVo;
import com.ejianc.business.tender.common.vo.TenderPicketageDetailVO;
import com.ejianc.business.tender.common.vo.TenderPicketageVO;
import com.ejianc.business.utils.CommonUtils;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.CollectionUtil;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 购置合同表
 *
 * @author generator
 */
@Service("purchaseContractService")
public class PurchaseContractServiceImpl extends BaseServiceImpl<PurchaseContractMapper, PurchaseContractEntity> implements IPurchaseContractService {

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IParamCheckApi paramCheckApi;

    @Autowired
    private ITenderEquipmentApi tenderApi;
    //定标结果未占用状态
    int unOccupyState = 0;
    //定标结果已占用状态
    int occupyState = 1;
    private static final String BILL_TYPE = "BT220323000000001";//合同单据编码

    private static final String CHANGE_BILL_TYPE = "BT220323000000002";//变更合同单据编码

    private static final String BILL_CODE = "PURCBASE_CONTRACT";//此处需要根据实际修改
    private static final String WATERMARK_CHECK_PARAM_NAME = "P-00a9W886";
    private static final String BILL_CODE_YNJT = "PURCBASE_CONTRACT_YNJT01";//云南建投编码规则
    private static final String GenerateSourceType = "SPCG10086";//编码流水号业务类型
    @Value("${contract.generateBillCodeType:common}")
    private String GenerateBillCodeType;
    @Autowired
    private ICommonSNAPI commonSNAPI;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IPurchaseContractService service;

    @Autowired
    private IEquipmentDetailedService contractDetailService;


    @Autowired
    private IChangePurchaseContractService changeService;

    @Autowired
    private IPurchaseContractRelieveService relieveService;

    @Autowired
    private IPurchaseContractFreezeService freezeService;
    @Autowired
    private IParamConfigApi paramConfigApi;
    private static final String CHECK_PARAM_CODE = "P-06vj8393";//设备采购合同补充金额控制

    private static final String CONTRACT_FILING_CODE = "P-eg7rBO0134"; //合同归档控制

    @Autowired
    private IDutyApi dutyApi;


    @Value("${common.env.base-host}")
    private String BaseHost;

    @Autowired
    private IContractPoolApi contractPoolApi;

    @Autowired
    private IExecutionApi executionApi;

    @Autowired
    private IShareMaterialApi materialApi;

    @Autowired
    private IContractAsyncService contractAsyncService;
    @Autowired
    ISignatureCommonApi signatureCommonApi;

    @Autowired
    private IAttachmentApi attachmentApi;
    private static final String linkUrl = "/ejc-proequipmentp-frontend/#/machineryPurchaseContract/card?id=";//此处需要根据实际修改
    private static final String changeLinkUrl = "ejc-proequipmentp-frontend/#/machineryPurchaseContract/contractChangeCard?id=";//此处需要根据实际修改

    // 设备购置合同-签订、变更、补充协议  【设备购置清单历史最高价】 控【设备购置合同价格】
    private final String HISTORY_MAX_PRICE_CTRL_CON_PRICE = "P-X74QbJ0193";
    // 设备购置合同-签订、变更、补充协议  【设备购置清单历史最低价】 控【设备购置合同价格】
    private final String HISTORY_MIN_PRICE_CTRL_CON_PRICE = "P-A1NkyL0194";
    /**
     * 新增或者修改合同
     *
     * @param contractVO
     * @return
     */
    @Override
    public PurchaseContractVO insertOrUpdate(PurchaseContractVO contractVO, String authority, Boolean isControl) {
//        PurchaseContractEntity entity = BeanMapper.map(contractVO, PurchaseContractEntity.class);
        // parentOrgCode如果是空的，则需要查询赋值
//        if (StringUtils.isEmpty(entity.getParentOrgCode()) && entity.getParentOrgId() != null) {
//            CommonResponse<OrgVO> orgResponse = iOrgApi.getOneById(entity.getParentOrgId());
//            if (orgResponse.isSuccess()) {
//                OrgVO orgVO = orgResponse.getData();
//                entity.setParentOrgCode(orgVO.getCode());
//                contractVO.setParentOrgCode(orgVO.getCode());
//            }
//        }
//        CommonResponse<OrgVO> orgResponse1 = iOrgApi.getOneById(entity.getOrgId());
//        if (orgResponse1.isSuccess()) {
//            OrgVO orgVO = orgResponse1.getData();
//            entity.setOrgCode(orgVO.getCode());
//            contractVO.setOrgCode(orgVO.getCode());
//        }
        if (contractVO.getOrgId() != null && (StringUtils.isEmpty(contractVO.getOrgCode()) || StringUtils.isEmpty(contractVO.getParentOrgCode()))) {
            CommonResponse<OrgVO> orgResponse = iOrgApi.getOneById(contractVO.getOrgId());
            if (orgResponse.isSuccess()) {
                OrgVO orgVO = orgResponse.getData();
                contractVO.setOrgCode(orgVO.getCode());
                // 项目部
                if(5 == orgVO.getOrgType()){
                    CommonResponse<OrgVO> parentOrgResponse = iOrgApi.getOneById(orgVO.getParentId());
                    if (parentOrgResponse.isSuccess()) {
                        OrgVO parentOrgVO = parentOrgResponse.getData();
                        contractVO.setParentOrgId(parentOrgVO.getId());
                        contractVO.setParentOrgCode(parentOrgVO.getCode());
                        contractVO.setParentOrgName(parentOrgVO.getName());
                    }
                }
                // 非项目部
                else {
                    contractVO.setParentOrgId(contractVO.getOrgId());
                    contractVO.setParentOrgCode(contractVO.getOrgCode());
                    contractVO.setParentOrgName(contractVO.getOrgName());
                }
            }
        }
        PurchaseContractEntity entity = BeanMapper.map(contractVO, PurchaseContractEntity.class);
        if (!isControl) {
            if (entity.getId() == null) {
                if (StringUtils.isBlank(entity.getBillCode())) {

                    switch (GenerateBillCodeType) {
                        case "common":
                            CommonResponse<String> billCode = billCodeApi.generateBillCode(BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), contractVO));
                            if (!billCode.isSuccess()) {
                                logger.error("保存合同失败，自动生成合同合同失败: {}", billCode.getMsg());
                                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                            }

                            entity.setBillCode(billCode.getData());
                            break;
                        case "ynjt":
                            CommonResponse<String> billCodeFirstPart = billCodeApi.generateBillCode(BillCodeParam.build(BILL_CODE_YNJT, InvocationInfoProxy.getTenantid(), contractVO));
                            if (!billCodeFirstPart.isSuccess()) {
                                logger.error("保存合同失败，自动生成合同合同失败: {}", billCodeFirstPart.getMsg());
                                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                            }
                            //根据合同基层单位后三位查询查询流水号
                            CommonSNVO commonSNVO = new CommonSNVO();
                            commonSNVO.setSnLength(4);
                            commonSNVO.setTenantId(InvocationInfoProxy.getTenantid());
                            commonSNVO.setDimension(entity.getParentOrgCode().substring(entity.getParentOrgCode().length() - 3));
                            commonSNVO.setSourceType(GenerateBillCodeType);
                            CommonResponse<String> snResp = commonSNAPI.getNext(commonSNVO);
                            if (!snResp.isSuccess()) {
                                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                            }
                            entity.setBillCode(billCodeFirstPart.getData() + entity.getParentOrgCode().substring(entity.getParentOrgCode().length() - 3) + snResp.getData());
                            break;
                    }
                }
                else {
                    //验证编码是否唯一
                    if (checkSameBillCode(BeanMapper.map(entity, PurchaseContractVO.class))) {
                        throw new BusinessException("编码重复，不允许保存!");
                    }
                }


                if (entity.getId() == null) {
                    //设置归档状态
                    if (entity.getFilingStatus() == null) {
                        entity.setFilingStatus(FilingStatusEnum.未归档.getTypeCode());
                    }
                    entity.setFilingRef(0);
                }


                //设置合同初始状态
                entity.setSignatureStatus(SignatureStatusEnum.未签章.getCode());
                entity.setSupplementFlag(0);
                entity.setChangeStatus(ChangeStatusEnum.未变更.getCode());
                entity.setMainContractCreateDate(new Date());
                //回写定标结果占据状态
//                tenderApi.updateById(entity.getTargetResultId(), occupyState);
                this.updateTargetResult(contractVO, 0);
            }
            else {
                //若定标结果更换则回写原来定标结果为为占用状态，新定标结果为占用状态
                PurchaseContractEntity oldPurchaseContractEntity = super.selectById(entity.getId());
                if (null != entity.getTargetResultId()) {
//                    tenderApi.updateById(oldPurchaseContractEntity.getTargetResultId(), unOccupyState);
//                    tenderApi.updateById(entity.getTargetResultId(), occupyState);
                    // 如果是合同修改，先对修改前合同做反向操作，再进行占用
                    this.updateTargetResult(BeanMapper.map(oldPurchaseContractEntity, PurchaseContractVO.class), 1);
                    this.updateTargetResult(contractVO, 0);
                }
                if (StringUtils.isBlank(entity.getBillCode())) {
                    entity.setBillCode(oldPurchaseContractEntity.getBillCode());
                }
                else {
                    //验证编码是否唯一
                    if (checkSameBillCode(BeanMapper.map(entity, PurchaseContractVO.class))) {
                        throw new BusinessException("编码重复，不允许保存!");
                    }
                }
            }
        }
        //补充金额明细
        entity.setContractMny(contractVO.getContractMny() == null ? BigDecimal.ZERO : contractVO.getContractMny());
        entity.setContractTaxMny(contractVO.getContractTaxMny() == null ? BigDecimal.ZERO : contractVO.getContractTaxMny());
        entity.setContractTax(contractVO.getContractTax() == null ? BigDecimal.ZERO : contractVO.getContractTax());
        //分包明细
        entity.setEquipmentTaxMny(contractVO.getEquipmentTaxMny() == null ? BigDecimal.ZERO : contractVO.getEquipmentTaxMny());
        entity.setEquipmentMny(contractVO.getEquipmentMny() == null ? BigDecimal.ZERO : contractVO.getEquipmentMny());
        entity.setEquipmentTax(contractVO.getEquipmentTax() == null ? BigDecimal.ZERO : contractVO.getEquipmentTax());
        //其他费用
        entity.setOtherTaxMny(contractVO.getOtherTaxMny() == null ? BigDecimal.ZERO : contractVO.getOtherTaxMny());
        entity.setOtherMny(contractVO.getOtherMny() == null ? BigDecimal.ZERO : contractVO.getOtherMny());
        entity.setOtherTax(contractVO.getOtherTax() == null ? BigDecimal.ZERO : contractVO.getOtherTax());
        //设置初始金额
        entity.setBaseMny(entity.getContractMny() == null ? BigDecimal.ZERO : entity.getContractMny());
        entity.setBaseTaxMny(entity.getContractTaxMny() == null ? BigDecimal.ZERO : entity.getContractTaxMny());
        //设置变更前金额
        entity.setBeforeChangeMny(entity.getContractMny() == null ? BigDecimal.ZERO : entity.getContractMny());
        entity.setBeforeChangeTaxMny(entity.getContractTaxMny() == null ? BigDecimal.ZERO : entity.getContractTaxMny());

//        if (entity.getContractFileId() != null) {
//            if (entity.getId() != null) {
//                PurchaseContractEntity contract = service.getById(entity.getId());
//                //如果改合同上次修改的起草方式不是线上起草  且 这次改为线上起草，则删除附件
//                if (contract != null && !DraftTypeEnum.线上起草.getCode().toString().equals(contract.getDraftType()) && DraftTypeEnum.线上起草.getCode().toString().equals(entity.getDraftType())) {
//                    if (!isControl){
//                        delContractFile(entity.getContractFileId(), authority);
//                    }
//                    entity.setContractFileId(null);
//                    entity.setContractFilePath(null);
//                }
//            }
//            else {
//                //如果是新建合同，且起草方式为线上起草则删除附件
//                if (DraftTypeEnum.线上起草.getCode().toString().equals(entity.getDraftType())) {
//                    if (!isControl){
//                        delContractFile(entity.getContractFileId(), authority);
//                    }
//                    entity.setContractFileId(null);
//                    entity.setContractFilePath(null);
//                }
//            }
//        }

        // 1、合同保存方法增加逻辑
        if (entity.getContractFileId() != null) {
            //合同旧数据
            PurchaseContractEntity contract = service.getById(entity.getId());
            if (contract != null && (
                    //如果当前合同是线上起草，而且合同分类做了变更，那么删除附件
                    !contract.getContractCategoryId().equals(entity.getContractCategoryId())
                            //如果改合同上次修改的起草方式不是线上起草  且 这次改为线上起草，则删除附件
                            || !(DraftTypeEnum.线上起草.getCode().toString().equals(contract.getDraftType())
                            || DraftTypeEnum.线上起草不使用电子签章.getCode().toString().equals(contract.getDraftType()))
            ) && (DraftTypeEnum.线上起草.getCode().toString().equals(entity.getDraftType()) ||
                    DraftTypeEnum.线上起草不使用电子签章.getCode().toString().equals(entity.getDraftType())
            )) {
                if (Boolean.FALSE.equals(isControl) && null != contract.getContractFileId()) {
                    delContractFile(contract.getContractFileId(), authority);
                }
                entity.setContractFileId(null);
                entity.setContractFilePath(null);
            }
        }

        //将合同文件同步标识置为未同步
        if (DraftTypeEnum.线上起草.getCode().toString().equals(entity.getDraftType()) || DraftTypeEnum.线上起草不使用电子签章.getCode().toString().equals(entity.getDraftType())) {
            entity.setContractFileSyncFlag(false);
        }


        //设置项目部id和项目部上级组织id
//        if (null != entity.getOrgId()){
//            CommonResponse<OrgVO> orgResp = iOrgApi.getOneById(entity.getOrgId());
//            if(!orgResp.isSuccess()) {
//                logger.error("保存合同失败，获取项目部id-{}信息失败，{}", entity.getOrgId(), orgResp.getMsg());
//                throw new BusinessException("保存失败，获取项目部信息失败！");
//            }
//            OrgVO orgVO = orgResp.getData();
//            if (null != orgVO && null != orgVO.getParentId()){
//                entity.setParentOrgId(orgVO.getParentId());
//                entity.setParentOrgName(orgVO.getpFName());
//                //获取父级orgCode
//                CommonResponse<OrgVO> parentOrgResp = iOrgApi.getOneById(orgVO.getParentId());
//                if(!parentOrgResp.isSuccess()) {
//                    logger.error("保存合同失败，获取项目部parentId-{}信息失败，{}", orgVO.getParentId(), parentOrgResp.getMsg());
//                    throw new BusinessException("保存失败，获取项目部父级信息失败！");
//                }
//                OrgVO parentOrgVO = parentOrgResp.getData();
//                if (null != parentOrgVO && null != parentOrgVO.getCode()){
//                    entity.setParentOrgCode(parentOrgVO.getCode());
//                }
//            }
//        }

        //保存前清空主键和父主键，重新生成
//        resetPid(entity.getDetailList());
        if (!isControl) {
            super.saveOrUpdate(entity, false);
            //目标成本推送
            ExecutionVO executionVO = service.targetCost(BeanMapper.map(entity, PurchaseContractVO.class), BILL_TYPE, linkUrl);
            logger.info("目标成本推送数据" + JSON.toJSONString(executionVO));
            CommonResponse<String> response = executionApi.aggPush(executionVO);
            if (!response.isSuccess()) {
                throw new BusinessException("目标成本推送失败," + response.getMsg());
            }
        }
        if (null == entity.getId() && isControl) {
            entity.setId(IdWorker.getId());
            return BeanMapper.map(entity, PurchaseContractVO.class);
        }
        return queryDetail(entity.getId());
    }


    @Override
    public ExecutionVO targetCost(PurchaseContractVO contractVO, String BillType, String linkUrl) {
        ExecutionVO executionVO = new ExecutionVO();
        TotalExecutionVO totalVO = new TotalExecutionVO();
        List<DetailExecutionVO> detailList = new ArrayList<>();
        totalVO.setSourceId(contractVO.getId());
        totalVO.setTenantId(contractVO.getTenantId());
        totalVO.setBillCode(contractVO.getBillCode());
        totalVO.setBillType(BillType);
        totalVO.setBussinessType(BussinessTypeEnum.设备采购合同.getCode());
        totalVO.setBillCategory(BillCategoryEnum.合同.getCode());
        totalVO.setProjectId(contractVO.getProjectId());
        totalVO.setOrgId(contractVO.getOrgId());
        totalVO.setMoney(contractVO.getContractMny());
        totalVO.setTaxMoney(contractVO.getContractTaxMny());
        totalVO.setLinkUrl(BaseHost + linkUrl + contractVO.getId());
        List contractDetailList;
        if (BillType.equals(BILL_TYPE)) {
            contractDetailList = contractVO.getDetailList();
        }
        else {
            totalVO.setLastSourceId(contractVO.getMainContractId());
            contractDetailList = changeService.queryDetail(contractVO.getId()).getDetailList();
        }
        if (contractDetailList != null) {
            for (EquipmentDetailedVO planDetailVO : contractVO.getDetailList()) {
                if (planDetailVO.getRowState() != null && planDetailVO.getRowState().equals("del")) {
                    continue;
                }
                DetailExecutionVO detailExecutionVO = new DetailExecutionVO();
                detailExecutionVO.setSourceId(planDetailVO.getId() == null ? IdWorker.getId() : planDetailVO.getId());
                detailExecutionVO.setSourceBillId(contractVO.getId());
                detailExecutionVO.setCategoryId(planDetailVO.getDocCategoryId());
                detailExecutionVO.setCategoryName(planDetailVO.getEquipmentType());
                //判断是否是分类
                if (planDetailVO.getDocId() == null) {
                    detailExecutionVO.setCategoryFlag(true);
                    detailExecutionVO.setDocId(planDetailVO.getDocCategoryId());
                }
                else {
                    detailExecutionVO.setCategoryFlag(false);
                    detailExecutionVO.setDocId(planDetailVO.getDocId());
                }
                detailExecutionVO.setCode(planDetailVO.getEquipmentCode());
                detailExecutionVO.setCategoryContainFlag(false);
                //根据分类ID查询物料分类信息
                MaterialCategoryVO categoryVO = materialApi.queryCategoryById(planDetailVO.getDocId()).getData();
                if (categoryVO == null) {
                    detailExecutionVO.setCategoryInnerCode(null);
                    detailExecutionVO.setCategoryCode(null);
                }
                else {
                    detailExecutionVO.setCategoryInnerCode(categoryVO.getInnerCode());
                    detailExecutionVO.setCategoryCode(categoryVO.getCode());
                }
                detailExecutionVO.setDocType(DocTypeEnum.设备档案.getCode());
                detailExecutionVO.setName(planDetailVO.getEquipmentName());
//                detailExecutionVO.setUnitId(planDetailVO.getUnitId());
                detailExecutionVO.setUnitName(planDetailVO.getCompany());
                detailExecutionVO.setNum(BigDecimal.valueOf(planDetailVO.getPurchaseNum()));
                detailExecutionVO.setMoney(planDetailVO.getPurchaseAmountNoTax());
                detailExecutionVO.setSpec(planDetailVO.getSpec());
                detailExecutionVO.setTaxMoney(planDetailVO.getPurchaseAmount());
                detailExecutionVO.setPrice(planDetailVO.getPurchasePricetNoTax());
                detailExecutionVO.setTaxPrice(planDetailVO.getPurchasePrice());
                detailExecutionVO.setTaxRate(planDetailVO.getTaxRate());
                detailList.add(detailExecutionVO);
            }
        }
        executionVO.setTotalVO(totalVO);
        executionVO.setDetailList(detailList);
        return executionVO;
    }

    @Override
    public void pushContract(PurchaseContractVO contractVO) {
        ContractPoolVO data = new ContractPoolVO();
        try {
            BeanConvertorUtil.convert(contractVO, data);
            data.setPcCardUrl(linkUrl + contractVO.getId());
            data.setSourceType(ContractTypeEnum.设备采购.getTypeCode());

//            data.setPcCardUrl("/ejc-proequipmentp-frontend/#/machineryPurchaseContract/contractApprove?id="
//                    + contractVO.getId() + "&supplementFlag=" + contractVO.getSupplementFlag()
//                    + "&targetType=" + contractVO.getTargetResultId() + "&performanceStatus="
//                    + contractVO.getContractPerformanceState());
            data.setContractProperty(ContractPropertyEnum.支出合同.getPropertyCode());
            logger.info("开始推送合同池>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
            logger.info("推送数据：{}", JSONObject.toJSONString(data));
            CommonResponse<ContractPoolVO> transDataResp = contractPoolApi.saveOrUpdateContract(data);
            logger.info("推送合同池结束，推送结果：{}<<<<<<<<<<<<<<<<<<<<<<<<<<<<<", transDataResp.isSuccess());
            if (!transDataResp.isSuccess()) {
                logger.error("合同id-{}推送合同池失败，{}", contractVO.getId(), transDataResp.getMsg());
            }
        } catch (Exception e) {
            logger.error("合同-{}推送合同池失败，", contractVO.getId(), e);
        }
    }

    @Override
    public Boolean delContractFile(Long fileId, String authority) {
        Map<String, Object> params = new HashMap<>();
        Map<String, String> header = new HashMap<>();
        params.put("ids", fileId.toString());
        header.put("authority", authority);

        String delRespStr = null;
        try {
            delRespStr = HttpTookit.get(BaseHost + "ejc-file-web/attachment/delete", params, header, 10000, 10000);
        } catch (Exception e) {
            e.printStackTrace();
        }
        CommonResponse<String> delResp = JSONObject.parseObject(delRespStr, CommonResponse.class);
        if (delResp != null) {
            logger.info("在线起草，删除上传合同返回信息：" + delResp.getMsg());
        }
        return true;
    }

    private void resetPid(List<EquipmentDetailedEntity> detailList) {
        if (CollectionUtils.isNotEmpty(detailList)) {
            Map<String, Long> idMap = new HashMap<>();
            for (EquipmentDetailedEntity cdEntity : detailList) {
                if (cdEntity.getId() == null) {
                    cdEntity.setId(IdWorker.getId());
                }
                idMap.put(cdEntity.getDocId().toString(), cdEntity.getId());
                cdEntity.setParentId(null);
            }
            for (EquipmentDetailedEntity cdEntity : detailList) {
                if (StringUtils.isNotEmpty(cdEntity.getDocId().toString())) {
                    cdEntity.setParentId(idMap.get(cdEntity.getDocId()));
                }
            }
        }
    }

    /**
     * 查询合同详情
     *
     * @param id
     * @return
     */
    @Override
    public PurchaseContractVO queryDetail(Long id) {
        Map<String, LinkedHashMap<String, String>> orderMap = new HashMap<>();
        LinkedHashMap<String, String> orderParams = new LinkedHashMap<>();
        orderMap.put("detailList", orderParams);
        orderMap.put("otherCostList", orderParams);

        PurchaseContractEntity contractEntity = super.selectById(id, orderMap);
        PurchaseContractVO contractVO = BeanMapper.map(contractEntity, PurchaseContractVO.class);

        if (CollectionUtils.isNotEmpty(contractVO.getDetailList())) {
            contractVO.setDetailList(contractVO.getDetailList());
        }

        return contractVO;
    }

    /**
     * 查询当前合同下补充协议列表
     *
     * @param id
     * @return
     */
    @Override
    public PurchaseContractVO querySupplementRecord(Long id) {
        PurchaseContractEntity contractEntity = super.selectById(id);
        PurchaseContractVO contractVO = new PurchaseContractVO();

        BigDecimal contractTaxMny = contractEntity.getContractTaxMny() == null ? BigDecimal.ZERO : contractEntity.getContractTaxMny();

        contractVO.setId(id);
        contractVO.setContractTaxMny(contractTaxMny);
        contractVO.setChangeStatus(contractEntity.getChangeStatus());

        QueryWrapper<PurchaseContractEntity> query = new QueryWrapper<>();
        query.eq("main_contract_id", id);
        query.eq("contract_performance_state", ContractPerformanceStateEnum.履约中.getStateCode());
        query.orderByDesc("create_time");
        List<PurchaseContractEntity> supplementEntities = super.list(query);

        contractVO.setSupplementList(BeanMapper.mapList(supplementEntities, PurchaseContractVO.class));
        //补充协议次数
        contractVO.setSupplementNum(supplementEntities.size());
        //设置累计补充总金额
        BigDecimal allSupplementAmt = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty(supplementEntities)) {
            for (PurchaseContractEntity c : supplementEntities) {
                if (c.getContractTaxMny() != null) {
                    allSupplementAmt = c.getContractTaxMny().add(allSupplementAmt);
                }
            }
        }
        contractVO.setAllSupplementMny(allSupplementAmt);
        //设置补充金额比例
        contractVO.setSupplementMnyRate(BigDecimal.ZERO.compareTo(contractTaxMny) != 0 ? (allSupplementAmt.divide(contractTaxMny, 8, BigDecimal.ROUND_HALF_UP)).multiply(new BigDecimal(100)) : BigDecimal.ZERO);

        //判断能否新增补充协议
        if (SignatureStatusEnum.已签章.getCode().equals(contractEntity.getSignatureStatus())
                && (BillStateEnum.PASSED_STATE.getBillStateCode().equals(contractEntity.getBillState()) || BillStateEnum.COMMITED_STATE.getBillStateCode().equals(contractEntity.getBillState()))
                && (!(ContractPerformanceStateEnum.已作废.getStateCode().equals(contractEntity.getContractPerformanceState()) || ContractPerformanceStateEnum.已冻结.getStateCode().equals(contractEntity.getContractPerformanceState()) || ContractPerformanceStateEnum.已终止.getStateCode().equals(contractEntity.getContractPerformanceState())))) {
            contractVO.setEditFlag(this.addSupplementFlag(id));
        }
        return contractVO;
    }

    /**
     * 判断当前合同是否能新增补充协议
     *
     * @param id
     * @return
     */
    @Override
    public Boolean addSupplementFlag(Long id) {
        /*
            一个主合同仅有一个未生效得补充协议
            单据生效： 当单据审批通过，且签章状态为已签章
         */
        LambdaQueryWrapper<PurchaseContractEntity> lambda = new LambdaQueryWrapper<>();
        lambda.eq(PurchaseContractEntity::getMainContractId, id);
        lambda.eq(PurchaseContractEntity::getSupplementFlag, PurchaseContractVO.CONTRACT_TYPE_SUPPLEMENT);
        lambda.and(l -> l.ne(PurchaseContractEntity::getSignatureStatus, String.valueOf(SignatureStatusEnum.已签章.getCode())).or(c -> c.notIn(PurchaseContractEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode())).or(c -> c.eq(PurchaseContractEntity::getContractPerformanceState, String.valueOf(ContractPerformanceStateEnum.已作废.getStateCode()))));
        List<PurchaseContractEntity> supplementList = super.list(lambda);
        return supplementList.size() == 0;
    }

    /**
     * 新增或者修改补充协议
     *
     * @param contractVO
     * @return
     */
    @Override
    public PurchaseContractVO saveOrUpdateSupplement(PurchaseContractVO contractVO, Boolean isControl) {
        PurchaseContractEntity entity = null;
        // parentOrgCode如果是空的，则需要查询赋值
        if (StringUtils.isEmpty(contractVO.getParentOrgCode()) && contractVO.getParentOrgId() != null) {
            CommonResponse<OrgVO> orgResponse = iOrgApi.getOneById(contractVO.getParentOrgId());
            if (orgResponse.isSuccess()) {
                OrgVO orgVO = orgResponse.getData();
                contractVO.setParentOrgCode(orgVO.getCode());
            }
        }
        if (StringUtils.isNotBlank(contractVO.getBillCode()) && checkSameBillCode(contractVO)) {
            throw new BusinessException("编码重复，不允许保存!");
        }
        if (contractVO.getId() == null) {
            //新增补充协议
            //校验：补充协议只能存在一条未生效的
            QueryParam param = new QueryParam();
            param.getParams().put("main_contract_id", new Parameter("eq", contractVO.getMainContractId()));
            List<PurchaseContractEntity> supplementList = service.queryList(param, false);
            supplementList.stream().forEach(e -> {
                if (!(e.getSignatureStatus().equals(SignatureStatusEnum.已签章.getCode()) &&
                        (e.getBillState().equals(BillStateEnum.COMMITED_STATE.getBillStateCode())
                                || e.getBillState().equals(BillStateEnum.PASSED_STATE.getBillStateCode())))) {
                    //存在未生效的补充协议
                    throw new BusinessException("该合同已存在未生效的补充协议!");
                }
            });

            //设置补充协议编码
            String supplementNum = "";
            if (supplementList.size() < 9) {
                supplementNum += "0" + (supplementList.size() + 1);
            }
            else {
                supplementNum += (supplementList.size() + 1);
            }

            //主合同
            PurchaseContractEntity mainContract = service.selectById(contractVO.getMainContractId());
            if (null == mainContract) {
                throw new BusinessException("未找到主合同，不能创建补充协议！");
            }

            entity = BeanMapper.map(mainContract, PurchaseContractEntity.class);
            //清空基础字段
            clearBaseFields(entity);
            entity.setSignatureStatus(SignatureStatusEnum.未签章.getCode());
            entity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            entity.setBillCode(entity.getBillCode() + "-2-" + supplementNum);

            //基本信息
            entity.setContractName(contractVO.getContractName());
            entity.setSignDate(contractVO.getSignDate());
            entity.setContractPerformanceState(contractVO.getContractPerformanceState());
            entity.setDraftType(contractVO.getDraftType());
            entity.setTaxRate(contractVO.getTaxRate());
            entity.setFirstPartyEmployeeId(contractVO.getFirstPartyEmployeeId());
            entity.setFirstPartyEmployee(contractVO.getFirstPartyEmployee());
            entity.setContractCode(contractVO.getContractCode());

            //设置文件路径
            entity.setContractFilePath(contractVO.getContractFilePath());
            entity.setContractFileId(contractVO.getContractFileId());

            entity.setContractTemplateId(contractVO.getContractTemplateId());
            entity.setContractTemplateName(contractVO.getContractTemplateName());
            entity.setContractFileVersionId(contractVO.getContractFileVersionId());
            entity.setContractFileVersion(contractVO.getContractFileVersion());
            entity.setSupplementDescribe(contractVO.getSupplementDescribe());

            entity.setContractMny(contractVO.getContractMny() == null ? BigDecimal.ZERO : contractVO.getContractMny());
            entity.setContractTaxMny(contractVO.getContractTaxMny() == null ? BigDecimal.ZERO : contractVO.getContractTaxMny());
            entity.setContractTax(contractVO.getContractTax() == null ? BigDecimal.ZERO : contractVO.getContractTax());

            entity.setEquipmentTaxMny(contractVO.getEquipmentTaxMny() == null ? BigDecimal.ZERO : contractVO.getEquipmentTaxMny());
            entity.setEquipmentMny(contractVO.getEquipmentMny() == null ? BigDecimal.ZERO : contractVO.getEquipmentMny());
            entity.setEquipmentTax(contractVO.getEquipmentTax() == null ? BigDecimal.ZERO : contractVO.getEquipmentTax());

            entity.setOtherMny(contractVO.getOtherMny() == null ? BigDecimal.ZERO : contractVO.getOtherMny());
            entity.setOtherTaxMny(contractVO.getOtherTaxMny() == null ? BigDecimal.ZERO : contractVO.getOtherTaxMny());
            entity.setOtherTax(contractVO.getOtherTax() == null ? BigDecimal.ZERO : contractVO.getOtherTax());

            entity.setDetailList(BeanMapper.mapList(contractVO.getDetailList(), EquipmentDetailedEntity.class));
            entity.setOtherCostList(BeanMapper.mapList(contractVO.getOtherCostList(), OtherDetailedEntity.class));
            entity.setClauseList(BeanMapper.mapList(contractVO.getClauseList(), PurchaseContractClauseEntity.class));
            entity.setPaymentList(BeanMapper.mapList(contractVO.getPaymentList(), PurchaseContractPaymentClauseEntity.class));

            //初始化变更字段
            entity.setChangingMny(null);
            entity.setChangeCode(null);
            entity.setChangeVersion(null);
            entity.setChangeId(null);
            entity.setChangeStatus(ChangeStatusEnum.未变更.getCode());

            //补充协议状态
            entity.setSupplementFlag(PurchaseContractVO.CONTRACT_TYPE_SUPPLEMENT);
            entity.setMainContractId(contractVO.getMainContractId());
            entity.setMainContractCode(contractVO.getMainContractCode());
            entity.setMainContractName(contractVO.getMainContractName());
        }
        else {
            entity = BeanMapper.map(contractVO, PurchaseContractEntity.class);
        }

        //设置初始金额
        entity.setBaseMny(entity.getContractMny());
        entity.setBaseTaxMny(entity.getContractTaxMny());
        //设置变更前金额
        entity.setBeforeChangeMny(entity.getContractMny());
        entity.setBeforeChangeTaxMny(entity.getContractTaxMny());
        //设置关联的附件Ids
        entity.setAttachIds(contractVO.getAttachIds());
        if (FilingStatusEnum.已归档.getTypeCode().equals(entity.getFilingStatus())) {
            entity.setFilingRef(0);
        }


        //保存前清空主键和父主键，重新生成
//        resetPid(entity.getDetailList());
        // 校验其他单据
        this.checkContract(entity.getMainContractId(), entity.getId());
        if (!isControl) {
            service.saveOrUpdate(entity, false);
            //目标成本推送
            ExecutionVO executionVO = service.targetCost(BeanMapper.map(entity, PurchaseContractVO.class), BILL_TYPE, linkUrl);
            logger.info("目标成本推送数据" + JSON.toJSONString(executionVO));
            CommonResponse<String> response = executionApi.aggPush(executionVO);
            if (!response.isSuccess()) {
                throw new BusinessException("目标成本推送失败," + response.getMsg());
            }
            return queryDetail(entity.getId());
        }
        else {
            if (entity.getId() == null) {
                entity.setId(IdWorker.getId());
            }
            return BeanMapper.map(entity, PurchaseContractVO.class);
        }

    }

    /**
     * 重置单据基础字段
     *
     * @param entity
     */
    private void clearBaseFields(PurchaseContractEntity entity) {
        entity.setId(null);
        entity.setCreateTime(null);
        entity.setCreateUserCode(null);
        entity.setUpdateTime(null);
        entity.setUpdateUserCode(null);
        entity.setCommitDate(null);
        entity.setCommitUserCode(null);
        entity.setCommitDate(null);
        entity.setCommitUserName(null);
        entity.setEffectiveDate(null);
    }

    /**
     * 查询补充协议代入的主合同信息
     *
     * @param contractId
     * @return
     */
    @Override
    public PurchaseContractVO addConvertByConId(Long contractId) {
        PurchaseContractEntity contractVO = super.selectById(contractId);
        PurchaseContractVO supplementVO = new PurchaseContractVO();
        supplementVO.setMainContractName(contractVO.getContractName());
        supplementVO.setMainContractCode(contractVO.getBillCode());
        supplementVO.setMainContractId(contractId);
        supplementVO.setSupplementFlag(PurchaseContractVO.CONTRACT_TYPE_SUPPLEMENT);
        supplementVO.setContractCategoryId(contractVO.getContractCategoryId());

        supplementVO.setProjectName(contractVO.getProjectName());
        supplementVO.setProjectId(contractVO.getProjectId());
        supplementVO.setFirstPartyId(contractVO.getFirstPartyId());
        supplementVO.setFirstPartyName(contractVO.getFirstPartyName());
        supplementVO.setSupplierId(contractVO.getSupplierId());
        supplementVO.setSupplierName(contractVO.getSupplierName());
        supplementVO.setOrgId(contractVO.getOrgId());
        supplementVO.setOrgName(contractVO.getOrgName());
        supplementVO.setParentOrgId(contractVO.getParentOrgId());
        supplementVO.setParentOrgName(contractVO.getParentOrgName());
        supplementVO.setParentOrgCode(contractVO.getParentOrgCode());
        supplementVO.setDraftType(DraftTypeEnum.上传合同.getCode().toString());
        supplementVO.setContractName(contractVO.getContractName() + "补充协议");
        supplementVO.setFilingStatus(FilingStatusEnum.未归档.getTypeCode());


        return supplementVO;
    }

    /**
     * 计算合同列表需要字段
     *
     * @param param
     * @return
     */
    @Override
    public Map<String, Object> countContractAmount(QueryParam param) {
        Map<String, Object> resp = new HashMap<>();
        QueryWrapper wrapper = changeToQueryWrapper(param);
        wrapper.select("sum(base_tax_mny) as baseTaxMny, sum(contract_tax_mny) as contractTaxMny");
        resp = super.getMap(wrapper);
        if (null == resp) {
            resp = new HashMap<>();
            resp.put("baseTaxMny", 0);
            resp.put("contractTaxMny", 0);
        }
        return resp;

    }

    @Override
    public CommonResponse<String> deleteByIds(List<PurchaseContractVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            //目标成本推送
            List<TotalExecutionVO> totalExecutionVOList = new ArrayList<>();
            for (PurchaseContractVO contractVO : vos) {
                PurchaseContractEntity contractEntity = service.selectById(contractVO.getId());
                ExecutionVO executionVO = service.targetCost(BeanMapper.map(contractEntity, PurchaseContractVO.class), BILL_TYPE, linkUrl);
                totalExecutionVOList.add(executionVO.getTotalVO());
                logger.info("目标成本删除数据" + JSON.toJSONString(totalExecutionVOList));
                CommonResponse<String> response = executionApi.aggDel(totalExecutionVOList);
                if (!response.isSuccess()) {
                    throw new BusinessException("目标成本推送失败," + response.getMsg());
                }
            }
        }
        vos.forEach(contractVO -> {
            PurchaseContractEntity contractEntity = super.getById(contractVO.getId());
            if (null != contractEntity.getTargetResultId()) {
//                CommonResponse<String>  tender = tenderApi.updateById(contractEntity.getTargetResultId(), unOccupyState);
//                logger.info("定标结果占用状态修改为未占用状态信息：" + tender.getMsg());
                this.updateTargetResult(BeanMapper.map(contractEntity, PurchaseContractVO.class), 1);
            }
        });
        service.removeByIds(vos.stream().map(PurchaseContractVO::getId).collect(Collectors.toList()), false);
        return CommonResponse.success("删除成功！");
    }

    /**
     * 检查单据是否存在相同编码
     *
     * @param contractVO
     * @return
     */
    private Boolean checkSameBillCode(PurchaseContractVO contractVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        LambdaQueryWrapper<PurchaseContractEntity> lambda = new LambdaQueryWrapper<>();
        lambda.eq(PurchaseContractEntity::getBillCode, contractVO.getBillCode());
        lambda.eq(PurchaseContractEntity::getTenantId, tenantId);
        if (null != contractVO.getId() && contractVO.getId() > 0) {
            lambda.ne(PurchaseContractEntity::getId, contractVO.getId());
        }
        return super.list(lambda).size() > 0;
    }

    /**
     * 校验合同是否能做其他业务
     * 合同只能存在一个未生效的下游业务
     *
     * @param id      合同id
     * @param otherId 其他单据id
     */
    @Override
    public boolean checkContract(Long id, Long otherId) {
        List<Integer> billStateList = Arrays.asList(BillStateEnum.UNCOMMITED_STATE.getBillStateCode(),
                BillStateEnum.APPROVING_HAS_STATE.getBillStateCode(),
                BillStateEnum.UNAPPROVED.getBillStateCode(),
                BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode());
        // 校验补充协议
        // 存在非审批通过或非签章通过的补充协议，不允许做其他业务
//        queryParam.getParams().put("supplementFlag", new Parameter(QueryParam.EQ, 1));
        QueryParam supplementQueryParam = new QueryParam();
        supplementQueryParam.getParams().put("mainContractId", new Parameter(QueryParam.EQ, id));
        if (otherId != null) {
            supplementQueryParam.getParams().put("id", new Parameter(QueryParam.NE, otherId));
        }
        supplementQueryParam.getParams().put("signatureStatus", new Parameter(QueryParam.NE, SignatureStatusEnum.已签章.getCode()));
        List<PurchaseContractEntity> supplementContractList = super.queryList(supplementQueryParam, false);
        // 存在未生效的补充协议，则抛出异常
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(supplementContractList)) {
            throw new BusinessException("存在未生效的补充协议！");
        }

        // 校验变更合同
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter(QueryParam.EQ, id));
//        queryParam.getParams().put("billState", new Parameter(QueryParam.IN, billStateList));
        queryParam.getParams().put("signatureStatus", new Parameter(QueryParam.NE, SignatureStatusEnum.已签章.getCode()));
        // 做修改时，排除当前单据的id
        if (otherId != null) {
            queryParam.getParams().put("id", new Parameter(QueryParam.NE, otherId));
        }
        List<ChangePurchaseContractEntity> contractChangeEntityList = changeService.queryList(queryParam, false);
        // 存在未生效的变更合同，则抛出异常
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(contractChangeEntityList)) {
            throw new BusinessException("存在未生效的变更合同！");
        }

        // 查询合同解除
        List<PurchaseContractRelieveEntity> relieveEntityList = relieveService.queryList(queryParam, false);
        // 存在未生效的合同解除，则抛出异常
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(relieveEntityList)) {
            throw new BusinessException("存在未生效的合同解除单据！");
        }
        // 查询合同冻结、解冻
        // 清除签章条件
        queryParam.getParams().remove("signatureStatus");
        queryParam.getParams().put("billState", new Parameter(QueryParam.IN, billStateList));
        List<PurchaseContractFreezeEntity> freezeEntityList = freezeService.queryList(queryParam, false);
        // 存在未生效的合同冻结、解冻，则抛出异常
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(freezeEntityList)) {
            throw new BusinessException("存在未生效的合同冻结或合同解冻单据！");
        }
        return true;
    }

    @Override
    public ParamsCheckVO targetCostCtrl(PurchaseContractVO contractVO, String authority) {
        PurchaseContractVO contractVO1;
        if (contractVO.getSupplementFlag() != null && contractVO.getSupplementFlag() == 1) {
            contractVO1 = saveOrUpdateSupplement(contractVO, true);
        }
        else {
            contractVO1 = insertOrUpdate(contractVO, authority, true);
        }
        ExecutionVO executionVO = service.targetCost(BeanMapper.map(contractVO1, PurchaseContractVO.class), BILL_TYPE, linkUrl);
        logger.info("目标成本推送数据" + JSON.toJSONString(executionVO));
        logger.error("ss" + JSONObject.toJSONString(executionVO));
        CommonResponse<ParamsCheckVO> response = executionApi.ctrlCheckVO(executionVO);
//参数控制
        ParamsCheckVO paramsCheckVO = checkParams(contractVO, response.getData());
        return paramsCheckVO;
    }

    @Override
    public ParamsCheckVO viewTargetCostCtrlInfo(Long id) {
        PurchaseContractVO contractVO = queryDetail(id);
        ExecutionVO executionVO = service.targetCost(BeanMapper.map(contractVO, PurchaseContractVO.class), BILL_TYPE, linkUrl);
        logger.error("ss" + JSONObject.toJSONString(executionVO));
        CommonResponse<ParamsCheckVO> response = executionApi.ctrlCheckVO(executionVO);
        //参数控制
        ParamsCheckVO paramsCheckVO = checkParams(contractVO, response.getData());
        return paramsCheckVO;
    }

    @Override
    public CommonResponse<String> pushTargetCost(Long id) {
        QueryWrapper<ChangePurchaseContractEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("contract_id", id).eq("dr", 0).orderByDesc("create_time");
        List<ChangePurchaseContractEntity> list = changeService.list(wrapper);
        ExecutionVO executionVO;
        //判断是否有过变更
        if (list.size() > 0) {
            executionVO = service.targetCost(BeanMapper.map(list.get(0), PurchaseContractVO.class), CHANGE_BILL_TYPE, changeLinkUrl);
        }
        else {
            executionVO = service.targetCost(service.queryDetail(id), BILL_TYPE, linkUrl);
            logger.info("目标成本推送数据" + JSON.toJSONString(executionVO));
        }
        CommonResponse<String> response = executionApi.aggPush(executionVO);
        if (!response.isSuccess()) {
            throw new BusinessException("目标成本推送失败," + response.getMsg());
        }
        return CommonResponse.success("目标成本推送成功");
    }

    @Override
    public boolean delWatermarkContractFile(Long watermarkFileId) {
        Assert.notNull(watermarkFileId, "水印合同附件不能为空！");
        CommonResponse<String> res = attachmentApi.delete(String.valueOf(watermarkFileId));
        if (!res.isSuccess()) {
            logger.error("删除文件中心水印文件失败，原因：{}，水印文件id：{}", res.getMsg(), watermarkFileId);
            throw new BusinessException("删除文件中心水印文件失败，原因：" + res.getMsg() + "，水印文件id：" + watermarkFileId);
        }
        return true;
    }

    //单据参数控制
    @Override
    public ParamsCheckVO checkParams(PurchaseContractVO vo, ParamsCheckVO paramsCheckVO2) {
        List<ParamsCheckVO> paramsCheckVOS = new ArrayList<>();
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        /*添加参数控制区域---*/
        if (CollectionUtils.isNotEmpty(this.checkParamsConstruction(vo))) {
            paramsCheckVOS.addAll(this.checkParamsConstruction(vo));//施工合同控制
        }
        if (vo.getSupplementFlag() != null && Objects.equals(vo.getSupplementFlag(), PurchaseContractVO.CONTRACT_TYPE_SUPPLEMENT)) {
            paramsCheckVOS.addAll(this.checkParamsMnySup(vo));//合同金额控制补充协同金额
        }
        // 历史价控 合同价
        paramsCheckVOS.addAll(this.historyPriceCtrlContractPrice(vo));

        //目标成本价格库控制
        ParamsCheckVO costParams = this.costPriceCheckParams(vo);
        if(costParams!=null){
            paramsCheckVOS.add(costParams);
        }
        if (paramsCheckVO2 != null) {//组合成本参数
            paramsCheckVOS.add(paramsCheckVO2);
        }

        /*添加参数控制区域---*/
        Map<String, List<ParamsCheckDsVO>> map = new HashMap<>();
        String[] paramsArray = {"alert", "warn", "none"};
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(paramsCheckVOS)) {
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if (map.containsKey(warnType)) {
                    List<ParamsCheckDsVO> checkDsVOS = map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType, checkDsVOS);
                }
                else {
                    map.put(warnType, checkVO.getDataSource());
                }
            }
        }
        for (String s : paramsArray) {
            if (map.containsKey(s)) {
                paramsCheckVO.setWarnType(s);
                paramsCheckVO.setDataSource(map.get(s));
                if (org.apache.commons.collections.CollectionUtils.isEmpty(paramsCheckVO.getDataSource())) {
                    paramsCheckVO.setWarnType("none");
                }else {
                    return paramsCheckVO;
                }
            }
        }
        return paramsCheckVO;
    }
    public ParamsCheckVO costPriceCheckParams(PurchaseContractVO vo) {
       MaterialCostPriceApiVO materialPriceHistoryApiVO = new MaterialCostPriceApiVO();
        materialPriceHistoryApiVO.setPriceCheckType(MaterialCostPriceCheckTypeEnum.设备采购合同.getCode());
        ArrayList<MaterialCostPriceApiVO> materialPriceHistoryApiVOS = new ArrayList<>();
        if(CollectionUtil.isNotEmpty(vo.getDetailList())){
            for (EquipmentDetailedVO detailVO : vo.getDetailList()) {
                if(!"del".equals(detailVO.getRowState()) && detailVO.getDocId()!=null){
                    MaterialCostPriceApiVO priceHistoryApiVO = new MaterialCostPriceApiVO();
                    priceHistoryApiVO.setMaterialId(detailVO.getDocId());
                    priceHistoryApiVO.setMaterialName(detailVO.getEquipmentName());
                    priceHistoryApiVO.setSpec(detailVO.getSpec());
                    priceHistoryApiVO.setPrice(detailVO.getPurchasePrice());
                    priceHistoryApiVO.setTaxPrice(detailVO.getPurchasePricetNoTax());
                    materialPriceHistoryApiVOS.add(priceHistoryApiVO);
                }
            }
        }
        materialPriceHistoryApiVO.setOrgId(vo.getOrgId());
        materialPriceHistoryApiVO.setProjectId(vo.getProjectId());
        materialPriceHistoryApiVO.setMaterialCostPriceApiVOList(materialPriceHistoryApiVOS);
        ParamsCheckVO paramsCheckVO = this.costPriceParams(materialPriceHistoryApiVO);
        return  paramsCheckVO;
    }
    /**
     * 历史价控合同价
     * @param contractVO
     * @return
     */
    @Override
    public List<ParamsCheckVO> historyPriceCtrlContractPrice(PurchaseContractVO contractVO) {
        logger.info("proequipmentp---PurchaseContractServiceImpl---historyPriceCtrlContractPrice()--- 历史价控合同价入参：{}", JSONObject.toJSONString(contractVO));
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        List<ParamsCheckVO> paramsCheckVOList = new ArrayList<>();
//        // 分包价格库查询价格类型（云南建投不做处理，一建查询综合单价类型）
//        CommonResponse<ParamRegisterSetVO> response = paramConfigApi.getByCode(PRICE_LIB_CHECK_TYPE);
//        if (!response.isSuccess() || response.getData() == null) {
//            throw new BusinessException("获取分包价格库查询价格类型系统参数请求失败，失败原因：" + response.getMsg());
//        }
//        String valueData = response.getData().getValueData();
//        if (StringUtils.isNotBlank(valueData) && valueData.contains("全部")){
//            //全部不做校验
//            logger.info("获取分包价格库查询价格类型系统参数为全部，则不做价格库校验！");
//            return paramsCheckVOList;
//        }

        CommonResponse<List<BillParamVO>> maxParamByCode = new CommonResponse<>();
        CommonResponse<List<BillParamVO>> minParamByCode = new CommonResponse<>();
//        Integer contractType = contractVO.getContractType();// 合同类型： 劳务分包合同-0，专业分包合同-1
        List<EquipmentDetailedVO> detailList = contractVO.getDetailList();

//         劳务
//        if (0 == contractType) {
        maxParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(HISTORY_MAX_PRICE_CTRL_CON_PRICE, contractVO.getOrgId());
        minParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(HISTORY_MIN_PRICE_CTRL_CON_PRICE, contractVO.getOrgId());
//        }
//        // 专业
//        if (1 == contractType) {
//            maxParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(PRO_HISTORY_MAX_PRICE_CTRL_CON_PRICE, contractVO.getOrgId());
//            minParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(PRO_HISTORY_MIN_PRICE_CTRL_CON_PRICE, contractVO.getOrgId());
//        }



        if (!maxParamByCode.isSuccess() || null == maxParamByCode.getData()) {
            logger.info("查询价格库历史单价参数查询失败：{}", maxParamByCode.getMsg());
            return paramsCheckVOList;
        }
        if (!minParamByCode.isSuccess() || null == minParamByCode.getData()) {
            logger.info("查询价格库历史单价参数查询失败：{}", minParamByCode.getMsg());
            return paramsCheckVOList;
        }
        logger.info("单据控制参数查询结果：{}", JSONObject.toJSONString(maxParamByCode));


        List<BillParamVO> maxParamVOS = maxParamByCode.getData();//校验结果
        List<BillParamVO> minParamVOS = minParamByCode.getData();
        logger.info("设备购置合同历史高价控制信息返回："+JSONObject.toJSONString(maxParamVOS));
        logger.info("设备购置合同历史低价控制信息返回："+JSONObject.toJSONString(minParamVOS));
        if(CollectionUtils.isNotEmpty(maxParamVOS)){//遍历高价
            for (BillParamVO maxParamVO : maxParamVOS) {
                ParamsCheckVO paramsCheckVOMax = new ParamsCheckVO();//高价
                List<ParamsCheckDsVO> checkDsVOSMax = new ArrayList<>();
                BigDecimal roleValueMax = maxParamVO.getRoleValue();//高价校验比例
                paramsCheckVOMax.setWarnType(paramsArray[maxParamVO.getControlType()]);//高价赋值控制类型
                //控制方式为none时不需要控制
                if ("none".equals(paramsArray[maxParamVO.getControlType()])) {
                    continue;
                }
                for (EquipmentDetailedVO  detailVO: detailList) {//遍历明细
//                    //非综合单价的数据不进行校验
//                    if (null == detailVO.getDocPriceTypeName() || !"综合单价".equals(detailVO.getDocPriceTypeName())){
//                        continue;
//                    }
                    String getHistoryPriceArea = detailVO.getHistoryPriceArea();
                    if(getHistoryPriceArea!=null && !getHistoryPriceArea.isEmpty()){//历史区间不为空"-"
                        String[] split = getHistoryPriceArea.split("-");//截取高低价
                        BigDecimal maxPrice = new BigDecimal(split[1]);
                        BigDecimal minPrice =new BigDecimal(split[0]);
                        logger.info("分包清单：{}--高价：{}---低价：{}",detailVO.getEquipmentName() ,split[1], split[0]);
                        if(maxPrice.compareTo(minPrice)==0){//相等跳过循环
                            continue;
                        }
                        BigDecimal price = detailVO.getPurchasePrice()==null ? BigDecimal.ZERO : detailVO.getPurchasePrice().setScale(4, BigDecimal.ROUND_HALF_UP);//采购单价
                        BigDecimal maxPriceParam = ComputeUtil.safeDiv(ComputeUtil.safeMultiply(maxPrice, roleValueMax), new BigDecimal("100")).setScale(4, BigDecimal.ROUND_HALF_UP);
                        if (price.compareTo(maxPriceParam) >0) {
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                            paramsCheckDsVO.setOrgName(maxParamVO.getOrgName());
                            paramsCheckDsVO.setWarnItem(detailVO.getEquipmentName());
                            paramsCheckDsVO.setWarnName("采购单价大于历史最高价");
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("设备单价：").append(price)
                                    .append("，历史价格区间:(").append(getHistoryPriceArea)
                                    .append("),历史最高价*").append(roleValueMax).append("%:").append(maxPriceParam)
                                    .append("，超出最高价：").append(ComputeUtil.safeSub(price,maxPriceParam).setScale(4,BigDecimal.ROUND_HALF_UP));
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            checkDsVOSMax.add(paramsCheckDsVO);
                        }
                    }
                }
                paramsCheckVOMax.setDataSource(checkDsVOSMax);
                paramsCheckVOList.add(paramsCheckVOMax);
            }
        }
        if(CollectionUtils.isNotEmpty(minParamVOS)){//遍历低价
            for (BillParamVO minParamVO : minParamVOS) {
                ParamsCheckVO paramsCheckVOMin = new ParamsCheckVO();//低价
                List<ParamsCheckDsVO> checkDsVOSMin = new ArrayList<>();
                BigDecimal roleValueMin = minParamVO.getRoleValue();//低价校验比例
                paramsCheckVOMin.setWarnType(paramsArray[minParamVO.getControlType()]);//低价赋值控制类型
                //控制方式为none时不需要控制
                if ("none".equals(paramsArray[minParamVO.getControlType()])) {
                    continue;
                }
                for (EquipmentDetailedVO  detailVO: detailList) {//遍历明细
//                    //非综合单价的数据不进行校验
//                    if (null == detailVO.getDocPriceTypeName() || !"综合单价".equals(detailVO.getDocPriceTypeName())){
//                        continue;
//                    }
                    String getHistoryPriceArea = detailVO.getHistoryPriceArea();
                    if(getHistoryPriceArea!=null && !getHistoryPriceArea.isEmpty()){//历史区间不为空"-"
                        String[] split = getHistoryPriceArea.split("-");//截取高低价
                        BigDecimal maxPrice = new BigDecimal(split[1]);
                        BigDecimal minPrice =new BigDecimal(split[0]);
                        logger.info("分包清单：{}--高价：{}---低价：{}",detailVO.getEquipmentName() ,split[1], split[0]);
                        if(maxPrice.compareTo(minPrice)==0){//相等跳过循环
                            continue;
                        }
                        BigDecimal price = detailVO.getPurchasePrice()==null ? BigDecimal.ZERO : detailVO.getPurchasePrice().setScale(4, BigDecimal.ROUND_HALF_UP);//采购单价
                        BigDecimal minPriceParam = ComputeUtil.safeDiv(ComputeUtil.safeMultiply(minPrice, roleValueMin), new BigDecimal("100")).setScale(4, BigDecimal.ROUND_HALF_UP);
                        if (price.compareTo(minPriceParam) < 0) {
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                            paramsCheckDsVO.setOrgName(minParamVO.getOrgName());
                            paramsCheckDsVO.setWarnItem(detailVO.getEquipmentName());
                            paramsCheckDsVO.setWarnName("采购单价小于于历史最低价");
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("设备单价：").append(price)
                                    .append("，历史价格区间:(").append(getHistoryPriceArea)
                                    .append("),历史最低价*").append(roleValueMin).append("%:").append(minPriceParam)
                                    .append("，低于最低价：").append(ComputeUtil.safeSub(minPriceParam,price).setScale(4,BigDecimal.ROUND_HALF_UP));
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            checkDsVOSMin.add(paramsCheckDsVO);
                        }
                    }
                }
                paramsCheckVOMin.setDataSource(checkDsVOSMin);
                paramsCheckVOList.add(paramsCheckVOMin);
            }
        }

        return paramsCheckVOList;
    }

    @Override
    public ParamsCheckVO costPriceParams(MaterialCostPriceApiVO materialPriceHistoryApiVO) {
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        String[] paramsArray = {"none", "warn", "alert"};
        List<ParamsCheckVO> paramsCheckVOS = new ArrayList<>();
        List<MaterialCostPriceApiVO> detailList = materialPriceHistoryApiVO.getMaterialCostPriceApiVOList();
        Integer priceCheckType = materialPriceHistoryApiVO.getPriceCheckType();
        if(priceCheckType==null){
            logger.info("priceCheckType为空直接返回结果");
            return paramsCheckVO;
        }
        if(org.apache.commons.collections.CollectionUtils.isEmpty(detailList)){//传入集合为空直接返回结果
            logger.info("detailList为空直接返回结果");
            return paramsCheckVO;
        }
        List<Long> materialIds = detailList.stream().map(MaterialCostPriceApiVO::getMaterialId).collect(Collectors.toList());
        String MAX_CODE ="";
        String name  = MaterialCostPriceCheckTypeEnum.getEnumByCode(priceCheckType).getDescription();
        switch (priceCheckType){
            case 1:MAX_CODE= MaterialCostPriceCheckCodeEnum.设备采购合同.getCode();break;
            case 2:MAX_CODE= MaterialCostPriceCheckCodeEnum.设备采购结算单.getCode();break;
        }
        Long orgId = materialPriceHistoryApiVO.getOrgId();
        if(null==orgId){
            logger.info("orgId为空");
            return paramsCheckVO;
        }
        //查询比例
        CommonResponse<List<BillParamVO>> maxParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(MAX_CODE,orgId);
        if(!maxParamByCode.isSuccess() && null == maxParamByCode.getData()){
            logger.info(maxParamByCode.getMsg());
            return paramsCheckVO;
        }
        List<BillParamVO> maxParamVOS = maxParamByCode.getData();//校验结果
        logger.info(name+"价格控制信息返回："+JSONObject.toJSONString(maxParamVOS));
        //获取目标成本价格
        CommonResponse<Map<Long, BigDecimal>> dutyRes = dutyApi.queryPriceByDocIds(materialPriceHistoryApiVO.getProjectId(),DocTypeEnum.设备档案.getCode(),materialIds);
        if(null==dutyRes){
            logger.info("获取目标成本价格为空");
            return paramsCheckVO;
        }
        Map<Long, BigDecimal> dutyMap = dutyRes.getData();
        if(null==dutyMap){
            logger.info("获取目标成本价格map为空");
            return paramsCheckVO;
        }
        if(org.apache.commons.collections.CollectionUtils.isNotEmpty(maxParamVOS)){//遍历高价
            for (BillParamVO maxParamVO : maxParamVOS) {
                ParamsCheckVO paramsCheckVOCost = new ParamsCheckVO();//高价
                List<ParamsCheckDsVO> checkDsVOSMax = new ArrayList<>();
                BigDecimal roleValueMax = maxParamVO.getRoleValue();//高价校验比例
                paramsCheckVOCost.setWarnType(paramsArray[maxParamVO.getControlType()]);//高价赋值控制类型
                for (MaterialCostPriceApiVO  detailVO: detailList) {//遍历明细
                    BigDecimal maxPrice = dutyMap.get(detailVO.getMaterialId())==null?BigDecimal.ZERO:dutyMap.get(detailVO.getMaterialId()).setScale(4,BigDecimal.ROUND_HALF_UP);//获取目标成本价格
                    BigDecimal price = detailVO.getPrice()==null?BigDecimal.ZERO:detailVO.getPrice().setScale(4, BigDecimal.ROUND_HALF_UP);//物资单价
                    BigDecimal maxPriceParam = ComputeUtil.safeDiv(ComputeUtil.safeMultiply(maxPrice, roleValueMax), new BigDecimal("100")).setScale(4, BigDecimal.ROUND_HALF_UP);
                    if (price.compareTo(maxPriceParam) >0) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setOrgName(maxParamVO.getOrgName());
                        paramsCheckDsVO.setWarnItem(detailVO.getMaterialName()+(detailVO.getSpec()==null ? "" : "+"+detailVO.getSpec()));
                        paramsCheckDsVO.setWarnName(name+"单价大于目标成本单价");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append(name+"单价：").append(price)
                                .append("，目标成本单价:(").append(maxPrice)
                                .append("),目标成本单价*").append(roleValueMax).append("%:").append(maxPriceParam)
                                .append("，超出：").append(ComputeUtil.safeSub(price,maxPriceParam).setScale(4,BigDecimal.ROUND_HALF_UP));
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOSMax.add(paramsCheckDsVO);
                    }
                }
                paramsCheckVOCost.setDataSource(checkDsVOSMax);
                paramsCheckVOS.add(paramsCheckVOCost);
            }
        }
        /*添加参数控制区域---*/
        String[] paramsArr = {"alert", "warn", "none"};
        Map<String, List<ParamsCheckDsVO>> map = new HashMap<>();
        if(org.apache.commons.collections.CollectionUtils.isNotEmpty(paramsCheckVOS)){
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if(map.containsKey(warnType)){
                    List<ParamsCheckDsVO> checkDsVOS = map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType,checkDsVOS);
                }else {
                    map.put(warnType,checkVO.getDataSource());
                }
            }
        }
        for (String s : paramsArr) {
            if(map.containsKey(s)){
                paramsCheckVO.setWarnType(s);
                paramsCheckVO.setDataSource(map.get(s));
                if(org.apache.commons.collections.CollectionUtils.isEmpty(paramsCheckVO.getDataSource())){
                    paramsCheckVO.setWarnType("none");
                }else{
                    return paramsCheckVO;
                }
            }
        }
        return paramsCheckVO;
    }

    //施工合同参数控制
    @Override
    public List<ParamsCheckVO>  checkParamsConstruction(PurchaseContractVO vo) {
        CommonResponse<List<ParamsCheckVO>> response = paramCheckApi.paramsCheck(vo.getProjectId(), vo.getId(), vo.getEstimateAmortizeTotalMny(),vo.getOrgId());
        logger.info("施工合同控制信息返回："+JSONObject.toJSONString(response.getData()));
        if(!response.isSuccess()){
            throw new BusinessException("获取施工参数控制信息失败!"+response.getMsg());
        }
        return response.getData();
    }

    /**
     * 单据管控-补充协议金额大于合同金额
     *
     * @return
     */
    @Override
    public List<ParamsCheckVO> checkParamsMnySup(PurchaseContractVO vo) {
        BigDecimal contractTaxMnySup = vo.getContractTaxMny() == null ? BigDecimal.ZERO : vo.getContractTaxMny();//本次补充协议金额
        PurchaseContractEntity contractEntity = super.selectById(vo.getMainContractId());
        BigDecimal contractTaxMny = contractEntity.getContractTaxMny() == null ? BigDecimal.ZERO : contractEntity.getContractTaxMny();//初始合同金额
        BigDecimal totalSupMoney = contractTaxMnySup;//累计补充金额  默认赋值本次
        //查询累计补充金额
        QueryParam supplementQueryParam = new QueryParam();
        supplementQueryParam.getParams().put("mainContractId", new Parameter(QueryParam.EQ, vo.getMainContractId()));
        if (vo.getId() != null) {
            supplementQueryParam.getParams().put("id", new Parameter(QueryParam.NE, vo.getId()));
        }
        supplementQueryParam.getParams().put("mainContractId", new Parameter(QueryParam.EQ, vo.getMainContractId()));
        supplementQueryParam.getParams().put("signatureStatus", new Parameter(QueryParam.EQ, SignatureStatusEnum.已签章.getCode()));
        List<PurchaseContractEntity> supplementContractList = super.queryList(supplementQueryParam, false);
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(supplementContractList)) {
            for (PurchaseContractEntity entity : supplementContractList) {
                totalSupMoney = ComputeUtil.safeAdd(entity.getContractTaxMny(), totalSupMoney);//累加变更金额
            }
        }
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        List<ParamsCheckVO> paramsCheckVOList = new ArrayList<>();
//        CommonResponse<BillParamVO> billParamByCode = paramConfigApi.getBillParamByCode(CHECK_PARAM_CODE);
        CommonResponse<List<BillParamVO>> billParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(CHECK_PARAM_CODE,vo.getOrgId());
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            List<BillParamVO> data = billParamByCode.getData();
            logger.info("协议金额控制信息返回："+JSONObject.toJSONString(data));
            if(org.apache.commons.collections.CollectionUtils.isNotEmpty(data)){
                for (BillParamVO datum : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    List<ParamsCheckDsVO> checkDsVOS = new ArrayList<>();
                    BigDecimal roleValue = datum.getRoleValue();
                    BigDecimal comMny = ComputeUtil.safeDiv(ComputeUtil.safeMultiply(contractTaxMny, roleValue), new BigDecimal("100")).setScale(2, BigDecimal.ROUND_HALF_UP);
                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    if (totalSupMoney.compareTo(comMny) > 0) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setOrgName(datum.getOrgName());
                        paramsCheckDsVO.setWarnItem("补充协议超合同金额");
                        paramsCheckDsVO.setWarnName("累计补充协议金额大于合同金额");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("本次补充协议金额：").append(contractTaxMnySup.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("元，含本次补充协议金额：").append(totalSupMoney.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("元，合同金额*").append(roleValue).append("%:").append(comMny.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("元。超出金额：").append(ComputeUtil.safeSub(totalSupMoney, comMny).setScale(2, BigDecimal.ROUND_HALF_UP)).append("元");
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOList.add(paramsCheckVO);
                }
            }
        }
        else {
            logger.info(billParamByCode.getMsg());
            throw new BusinessException("获取控制参数失败");
        }
        return paramsCheckVOList;
    }

    @Override
    public void updateTargetResult(PurchaseContractVO vo, Integer type) {
        if (vo.getTargetResultId() == null) return;
        if (org.apache.commons.collections.CollectionUtils.isEmpty(vo.getDetailList())) return;
        TenderPicketageVO picketageVO = new TenderPicketageVO();
        picketageVO.setId(vo.getTargetResultId()); // 定标参照id
        picketageVO.setContractMoneyTax(vo.getContractTaxMny()); // 合同金额（含税）
        picketageVO.setContractMoney(vo.getContractMny()); // 合同金额
        List<TenderPicketageDetailVO> list = new ArrayList<>();
        for (EquipmentDetailedVO detailVO : vo.getDetailList()) {
            // 删除的不做占用处理
            if ("del".equals(detailVO.getRowState())) continue;
            TenderPicketageDetailVO tenderDetailVo = new TenderPicketageDetailVO();
            tenderDetailVo.setId(detailVO.getSourceId());
            tenderDetailVo.setSignNum(new BigDecimal(detailVO.getPurchaseNum().toString()));
            list.add(tenderDetailVo);
        }
        picketageVO.setTenderPicketageDetailList(list);
        CommonResponse<String> response;
        String typeStr = 0 == type ? "占用" : "释放";
        logger.info("{}定标结果请求参数：{}", typeStr, JSONObject.toJSONString(picketageVO));
        // 占用
        if (0 == type) {
            response = tenderApi.updateStatus(picketageVO);
        }
        // 释放
        else {
            response = tenderApi.delUpdateStatus(picketageVO);
        }
        logger.info("{}定标结果请求结果：{}", typeStr, JSONObject.toJSONString(response));
        if (!response.isSuccess()) {
            throw new BusinessException(typeStr + "定标结果失败！失败原因：" + response.getMsg());
        }
    }

    @Override
    public List<SignContractVo> queryContractByTargetResultId(List<String> targetResultIdList) {
        List<SignContractVo> rtnList = new ArrayList<>();
        if (org.apache.commons.collections.CollectionUtils.isEmpty(targetResultIdList)) return rtnList;
        logger.info("定标id"+JSONObject.toJSONString(targetResultIdList));
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("target_result_id", new Parameter(QueryParam.IN, targetResultIdList));
        queryParam.getOrderMap().put("sign_date", QueryParam.DESC);
        List<PurchaseContractEntity> entityList = super.queryList(queryParam, false);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(entityList)) return rtnList;
        for (PurchaseContractEntity entity : entityList) {
            SignContractVo vo = new SignContractVo();
            vo.setBillCode(entity.getBillCode());
            vo.setContractId(entity.getId());
            vo.setContractName(entity.getContractName());
            vo.setSupplierId(entity.getSupplierId());
            vo.setSupplierName(entity.getSupplierName());
            vo.setContractMny(entity.getContractMny());
            vo.setContractTaxMny(entity.getContractTaxMny());
            vo.setSignDate(entity.getSignDate());
            vo.setBillState(entity.getBillState());
            vo.setLinkUrl(linkUrl + entity.getId());
            rtnList.add(vo);
        }
        return rtnList;
    }
    /**
     * 校验明细数量
     *
     * @param detailList 需要校验明细
     * @param contractId 合同id
     */
    private void checkDetailTenderNum(List<EquipmentDetailedVO> detailList, Long contractId) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(detailList)) return;
        List<Long> sourceIdList = detailList.stream().map(EquipmentDetailedVO::getSourceId).collect(Collectors.toList());
        QueryParam detailParam = new QueryParam();
        detailParam.getParams().put("sourceId", new Parameter(QueryParam.IN, sourceIdList));
        if (contractId != null) {
            detailParam.getParams().put("contractId", new Parameter(QueryParam.NE, contractId));
        }
        List<EquipmentDetailedEntity> detailEntityList = contractDetailService.queryList(detailParam, false);
        // 没有查询出结果则不校验
        if (org.apache.commons.collections.CollectionUtils.isEmpty(detailEntityList)) return;
        Map<Long, List<EquipmentDetailedEntity>> queryMap = detailEntityList.stream()
                .collect(Collectors.groupingBy(EquipmentDetailedEntity::getSourceId));
        for (EquipmentDetailedVO detail : detailList) {
            List<EquipmentDetailedEntity> queryDetailList = queryMap.get(detail.getSourceId());
            BigDecimal tenderNum = CommonUtils.setBigDecimalDefaultValue(detail.getTenderNum());
            // 列表为空则说明改材料未签订过合同，跳过验证
            if (org.apache.commons.collections.CollectionUtils.isEmpty(queryDetailList)) continue;
            BigDecimal signTenderNum = BigDecimal.ZERO; // 已签订总数量
            for (EquipmentDetailedEntity detailEntity : queryDetailList) {
                signTenderNum = signTenderNum.add(CommonUtils.setBigDecimalDefaultValue(detailEntity.getInitNum()));
            }
            BigDecimal sy = tenderNum.subtract(signTenderNum); // 剩余总数量
            // 剩余数量小于列表传入的数量，则抛出异常
            if (sy.compareTo(new BigDecimal(detail.getPurchaseNum())) < 0) {
                throw new BusinessException(detail.getEquipmentName() + "采购数量不能超过" + sy);
            }
        }
    }

    /**
     * 获取合同归档控制参数  没有获取到参数默认不限制
     *
     * @return 合同归档控制参数(0：不限制，1：部分限制，2：全部限制)
     */
    @Override
    public String getContractFilingCode() {
        // 合同归档参数控制
        CommonResponse<ParamRegisterSetVO> response = paramConfigApi.getByCode(CONTRACT_FILING_CODE);
        logger.info("合同归档控制参数查询结果：{}", JSONObject.toJSONString(response));
        if (!response.isSuccess() || response.getData() == null) {
            throw new BusinessException("获取合同归档控制参数请求失败，失败原因：" + response.getMsg());
        }
        String valueData = response.getData().getValueData();
//        Assert.hasText(valueData, "获取的合同归档控制参数不能为空!");
        return com.baomidou.mybatisplus.core.toolkit.StringUtils.isNotEmpty(valueData) ? valueData : "0";
    }

    /**
     * 根据合同归档控制参数，校验合同能否新增变更、补充协议
     *
     * @param contractId 合同id
     * @return true：可以新增，false：不能新增
     */
    @Override
    public boolean checkContractFiling(Long contractId) {
        String valueData = this.getContractFilingCode();
        PurchaseContractEntity contractEntity = super.selectById(contractId);
        // 不限制
        if("0".equals(valueData)){
            return true;
        }
        // 部分限制、全部限制，合同未归档，都不能新增合同变更、补充协议
        else {
            return FilingStatusEnum.已归档.getTypeCode().equals(contractEntity.getFilingStatus());
        }
    }
    /**
     * 根据变更合同id给水印文件赋值
     *
     * @param id 变更合同id
     */
    @Override
    public void asyncWatermarkById(Long id) {
        PurchaseContractEntity contractEntity = super.selectById(id);
        // 水印系统参数
        CommonResponse<ParamRegisterSetVO> response = paramConfigApi.getByCode(WATERMARK_CHECK_PARAM_NAME);
        if (!response.isSuccess() || response.getData() == null) {
            throw new BusinessException("获取水印系统参数请求失败，失败原因：" + response.getMsg());
        }
        String valueData = response.getData().getValueData();
        org.springframework.util.Assert.hasText(valueData, "获取的水印系统参数不能为空!");

        // 是否限制： 0:不限制，1:限制
        if ("0".equals(valueData)) {
            String billType = BILL_TYPE;
            String sourceType = ContractTypeEnum.设备采购.getTypeCode() ;
            // 转换水印参数配置：默认规则
            WatermarkVO watermarkVO = signatureCommonApi.fetchWatermarkConfig(contractEntity.getContractFileId(), contractEntity.getId(),
                    contractEntity.getBillCode(), billType, sourceType);
            org.springframework.util.Assert.notNull(watermarkVO, "获取水印系统参数失败!");
            // 获取上下文并异步调用添加水印
            HttpServletRequest request = ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();
            HashMap<String, String> headers = new HashMap<>();
            headers.put("authority", request.getHeader("authority"));
            headers.put("ejc-token", request.getHeader("ejc-token"));
            contractAsyncService.fetchWatermarkAttachment(headers, watermarkVO);
        }
    }
}
