/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pricelib.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.pricelib.bean.PriceContractEntity;
import com.ejianc.business.pricelib.service.IPriceContractService;
import com.ejianc.business.pricelib.vo.PriceContractVO;
import com.ejianc.business.pricelib.vo.PriceLibVO;
import com.ejianc.business.pricelib.vo.PriceTrendVo;
import com.ejianc.business.utils.DateUtils;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.api.IPriceDepotParamSetApi;
import com.ejianc.foundation.share.consts.PrinceDepotEnum;
import com.ejianc.foundation.share.vo.dto.PriceDepotParamSetDTO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"priceContract"})
public class PriceContractController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private IPriceDepotParamSetApi priceDepotParamSetApi;
    @Autowired
    private IPriceContractService service;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<PriceContractVO> saveOrUpdate(@RequestBody PriceContractVO saveOrUpdateVO) {
        PriceContractEntity entity = (PriceContractEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, PriceContractEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        PriceContractVO vo = (PriceContractVO)BeanMapper.map((Object)((Object)entity), PriceContractVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<PriceContractVO> queryDetail(Long id) {
        PriceContractEntity entity = (PriceContractEntity)((Object)this.service.selectById(id));
        PriceContractVO vo = (PriceContractVO)BeanMapper.map((Object)((Object)entity), PriceContractVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PriceContractVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (PriceContractVO priceContractVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<PriceContractVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), PriceContractVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        HashMap<String, List> beans = new HashMap<String, List>();
        CommonResponse<IPage<PriceLibVO>> priceContractData = this.queryPriceList(param);
        if (priceContractData.isSuccess()) {
            beans.put("records", ((IPage)priceContractData.getData()).getRecords());
        }
        String exportFileName = "purchasePriceLib-export.xlsx";
        ExcelExport.getInstance().export(exportFileName, beans, response);
    }

    @RequestMapping(value={"/refPriceContractData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<PriceContractVO>> refPriceContractData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), PriceContractVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryPriceList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<PriceLibVO>> queryPriceList(@RequestBody QueryParam param) {
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", this.service.queryPriceLibListByTime(param));
    }

    @RequestMapping(value={"/queryPriceContractList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<PriceContractVO>> queryPriceContractList(@RequestBody QueryParam param) {
        return CommonResponse.success((String)"\u67e5\u8be2\u5408\u540c\u660e\u7ec6\u5217\u8868\u6570\u636e\u6210\u529f\uff01", this.service.queryPriceContractListDetail(param));
    }

    @RequestMapping(value={"/refPurchasePriceContractData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<PriceLibVO>> refPurchasePriceContractData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String relyCondition, String searchText, String condition, String searchObject) {
        JSONObject _con;
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        if (StringUtils.isNotEmpty((CharSequence)relyCondition)) {
            String innerCode = relyCondition.split("=")[1];
            param.getParams().put("docInnerCode", new Parameter("like", (Object)innerCode));
        }
        if (StringUtils.isNotEmpty((CharSequence)condition) && (_con = JSONObject.parseObject((String)condition)).containsKey((Object)"innerCode")) {
            param.getParams().put("docInnerCode", new Parameter("like_right", _con.get((Object)"innerCode")));
        }
        CommonResponse rsp = this.priceDepotParamSetApi.queryPriceDepotParamSetList(PrinceDepotEnum.\u8bbe\u5907\u91c7\u8d2d\u4ef7\u683c\u5e93.getCode());
        this.logger.info("\u67e5\u8be2\u4ef7\u683c\u5e93\u8bbe\u7f6e\uff0c\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)rsp));
        if (!rsp.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u4ef7\u683c\u5e93\u8bbe\u7f6e\u5931\u8d25\uff01" + rsp.getMsg());
        }
        BigDecimal cycle = ((PriceDepotParamSetDTO)((List)rsp.getData()).get(0)).getCycle();
        int c = cycle.intValue();
        Date endDate = DateUtils.formatDate(new Date(), "yyyy-MM-dd");
        Date startDate = DateUtils.formatDate(DateUtils.calculationMonth(endDate, -c), "yyyy-MM-dd");
        param.getParams().put("startDate", new Parameter("eq", (Object)DateUtils.transformationDefaultDate(startDate)));
        param.getParams().put("endDate", new Parameter("eq", (Object)DateUtils.transformationDefaultDate(endDate)));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", this.service.queryPriceLibListByTime(param));
    }

    @RequestMapping(value={"/refProPriceContractData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<PriceLibVO>> refProPriceContractData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String relyCondition, String searchText, String condition, String searchObject) {
        JSONObject _con;
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("contractType", new Parameter("eq", (Object)1));
        if (StringUtils.isNotEmpty((CharSequence)relyCondition)) {
            String innerCode = relyCondition.split("=")[1];
            param.getParams().put("docInnerCode", new Parameter("like_right", (Object)innerCode));
        }
        if (StringUtils.isNotEmpty((CharSequence)condition) && (_con = JSONObject.parseObject((String)condition)).containsKey((Object)"innerCode")) {
            param.getParams().put("docInnerCode", new Parameter("like_right", _con.get((Object)"innerCode")));
        }
        CommonResponse rsp = this.priceDepotParamSetApi.queryPriceDepotParamSetList(PrinceDepotEnum.\u8bbe\u5907\u91c7\u8d2d\u4ef7\u683c\u5e93.getCode());
        this.logger.info("\u67e5\u8be2\u4ef7\u683c\u5e93\u8bbe\u7f6e\uff0c\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)rsp));
        if (!rsp.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u4ef7\u683c\u5e93\u8bbe\u7f6e\u5931\u8d25\uff01" + rsp.getMsg());
        }
        BigDecimal cycle = ((PriceDepotParamSetDTO)((List)rsp.getData()).get(0)).getCycle();
        int c = cycle.intValue();
        Date endDate = DateUtils.formatDate(new Date(), "yyyy-MM-dd");
        Date startDate = DateUtils.formatDate(DateUtils.calculationMonth(endDate, -c), "yyyy-MM-dd");
        param.getParams().put("startDate", new Parameter("eq", (Object)DateUtils.transformationDefaultDate(startDate)));
        param.getParams().put("endDate", new Parameter("eq", (Object)DateUtils.transformationDefaultDate(endDate)));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", this.service.queryPriceLibListByTime(param));
    }

    @RequestMapping(value={"/initPriceContract"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> initPriceContract(HttpServletRequest request) {
        String param = request.getParameter("param");
        JSONArray json = JSONArray.parseArray((String)param);
        this.logger.info("\u83b7\u53d6\u5230\u7684\u53c2\u6570JSON\u662f\uff1a" + param + "----");
        this.service.savePriceContractByTiming(null);
        return CommonResponse.success((String)"\u521d\u59cb\u5316\u5904\u7406\u6210\u529f");
    }

    @RequestMapping(value={"/savePriceContractByTiming"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> savePriceContractByTiming(HttpServletRequest request) {
        String param = request.getParameter("param");
        JSONArray json = JSONArray.parseArray((String)param);
        this.logger.info("\u83b7\u53d6\u5230\u7684\u53c2\u6570JSON\u662f\uff1a" + param + "----");
        this.service.savePriceContractByTiming(new Date());
        return CommonResponse.success((String)"\u5b9a\u65f6\u4efb\u52a1\u5904\u7406\u6210\u529f");
    }

    @RequestMapping(value={"/queryPriceDetail"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<PriceLibVO> queryPriceDetail(@RequestBody QueryParam param) {
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)this.service.queryPriceLibDetail(param));
    }

    @RequestMapping(value={"/queryPriceTrendContractList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<PriceTrendVo>> queryPriceTrendContractList(@RequestBody QueryParam param) {
        return CommonResponse.success((String)"\u67e5\u8be2\u5408\u540c\u4ef7\u683c\u8d8b\u52bf\u56fe\u6570\u636e\uff01", this.service.queryPriceTrendContractList(param));
    }

    @RequestMapping(value={"/removePriceContractDetail"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> removePriceContractDetail(@RequestBody PriceContractVO vo) {
        this.service.removePriceContractDetail(vo.getId());
        return CommonResponse.success((String)"\u79fb\u9664\u6210\u529f");
    }
}

