/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.purchase.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.contractbase.api.ICommonSNAPI;
import com.ejianc.business.contractbase.api.IParamCheckApi;
import com.ejianc.business.contractbase.filing.enums.FilingStatusEnum;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.contractbase.pool.enums.ContractPerformanceStateEnum;
import com.ejianc.business.contractbase.pool.enums.ContractPropertyEnum;
import com.ejianc.business.contractbase.pool.enums.ContractTypeEnum;
import com.ejianc.business.contractbase.vo.CommonSNVO;
import com.ejianc.business.contractpub.util.BeanConvertorUtil;
import com.ejianc.business.purchase.bean.EquipmentDetailedEntity;
import com.ejianc.business.purchase.bean.OtherDetailedEntity;
import com.ejianc.business.purchase.bean.PurchaseContractClauseEntity;
import com.ejianc.business.purchase.bean.PurchaseContractEntity;
import com.ejianc.business.purchase.bean.PurchaseContractPaymentClauseEntity;
import com.ejianc.business.purchase.enums.ChangeStatusEnum;
import com.ejianc.business.purchase.enums.DraftTypeEnum;
import com.ejianc.business.purchase.enums.SignatureStatusEnum;
import com.ejianc.business.purchase.mapper.PurchaseContractMapper;
import com.ejianc.business.purchase.service.IChangePurchaseContractService;
import com.ejianc.business.purchase.service.IContractAsyncService;
import com.ejianc.business.purchase.service.IEquipmentDetailedService;
import com.ejianc.business.purchase.service.IPurchaseContractFreezeService;
import com.ejianc.business.purchase.service.IPurchaseContractRelieveService;
import com.ejianc.business.purchase.service.IPurchaseContractService;
import com.ejianc.business.purchase.vo.EquipmentDetailedVO;
import com.ejianc.business.purchase.vo.PurchaseContractVO;
import com.ejianc.business.signaturemanage.api.ISignatureCommonApi;
import com.ejianc.business.signaturemanage.vo.WatermarkVO;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.business.targetcost.enums.DocTypeEnum;
import com.ejianc.business.targetcost.vo.DetailExecutionVO;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.ParamsCheckDsVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.business.tender.api.ITenderEquipmentApi;
import com.ejianc.business.tender.common.vo.SignContractVo;
import com.ejianc.business.tender.common.vo.TenderPicketageDetailVO;
import com.ejianc.business.tender.common.vo.TenderPicketageVO;
import com.ejianc.business.utils.CommonUtils;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Service(value="purchaseContractService")
public class PurchaseContractServiceImpl
extends BaseServiceImpl<PurchaseContractMapper, PurchaseContractEntity>
implements IPurchaseContractService {
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IParamCheckApi paramCheckApi;
    @Autowired
    private ITenderEquipmentApi tenderApi;
    int unOccupyState = 0;
    int occupyState = 1;
    private static final String BILL_TYPE = "BT220323000000001";
    private static final String CHANGE_BILL_TYPE = "BT220323000000002";
    private static final String BILL_CODE = "PURCBASE_CONTRACT";
    private static final String WATERMARK_CHECK_PARAM_NAME = "P-00a9W886";
    private static final String BILL_CODE_YNJT = "PURCBASE_CONTRACT_YNJT01";
    private static final String GenerateSourceType = "SPCG10086";
    @Value(value="${contract.generateBillCodeType:common}")
    private String GenerateBillCodeType;
    @Autowired
    private ICommonSNAPI commonSNAPI;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IPurchaseContractService service;
    @Autowired
    private IEquipmentDetailedService contractDetailService;
    @Autowired
    private IChangePurchaseContractService changeService;
    @Autowired
    private IPurchaseContractRelieveService relieveService;
    @Autowired
    private IPurchaseContractFreezeService freezeService;
    @Autowired
    private IParamConfigApi paramConfigApi;
    private static final String CHECK_PARAM_CODE = "P-06vj8393";
    private static final String CONTRACT_FILING_CODE = "P-eg7rBO0134";
    private static final String CONTRACTION_CHECK_PARAM_CODE = "P-434f5499";
    @Value(value="${common.env.base-host}")
    private String BaseHost;
    @Autowired
    private IContractPoolApi contractPoolApi;
    @Autowired
    private IExecutionApi executionApi;
    @Autowired
    private IShareMaterialApi materialApi;
    @Autowired
    private IContractAsyncService contractAsyncService;
    @Autowired
    ISignatureCommonApi signatureCommonApi;
    @Autowired
    private IAttachmentApi attachmentApi;
    private static final String linkUrl = "/ejc-proequipmentp-frontend/#/machineryPurchaseContract/card?id=";
    private static final String changeLinkUrl = "ejc-proequipmentp-frontend/#/machineryPurchaseContract/contractChangeCard?id=";
    private final String HISTORY_MAX_PRICE_CTRL_CON_PRICE = "P-X74QbJ0193";
    private final String HISTORY_MIN_PRICE_CTRL_CON_PRICE = "P-A1NkyL0194";

    @Override
    public PurchaseContractVO insertOrUpdate(PurchaseContractVO contractVO, String authority, Boolean isControl) {
        PurchaseContractEntity contract;
        CommonResponse orgResponse;
        if (contractVO.getOrgId() != null && (StringUtils.isEmpty((CharSequence)contractVO.getOrgCode()) || StringUtils.isEmpty((CharSequence)contractVO.getParentOrgCode())) && (orgResponse = this.iOrgApi.getOneById(contractVO.getOrgId())).isSuccess()) {
            Object orgVO = (OrgVO)orgResponse.getData();
            contractVO.setOrgCode(orgVO.getCode());
            if (5 == orgVO.getOrgType()) {
                CommonResponse parentOrgResponse = this.iOrgApi.getOneById(orgVO.getParentId());
                if (parentOrgResponse.isSuccess()) {
                    OrgVO parentOrgVO = (OrgVO)parentOrgResponse.getData();
                    contractVO.setParentOrgId(parentOrgVO.getId());
                    contractVO.setParentOrgCode(parentOrgVO.getCode());
                    contractVO.setParentOrgName(parentOrgVO.getName());
                }
            } else {
                contractVO.setParentOrgId(contractVO.getOrgId());
                contractVO.setParentOrgCode(contractVO.getOrgCode());
                contractVO.setParentOrgName(contractVO.getOrgName());
            }
        }
        PurchaseContractEntity entity = (PurchaseContractEntity)((Object)BeanMapper.map((Object)contractVO, PurchaseContractEntity.class));
        if (!isControl.booleanValue()) {
            if (entity.getId() == null) {
                if (StringUtils.isBlank((CharSequence)entity.getBillCode())) {
                    switch (this.GenerateBillCodeType) {
                        case "common": {
                            CommonResponse billCode = this.billCodeApi.generateBillCode(BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)contractVO));
                            if (!billCode.isSuccess()) {
                                this.logger.error("\u4fdd\u5b58\u5408\u540c\u5931\u8d25\uff0c\u81ea\u52a8\u751f\u6210\u5408\u540c\u5408\u540c\u5931\u8d25: {}", (Object)billCode.getMsg());
                                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                            }
                            entity.setBillCode((String)billCode.getData());
                            break;
                        }
                        case "ynjt": {
                            CommonResponse billCodeFirstPart = this.billCodeApi.generateBillCode(BillCodeParam.build((String)BILL_CODE_YNJT, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)contractVO));
                            if (!billCodeFirstPart.isSuccess()) {
                                this.logger.error("\u4fdd\u5b58\u5408\u540c\u5931\u8d25\uff0c\u81ea\u52a8\u751f\u6210\u5408\u540c\u5408\u540c\u5931\u8d25: {}", (Object)billCodeFirstPart.getMsg());
                                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                            }
                            CommonSNVO commonSNVO = new CommonSNVO();
                            commonSNVO.setSnLength(Integer.valueOf(4));
                            commonSNVO.setTenantId(InvocationInfoProxy.getTenantid());
                            commonSNVO.setDimension(entity.getParentOrgCode().substring(entity.getParentOrgCode().length() - 3));
                            commonSNVO.setSourceType(this.GenerateBillCodeType);
                            CommonResponse snResp = this.commonSNAPI.getNext(commonSNVO);
                            if (!snResp.isSuccess()) {
                                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                            }
                            entity.setBillCode((String)billCodeFirstPart.getData() + entity.getParentOrgCode().substring(entity.getParentOrgCode().length() - 3) + (String)snResp.getData());
                        }
                    }
                } else if (this.checkSameBillCode((PurchaseContractVO)BeanMapper.map((Object)((Object)entity), PurchaseContractVO.class)).booleanValue()) {
                    throw new BusinessException("\u7f16\u7801\u91cd\u590d\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
                }
                if (entity.getId() == null) {
                    if (entity.getFilingStatus() == null) {
                        entity.setFilingStatus(FilingStatusEnum.\u672a\u5f52\u6863.getTypeCode());
                    }
                    entity.setFilingRef(0);
                }
                entity.setSignatureStatus(SignatureStatusEnum.\u672a\u7b7e\u7ae0.getCode());
                entity.setSupplementFlag(0);
                entity.setChangeStatus(ChangeStatusEnum.\u672a\u53d8\u66f4.getCode());
                entity.setMainContractCreateDate(new Date());
                this.updateTargetResult(contractVO, 0);
            } else {
                PurchaseContractEntity oldPurchaseContractEntity = (PurchaseContractEntity)((Object)super.selectById((Serializable)entity.getId()));
                if (null != entity.getTargetResultId()) {
                    this.updateTargetResult((PurchaseContractVO)BeanMapper.map((Object)((Object)oldPurchaseContractEntity), PurchaseContractVO.class), 1);
                    this.updateTargetResult(contractVO, 0);
                }
                if (StringUtils.isBlank((CharSequence)entity.getBillCode())) {
                    entity.setBillCode(oldPurchaseContractEntity.getBillCode());
                } else if (this.checkSameBillCode((PurchaseContractVO)BeanMapper.map((Object)((Object)entity), PurchaseContractVO.class)).booleanValue()) {
                    throw new BusinessException("\u7f16\u7801\u91cd\u590d\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
                }
            }
        }
        entity.setContractMny(contractVO.getContractMny() == null ? BigDecimal.ZERO : contractVO.getContractMny());
        entity.setContractTaxMny(contractVO.getContractTaxMny() == null ? BigDecimal.ZERO : contractVO.getContractTaxMny());
        entity.setContractTax(contractVO.getContractTax() == null ? BigDecimal.ZERO : contractVO.getContractTax());
        entity.setEquipmentTaxMny(contractVO.getEquipmentTaxMny() == null ? BigDecimal.ZERO : contractVO.getEquipmentTaxMny());
        entity.setEquipmentMny(contractVO.getEquipmentMny() == null ? BigDecimal.ZERO : contractVO.getEquipmentMny());
        entity.setEquipmentTax(contractVO.getEquipmentTax() == null ? BigDecimal.ZERO : contractVO.getEquipmentTax());
        entity.setOtherTaxMny(contractVO.getOtherTaxMny() == null ? BigDecimal.ZERO : contractVO.getOtherTaxMny());
        entity.setOtherMny(contractVO.getOtherMny() == null ? BigDecimal.ZERO : contractVO.getOtherMny());
        entity.setOtherTax(contractVO.getOtherTax() == null ? BigDecimal.ZERO : contractVO.getOtherTax());
        entity.setBaseMny(entity.getContractMny() == null ? BigDecimal.ZERO : entity.getContractMny());
        entity.setBaseTaxMny(entity.getContractTaxMny() == null ? BigDecimal.ZERO : entity.getContractTaxMny());
        entity.setBeforeChangeMny(entity.getContractMny() == null ? BigDecimal.ZERO : entity.getContractMny());
        entity.setBeforeChangeTaxMny(entity.getContractTaxMny() == null ? BigDecimal.ZERO : entity.getContractTaxMny());
        if (!(entity.getContractFileId() == null || (contract = (PurchaseContractEntity)((Object)this.service.getById(entity.getId()))) == null || contract.getContractCategoryId().equals(entity.getContractCategoryId()) && (DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349.getCode().toString().equals(contract.getDraftType()) || DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349\u4e0d\u4f7f\u7528\u7535\u5b50\u7b7e\u7ae0.getCode().toString().equals(contract.getDraftType())) || !DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349.getCode().toString().equals(entity.getDraftType()) && !DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349\u4e0d\u4f7f\u7528\u7535\u5b50\u7b7e\u7ae0.getCode().toString().equals(entity.getDraftType()))) {
            if (Boolean.FALSE.equals(isControl) && null != contract.getContractFileId()) {
                this.delContractFile(contract.getContractFileId(), authority);
            }
            entity.setContractFileId(null);
            entity.setContractFilePath(null);
        }
        if (DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349.getCode().toString().equals(entity.getDraftType()) || DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349\u4e0d\u4f7f\u7528\u7535\u5b50\u7b7e\u7ae0.getCode().toString().equals(entity.getDraftType())) {
            entity.setContractFileSyncFlag(false);
        }
        if (!isControl.booleanValue()) {
            super.saveOrUpdate((Object)entity, false);
            ExecutionVO executionVO = this.service.targetCost((PurchaseContractVO)BeanMapper.map((Object)((Object)entity), PurchaseContractVO.class), BILL_TYPE, linkUrl);
            this.logger.info("\u76ee\u6807\u6210\u672c\u63a8\u9001\u6570\u636e" + JSON.toJSONString((Object)executionVO));
            CommonResponse response = this.executionApi.aggPush(executionVO);
            if (!response.isSuccess()) {
                throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25," + response.getMsg());
            }
        }
        if (null == entity.getId() && isControl.booleanValue()) {
            entity.setId(IdWorker.getId());
            return (PurchaseContractVO)BeanMapper.map((Object)((Object)entity), PurchaseContractVO.class);
        }
        return this.queryDetail(entity.getId());
    }

    @Override
    public ExecutionVO targetCost(PurchaseContractVO contractVO, String BillType, String linkUrl) {
        List contractDetailList;
        ExecutionVO executionVO = new ExecutionVO();
        TotalExecutionVO totalVO = new TotalExecutionVO();
        ArrayList<DetailExecutionVO> detailList = new ArrayList<DetailExecutionVO>();
        totalVO.setSourceId(contractVO.getId());
        totalVO.setTenantId(contractVO.getTenantId());
        totalVO.setBillCode(contractVO.getBillCode());
        totalVO.setBillType(BillType);
        totalVO.setBussinessType(BussinessTypeEnum.\u8bbe\u5907\u91c7\u8d2d\u5408\u540c.getCode());
        totalVO.setBillCategory(BillCategoryEnum.\u5408\u540c.getCode());
        totalVO.setProjectId(contractVO.getProjectId());
        totalVO.setOrgId(contractVO.getOrgId());
        totalVO.setMoney(contractVO.getContractMny());
        totalVO.setTaxMoney(contractVO.getContractTaxMny());
        totalVO.setLinkUrl(this.BaseHost + linkUrl + contractVO.getId());
        if (BillType.equals(BILL_TYPE)) {
            contractDetailList = contractVO.getDetailList();
        } else {
            totalVO.setLastSourceId(contractVO.getMainContractId());
            contractDetailList = this.changeService.queryDetail(contractVO.getId()).getDetailList();
        }
        if (contractDetailList != null) {
            for (EquipmentDetailedVO planDetailVO : contractVO.getDetailList()) {
                if (planDetailVO.getRowState() != null && planDetailVO.getRowState().equals("del")) continue;
                DetailExecutionVO detailExecutionVO = new DetailExecutionVO();
                detailExecutionVO.setSourceId(Long.valueOf(planDetailVO.getId() == null ? IdWorker.getId() : planDetailVO.getId()));
                detailExecutionVO.setSourceBillId(contractVO.getId());
                detailExecutionVO.setCategoryId(planDetailVO.getDocCategoryId());
                detailExecutionVO.setCategoryName(planDetailVO.getEquipmentType());
                if (planDetailVO.getDocId() == null) {
                    detailExecutionVO.setCategoryFlag(Boolean.valueOf(true));
                    detailExecutionVO.setDocId(planDetailVO.getDocCategoryId());
                } else {
                    detailExecutionVO.setCategoryFlag(Boolean.valueOf(false));
                    detailExecutionVO.setDocId(planDetailVO.getDocId());
                }
                detailExecutionVO.setCode(planDetailVO.getEquipmentCode());
                detailExecutionVO.setCategoryContainFlag(Boolean.valueOf(false));
                MaterialCategoryVO categoryVO = (MaterialCategoryVO)this.materialApi.queryCategoryById(planDetailVO.getDocId()).getData();
                if (categoryVO == null) {
                    detailExecutionVO.setCategoryInnerCode(null);
                    detailExecutionVO.setCategoryCode(null);
                } else {
                    detailExecutionVO.setCategoryInnerCode(categoryVO.getInnerCode());
                    detailExecutionVO.setCategoryCode(categoryVO.getCode());
                }
                detailExecutionVO.setDocType(DocTypeEnum.\u8bbe\u5907\u6863\u6848.getCode());
                detailExecutionVO.setName(planDetailVO.getEquipmentName());
                detailExecutionVO.setUnitName(planDetailVO.getCompany());
                detailExecutionVO.setNum(BigDecimal.valueOf(planDetailVO.getPurchaseNum()));
                detailExecutionVO.setMoney(planDetailVO.getPurchaseAmountNoTax());
                detailExecutionVO.setSpec(planDetailVO.getSpec());
                detailExecutionVO.setTaxMoney(planDetailVO.getPurchaseAmount());
                detailExecutionVO.setPrice(planDetailVO.getPurchasePricetNoTax());
                detailExecutionVO.setTaxPrice(planDetailVO.getPurchasePrice());
                detailExecutionVO.setTaxRate(planDetailVO.getTaxRate());
                detailList.add(detailExecutionVO);
            }
        }
        executionVO.setTotalVO(totalVO);
        executionVO.setDetailList(detailList);
        return executionVO;
    }

    @Override
    public void pushContract(PurchaseContractVO contractVO) {
        ContractPoolVO data = new ContractPoolVO();
        try {
            BeanConvertorUtil.convert((Object)contractVO, (Object)data);
            data.setPcCardUrl(linkUrl + contractVO.getId());
            data.setSourceType(ContractTypeEnum.\u8bbe\u5907\u91c7\u8d2d.getTypeCode());
            data.setContractProperty(ContractPropertyEnum.\u652f\u51fa\u5408\u540c.getPropertyCode());
            this.logger.info("\u5f00\u59cb\u63a8\u9001\u5408\u540c\u6c60>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
            this.logger.info("\u63a8\u9001\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString((Object)data));
            CommonResponse transDataResp = this.contractPoolApi.saveOrUpdateContract(data);
            this.logger.info("\u63a8\u9001\u5408\u540c\u6c60\u7ed3\u675f\uff0c\u63a8\u9001\u7ed3\u679c\uff1a{}<<<<<<<<<<<<<<<<<<<<<<<<<<<<<", (Object)transDataResp.isSuccess());
            if (!transDataResp.isSuccess()) {
                this.logger.error("\u5408\u540cid-{}\u63a8\u9001\u5408\u540c\u6c60\u5931\u8d25\uff0c{}", (Object)contractVO.getId(), (Object)transDataResp.getMsg());
            }
        }
        catch (Exception e) {
            this.logger.error("\u5408\u540c-{}\u63a8\u9001\u5408\u540c\u6c60\u5931\u8d25\uff0c", (Object)contractVO.getId(), (Object)e);
        }
    }

    @Override
    public Boolean delContractFile(Long fileId, String authority) {
        HashMap<String, String> params = new HashMap<String, String>();
        HashMap<String, String> header = new HashMap<String, String>();
        params.put("ids", fileId.toString());
        header.put("authority", authority);
        String delRespStr = null;
        try {
            delRespStr = HttpTookit.get((String)(this.BaseHost + "ejc-file-web/attachment/delete"), params, header, (int)10000, (int)10000);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        CommonResponse delResp = (CommonResponse)JSONObject.parseObject(delRespStr, CommonResponse.class);
        if (delResp != null) {
            this.logger.info("\u5728\u7ebf\u8d77\u8349\uff0c\u5220\u9664\u4e0a\u4f20\u5408\u540c\u8fd4\u56de\u4fe1\u606f\uff1a" + delResp.getMsg());
        }
        return true;
    }

    private void resetPid(List<EquipmentDetailedEntity> detailList) {
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(detailList)) {
            HashMap<String, Long> idMap = new HashMap<String, Long>();
            for (EquipmentDetailedEntity cdEntity : detailList) {
                if (cdEntity.getId() == null) {
                    cdEntity.setId(IdWorker.getId());
                }
                idMap.put(cdEntity.getDocId().toString(), cdEntity.getId());
                cdEntity.setParentId(null);
            }
            for (EquipmentDetailedEntity cdEntity : detailList) {
                if (!StringUtils.isNotEmpty((CharSequence)cdEntity.getDocId().toString())) continue;
                cdEntity.setParentId((Long)idMap.get(cdEntity.getDocId()));
            }
        }
    }

    @Override
    public PurchaseContractVO queryDetail(Long id) {
        HashMap orderMap = new HashMap();
        LinkedHashMap orderParams = new LinkedHashMap();
        orderMap.put("detailList", orderParams);
        orderMap.put("otherCostList", orderParams);
        PurchaseContractEntity contractEntity = (PurchaseContractEntity)((Object)super.selectById((Serializable)id, orderMap));
        PurchaseContractVO contractVO = (PurchaseContractVO)BeanMapper.map((Object)((Object)contractEntity), PurchaseContractVO.class);
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)contractVO.getDetailList())) {
            contractVO.setDetailList(contractVO.getDetailList());
        }
        return contractVO;
    }

    @Override
    public PurchaseContractVO querySupplementRecord(Long id) {
        PurchaseContractEntity contractEntity = (PurchaseContractEntity)((Object)super.selectById((Serializable)id));
        PurchaseContractVO contractVO = new PurchaseContractVO();
        BigDecimal contractTaxMny = contractEntity.getContractTaxMny() == null ? BigDecimal.ZERO : contractEntity.getContractTaxMny();
        contractVO.setId(id);
        contractVO.setContractTaxMny(contractTaxMny);
        contractVO.setChangeStatus(contractEntity.getChangeStatus());
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"main_contract_id", (Object)id);
        query.eq((Object)"contract_performance_state", (Object)ContractPerformanceStateEnum.\u5c65\u7ea6\u4e2d.getStateCode());
        query.orderByDesc((Object)"create_time");
        List supplementEntities = super.list((Wrapper)query);
        contractVO.setSupplementList(BeanMapper.mapList((Iterable)supplementEntities, PurchaseContractVO.class));
        contractVO.setSupplementNum(Integer.valueOf(supplementEntities.size()));
        BigDecimal allSupplementAmt = BigDecimal.ZERO;
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)supplementEntities)) {
            for (PurchaseContractEntity c : supplementEntities) {
                if (c.getContractTaxMny() == null) continue;
                allSupplementAmt = c.getContractTaxMny().add(allSupplementAmt);
            }
        }
        contractVO.setAllSupplementMny(allSupplementAmt);
        contractVO.setSupplementMnyRate(BigDecimal.ZERO.compareTo(contractTaxMny) != 0 ? allSupplementAmt.divide(contractTaxMny, 8, 4).multiply(new BigDecimal(100)) : BigDecimal.ZERO);
        if (SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode().equals(contractEntity.getSignatureStatus()) && (BillStateEnum.PASSED_STATE.getBillStateCode().equals(contractEntity.getBillState()) || BillStateEnum.COMMITED_STATE.getBillStateCode().equals(contractEntity.getBillState())) && !ContractPerformanceStateEnum.\u5df2\u4f5c\u5e9f.getStateCode().equals(contractEntity.getContractPerformanceState()) && !ContractPerformanceStateEnum.\u5df2\u51bb\u7ed3.getStateCode().equals(contractEntity.getContractPerformanceState()) && !ContractPerformanceStateEnum.\u5df2\u7ec8\u6b62.getStateCode().equals(contractEntity.getContractPerformanceState())) {
            contractVO.setEditFlag(this.addSupplementFlag(id));
        }
        return contractVO;
    }

    @Override
    public Boolean addSupplementFlag(Long id) {
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.eq(PurchaseContractEntity::getMainContractId, (Object)id);
        lambda.eq(PurchaseContractEntity::getSupplementFlag, (Object)PurchaseContractVO.CONTRACT_TYPE_SUPPLEMENT);
        lambda.and(l -> (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)l.ne(PurchaseContractEntity::getSignatureStatus, (Object)String.valueOf(SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode()))).or(c -> (LambdaQueryWrapper)c.notIn(PurchaseContractEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()}))).or(c -> (LambdaQueryWrapper)c.eq(PurchaseContractEntity::getContractPerformanceState, (Object)String.valueOf(ContractPerformanceStateEnum.\u5df2\u4f5c\u5e9f.getStateCode()))));
        List supplementList = super.list((Wrapper)lambda);
        return supplementList.size() == 0;
    }

    @Override
    public PurchaseContractVO saveOrUpdateSupplement(PurchaseContractVO contractVO, Boolean isControl) {
        CommonResponse orgResponse;
        PurchaseContractEntity entity = null;
        if (StringUtils.isEmpty((CharSequence)contractVO.getParentOrgCode()) && contractVO.getParentOrgId() != null && (orgResponse = this.iOrgApi.getOneById(contractVO.getParentOrgId())).isSuccess()) {
            OrgVO orgVO = (OrgVO)orgResponse.getData();
            contractVO.setParentOrgCode(orgVO.getCode());
        }
        if (StringUtils.isNotBlank((CharSequence)contractVO.getBillCode()) && this.checkSameBillCode(contractVO).booleanValue()) {
            throw new BusinessException("\u7f16\u7801\u91cd\u590d\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
        }
        if (contractVO.getId() == null) {
            QueryParam param = new QueryParam();
            param.getParams().put("main_contract_id", new Parameter("eq", (Object)contractVO.getMainContractId()));
            List supplementList = this.service.queryList(param, false);
            supplementList.stream().forEach(e -> {
                if (!e.getSignatureStatus().equals(SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode()) || !e.getBillState().equals(BillStateEnum.COMMITED_STATE.getBillStateCode()) && !e.getBillState().equals(BillStateEnum.PASSED_STATE.getBillStateCode())) {
                    throw new BusinessException("\u8be5\u5408\u540c\u5df2\u5b58\u5728\u672a\u751f\u6548\u7684\u8865\u5145\u534f\u8bae!");
                }
            });
            String supplementNum = "";
            supplementNum = supplementList.size() < 9 ? supplementNum + "0" + (supplementList.size() + 1) : supplementNum + (supplementList.size() + 1);
            PurchaseContractEntity mainContract = (PurchaseContractEntity)((Object)this.service.selectById(contractVO.getMainContractId()));
            if (null == mainContract) {
                throw new BusinessException("\u672a\u627e\u5230\u4e3b\u5408\u540c\uff0c\u4e0d\u80fd\u521b\u5efa\u8865\u5145\u534f\u8bae\uff01");
            }
            entity = (PurchaseContractEntity)((Object)BeanMapper.map((Object)((Object)mainContract), PurchaseContractEntity.class));
            this.clearBaseFields(entity);
            entity.setSignatureStatus(SignatureStatusEnum.\u672a\u7b7e\u7ae0.getCode());
            entity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            entity.setBillCode(entity.getBillCode() + "-2-" + supplementNum);
            entity.setContractName(contractVO.getContractName());
            entity.setSignDate(contractVO.getSignDate());
            entity.setContractPerformanceState(contractVO.getContractPerformanceState());
            entity.setDraftType(contractVO.getDraftType());
            entity.setTaxRate(contractVO.getTaxRate());
            entity.setFirstPartyEmployeeId(contractVO.getFirstPartyEmployeeId());
            entity.setFirstPartyEmployee(contractVO.getFirstPartyEmployee());
            entity.setContractCode(contractVO.getContractCode());
            entity.setContractFilePath(contractVO.getContractFilePath());
            entity.setContractFileId(contractVO.getContractFileId());
            entity.setContractTemplateId(contractVO.getContractTemplateId());
            entity.setContractTemplateName(contractVO.getContractTemplateName());
            entity.setContractFileVersionId(contractVO.getContractFileVersionId());
            entity.setContractFileVersion(contractVO.getContractFileVersion());
            entity.setSupplementDescribe(contractVO.getSupplementDescribe());
            entity.setContractMny(contractVO.getContractMny() == null ? BigDecimal.ZERO : contractVO.getContractMny());
            entity.setContractTaxMny(contractVO.getContractTaxMny() == null ? BigDecimal.ZERO : contractVO.getContractTaxMny());
            entity.setContractTax(contractVO.getContractTax() == null ? BigDecimal.ZERO : contractVO.getContractTax());
            entity.setEquipmentTaxMny(contractVO.getEquipmentTaxMny() == null ? BigDecimal.ZERO : contractVO.getEquipmentTaxMny());
            entity.setEquipmentMny(contractVO.getEquipmentMny() == null ? BigDecimal.ZERO : contractVO.getEquipmentMny());
            entity.setEquipmentTax(contractVO.getEquipmentTax() == null ? BigDecimal.ZERO : contractVO.getEquipmentTax());
            entity.setOtherMny(contractVO.getOtherMny() == null ? BigDecimal.ZERO : contractVO.getOtherMny());
            entity.setOtherTaxMny(contractVO.getOtherTaxMny() == null ? BigDecimal.ZERO : contractVO.getOtherTaxMny());
            entity.setOtherTax(contractVO.getOtherTax() == null ? BigDecimal.ZERO : contractVO.getOtherTax());
            entity.setDetailList(BeanMapper.mapList((Iterable)contractVO.getDetailList(), EquipmentDetailedEntity.class));
            entity.setOtherCostList(BeanMapper.mapList((Iterable)contractVO.getOtherCostList(), OtherDetailedEntity.class));
            entity.setClauseList(BeanMapper.mapList((Iterable)contractVO.getClauseList(), PurchaseContractClauseEntity.class));
            entity.setPaymentList(BeanMapper.mapList((Iterable)contractVO.getPaymentList(), PurchaseContractPaymentClauseEntity.class));
            entity.setChangingMny(null);
            entity.setChangeCode(null);
            entity.setChangeVersion(null);
            entity.setChangeId(null);
            entity.setChangeStatus(ChangeStatusEnum.\u672a\u53d8\u66f4.getCode());
            entity.setSupplementFlag(PurchaseContractVO.CONTRACT_TYPE_SUPPLEMENT);
            entity.setMainContractId(contractVO.getMainContractId());
            entity.setMainContractCode(contractVO.getMainContractCode());
            entity.setMainContractName(contractVO.getMainContractName());
        } else {
            entity = (PurchaseContractEntity)((Object)BeanMapper.map((Object)contractVO, PurchaseContractEntity.class));
        }
        entity.setBaseMny(entity.getContractMny());
        entity.setBaseTaxMny(entity.getContractTaxMny());
        entity.setBeforeChangeMny(entity.getContractMny());
        entity.setBeforeChangeTaxMny(entity.getContractTaxMny());
        entity.setAttachIds(contractVO.getAttachIds());
        if (FilingStatusEnum.\u5df2\u5f52\u6863.getTypeCode().equals(entity.getFilingStatus())) {
            entity.setFilingRef(0);
        }
        this.checkContract(entity.getMainContractId(), entity.getId());
        if (!isControl.booleanValue()) {
            this.service.saveOrUpdate((Object)entity, false);
            ExecutionVO executionVO = this.service.targetCost((PurchaseContractVO)BeanMapper.map((Object)((Object)entity), PurchaseContractVO.class), BILL_TYPE, linkUrl);
            this.logger.info("\u76ee\u6807\u6210\u672c\u63a8\u9001\u6570\u636e" + JSON.toJSONString((Object)executionVO));
            CommonResponse response = this.executionApi.aggPush(executionVO);
            if (!response.isSuccess()) {
                throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25," + response.getMsg());
            }
            return this.queryDetail(entity.getId());
        }
        if (entity.getId() == null) {
            entity.setId(IdWorker.getId());
        }
        return (PurchaseContractVO)BeanMapper.map((Object)((Object)entity), PurchaseContractVO.class);
    }

    private void clearBaseFields(PurchaseContractEntity entity) {
        entity.setId(null);
        entity.setCreateTime(null);
        entity.setCreateUserCode(null);
        entity.setUpdateTime(null);
        entity.setUpdateUserCode(null);
        entity.setCommitDate(null);
        entity.setCommitUserCode(null);
        entity.setCommitDate(null);
        entity.setCommitUserName(null);
        entity.setEffectiveDate(null);
    }

    @Override
    public PurchaseContractVO addConvertByConId(Long contractId) {
        PurchaseContractEntity contractVO = (PurchaseContractEntity)((Object)super.selectById((Serializable)contractId));
        PurchaseContractVO supplementVO = new PurchaseContractVO();
        supplementVO.setMainContractName(contractVO.getContractName());
        supplementVO.setMainContractCode(contractVO.getBillCode());
        supplementVO.setMainContractId(contractId);
        supplementVO.setSupplementFlag(PurchaseContractVO.CONTRACT_TYPE_SUPPLEMENT);
        supplementVO.setContractCategoryId(contractVO.getContractCategoryId());
        supplementVO.setProjectName(contractVO.getProjectName());
        supplementVO.setProjectId(contractVO.getProjectId());
        supplementVO.setFirstPartyId(contractVO.getFirstPartyId());
        supplementVO.setFirstPartyName(contractVO.getFirstPartyName());
        supplementVO.setSupplierId(contractVO.getSupplierId());
        supplementVO.setSupplierName(contractVO.getSupplierName());
        supplementVO.setOrgId(contractVO.getOrgId());
        supplementVO.setOrgName(contractVO.getOrgName());
        supplementVO.setParentOrgId(contractVO.getParentOrgId());
        supplementVO.setParentOrgName(contractVO.getParentOrgName());
        supplementVO.setParentOrgCode(contractVO.getParentOrgCode());
        supplementVO.setDraftType(DraftTypeEnum.\u4e0a\u4f20\u5408\u540c.getCode().toString());
        supplementVO.setContractName(contractVO.getContractName() + "\u8865\u5145\u534f\u8bae");
        supplementVO.setFilingStatus(FilingStatusEnum.\u672a\u5f52\u6863.getTypeCode());
        return supplementVO;
    }

    @Override
    public Map<String, Object> countContractAmount(QueryParam param) {
        Map<String, Integer> resp = new HashMap();
        QueryWrapper wrapper = PurchaseContractServiceImpl.changeToQueryWrapper((QueryParam)param);
        wrapper.select(new String[]{"sum(base_tax_mny) as baseTaxMny, sum(contract_tax_mny) as contractTaxMny"});
        resp = super.getMap((Wrapper)wrapper);
        if (null == resp) {
            resp = new HashMap();
            resp.put("baseTaxMny", 0);
            resp.put("contractTaxMny", 0);
        }
        return resp;
    }

    @Override
    public CommonResponse<String> deleteByIds(List<PurchaseContractVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            ArrayList<TotalExecutionVO> totalExecutionVOList = new ArrayList<TotalExecutionVO>();
            for (PurchaseContractVO contractVO2 : vos) {
                PurchaseContractEntity contractEntity = (PurchaseContractEntity)((Object)this.service.selectById(contractVO2.getId()));
                ExecutionVO executionVO = this.service.targetCost((PurchaseContractVO)BeanMapper.map((Object)((Object)contractEntity), PurchaseContractVO.class), BILL_TYPE, linkUrl);
                totalExecutionVOList.add(executionVO.getTotalVO());
                this.logger.info("\u76ee\u6807\u6210\u672c\u5220\u9664\u6570\u636e" + JSON.toJSONString(totalExecutionVOList));
                CommonResponse response = this.executionApi.aggDel(totalExecutionVOList);
                if (response.isSuccess()) continue;
                throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25," + response.getMsg());
            }
        }
        vos.forEach(contractVO -> {
            PurchaseContractEntity contractEntity = (PurchaseContractEntity)((Object)((Object)super.getById((Serializable)contractVO.getId())));
            if (null != contractEntity.getTargetResultId()) {
                this.updateTargetResult((PurchaseContractVO)BeanMapper.map((Object)((Object)contractEntity), PurchaseContractVO.class), 1);
            }
        });
        this.service.removeByIds(vos.stream().map(PurchaseContractVO::getId).collect(Collectors.toList()), false);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    private Boolean checkSameBillCode(PurchaseContractVO contractVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.eq(PurchaseContractEntity::getBillCode, (Object)contractVO.getBillCode());
        lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
        if (null != contractVO.getId() && contractVO.getId() > 0L) {
            lambda.ne(BaseEntity::getId, (Object)contractVO.getId());
        }
        return super.list((Wrapper)lambda).size() > 0;
    }

    @Override
    public boolean checkContract(Long id, Long otherId) {
        List contractChangeEntityList;
        List<Integer> billStateList = Arrays.asList(BillStateEnum.UNCOMMITED_STATE.getBillStateCode(), BillStateEnum.APPROVING_HAS_STATE.getBillStateCode(), BillStateEnum.UNAPPROVED.getBillStateCode(), BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode());
        QueryParam supplementQueryParam = new QueryParam();
        supplementQueryParam.getParams().put("mainContractId", new Parameter("eq", (Object)id));
        if (otherId != null) {
            supplementQueryParam.getParams().put("id", new Parameter("ne", (Object)otherId));
        }
        supplementQueryParam.getParams().put("signatureStatus", new Parameter("ne", (Object)SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode()));
        List supplementContractList = super.queryList(supplementQueryParam, false);
        if (CollectionUtils.isNotEmpty((Collection)supplementContractList)) {
            throw new BusinessException("\u5b58\u5728\u672a\u751f\u6548\u7684\u8865\u5145\u534f\u8bae\uff01");
        }
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter("eq", (Object)id));
        queryParam.getParams().put("signatureStatus", new Parameter("ne", (Object)SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode()));
        if (otherId != null) {
            queryParam.getParams().put("id", new Parameter("ne", (Object)otherId));
        }
        if (CollectionUtils.isNotEmpty((Collection)(contractChangeEntityList = this.changeService.queryList(queryParam, false)))) {
            throw new BusinessException("\u5b58\u5728\u672a\u751f\u6548\u7684\u53d8\u66f4\u5408\u540c\uff01");
        }
        List relieveEntityList = this.relieveService.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty((Collection)relieveEntityList)) {
            throw new BusinessException("\u5b58\u5728\u672a\u751f\u6548\u7684\u5408\u540c\u89e3\u9664\u5355\u636e\uff01");
        }
        queryParam.getParams().remove("signatureStatus");
        queryParam.getParams().put("billState", new Parameter("in", billStateList));
        List freezeEntityList = this.freezeService.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty((Collection)freezeEntityList)) {
            throw new BusinessException("\u5b58\u5728\u672a\u751f\u6548\u7684\u5408\u540c\u51bb\u7ed3\u6216\u5408\u540c\u89e3\u51bb\u5355\u636e\uff01");
        }
        return true;
    }

    @Override
    public ParamsCheckVO targetCostCtrl(PurchaseContractVO contractVO, String authority) {
        PurchaseContractVO contractVO1 = contractVO.getSupplementFlag() != null && contractVO.getSupplementFlag() == 1 ? this.saveOrUpdateSupplement(contractVO, true) : this.insertOrUpdate(contractVO, authority, true);
        ExecutionVO executionVO = this.service.targetCost((PurchaseContractVO)BeanMapper.map((Object)contractVO1, PurchaseContractVO.class), BILL_TYPE, linkUrl);
        this.logger.info("\u76ee\u6807\u6210\u672c\u63a8\u9001\u6570\u636e" + JSON.toJSONString((Object)executionVO));
        this.logger.error("ss" + JSONObject.toJSONString((Object)executionVO));
        CommonResponse response = this.executionApi.ctrlCheckVO(executionVO);
        ParamsCheckVO paramsCheckVO = this.checkParams(contractVO, (ParamsCheckVO)response.getData());
        return paramsCheckVO;
    }

    @Override
    public ParamsCheckVO viewTargetCostCtrlInfo(Long id) {
        PurchaseContractVO contractVO = this.queryDetail(id);
        ExecutionVO executionVO = this.service.targetCost((PurchaseContractVO)BeanMapper.map((Object)contractVO, PurchaseContractVO.class), BILL_TYPE, linkUrl);
        this.logger.error("ss" + JSONObject.toJSONString((Object)executionVO));
        CommonResponse response = this.executionApi.ctrlCheckVO(executionVO);
        ParamsCheckVO paramsCheckVO = this.checkParams(contractVO, (ParamsCheckVO)response.getData());
        return paramsCheckVO;
    }

    @Override
    public CommonResponse<String> pushTargetCost(Long id) {
        ExecutionVO executionVO;
        QueryWrapper wrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)wrapper.eq((Object)"contract_id", (Object)id)).eq((Object)"dr", (Object)0)).orderByDesc((Object)"create_time");
        List list = this.changeService.list((Wrapper)wrapper);
        if (list.size() > 0) {
            executionVO = this.service.targetCost((PurchaseContractVO)BeanMapper.map(list.get(0), PurchaseContractVO.class), CHANGE_BILL_TYPE, changeLinkUrl);
        } else {
            executionVO = this.service.targetCost(this.service.queryDetail(id), BILL_TYPE, linkUrl);
            this.logger.info("\u76ee\u6807\u6210\u672c\u63a8\u9001\u6570\u636e" + JSON.toJSONString((Object)executionVO));
        }
        CommonResponse response = this.executionApi.aggPush(executionVO);
        if (!response.isSuccess()) {
            throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25," + response.getMsg());
        }
        return CommonResponse.success((String)"\u76ee\u6807\u6210\u672c\u63a8\u9001\u6210\u529f");
    }

    @Override
    public boolean delWatermarkContractFile(Long watermarkFileId) {
        com.baomidou.mybatisplus.core.toolkit.Assert.notNull((Object)watermarkFileId, (String)"\u6c34\u5370\u5408\u540c\u9644\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        CommonResponse res = this.attachmentApi.delete(String.valueOf(watermarkFileId));
        if (!res.isSuccess()) {
            this.logger.error("\u5220\u9664\u6587\u4ef6\u4e2d\u5fc3\u6c34\u5370\u6587\u4ef6\u5931\u8d25\uff0c\u539f\u56e0\uff1a{}\uff0c\u6c34\u5370\u6587\u4ef6id\uff1a{}", (Object)res.getMsg(), (Object)watermarkFileId);
            throw new BusinessException("\u5220\u9664\u6587\u4ef6\u4e2d\u5fc3\u6c34\u5370\u6587\u4ef6\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + res.getMsg() + "\uff0c\u6c34\u5370\u6587\u4ef6id\uff1a" + watermarkFileId);
        }
        return true;
    }

    @Override
    public ParamsCheckVO checkParams(PurchaseContractVO vo, ParamsCheckVO paramsCheckVO2) {
        ArrayList<ParamsCheckVO> paramsCheckVOS = new ArrayList<ParamsCheckVO>();
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        paramsCheckVOS.addAll(this.checkParamsConstruction(vo));
        if (vo.getSupplementFlag() != null && Objects.equals(vo.getSupplementFlag(), PurchaseContractVO.CONTRACT_TYPE_SUPPLEMENT)) {
            paramsCheckVOS.addAll(this.checkParamsMnySup(vo));
        }
        paramsCheckVOS.addAll(this.historyPriceCtrlContractPrice(vo));
        if (paramsCheckVO2 != null) {
            paramsCheckVOS.add(paramsCheckVO2);
        }
        HashMap<String, List> map = new HashMap<String, List>();
        String[] paramsArray = new String[]{"alert", "warn", "none"};
        if (CollectionUtils.isNotEmpty(paramsCheckVOS)) {
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if (map.containsKey(warnType)) {
                    List checkDsVOS = (List)map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType, checkDsVOS);
                    continue;
                }
                map.put(warnType, checkVO.getDataSource());
            }
        }
        for (String s : paramsArray) {
            if (!map.containsKey(s)) continue;
            paramsCheckVO.setWarnType(s);
            paramsCheckVO.setDataSource((List)map.get(s));
            if (CollectionUtils.isEmpty((Collection)paramsCheckVO.getDataSource())) {
                paramsCheckVO.setWarnType("none");
                continue;
            }
            return paramsCheckVO;
        }
        return paramsCheckVO;
    }

    @Override
    public List<ParamsCheckVO> historyPriceCtrlContractPrice(PurchaseContractVO contractVO) {
        StringBuffer stringBuffer;
        ParamsCheckDsVO paramsCheckDsVO;
        BigDecimal price;
        BigDecimal minPrice;
        BigDecimal maxPrice;
        String[] split;
        String getHistoryPriceArea;
        this.logger.info("proequipmentp---PurchaseContractServiceImpl---historyPriceCtrlContractPrice()--- \u5386\u53f2\u4ef7\u63a7\u5408\u540c\u4ef7\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)contractVO));
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ArrayList<ParamsCheckVO> paramsCheckVOList = new ArrayList<ParamsCheckVO>();
        CommonResponse maxParamByCode = new CommonResponse();
        CommonResponse minParamByCode = new CommonResponse();
        List detailList = contractVO.getDetailList();
        maxParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId("P-X74QbJ0193", contractVO.getOrgId());
        minParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId("P-A1NkyL0194", contractVO.getOrgId());
        if (!maxParamByCode.isSuccess() || null == maxParamByCode.getData()) {
            this.logger.info("\u67e5\u8be2\u4ef7\u683c\u5e93\u5386\u53f2\u5355\u4ef7\u53c2\u6570\u67e5\u8be2\u5931\u8d25\uff1a{}", (Object)maxParamByCode.getMsg());
            return paramsCheckVOList;
        }
        if (!minParamByCode.isSuccess() || null == minParamByCode.getData()) {
            this.logger.info("\u67e5\u8be2\u4ef7\u683c\u5e93\u5386\u53f2\u5355\u4ef7\u53c2\u6570\u67e5\u8be2\u5931\u8d25\uff1a{}", (Object)minParamByCode.getMsg());
            return paramsCheckVOList;
        }
        this.logger.info("\u5355\u636e\u63a7\u5236\u53c2\u6570\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)maxParamByCode));
        List maxParamVOS = (List)maxParamByCode.getData();
        List minParamVOS = (List)minParamByCode.getData();
        this.logger.info("\u8bbe\u5907\u8d2d\u7f6e\u5408\u540c\u5386\u53f2\u9ad8\u4ef7\u63a7\u5236\u4fe1\u606f\u8fd4\u56de\uff1a" + JSONObject.toJSONString((Object)maxParamVOS));
        this.logger.info("\u8bbe\u5907\u8d2d\u7f6e\u5408\u540c\u5386\u53f2\u4f4e\u4ef7\u63a7\u5236\u4fe1\u606f\u8fd4\u56de\uff1a" + JSONObject.toJSONString((Object)minParamVOS));
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)maxParamVOS)) {
            for (BillParamVO maxParamVO : maxParamVOS) {
                ParamsCheckVO paramsCheckVOMax = new ParamsCheckVO();
                ArrayList<ParamsCheckDsVO> checkDsVOSMax = new ArrayList<ParamsCheckDsVO>();
                BigDecimal roleValueMax = maxParamVO.getRoleValue();
                paramsCheckVOMax.setWarnType(paramsArray[maxParamVO.getControlType()]);
                if ("none".equals(paramsArray[maxParamVO.getControlType()])) continue;
                for (EquipmentDetailedVO detailVO : detailList) {
                    BigDecimal maxPriceParam;
                    getHistoryPriceArea = detailVO.getHistoryPriceArea();
                    if (getHistoryPriceArea == null || getHistoryPriceArea.isEmpty()) continue;
                    split = getHistoryPriceArea.split("-");
                    maxPrice = new BigDecimal(split[1]);
                    minPrice = new BigDecimal(split[0]);
                    this.logger.info("\u5206\u5305\u6e05\u5355\uff1a{}--\u9ad8\u4ef7\uff1a{}---\u4f4e\u4ef7\uff1a{}", new Object[]{detailVO.getEquipmentName(), split[1], split[0]});
                    if (maxPrice.compareTo(minPrice) == 0 || (price = detailVO.getPurchasePrice() == null ? BigDecimal.ZERO : detailVO.getPurchasePrice().setScale(4, 4)).compareTo(maxPriceParam = ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)maxPrice, (BigDecimal)roleValueMax), (BigDecimal)new BigDecimal("100")).setScale(4, 4)) <= 0) continue;
                    paramsCheckDsVO = new ParamsCheckDsVO();
                    paramsCheckDsVO.setOrgName(maxParamVO.getOrgName());
                    paramsCheckDsVO.setWarnItem(detailVO.getEquipmentName());
                    paramsCheckDsVO.setWarnName("\u91c7\u8d2d\u5355\u4ef7\u5927\u4e8e\u5386\u53f2\u6700\u9ad8\u4ef7");
                    stringBuffer = new StringBuffer();
                    stringBuffer.append("\u8bbe\u5907\u5355\u4ef7\uff1a").append(price).append("\uff0c\u5386\u53f2\u4ef7\u683c\u533a\u95f4:(").append(getHistoryPriceArea).append("),\u5386\u53f2\u6700\u9ad8\u4ef7*").append(roleValueMax).append("%:").append(maxPriceParam).append("\uff0c\u8d85\u51fa\u6700\u9ad8\u4ef7\uff1a").append(ComputeUtil.safeSub((BigDecimal)price, (BigDecimal)maxPriceParam).setScale(4, 4));
                    paramsCheckDsVO.setContent(stringBuffer.toString());
                    checkDsVOSMax.add(paramsCheckDsVO);
                }
                paramsCheckVOMax.setDataSource(checkDsVOSMax);
                paramsCheckVOList.add(paramsCheckVOMax);
            }
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)minParamVOS)) {
            for (BillParamVO minParamVO : minParamVOS) {
                ParamsCheckVO paramsCheckVOMin = new ParamsCheckVO();
                ArrayList<ParamsCheckDsVO> checkDsVOSMin = new ArrayList<ParamsCheckDsVO>();
                BigDecimal roleValueMin = minParamVO.getRoleValue();
                paramsCheckVOMin.setWarnType(paramsArray[minParamVO.getControlType()]);
                if ("none".equals(paramsArray[minParamVO.getControlType()])) continue;
                for (EquipmentDetailedVO detailVO : detailList) {
                    BigDecimal minPriceParam;
                    getHistoryPriceArea = detailVO.getHistoryPriceArea();
                    if (getHistoryPriceArea == null || getHistoryPriceArea.isEmpty()) continue;
                    split = getHistoryPriceArea.split("-");
                    maxPrice = new BigDecimal(split[1]);
                    minPrice = new BigDecimal(split[0]);
                    this.logger.info("\u5206\u5305\u6e05\u5355\uff1a{}--\u9ad8\u4ef7\uff1a{}---\u4f4e\u4ef7\uff1a{}", new Object[]{detailVO.getEquipmentName(), split[1], split[0]});
                    if (maxPrice.compareTo(minPrice) == 0 || (price = detailVO.getPurchasePrice() == null ? BigDecimal.ZERO : detailVO.getPurchasePrice().setScale(4, 4)).compareTo(minPriceParam = ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)minPrice, (BigDecimal)roleValueMin), (BigDecimal)new BigDecimal("100")).setScale(4, 4)) >= 0) continue;
                    paramsCheckDsVO = new ParamsCheckDsVO();
                    paramsCheckDsVO.setOrgName(minParamVO.getOrgName());
                    paramsCheckDsVO.setWarnItem(detailVO.getEquipmentName());
                    paramsCheckDsVO.setWarnName("\u91c7\u8d2d\u5355\u4ef7\u5c0f\u4e8e\u4e8e\u5386\u53f2\u6700\u4f4e\u4ef7");
                    stringBuffer = new StringBuffer();
                    stringBuffer.append("\u8bbe\u5907\u5355\u4ef7\uff1a").append(price).append("\uff0c\u5386\u53f2\u4ef7\u683c\u533a\u95f4:(").append(getHistoryPriceArea).append("),\u5386\u53f2\u6700\u4f4e\u4ef7*").append(roleValueMin).append("%:").append(minPriceParam).append("\uff0c\u4f4e\u4e8e\u6700\u4f4e\u4ef7\uff1a").append(ComputeUtil.safeSub((BigDecimal)minPriceParam, (BigDecimal)price).setScale(4, 4));
                    paramsCheckDsVO.setContent(stringBuffer.toString());
                    checkDsVOSMin.add(paramsCheckDsVO);
                }
                paramsCheckVOMin.setDataSource(checkDsVOSMin);
                paramsCheckVOList.add(paramsCheckVOMin);
            }
        }
        return paramsCheckVOList;
    }

    @Override
    public List<ParamsCheckVO> checkParamsConstruction(PurchaseContractVO vo) {
        CommonResponse contractionData = this.contractPoolApi.queryContractionTaxMny(vo.getProjectId());
        if (!contractionData.isSuccess() || null == contractionData.getData()) {
            this.logger.info(contractionData.getMsg());
            throw new BusinessException("\u83b7\u53d6\u65bd\u5de5\u5408\u540c\u4fe1\u606f\u5931\u8d25\uff01");
        }
        BigDecimal contractionTaxMny = new BigDecimal(String.valueOf(contractionData.getData()));
        this.logger.info("\u83b7\u53d6\u9879\u76ee\uff1a{}\u4e0b\uff0c\u65bd\u5de5\u5408\u540c\u603b\u91d1\u989d\uff1a{}", (Object)vo.getProjectId(), (Object)contractionTaxMny);
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ArrayList<ParamsCheckVO> paramsCheckVOList = new ArrayList<ParamsCheckVO>();
        if (BigDecimal.ZERO.compareTo(contractionTaxMny) == 0) {
            return paramsCheckVOList;
        }
        CommonResponse billParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId(CONTRACTION_CHECK_PARAM_CODE, vo.getOrgId());
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            List data = (List)billParamByCode.getData();
            if (CollectionUtils.isNotEmpty((Collection)data)) {
                CommonResponse projectData = this.executionApi.queryTotalContMny(vo.getProjectId());
                if (!projectData.isSuccess() || null == projectData.getData()) {
                    this.logger.info(projectData.getMsg());
                    throw new BusinessException("\u83b7\u53d6\u76ee\u6807\u6210\u672c\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff01");
                }
                BigDecimal allExpenseContractTaxMny = new BigDecimal(String.valueOf(projectData.getData()));
                this.logger.info("\u83b7\u53d6\u76ee\u6807\u6210\u672c\u9879\u76ee\uff1a{}\u4e0b\uff0c\u6240\u6709\u652f\u51fa\u5408\u540c\u603b\u91d1\u989d\uff1a{}", (Object)vo.getProjectId(), (Object)allExpenseContractTaxMny);
                BigDecimal thisTimeChangeTaxMny = BigDecimal.ZERO;
                PurchaseContractEntity contractEntity = (PurchaseContractEntity)((Object)this.service.selectById(vo.getId()));
                thisTimeChangeTaxMny = null != contractEntity ? ComputeUtil.safeSub((BigDecimal)vo.getContractTaxMny(), (BigDecimal)contractEntity.getContractTaxMny()).setScale(2, 4) : vo.getContractTaxMny();
                this.logger.info("\u672c\u6b21\u53d8\u52a8\u91d1\u989d\uff1a{}", (Object)thisTimeChangeTaxMny);
                for (BillParamVO billParamVO : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    ArrayList<ParamsCheckDsVO> checkDsVOS = new ArrayList<ParamsCheckDsVO>();
                    BigDecimal roleValue = billParamVO.getRoleValue();
                    BigDecimal comMny = ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)contractionTaxMny, (BigDecimal)roleValue), (BigDecimal)new BigDecimal("100")).setScale(2, 4);
                    this.logger.info("\u65bd\u5de5\u5408\u540c\u91d1\u989d*\u6bd4\u4f8b\u540e\u91d1\u989d\uff1a{}", (Object)comMny);
                    BigDecimal sumPayContractTaxMny = ComputeUtil.safeAdd((BigDecimal)allExpenseContractTaxMny, (BigDecimal)thisTimeChangeTaxMny).setScale(2, 4);
                    this.logger.info("\u542b\u672c\u6b21\u5408\u540c\u91d1\u989d\uff1a{}", (Object)sumPayContractTaxMny);
                    if (sumPayContractTaxMny.compareTo(comMny) <= 0) {
                        paramsCheckVO.setWarnType(paramsArray[0]);
                        paramsCheckVOList.add(paramsCheckVO);
                        return paramsCheckVOList;
                    }
                    paramsCheckVO.setWarnType(paramsArray[billParamVO.getControlType()]);
                    ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                    paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                    paramsCheckDsVO.setWarnItem("\u652f\u51fa\u8d85\u65bd\u5de5\u5408\u540c");
                    paramsCheckDsVO.setWarnName("\u7d2f\u8ba1\u652f\u51fa\u5408\u540c\u91d1\u989d\u5927\u4e8e\u65bd\u5de5\u5408\u540c\u91d1\u989d");
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("\u672c\u6b21\u5408\u540c\u91d1\u989d\uff1a").append(vo.getContractTaxMny()).append("\u5143\uff0c\u542b\u672c\u6b21\u5408\u540c\u91d1\u989d\uff1a").append(sumPayContractTaxMny).append("\u5143\uff0c\u65bd\u5de5\u5408\u540c\u91d1\u989d*").append(roleValue).append("% = ").append(comMny).append("\u5143\u3002\u8d85\u51fa\u91d1\u989d\uff1a").append(ComputeUtil.safeSub((BigDecimal)sumPayContractTaxMny, (BigDecimal)comMny).setScale(2, 4)).append("\u5143");
                    paramsCheckDsVO.setContent(stringBuffer.toString());
                    checkDsVOS.add(paramsCheckDsVO);
                    this.logger.info("paramsCheckDsVO:{}", (Object)JSONObject.toJSONString((Object)paramsCheckDsVO));
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOList.add(paramsCheckVO);
                }
            }
        } else {
            this.logger.info(billParamByCode.getMsg());
            throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
        }
        return paramsCheckVOList;
    }

    @Override
    public List<ParamsCheckVO> checkParamsMnySup(PurchaseContractVO vo) {
        BigDecimal contractTaxMnySup = vo.getContractTaxMny() == null ? BigDecimal.ZERO : vo.getContractTaxMny();
        PurchaseContractEntity contractEntity = (PurchaseContractEntity)((Object)super.selectById((Serializable)vo.getMainContractId()));
        BigDecimal contractTaxMny = contractEntity.getContractTaxMny() == null ? BigDecimal.ZERO : contractEntity.getContractTaxMny();
        BigDecimal totalSupMoney = contractTaxMnySup;
        QueryParam supplementQueryParam = new QueryParam();
        supplementQueryParam.getParams().put("mainContractId", new Parameter("eq", (Object)vo.getMainContractId()));
        if (vo.getId() != null) {
            supplementQueryParam.getParams().put("id", new Parameter("ne", (Object)vo.getId()));
        }
        supplementQueryParam.getParams().put("mainContractId", new Parameter("eq", (Object)vo.getMainContractId()));
        supplementQueryParam.getParams().put("signatureStatus", new Parameter("eq", (Object)SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode()));
        List supplementContractList = super.queryList(supplementQueryParam, false);
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)supplementContractList)) {
            for (PurchaseContractEntity entity : supplementContractList) {
                totalSupMoney = ComputeUtil.safeAdd((BigDecimal)entity.getContractTaxMny(), (BigDecimal)totalSupMoney);
            }
        }
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ArrayList<ParamsCheckVO> paramsCheckVOList = new ArrayList<ParamsCheckVO>();
        CommonResponse billParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId(CHECK_PARAM_CODE, vo.getOrgId());
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            List data = (List)billParamByCode.getData();
            this.logger.info("\u534f\u8bae\u91d1\u989d\u63a7\u5236\u4fe1\u606f\u8fd4\u56de\uff1a" + JSONObject.toJSONString((Object)data));
            if (CollectionUtils.isNotEmpty((Collection)data)) {
                for (BillParamVO datum : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    ArrayList<ParamsCheckDsVO> checkDsVOS = new ArrayList<ParamsCheckDsVO>();
                    BigDecimal roleValue = datum.getRoleValue();
                    BigDecimal comMny = ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)contractTaxMny, (BigDecimal)roleValue), (BigDecimal)new BigDecimal("100")).setScale(2, 4);
                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    if (totalSupMoney.compareTo(comMny) > 0) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setOrgName(datum.getOrgName());
                        paramsCheckDsVO.setWarnItem("\u8865\u5145\u534f\u8bae\u8d85\u5408\u540c\u91d1\u989d");
                        paramsCheckDsVO.setWarnName("\u7d2f\u8ba1\u8865\u5145\u534f\u8bae\u91d1\u989d\u5927\u4e8e\u5408\u540c\u91d1\u989d");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("\u672c\u6b21\u8865\u5145\u534f\u8bae\u91d1\u989d\uff1a").append(contractTaxMnySup.setScale(2, 4)).append("\u5143\uff0c\u542b\u672c\u6b21\u8865\u5145\u534f\u8bae\u91d1\u989d\uff1a").append(totalSupMoney.setScale(2, 4)).append("\u5143\uff0c\u5408\u540c\u91d1\u989d*").append(roleValue).append("%:").append(comMny.setScale(2, 4)).append("\u5143\u3002\u8d85\u51fa\u91d1\u989d\uff1a").append(ComputeUtil.safeSub((BigDecimal)totalSupMoney, (BigDecimal)comMny).setScale(2, 4)).append("\u5143");
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOList.add(paramsCheckVO);
                }
            }
        } else {
            this.logger.info(billParamByCode.getMsg());
            throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
        }
        return paramsCheckVOList;
    }

    @Override
    public void updateTargetResult(PurchaseContractVO vo, Integer type) {
        if (vo.getTargetResultId() == null) {
            return;
        }
        if (CollectionUtils.isEmpty((Collection)vo.getDetailList())) {
            return;
        }
        TenderPicketageVO picketageVO = new TenderPicketageVO();
        picketageVO.setId(vo.getTargetResultId());
        picketageVO.setContractMoneyTax(vo.getContractTaxMny());
        picketageVO.setContractMoney(vo.getContractMny());
        ArrayList<TenderPicketageDetailVO> list = new ArrayList<TenderPicketageDetailVO>();
        for (EquipmentDetailedVO detailVO : vo.getDetailList()) {
            if ("del".equals(detailVO.getRowState())) continue;
            TenderPicketageDetailVO tenderDetailVo = new TenderPicketageDetailVO();
            tenderDetailVo.setId(detailVO.getSourceId());
            tenderDetailVo.setSignNum(new BigDecimal(detailVO.getPurchaseNum().toString()));
            list.add(tenderDetailVo);
        }
        picketageVO.setTenderPicketageDetailList(list);
        String typeStr = 0 == type ? "\u5360\u7528" : "\u91ca\u653e";
        this.logger.info("{}\u5b9a\u6807\u7ed3\u679c\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)typeStr, (Object)JSONObject.toJSONString((Object)picketageVO));
        CommonResponse response = 0 == type ? this.tenderApi.updateStatus(picketageVO) : this.tenderApi.delUpdateStatus(picketageVO);
        this.logger.info("{}\u5b9a\u6807\u7ed3\u679c\u8bf7\u6c42\u7ed3\u679c\uff1a{}", (Object)typeStr, (Object)JSONObject.toJSONString((Object)response));
        if (!response.isSuccess()) {
            throw new BusinessException(typeStr + "\u5b9a\u6807\u7ed3\u679c\u5931\u8d25\uff01\u5931\u8d25\u539f\u56e0\uff1a" + response.getMsg());
        }
    }

    @Override
    public List<SignContractVo> queryContractByTargetResultId(List<String> targetResultIdList) {
        ArrayList<SignContractVo> rtnList = new ArrayList<SignContractVo>();
        if (CollectionUtils.isEmpty(targetResultIdList)) {
            return rtnList;
        }
        this.logger.info("\u5b9a\u6807id" + JSONObject.toJSONString(targetResultIdList));
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("target_result_id", new Parameter("in", targetResultIdList));
        queryParam.getOrderMap().put("sign_date", "desc");
        List entityList = super.queryList(queryParam, false);
        if (CollectionUtils.isEmpty((Collection)entityList)) {
            return rtnList;
        }
        for (PurchaseContractEntity entity : entityList) {
            SignContractVo vo = new SignContractVo();
            vo.setBillCode(entity.getBillCode());
            vo.setContractId(entity.getId());
            vo.setContractName(entity.getContractName());
            vo.setSupplierId(entity.getSupplierId());
            vo.setSupplierName(entity.getSupplierName());
            vo.setContractMny(entity.getContractMny());
            vo.setContractTaxMny(entity.getContractTaxMny());
            vo.setSignDate(entity.getSignDate());
            vo.setBillState(entity.getBillState());
            vo.setLinkUrl(linkUrl + entity.getId());
            rtnList.add(vo);
        }
        return rtnList;
    }

    private void checkDetailTenderNum(List<EquipmentDetailedVO> detailList, Long contractId) {
        List detailEntityList;
        if (CollectionUtils.isEmpty(detailList)) {
            return;
        }
        List sourceIdList = detailList.stream().map(EquipmentDetailedVO::getSourceId).collect(Collectors.toList());
        QueryParam detailParam = new QueryParam();
        detailParam.getParams().put("sourceId", new Parameter("in", sourceIdList));
        if (contractId != null) {
            detailParam.getParams().put("contractId", new Parameter("ne", (Object)contractId));
        }
        if (CollectionUtils.isEmpty((Collection)(detailEntityList = this.contractDetailService.queryList(detailParam, false)))) {
            return;
        }
        Map<Long, List<EquipmentDetailedEntity>> queryMap = detailEntityList.stream().collect(Collectors.groupingBy(EquipmentDetailedEntity::getSourceId));
        for (EquipmentDetailedVO detail : detailList) {
            List<EquipmentDetailedEntity> queryDetailList = queryMap.get(detail.getSourceId());
            BigDecimal tenderNum = CommonUtils.setBigDecimalDefaultValue(detail.getTenderNum());
            if (CollectionUtils.isEmpty(queryDetailList)) continue;
            BigDecimal signTenderNum = BigDecimal.ZERO;
            for (EquipmentDetailedEntity detailEntity : queryDetailList) {
                signTenderNum = signTenderNum.add(CommonUtils.setBigDecimalDefaultValue(detailEntity.getInitNum()));
            }
            BigDecimal sy = tenderNum.subtract(signTenderNum);
            if (sy.compareTo(new BigDecimal(detail.getPurchaseNum())) >= 0) continue;
            throw new BusinessException(detail.getEquipmentName() + "\u91c7\u8d2d\u6570\u91cf\u4e0d\u80fd\u8d85\u8fc7" + sy);
        }
    }

    @Override
    public String getContractFilingCode() {
        CommonResponse response = this.paramConfigApi.getByCode(CONTRACT_FILING_CODE);
        this.logger.info("\u5408\u540c\u5f52\u6863\u63a7\u5236\u53c2\u6570\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)response));
        if (!response.isSuccess() || response.getData() == null) {
            throw new BusinessException("\u83b7\u53d6\u5408\u540c\u5f52\u6863\u63a7\u5236\u53c2\u6570\u8bf7\u6c42\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + response.getMsg());
        }
        String valueData = ((ParamRegisterSetVO)response.getData()).getValueData();
        return com.baomidou.mybatisplus.core.toolkit.StringUtils.isNotEmpty((CharSequence)valueData) ? valueData : "0";
    }

    @Override
    public boolean checkContractFiling(Long contractId) {
        String valueData = this.getContractFilingCode();
        PurchaseContractEntity contractEntity = (PurchaseContractEntity)((Object)super.selectById((Serializable)contractId));
        if ("0".equals(valueData)) {
            return true;
        }
        return FilingStatusEnum.\u5df2\u5f52\u6863.getTypeCode().equals(contractEntity.getFilingStatus());
    }

    @Override
    public void asyncWatermarkById(Long id) {
        PurchaseContractEntity contractEntity = (PurchaseContractEntity)((Object)super.selectById((Serializable)id));
        CommonResponse response = this.paramConfigApi.getByCode(WATERMARK_CHECK_PARAM_NAME);
        if (!response.isSuccess() || response.getData() == null) {
            throw new BusinessException("\u83b7\u53d6\u6c34\u5370\u7cfb\u7edf\u53c2\u6570\u8bf7\u6c42\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + response.getMsg());
        }
        String valueData = ((ParamRegisterSetVO)response.getData()).getValueData();
        Assert.hasText((String)valueData, (String)"\u83b7\u53d6\u7684\u6c34\u5370\u7cfb\u7edf\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a!");
        if ("0".equals(valueData)) {
            String billType = BILL_TYPE;
            String sourceType = ContractTypeEnum.\u8bbe\u5907\u91c7\u8d2d.getTypeCode();
            WatermarkVO watermarkVO = this.signatureCommonApi.fetchWatermarkConfig(contractEntity.getContractFileId(), contractEntity.getId(), contractEntity.getBillCode(), billType, sourceType);
            Assert.notNull((Object)watermarkVO, (String)"\u83b7\u53d6\u6c34\u5370\u7cfb\u7edf\u53c2\u6570\u5931\u8d25!");
            HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("authority", request.getHeader("authority"));
            headers.put("ejc-token", request.getHeader("ejc-token"));
            this.contractAsyncService.fetchWatermarkAttachment(headers, watermarkVO);
        }
    }
}

