package com.ejianc.business.acceptance.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.acceptance.bean.PurchaseAcceptanceSubEntity;
/**
 * 购置验收表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_proequipment_purchase_acceptance")
public class PurchaseAcceptanceEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_state")
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="project_code")
    private String projectCode; // 项目编号
    @TableField(value="project_id")
    private Long projectId; // 项目id
    @TableField(value="project_org")
    private String projectOrg; // 所属单位
    @TableField(value="project_org_id")
    private Long projectOrgId; // 所属单位id
    @TableField(value="contract_name")
    private String contractName; // 合同名称
    @TableField(value="contract_id")
    private Long contractId; // 合同id
    @TableField(value="contract_code")
    private String contractCode; // 合同编号
    @TableField(value="supplier_name")
    private String supplierName; // 供应商
    @TableField(value="supplier_id")
    private Long supplierId; // 供应商id
    @TableField(value="property_right_company")
    private String propertyRightCompany; // 产权单位
    @TableField(value="property_right_company_id")
    private Long propertyRightCompanyId; // 产权单位id
    @TableField(value="manage_company")
    private String manageCompany; // 管理单位
    @TableField(value="manage_company_id")
    private Long manageCompanyId; // 管理单位id
    @TableField(value="acceptance_date")
    private Date acceptanceDate; // 验收日期
    @TableField(value="acceptance_psn")
    private String acceptancePsn; // 验收人
    @TableField(value="acceptance_psn_id")
    private Long acceptancePsnId; // 验收人id
    @TableField(value="manufactor")
    private String manufactor; // 厂家:一致/不一致
    @TableField(value="equipment_model")
    private String equipmentModel; // 设备型号:一致/不一致
    @TableField(value="appearance")
    private String appearance; // 外观:一致/不一致
    @TableField(value="body_structure")
    private String bodyStructure; // 机体结构:良好/一般/差
    @TableField(value="safe_protect_device")
    private String safeProtectDevice; // 安全防护装置：良好/一般/差
    @TableField(value="test_run")
    private String testRun; // 试运行:合格/不合格
    @TableField(value="skill_information")
    private String skillInformation; // 技术资料:完备/不完备
    @TableField(value="manufacturer")
    private String manufacturer; // 生产厂家
    @TableField(value="certificate_num")
    private String certificateNum; // 合格证号
    @TableField(value="production_date")
    private Date productionDate; // 生产日期
    @TableField(value="leave_factory_code")
    private String leaveFactoryCode; // 出厂编号
    @TableField(value="random_tool")
    private String randomTool; // 随机工具
    @TableField(value="ability")
    private String ability; // 能力
    @TableField(value="weight")
    private BigDecimal weight; // 重量（t）
    @TableField(value="power")
    private BigDecimal power; // 动力（kw）
    @TableField(value="own_weight")
    private BigDecimal ownWeight; // 自重（t）
    @TableField(value="appearance_size")
    private BigDecimal appearanceSize; // 外形尺寸（毫米）
    @TableField(value="model_explain")
    private String modelExplain; // 型号说明
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="original_bill_path")
    private String originalBillPath; // 原始单据路径
    @TableField(value="photo_path")
    private String photoPath; // 现场照片路径

    @TableField(value="project_manger_sign")
    private String projectMangerSign; // 项目经理签字
    @TableField(value="supplier_sign")
    private String supplierSign; // 供应商签字

    @TableField(value="project_department_id")
    private Long projectDepartmentId; // 项目部ID
    @TableField(value="project_department_name")
    private String projectDepartmentName; // 项目部名称

    @TableField(value="not_signature")
    private Boolean notSignature;//是否签字
    @TableField(value="org_id")
    private Long orgId; // 组织id
    @TableField(value="org_name")
    private String orgName; // 项目部名称
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 项目部上级组织Id
    @TableField(value="parent_org_name")
    private String parentOrgName; // 项目部上级组织名称
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 项目部上级组织编码
    @TableField(value="org_code")
    private String orgCode; // 项目部编码
    @TableField(value="finance_push_flag")
    private Integer financePushFlag; // 是否推送财务1推送0不推送




    @TableField(exist=false)
    @SubEntity(serviceName="purchaseAcceptanceSubService")
    private List<PurchaseAcceptanceSubEntity> purchaseAcceptanceSubList = new ArrayList<>(); // 设备购置验收-设备明细

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectOrg() {
        return projectOrg;
    }

    public void setProjectOrg(String projectOrg) {
        this.projectOrg = projectOrg;
    }
    public Long getProjectOrgId() {
        return projectOrgId;
    }

    public void setProjectOrgId(Long projectOrgId) {
        this.projectOrgId = projectOrgId;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getPropertyRightCompany() {
        return propertyRightCompany;
    }

    public void setPropertyRightCompany(String propertyRightCompany) {
        this.propertyRightCompany = propertyRightCompany;
    }
    public Long getPropertyRightCompanyId() {
        return propertyRightCompanyId;
    }

    public void setPropertyRightCompanyId(Long propertyRightCompanyId) {
        this.propertyRightCompanyId = propertyRightCompanyId;
    }
    public String getManageCompany() {
        return manageCompany;
    }

    public void setManageCompany(String manageCompany) {
        this.manageCompany = manageCompany;
    }
    public Long getManageCompanyId() {
        return manageCompanyId;
    }

    public void setManageCompanyId(Long manageCompanyId) {
        this.manageCompanyId = manageCompanyId;
    }
    public Date getAcceptanceDate() {
        return acceptanceDate;
    }

    public void setAcceptanceDate(Date acceptanceDate) {
        this.acceptanceDate = acceptanceDate;
    }
    public String getAcceptancePsn() {
        return acceptancePsn;
    }

    public void setAcceptancePsn(String acceptancePsn) {
        this.acceptancePsn = acceptancePsn;
    }
    public Long getAcceptancePsnId() {
        return acceptancePsnId;
    }

    public void setAcceptancePsnId(Long acceptancePsnId) {
        this.acceptancePsnId = acceptancePsnId;
    }
    public String getManufactor() {
        return manufactor;
    }

    public void setManufactor(String manufactor) {
        this.manufactor = manufactor;
    }
    public String getEquipmentModel() {
        return equipmentModel;
    }

    public void setEquipmentModel(String equipmentModel) {
        this.equipmentModel = equipmentModel;
    }
    public String getAppearance() {
        return appearance;
    }

    public void setAppearance(String appearance) {
        this.appearance = appearance;
    }
    public String getBodyStructure() {
        return bodyStructure;
    }

    public void setBodyStructure(String bodyStructure) {
        this.bodyStructure = bodyStructure;
    }
    public String getSafeProtectDevice() {
        return safeProtectDevice;
    }

    public void setSafeProtectDevice(String safeProtectDevice) {
        this.safeProtectDevice = safeProtectDevice;
    }
    public String getTestRun() {
        return testRun;
    }

    public void setTestRun(String testRun) {
        this.testRun = testRun;
    }
    public String getSkillInformation() {
        return skillInformation;
    }

    public void setSkillInformation(String skillInformation) {
        this.skillInformation = skillInformation;
    }
    public String getManufacturer() {
        return manufacturer;
    }

    public void setManufacturer(String manufacturer) {
        this.manufacturer = manufacturer;
    }
    public String getCertificateNum() {
        return certificateNum;
    }

    public void setCertificateNum(String certificateNum) {
        this.certificateNum = certificateNum;
    }
    public Date getProductionDate() {
        return productionDate;
    }

    public void setProductionDate(Date productionDate) {
        this.productionDate = productionDate;
    }
    public String getLeaveFactoryCode() {
        return leaveFactoryCode;
    }

    public void setLeaveFactoryCode(String leaveFactoryCode) {
        this.leaveFactoryCode = leaveFactoryCode;
    }
    public String getRandomTool() {
        return randomTool;
    }

    public void setRandomTool(String randomTool) {
        this.randomTool = randomTool;
    }
    public String getAbility() {
        return ability;
    }

    public void setAbility(String ability) {
        this.ability = ability;
    }
    public BigDecimal getWeight() {
        return weight;
    }

    public void setWeight(BigDecimal weight) {
        this.weight = weight;
    }
    public BigDecimal getPower() {
        return power;
    }

    public void setPower(BigDecimal power) {
        this.power = power;
    }
    public BigDecimal getOwnWeight() {
        return ownWeight;
    }

    public void setOwnWeight(BigDecimal ownWeight) {
        this.ownWeight = ownWeight;
    }
    public BigDecimal getAppearanceSize() {
        return appearanceSize;
    }

    public void setAppearanceSize(BigDecimal appearanceSize) {
        this.appearanceSize = appearanceSize;
    }
    public String getModelExplain() {
        return modelExplain;
    }

    public void setModelExplain(String modelExplain) {
        this.modelExplain = modelExplain;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public String getOriginalBillPath() {
        return originalBillPath;
    }

    public void setOriginalBillPath(String originalBillPath) {
        this.originalBillPath = originalBillPath;
    }

    public String getPhotoPath() {
        return photoPath;
    }

    public void setPhotoPath(String photoPath) {
        this.photoPath = photoPath;
    }

    public String getProjectMangerSign() {
        return projectMangerSign;
    }

    public void setProjectMangerSign(String projectMangerSign) {
        this.projectMangerSign = projectMangerSign;
    }

    public String getSupplierSign() {
        return supplierSign;
    }

    public void setSupplierSign(String supplierSign) {
        this.supplierSign = supplierSign;
    }

    public Long getProjectDepartmentId() {
        return projectDepartmentId;
    }

    public void setProjectDepartmentId(Long projectDepartmentId) {
        this.projectDepartmentId = projectDepartmentId;
    }

    public String getProjectDepartmentName() {
        return projectDepartmentName;
    }

    public void setProjectDepartmentName(String projectDepartmentName) {
        this.projectDepartmentName = projectDepartmentName;
    }

    public Boolean getNotSignature() {
        return notSignature;
    }

    public void setNotSignature(Boolean notSignature) {
        this.notSignature = notSignature;
    }

    public Integer getFinancePushFlag() {
        return financePushFlag;
    }

    public void setFinancePushFlag(Integer financePushFlag) {
        this.financePushFlag = financePushFlag;
    }

    public List<PurchaseAcceptanceSubEntity> getPurchaseAcceptanceSubList() {
        return purchaseAcceptanceSubList;
    }

    public void setPurchaseAcceptanceSubList(List<PurchaseAcceptanceSubEntity> purchaseAcceptanceSubList) {
        this.purchaseAcceptanceSubList = purchaseAcceptanceSubList;
    }
}
