package com.ejianc.business.pricelib.bean;

import java.util.Date;
import java.math.*;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

/**
 * 设备价格库清单明细实体
 * 
 * @author generator
 * 
 */
 @TableName("ejc_proequipment_price_contract")
public class PriceContractEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="bill_state")
    private Integer billState; // 单据状态（审批必须字段）
    @TableField(value="contract_name")
    private String contractName; // 合同名称
    @TableField(value="contract_id")
    private Long contractId; // 合同id
    @TableField(value="contract_code")
    private String contractCode; // 合同编码
    @TableField(value="contract_type")
    private Integer contractType; // 合同类型：0-劳务合同 1-专业合同
    @TableField(value="contract_flag")
    private Integer contractFlag; // 合同类型：0-主合同 1-补充协议
    @TableField(value="performance_status")
    private String performanceStatus; // 合同履约状态：1、未签订；2、履约中；3、已封账；4、已解除；   默认为未签定，签章状态为已签章时，状态自动更改为【履约中】。当合同存在生效的最终结算时，状态自动改为【已封账】
    @TableField(value="pc_card_url")
    private String pcCardUrl; // 合同来源地址
    @TableField(value="supplier_id")
    private Long supplierId; // 乙方Id
    @TableField(value="supplier_name")
    private String supplierName; // 乙方名称
    @TableField(value="project_id")
    private Long projectId; // 项目ID
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="project_code")
    private String projectCode; // 项目编号
    @TableField(value="org_id")
    private Long orgId; // 所属单位id
    @TableField(value="org_name")
    private String orgName; // 所属单位名称
    @TableField(value="org_code")
    private String orgCode; // 所属单位编码
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 父级组织
    @TableField(value="parent_org_name")
    private String parentOrgName; // 
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 项目部上级组织编码
    @TableField(value="area")
    private String area; // 项目地区
    @TableField(value="area_name")
    private String areaName; // 项目地区
    @TableField(value="measure_rule")
    private String measureRule; // 计量规则
    @TableField(value="work_content")
    private String workContent; // 工作内容
    @TableField(value="spec")
    private String spec; // 规格型号
    @TableField(value="manufacturer")
    private String manufacturer; // 生产厂家
    @TableField(value="sign_date")
    private Date signDate; // 签订时间
    @TableField(value="contract_tax_rate")
    private BigDecimal contractTaxRate; // 税率
    @TableField(value="contract_num")
    private BigDecimal contractNum; // 数量
    @TableField(value="contract_price")
    private BigDecimal contractPrice; // 合同单价(无税)
    @TableField(value="contract_tax_price")
    private BigDecimal contractTaxPrice; // 单价(含税)
    @TableField(value="contract_mny")
    private BigDecimal contractMny; // 合同金额(无税)
    @TableField(value="contract_tax_mny")
    private BigDecimal contractTaxMny; // 合同金额(含税)
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="out_flag")
    private Integer outFlag; // 是否移除（0-否未移除，1-是）
    @TableField(value="doc_id")
    private Long docId; // 清单id-档案Id
    @TableField(value="doc_code")
    private String docCode; // 清单编码-档案编码
    @TableField(value="doc_name")
    private String docName; // 清单名称-档案名称
    @TableField(value="doc_category_id")
    private Long docCategoryId; // 所属上级id-档案分类Id
    @TableField(value="doc_category_name")
    private String docCategoryName; // 所属上级名称-档案分类名称
    @TableField(value="doc_inner_code")
    private String docInnerCode; // 分类内码
    @TableField(value="unit_id")
    private Long unitId; // 计量单位主键
    @TableField(value="unit_name")
    private String unitName; // 计量单位
    @TableField(value="price_type_id")
    private Long priceTypeId; // 价格类型id
    @TableField(value="price_type_name")
    private String priceTypeName; // 价格类型
    @TableField(value="target_result_id")
    private Long targetResultId; // 定标结果Id
    @TableField(value="source_id")
    private Long sourceId; // 来源id
    @TableField(value="settlement_date")
    private Date settlementDate; // 结算日期（最终结算日期）


    @TableField(value="equipment_height")
    private String equipmentHeight; // 设备高度
    public String getEquipmentHeight() {
        return equipmentHeight;
    }

    public void setEquipmentHeight(String equipmentHeight) {
        this.equipmentHeight = equipmentHeight;
    }
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public Integer getContractType() {
        return contractType;
    }

    public void setContractType(Integer contractType) {
        this.contractType = contractType;
    }
    public Integer getContractFlag() {
        return contractFlag;
    }

    public void setContractFlag(Integer contractFlag) {
        this.contractFlag = contractFlag;
    }
    public String getPerformanceStatus() {
        return performanceStatus;
    }

    public void setPerformanceStatus(String performanceStatus) {
        this.performanceStatus = performanceStatus;
    }
    public String getPcCardUrl() {
        return pcCardUrl;
    }

    public void setPcCardUrl(String pcCardUrl) {
        this.pcCardUrl = pcCardUrl;
    }
    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getArea() {
        return area;
    }

    public void setArea(String area) {
        this.area = area;
    }
    public String getAreaName() {
        return areaName;
    }

    public void setAreaName(String areaName) {
        this.areaName = areaName;
    }
    public String getMeasureRule() {
        return measureRule;
    }

    public void setMeasureRule(String measureRule) {
        this.measureRule = measureRule;
    }
    public String getWorkContent() {
        return workContent;
    }

    public void setWorkContent(String workContent) {
        this.workContent = workContent;
    }
    public String getSpec() {
        return spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }
    public String getManufacturer() {
        return manufacturer;
    }

    public void setManufacturer(String manufacturer) {
        this.manufacturer = manufacturer;
    }
    public Date getSignDate() {
        return signDate;
    }

    public void setSignDate(Date signDate) {
        this.signDate = signDate;
    }
    public BigDecimal getContractTaxRate() {
        return contractTaxRate;
    }

    public void setContractTaxRate(BigDecimal contractTaxRate) {
        this.contractTaxRate = contractTaxRate;
    }
    public BigDecimal getContractNum() {
        return contractNum;
    }

    public void setContractNum(BigDecimal contractNum) {
        this.contractNum = contractNum;
    }
    public BigDecimal getContractPrice() {
        return contractPrice;
    }

    public void setContractPrice(BigDecimal contractPrice) {
        this.contractPrice = contractPrice;
    }
    public BigDecimal getContractTaxPrice() {
        return contractTaxPrice;
    }

    public void setContractTaxPrice(BigDecimal contractTaxPrice) {
        this.contractTaxPrice = contractTaxPrice;
    }
    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }
    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Integer getOutFlag() {
        return outFlag;
    }

    public void setOutFlag(Integer outFlag) {
        this.outFlag = outFlag;
    }
    public Long getDocId() {
        return docId;
    }

    public void setDocId(Long docId) {
        this.docId = docId;
    }
    public String getDocCode() {
        return docCode;
    }

    public void setDocCode(String docCode) {
        this.docCode = docCode;
    }
    public String getDocName() {
        return docName;
    }

    public void setDocName(String docName) {
        this.docName = docName;
    }
    public Long getDocCategoryId() {
        return docCategoryId;
    }

    public void setDocCategoryId(Long docCategoryId) {
        this.docCategoryId = docCategoryId;
    }
    public String getDocCategoryName() {
        return docCategoryName;
    }

    public void setDocCategoryName(String docCategoryName) {
        this.docCategoryName = docCategoryName;
    }
    public String getDocInnerCode() {
        return docInnerCode;
    }

    public void setDocInnerCode(String docInnerCode) {
        this.docInnerCode = docInnerCode;
    }
    public Long getUnitId() {
        return unitId;
    }

    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }
    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }
    public Long getPriceTypeId() {
        return priceTypeId;
    }

    public void setPriceTypeId(Long priceTypeId) {
        this.priceTypeId = priceTypeId;
    }
    public String getPriceTypeName() {
        return priceTypeName;
    }

    public void setPriceTypeName(String priceTypeName) {
        this.priceTypeName = priceTypeName;
    }
    public Long getTargetResultId() {
        return targetResultId;
    }

    public void setTargetResultId(Long targetResultId) {
        this.targetResultId = targetResultId;
    }
    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }
    public Date getSettlementDate() {
        return settlementDate;
    }

    public void setSettlementDate(Date settlementDate) {
        this.settlementDate = settlementDate;
    }
    
}
