package com.ejianc.business.purchase.service;

import com.ejianc.business.promaterial.contract.vo.ContractVO;
import com.ejianc.business.purchase.vo.PurchaseContractVO;
import com.ejianc.business.settlement.vo.MaterialCostPriceApiVO;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.business.tender.common.vo.SignContractVo;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.purchase.bean.PurchaseContractEntity;

import java.util.List;
import java.util.Map;

/**
 * 购置合同表
 * 
 * @author generator
 * 
 */
public interface IPurchaseContractService extends IBaseService<PurchaseContractEntity> {

    PurchaseContractVO insertOrUpdate(PurchaseContractVO saveOrUpdateVO, String authority, Boolean isControl);

    Boolean delContractFile(Long fileId, String authority);

    PurchaseContractVO queryDetail(Long id);

    PurchaseContractVO querySupplementRecord(Long id);

    Boolean addSupplementFlag(Long id);

    PurchaseContractVO saveOrUpdateSupplement(PurchaseContractVO saveOrUpdateVO, Boolean isControl);

    PurchaseContractVO addConvertByConId(Long contractId);

    Map<String, Object> countContractAmount(QueryParam param);

    CommonResponse<String> deleteByIds(List<PurchaseContractVO> vos);

    ExecutionVO targetCost(PurchaseContractVO contractVO,String BillType,String linkUrl);

    void pushContract(PurchaseContractVO contractVO);

    boolean checkContract(Long id, Long otherId);

    ParamsCheckVO targetCostCtrl(PurchaseContractVO contractVO, String authority);

    ParamsCheckVO viewTargetCostCtrlInfo(Long id);

    CommonResponse<String> pushTargetCost(Long id);

    ParamsCheckVO checkParams(PurchaseContractVO vo, ParamsCheckVO paramsCheckVO2);
    /**
     * 单据管控-补充协议金额大于合同金额
     *
     * @return
     */
    List<ParamsCheckVO> checkParamsMnySup(PurchaseContractVO vo);

    boolean delWatermarkContractFile(Long watermarkFileId);
    /*施工合同 控 补充协议,主合同
     *        @param 最新合同vo  或 协议vo

     * */
    List<ParamsCheckVO>  checkParamsConstruction(PurchaseContractVO vo);

    void updateTargetResult(PurchaseContractVO vo, Integer type);

    List<SignContractVo> queryContractByTargetResultId(List<String> targetResultIdList);

    /**
     * 根据合同归档控制参数，校验合同能否新增变更、补充协议
     *
     * @param contractId 合同id
     * @return true：可以新增，false：不能新增
     */
    boolean checkContractFiling(Long contractId);


    /**
     * 获取合同归档控制参数  没有获取到参数默认不限制
     *
     * @return 合同归档控制参数(0：不限制，1：部分限制，2：全部限制)
     */
    String getContractFilingCode();


    /**
     * 根据变更合同id给水印文件赋值
     *
     * @param id 变更合同id
     */
    void asyncWatermarkById(Long id);

    /**
     * 历史价控合同价
     * @param contractVO
     * @return
     */
    List<ParamsCheckVO>  historyPriceCtrlContractPrice(PurchaseContractVO contractVO);

    ParamsCheckVO costPriceParams(MaterialCostPriceApiVO materialPriceHistoryApiVO);
}
