package com.ejianc.business.pricelib.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.pricelib.enums.PriceSourceTypeEnum;
import com.ejianc.business.pricelib.vo.PriceContractVO;
import com.ejianc.business.pricelib.vo.PriceLibVO;
import com.ejianc.business.pricelib.vo.PriceTrendVo;
import com.ejianc.business.pricelib.service.IPriceGuideDetailService;
import com.ejianc.business.pricelib.bean.*;
import com.ejianc.business.proequipmentcorppur.purchase.api.IContractCorpPurchaseApi;
import com.ejianc.business.purchase.bean.EquipmentDetailedEntity;
import com.ejianc.business.purchase.bean.PurchaseContractEntity;
import com.ejianc.business.purchase.enums.OutFlagEnum;
import com.ejianc.business.purchase.service.IPurchaseContractService;
import com.ejianc.business.settle.enums.SettleTypeEnum;
import com.ejianc.business.settlement.bean.PurchaseSettlementEntity;
import com.ejianc.business.settlement.service.IPurchaseSettlementService;
import com.ejianc.business.utils.DateUtils;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.*;
import com.ejianc.foundation.share.vo.*;
import com.ejianc.foundation.share.vo.dto.ProjectPoolDTO;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.*;
import com.google.common.collect.Maps;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.pricelib.mapper.PriceContractMapper;
import com.ejianc.business.pricelib.service.IPriceContractService;

import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 设备价格库清单明细实体
 * 
 * @author generator
 * 
 */
@Service("priceContractService")
public class PriceContractServiceImpl extends BaseServiceImpl<PriceContractMapper, PriceContractEntity> implements IPriceContractService{
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IPriceDepotPowerSetApi priceDepotPowerSetApi;
    @Autowired
    private IPriceGuideDetailService priceGuideDetailService;
    @Autowired
    private IPurchaseContractService contractService;
    @Autowired
    private IShareEquipmentApi shareEquipmentApi;
    @Autowired
    private IProjectSetApi projectSetApi;
    @Autowired
    private IPurchaseSettlementService settleService;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IParamConfigApi paramConfigApi;

    @Autowired
    private IContractCorpPurchaseApi contractCorpPurchaseApi;
    // 分包价格库查询类型 0、全部 1、综合单价
    private static final String PRICE_LIB_CHECK_TYPE = "P-5ukonG0162";

    /**
     * 查询价格库汇总信息
     *
     * @param param 查询参数
     * @return 查询结果
     */
    @Override
    public IPage<PriceLibVO> queryPriceLibListByTime(QueryParam param) {
        // 初始化参数
        logger.info("查询价格库，查询参数：{}", JSONObject.toJSONString(param));
        Date startDate;
        Date endDate;
        Map<String, Parameter> paramMap = param.getParams();
        if (paramMap.containsKey("startDate") && paramMap.containsKey("endDate")) {
            startDate = DateUtils.createDate(paramMap.get("startDate").getValue().toString());
            endDate = DateUtils.createDate(paramMap.get("endDate").getValue().toString());
            // 清除日期信息，保留其他查询条件
            paramMap.remove("startDate");
            paramMap.remove("endDate");
        }else {
            throw new BusinessException("查询日期不能为空");
        }
        List<Long> orgIdList = this.queryOrgIdList();
        List<PriceLibVO> priceLibList = this.queryPriceLibListAll(startDate, endDate, orgIdList, param);
        IPage<PriceLibVO> pageDate = new Page<>(param.getPageIndex(), param.getPageSize(), priceLibList.size());
        // 进行分页处理
        pageDate.setRecords(priceLibList.stream().skip((param.getPageIndex() - 1) * param.getPageSize())
                .limit(param.getPageSize()).collect(Collectors.toList()));
        return pageDate;
    }

    /**
     * 定时处理合同价格库明细
     * 如果传入日期为空，则为初始化，处理全部合同（已提交、审批通过）明细
     *
     * @param date 日期
     */
    @Override
    public void savePriceContractByTiming(Date date) {
        logger.info("========================价格库合同明细定时任务执行开始===========================");
        QueryParam queryParam = new QueryParam();
        List<PurchaseContractEntity> contractEntityList;
        String outLogDate = "";
        if (date != null) {
            // 日期不为空，则取大于上日日期数据
            Date qDate = DateUtils.calculationDay(date, -1);
            outLogDate = DateUtils.transformationDefaultDate(date);
            logger.info("执行定时任务，查询参数：{}", qDate);
            contractEntityList = baseMapper.getContractListByTime(qDate);
        }
        else {
            // 日期为空，默认为初始化，取提交后的数据
            queryParam.getComplexParams().add(ComplexParam.getApprovedComplexParam(ComplexParam.AND));
            contractEntityList = contractService.queryList(queryParam, false);
        }

        logger.info("执行日期：{}，查询合同结果：{}", outLogDate, JSONObject.toJSONString(contractEntityList));
        // 合同列表为空，不处理
        if (CollectionUtils.isEmpty(contractEntityList)) return;
        // 查询合同明细
        List<Long> contractIdList = contractEntityList.stream().map(PurchaseContractEntity::getId).collect(Collectors.toList());
        List<EquipmentDetailedEntity> allDocDetailEntityList = baseMapper.getContractDetailListByContractId(contractIdList);
        // 清单明细id对应清单名称，用于查询父级id的名称（档案分类名称）
        Map<Long, String> detailDocMap = allDocDetailEntityList.stream()
                .collect(Collectors
                        .toMap(EquipmentDetailedEntity::getId, EquipmentDetailedEntity::getEquipmentName, (key1, key2) -> key2));
        List<EquipmentDetailedEntity> detailEntityList = allDocDetailEntityList.stream().filter(e -> null != e.getDocId() && null != e.getEquipmentName()).collect(Collectors.toList());//过滤父子孙中的子级数据
        // 合同明细列表为空，不处理
        if (CollectionUtils.isEmpty(detailEntityList)) return;

        //查合同最终结算日期
        QueryParam settleParam = new QueryParam();
        settleParam.getParams().put("contract_id", new Parameter(QueryParam.IN, contractIdList));
        settleParam.getParams().put("bill_state", new Parameter(QueryParam.IN, Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        settleParam.getParams().put("signature_type", new Parameter(QueryParam.EQ, SettleTypeEnum.完工.getCode()));
        List<PurchaseSettlementEntity> settleList = settleService.queryList(settleParam);
        Map<Long, Date> settleDateMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(settleList)){
            settleDateMap = settleList.stream()
                    .collect(Collectors.toMap(PurchaseSettlementEntity::getContractId, PurchaseSettlementEntity::getSettlementDate,
                            (key1, key2) -> key2));
        }


        // 查询档案内码
        List<Long> docCategoryIdList = detailEntityList.stream().map(EquipmentDetailedEntity::getDocCategoryId)
                .distinct().collect(Collectors.toList());
        List<Long> docIs = detailEntityList.stream().filter(item -> null != item.getPurchaseNum()).map(EquipmentDetailedEntity::getDocId).distinct().collect(Collectors.toList());
        CommonResponse<List<EquipmentCategoryVO>> equipmentDocResponse = shareEquipmentApi
                .queryCategoryListByIds(docCategoryIdList);


        Map<Long, String> docCategoryMap = new HashMap<>();
        Map<Long,EquipmentVO> docItemMap = new HashMap();
        logger.info("查询设备档案内码，查询结果：{}", JSONObject.toJSONString(equipmentDocResponse));
        if (equipmentDocResponse.isSuccess()) {
            List<EquipmentCategoryVO> equipmentDocCategoryVOList = equipmentDocResponse.getData();
            docCategoryMap = equipmentDocCategoryVOList.stream()
                    .collect(Collectors.toMap(EquipmentCategoryVO::getId, EquipmentCategoryVO::getInnerCode,
                            (key1, key2) -> key2));
            CommonResponse<List<EquipmentVO>> equipmentDocItemResponse = shareEquipmentApi
                    .queryEquipmentItemByIds(docIs);
            if(equipmentDocItemResponse.isSuccess()) {
                logger.info("查询设备档案清单列表：{}", JSONObject.toJSONString(equipmentDocItemResponse.getData()));
                docItemMap = equipmentDocItemResponse.getData().stream().collect(
                        Collectors.toMap(EquipmentVO::getId, (p) -> p));
            } else {
                logger.error("查询设备档案信息失败，{}", JSONObject.toJSONString(equipmentDocItemResponse));
            }

        }else {
            logger.error("查询设备档案信分类息失败，{}", JSONObject.toJSONString(equipmentDocResponse));
        }


        // 查询项目信息
        List<Long> projectIdList = contractEntityList.stream().map(PurchaseContractEntity::getProjectId)
                .distinct().collect(Collectors.toList());
        CommonResponse<List<ProjectPoolDTO>> projectResponse = projectSetApi.getProjectListIds(projectIdList);
        logger.info("查询项目地址，查询结果：{}", JSONObject.toJSONString(projectResponse));
        Map<Long, String> projectAreaMap = new HashMap<>();
        Map<Long, String> projectAreaNameMap = new HashMap<>();
        if (projectResponse.isSuccess()) {
            List<ProjectPoolDTO> projectPoolList = projectResponse.getData();
            projectAreaMap = projectPoolList.stream().filter(t -> StringUtils.isNotEmpty(t.getArea()))
                    .collect(Collectors.toMap(ProjectPoolDTO::getId, ProjectPoolDTO::getArea, (key1, key2) -> key2));
            projectAreaNameMap = projectPoolList.stream().filter(t -> StringUtils.isNotEmpty(t.getAreaName()))
                    .collect(Collectors
                            .toMap(ProjectPoolDTO::getId, ProjectPoolDTO::getAreaName, (key1, key2) -> key2));
        }

        // 清单明细按合同id分组
        Map<Long, List<EquipmentDetailedEntity>> detailMap = detailEntityList.stream()
                .collect(Collectors.groupingBy(EquipmentDetailedEntity::getContractId));

        // 处理合同及合同明细
        // 进行插入数据组装
        List<PriceContractEntity> saveEntityList = new ArrayList<>();
        for (PurchaseContractEntity entity : contractEntityList) {
            List<EquipmentDetailedEntity> entityDetailList = detailMap.get(entity.getId());
            if (CollectionUtils.isEmpty(entityDetailList)) continue;
            //合同地址
//            String cardType = "";
//            if (entity.getAddType()==1){
//                if (entity.getContractType()==1){
//                    //专业
//                    cardType = "proSubDirectCard";
//                }else if(entity.getContractType()==0) {
//                    //劳务
//                    cardType = "laborSubDirectCard";
//                }
//                //直接新增
//            }else if (entity.getAddType()==0){
//                //参照定标结果
//                if (entity.getContractType()==1){
//                    //劳务
//                    cardType ="laborSubCard";
//                }else if(entity.getContractType()==0) {
//                    //专业
//                    cardType ="proSubCard";
//                }
//            }
            for (EquipmentDetailedEntity detailEntity : entityDetailList) {
                // 档案id为空不做价格库处理（大类不处理）
                if (detailEntity.getDocId() == null) continue;
                PriceContractEntity priceContractEntity = BeanMapper.map(entity, PriceContractEntity.class);
                //设置最终结算日期
                priceContractEntity.setSettlementDate(settleDateMap.get(entity.getId()));

                //主合同信息
                priceContractEntity.setContractId(entity.getId());
                priceContractEntity.setContractName(entity.getContractName());
                priceContractEntity.setContractCode(entity.getBillCode());
                priceContractEntity.setContractFlag(entity.getSupplementFlag());
                priceContractEntity.setSignDate(entity.getSignDate());
                priceContractEntity.setPerformanceStatus(entity.getContractPerformanceState());

                priceContractEntity.setPcCardUrl("/ejc-proequipmentp-frontend/#/machineryPurchaseContract/cardList?id=" + entity.getId());

                priceContractEntity.setArea(projectAreaMap.get(entity.getProjectId())); // 项目地区  查询项目获取
                priceContractEntity.setAreaName(projectAreaNameMap.get(entity.getProjectId())); // 项目地区  查询项目获取

                priceContractEntity.setTargetResultId(entity.getTargetResultId());
                priceContractEntity.setSourceId(detailEntity.getId());
                priceContractEntity.setSourceType(PriceSourceTypeEnum.设备购置合同.getCode());

                // 子表信息
                priceContractEntity.setContractTaxRate(detailEntity.getTaxRate());
                priceContractEntity.setContractNum(new BigDecimal(detailEntity.getPurchaseNum()));
                priceContractEntity.setContractPrice(null != detailEntity.getPurchasePricetNoTax() ? detailEntity.getPurchasePricetNoTax() : BigDecimal.ZERO);
                priceContractEntity.setContractTaxPrice(null != detailEntity.getPurchasePrice() ? detailEntity.getPurchasePrice() : BigDecimal.ZERO);
                priceContractEntity.setContractMny(null != detailEntity.getPurchaseAmountNoTax() ? detailEntity.getPurchaseAmountNoTax() : BigDecimal.ZERO);
                priceContractEntity.setContractTaxMny(null != detailEntity.getPurchaseAmount() ? detailEntity.getPurchaseAmount() : BigDecimal.ZERO);
                priceContractEntity.setMemo(detailEntity.getDetailMemo());
                priceContractEntity.setSpec(detailEntity.getSpec());
                priceContractEntity.setManufacturer(detailEntity.getManufacturer());

                priceContractEntity.setDocId(detailEntity.getDocId());
                priceContractEntity.setDocCode(detailEntity.getEquipmentCode());
                priceContractEntity.setDocName(detailEntity.getEquipmentName());
                priceContractEntity.setDocCategoryId(detailEntity.getDocCategoryId());

                priceContractEntity.setDocInnerCode(docCategoryMap.get(detailEntity.getDocCategoryId())); // 分类内码，查询获取
                if(null!=docItemMap&&null!=detailEntity.getDocId()){
                    priceContractEntity.setEquipmentHeight(docItemMap.get(detailEntity.getDocId()).getEquipmentHeight());
                }
                //计量单位
                priceContractEntity.setUnitName(detailEntity.getCompany());

                priceContractEntity.setOutFlag(OutFlagEnum.未移除.getCode());
                priceContractEntity.setId(null);
                priceContractEntity.setCreateTime(null);
                priceContractEntity.setCreateUserCode(null);
                priceContractEntity.setUpdateTime(null);
                priceContractEntity.setUpdateUserCode(null);
                priceContractEntity.setDr(detailEntity.getDr());
                saveEntityList.add(priceContractEntity);
            }
        }
        logger.info("获取设备公司数据前数据条数：" + saveEntityList.size());
        //获取设备公司购置数据
        //获取设备公司租出数据
        CommonResponse<List<PriceContractVO>> corpPurchaseResponse = contractCorpPurchaseApi.getPriceContractDataByCorpPurchase(date != null ? "1" : "0");
        logger.info("获取设备公司购置合同数据，查询结果：{}", JSONObject.toJSONString(corpPurchaseResponse));
        if (corpPurchaseResponse.isSuccess()) {
            List<PriceContractVO> corpOutContractList = corpPurchaseResponse.getData();
            saveEntityList.addAll(BeanMapper.mapList(corpOutContractList, PriceContractEntity.class));
        }
        logger.info("获取设备公司数据后数据条数：" + saveEntityList.size());

        // 查询是否为修改
        if (CollectionUtils.isEmpty(saveEntityList)) return;
        List<Long> sourceDetailIdList = saveEntityList.stream().map(PriceContractEntity::getSourceId)
                .collect(Collectors.toList());
        // 查询数据库
        QueryParam priceParam = new QueryParam();
        priceParam.getParams().put("sourceId", new Parameter(QueryParam.IN, sourceDetailIdList));
        List<PriceContractEntity> queryPriceList = super.queryList(priceParam, false);
        if (CollectionUtils.isNotEmpty(queryPriceList)) {
            // sourceId,id
            Map<Long, PriceContractEntity> queryPriceMap = queryPriceList.stream()
                    .collect(Collectors.toMap(PriceContractEntity::getSourceId, Function.identity(),
                            (key1, key2) -> key2));
            for (PriceContractEntity entity : saveEntityList) {
                PriceContractEntity queryEntity = queryPriceMap.get(entity.getSourceId());
                if (queryEntity != null) {
                    entity.setId(queryEntity.getId());
                    entity.setOutFlag(queryEntity.getOutFlag());
                }
            }
        }
        // 批量变更保存数据
//        logger.info("入库数据：{}", JSONObject.toJSONString(saveEntityList));
        super.saveOrUpdateBatch(saveEntityList);
        // 删除bill_state非1和3的数据
        // 不使用物理删除，使用逻辑删除
        QueryWrapper<PriceContractEntity> wrapper = new QueryWrapper<>();
        wrapper.notIn("bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(),
                BillStateEnum.PASSED_STATE.getBillStateCode()));
        super.remove(wrapper, false);
        // 删除dr!=0的数据
        // 删除的id
        List<Long> delIdList = saveEntityList.stream().filter(t -> t.getDr() != 0).map(PriceContractEntity::getId)
                .collect(Collectors.toList());
//        logger.info("删除数据id：{}",JSONObject.toJSONString(delIdList));
        if (CollectionUtils.isNotEmpty(delIdList)) {
            super.removeByIds(delIdList, false);
        }
        logger.info("========================价格库合同明细定时任务执行结束===========================");
    }

    /**
     * 根据档案id查询价格库信息
     *
     * @param param 查询参数
     * @return 查询结果
     */
    @Override
    public PriceLibVO queryPriceLibDetail(QueryParam param) {
        Map<String, Date> checkMap = this.checkQueryParam(param);
        Date startDate = checkMap.get("startDate");
        Date endDate = checkMap.get("endDate");
        List<Long> orgIdList = this.queryOrgIdList();
        List<PriceLibVO> priceLibList = this.queryPriceLibListAll(startDate, endDate, orgIdList, param);
//        if (CollectionUtils.isEmpty(priceLibList)) throw new BusinessException("查询详情失败！");
        return priceLibList.get(0);
    }

    @Override
    public List<PriceTrendVo> queryPriceTrendContractList(QueryParam param) {
        Map<String, Date> checkMap = this.checkQueryParam(param);
        Date startDate = checkMap.get("startDate");
        Date endDate = checkMap.get("endDate");
        List<Long> orgIdList = this.queryOrgIdList();
        List<PriceTrendVo> rtnList;
        // list转Map，同一天只会有一个价格
        Map<String, PriceTrendVo> trendMap = new HashMap<>();
        // 查询价格库合同明细
        List<PriceContractEntity> priceContractList = this.queryPriceContractList(startDate, orgIdList, param);
        if (CollectionUtils.isNotEmpty(priceContractList)) {
            Map<Date, List<PriceContractEntity>> contractMap = priceContractList.stream()
                    .collect(Collectors.groupingBy(PriceContractEntity::getSignDate));
            for (Map.Entry<Date, List<PriceContractEntity>> entry : contractMap.entrySet()) {
                List<PriceContractEntity> list = entry.getValue();
                if (CollectionUtils.isEmpty(list)) continue;
                PriceContractEntity priceContractEntity = list.get(0);
                List<BigDecimal> priceList = list.stream().map(PriceContractEntity::getContractPrice).collect(Collectors.toList());
                List<BigDecimal> taxPriceList = list.stream().map(PriceContractEntity::getContractTaxPrice).collect(Collectors.toList());
                BigDecimal num = BigDecimal.ZERO;
                BigDecimal mny = BigDecimal.ZERO;
                BigDecimal taxMny = BigDecimal.ZERO;
                BigDecimal avgPrice = BigDecimal.ZERO;
                BigDecimal taxAvgPrice = BigDecimal.ZERO;
                for (PriceContractEntity entity : list) {
                    num = num.add(entity.getContractNum());
                    mny = mny.add(entity.getContractMny());
                    taxMny = taxMny.add(entity.getContractTaxMny());
                }
                if (num.compareTo(BigDecimal.ZERO) != 0) {
                    avgPrice = mny.divide(num, 4, BigDecimal.ROUND_HALF_UP);
                    taxAvgPrice = taxMny.divide(num, 4, BigDecimal.ROUND_HALF_UP);
                }
                PriceTrendVo vo;
                String dateStr = DateUtils.transformationDefaultDate(entry.getKey());
                if (trendMap.containsKey(dateStr)) {
                    vo = trendMap.get(dateStr);
                }
                else {
                    vo = new PriceTrendVo();
                    trendMap.put(dateStr, vo);
                }
                vo.setContractPrice(priceContractEntity.getContractPrice());
                vo.setContractTaxPrice(priceContractEntity.getContractTaxPrice());
                vo.setContractNum(num);
                vo.setContractAvgPrice(avgPrice);
                vo.setContractMaxPrice(Collections.max(priceList).divide(BigDecimal.ONE, 4, BigDecimal.ROUND_HALF_UP));
                vo.setContractMinPrice(Collections.min(priceList).divide(BigDecimal.ONE, 4, BigDecimal.ROUND_HALF_UP));
                vo.setContractTaxAvgPrice(taxAvgPrice);
                vo.setContractTaxMaxPrice(Collections.max(taxPriceList).divide(BigDecimal.ONE, 4, BigDecimal.ROUND_HALF_UP));
                vo.setContractTaxMinPrice(Collections.min(taxPriceList).divide(BigDecimal.ONE, 4, BigDecimal.ROUND_HALF_UP));
                vo.setPriceDate(DateUtils.transformationDefaultDate(entry.getKey()));
            }
        }
        // map转list
        rtnList = new ArrayList<>(trendMap.values());
        // 按照日期排序
        if (CollectionUtils.isNotEmpty(rtnList)) {
            rtnList.sort(Comparator.comparing(PriceTrendVo::getPriceDate));
        }
        return rtnList;
    }

    /**
     * 移除合同明细
     *
     * @param id 明细id
     */
    @Override
    public void removePriceContractDetail(Long id) {
        PriceContractEntity entity = super.selectById(id);
        if (entity == null) throw new BusinessException("明细不存在");
        entity.setOutFlag(OutFlagEnum.已移除.getCode());
        super.saveOrUpdate(entity, false);
    }

    /**
     * 根据档案id查询对应的价格库合同明细
     *
     * @param param 查询参数
     * @return 查询结果
     */
    @Override
    public IPage<PriceContractVO> queryPriceContractListDetail(QueryParam param) {
        Map<String, Date> checkMap = this.checkQueryParam(param);
        Date startDate = checkMap.get("startDate");
        Date endDate = checkMap.get("endDate");
        if (param.getOrderMap().isEmpty()) {
            param.getOrderMap().put("signDate",QueryParam.DESC);
            param.getOrderMap().put("contractMny",QueryParam.DESC);
        }
        List<Long> orgIdList = this.queryOrgIdList();
        List<PriceContractEntity> priceContractList = this.queryPriceContractList(startDate, orgIdList, param);
        List<PriceContractVO> voList;
        IPage<PriceContractVO> pageDate = new Page<>(param.getPageIndex(), param.getPageSize(), priceContractList.size());
        if (CollectionUtils.isEmpty(priceContractList)) return pageDate;
        voList = BeanMapper.mapList(priceContractList, PriceContractVO.class);
        // 处理合同URL
        List<Long> myOrgList = this.getMyOrgList();
        for (PriceContractVO vo : voList) {
            if (!myOrgList.contains(vo.getOrgId())) {
                vo.setPcCardUrl(null);
            }
        }
        // 进行分页处理
        pageDate.setRecords(voList.stream().skip((param.getPageIndex() - 1) * param.getPageSize())
                .limit(param.getPageSize()).collect(Collectors.toList()));
        return pageDate;
    }
    /**
     * 查询当前组织本下
     * @return 组织本下list
     */
    private List<Long> getMyOrgList() {
        CommonResponse<List<OrgVO>> orgVOResp = iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId());
        if (!orgVOResp.isSuccess()) {
            throw new BusinessException("查询组织信息失败！");
        }
        List<OrgVO> orgVOList = orgVOResp.getData();
        if (CollectionUtils.isNotEmpty(orgVOList)) {
            return orgVOList.stream().map(OrgVO::getId).collect(Collectors.toList());
        }
        return new ArrayList<>();
    }


    /**
     * 校验查询条件
     *
     * @param param 查询条件
     * @return 日期
     */
    private Map<String, Date> checkQueryParam(QueryParam param) {
        Date startDate;
        Date endDate;
        Map<String, Parameter> paramMap = param.getParams();
        if (paramMap.containsKey("startDate") && paramMap.containsKey("endDate")) {
            startDate = DateUtils.createDate(paramMap.get("startDate").getValue().toString());
            endDate = DateUtils.createDate(paramMap.get("endDate").getValue().toString());
            // 清除日期信息，保留其他查询条件
            paramMap.remove("startDate");
            paramMap.remove("endDate");
        }
        else {
            throw new BusinessException("查询日期不能为空");
        }
        if (!paramMap.containsKey("docId")) {
            throw new BusinessException("查询档案id不能为空！");
        }
        Map<String, Date> rtnMap = new HashMap<>();
        rtnMap.put("startDate", startDate);
        rtnMap.put("endDate", endDate);
        return rtnMap;
    }


    /**
     * 查询价格库信息(参照查询列表查询都走此方法)
     *
     * @param startDate 开始日期
     * @param endDate   结束日期
     * @param orgIdList 查询结果
     * @param param     查询条件
     * @return 查询结果
     */
    private List<PriceLibVO> queryPriceLibListAll(Date startDate, Date endDate, List<Long> orgIdList,
                                                  QueryParam param) {

        Map<Long, PriceLibVO> map = new HashMap<>();
        this.queryPriceContractGroupByDocId(map, startDate, orgIdList, param);
        this.queryPriceGuide(map);
        List<PriceLibVO> priceLibList = new ArrayList<>(map.values());
        if (CollectionUtils.isNotEmpty(priceLibList)) {
            priceLibList.sort(Comparator.comparing(PriceLibVO::getDocCode, Comparator.nullsLast(String::compareTo)));
        }
        return priceLibList;
    }

    /**
     * 查询合同价格库信息 通过档案id查询该有该档案的合同
     *
     * @param libMap    价格库组装列表
     * @param startDate 开始日期
     * @param orgIdList 权限列表
     * @return 合同价格库列表
     */
    private void queryPriceContractGroupByDocId(Map<Long, PriceLibVO> libMap, Date startDate,
                                                List<Long> orgIdList, QueryParam param) {
        // 截止到当前日期状态为履约中的合同+已终止、已结束的合同取对应最终结算日期大于等于开始日期的合同
        List<PriceContractEntity> priceContractList = this.queryPriceContractList(startDate, orgIdList, param);
        if (CollectionUtils.isEmpty(priceContractList)) return;
        // 按照档案Id分组
        Map<Long, List<PriceContractEntity>> priceContractMap = priceContractList.stream()
                .collect(Collectors.groupingBy(PriceContractEntity::getDocId));
        // 汇总信息
        for (Map.Entry<Long, List<PriceContractEntity>> entry : priceContractMap.entrySet()) {
            Long key = entry.getKey();
            List<PriceContractEntity> value = entry.getValue();
            List<BigDecimal> priceList = value.stream().map(PriceContractEntity::getContractPrice).collect(Collectors.toList());
            List<BigDecimal> taxPriceList = value.stream().map(PriceContractEntity::getContractTaxPrice).collect(Collectors.toList());
            // 获取高频单价
            BigDecimal highFrequencyPrice =   getHighFrequencyPrice(priceList);
            BigDecimal highFrequencyTaxPrice =   getHighFrequencyPrice(taxPriceList);

            PriceContractEntity priceContract = value.get(0);
            if (priceContract == null) continue;
            BigDecimal num = BigDecimal.ZERO; // 数量
            BigDecimal mny = BigDecimal.ZERO; // 金额(无税)
            BigDecimal taxRate = BigDecimal.ZERO; // 税率
            BigDecimal taxMny = BigDecimal.ZERO; // 金额(含税)
            BigDecimal avgPrice = BigDecimal.ZERO; // 合同均价(无税)
            // 合同最高价(无税)
            BigDecimal maxPrice = Collections.max(priceList).divide(BigDecimal.ONE, 4, BigDecimal.ROUND_HALF_UP);
            // 合同最低价(无税)
            BigDecimal minPrice = Collections.min(priceList).divide(BigDecimal.ONE, 4, BigDecimal.ROUND_HALF_UP);
            String priceArea = minPrice + "-" + maxPrice; // 合同价格区间（无税）
            BigDecimal taxAvgPrice = BigDecimal.ZERO; // 合同均价（含税）
            // 合同最高价（含税）
            BigDecimal taxMaxPrice = Collections.max(taxPriceList).divide(BigDecimal.ONE, 4, BigDecimal.ROUND_HALF_UP);
            // 合同最低价（含税）
            BigDecimal taxMinPrice = Collections.min(taxPriceList).divide(BigDecimal.ONE, 4, BigDecimal.ROUND_HALF_UP);
            String taxPriceArea = taxMinPrice + "-" + taxMaxPrice; // 合同价格区间（含税）
            for (PriceContractEntity entity : value) {
                num = num.add(entity.getContractNum());
                mny = mny.add(entity.getContractMny());
                taxMny = taxMny.add(entity.getContractTaxMny());
            }
            if (num.compareTo(BigDecimal.ZERO) != 0) {
                avgPrice = mny.divide(num, 4, BigDecimal.ROUND_HALF_UP);
                taxAvgPrice = taxMny.divide(num, 4, BigDecimal.ROUND_HALF_UP);
            }
            taxRate = this.calculationTaxRate(taxMny, mny);
            PriceLibVO priceLibVO;
            if (libMap.containsKey(key)) {
                priceLibVO = libMap.get(key);
            } else {
                priceLibVO = new PriceLibVO();
                priceLibVO.setDocId(priceContract.getDocId());
                priceLibVO.setDocCode(priceContract.getDocCode());
                priceLibVO.setDocName(priceContract.getDocName());
                priceLibVO.setDocCategoryId(priceContract.getDocCategoryId());
                priceLibVO.setDocCategoryName(priceContract.getDocCategoryName());
                priceLibVO.setUnitId(priceContract.getUnitId());
                priceLibVO.setUnitName(priceContract.getUnitName());
                priceLibVO.setDocInnerCode(priceContract.getDocInnerCode());
                priceLibVO.setUnitName(priceContract.getUnitName());
                priceLibVO.setSpec(priceContract.getSpec());
                libMap.put(priceContract.getDocId(), priceLibVO);
            }
            priceLibVO.setContractNum(num);
            priceLibVO.setContractMny(mny);
            priceLibVO.setContractTaxRate(taxRate);
            priceLibVO.setContractTaxMny(taxMny);
            priceLibVO.setContractAvgPrice(avgPrice);
            priceLibVO.setContractMaxPrice(maxPrice);
            priceLibVO.setContractMinPrice(minPrice);
            priceLibVO.setContractPriceArea(priceArea);
            priceLibVO.setContractTaxAvgPrice(taxAvgPrice);
            priceLibVO.setContractTaxMaxPrice(taxMaxPrice);
            priceLibVO.setContractTaxMinPrice(taxMinPrice);
            priceLibVO.setContractTaxPriceArea(taxPriceArea);
            priceLibVO.setId(priceLibVO.getDocId());
            priceLibVO.setEquipmentHeight(priceContract.getEquipmentHeight());
            priceLibVO.setHigjFrequencyPrice(highFrequencyPrice);
            priceLibVO.setHigjFrequencyTaxPrice(highFrequencyTaxPrice);
            priceLibVO.setTax(taxMny.subtract(mny));
            // TODO: 2022/8/29 市场价赋值
        }
    }
    public BigDecimal getHighFrequencyPrice(List<BigDecimal> priceList){
        HashMap<BigDecimal,Integer> map = Maps.newHashMap();
        Integer MaxNum = 0;
        BigDecimal HighFrequencyPrice = null;
        for(BigDecimal price:priceList){
            if(map.containsKey(price)){
                Integer num = map.get(price)+1;
                map.put(price,num);
                if(num>MaxNum){
                    MaxNum = num;
                    HighFrequencyPrice = price;
                }
            }else{
                map.put(price,1);
            }
        }
        return HighFrequencyPrice;
    }
    /**
     * 查询符合条件的价格库合同明细
     *
     * @param startDate 开始日期
     * @param orgIdList 权限列表
     * @param param     查询参数
     * @return 查询结果
     */
    private List<PriceContractEntity> queryPriceContractList(Date startDate, List<Long> orgIdList,
                                                             QueryParam param) {
        // 截止到当前日期状态为履约中的合同+已终止、已结束的合同取对应最终结算日期大于等于开始日期的合同
        QueryParam contractParam = new QueryParam();
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = contractParam.getFuzzyFields();
        fuzzyFields.add("docCode");
        fuzzyFields.add("docName");
        fuzzyFields.add("unitName");
        fuzzyFields.add("area");
        fuzzyFields.add("areaName");
        contractParam.setSearchText(param.getSearchText());
        contractParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        contractParam.getParams().put("outFlag", new Parameter(QueryParam.EQ, OutFlagEnum.未移除.getCode()));

        // 分包价格库查询价格类型
//        CommonResponse<ParamRegisterSetVO> response = paramConfigApi.getByCode(PRICE_LIB_CHECK_TYPE);
//        if (!response.isSuccess() || response.getData() == null) {
//            throw new BusinessException("获取分包价格库查询价格类型系统参数请求失败，失败原因：" + response.getMsg());
//        }
//        String valueData = response.getData().getValueData();
//        if (StringUtils.isNotBlank(valueData) && !valueData.contains("全部")){
//            contractParam.getParams().put("priceTypeName", new Parameter(QueryParam.IN, Arrays.asList(valueData.split(","))));
//        }

        if (CollectionUtils.isNotEmpty(orgIdList)) {
            contractParam.getParams().put("orgId", new Parameter(QueryParam.IN, orgIdList));
        }
        if (param != null) {
            contractParam.getParams().putAll(param.getParams());
            if (CollectionUtils.isNotEmpty(param.getComplexParams())) {
                contractParam.getComplexParams().addAll(param.getComplexParams());
            }
            if (!param.getOrderMap().isEmpty()) {
                contractParam.getOrderMap().putAll(param.getOrderMap());
            }
        }
        ComplexParam c1 = new ComplexParam();
        c1.setLogic(ComplexParam.AND);
        // 履约中
        ComplexParam c2 = new ComplexParam();
        c2.setLogic(ComplexParam.OR);
        c2.getParams().put("performance_status", new Parameter(QueryParam.IN, Arrays.asList(2, 5)));
//        c2.getParams().put("sign_date", new Parameter(QueryParam.GE, startDate));
        c1.getComplexParams().add(c2);
        // 签订日期大于等于开始日期的合同
        ComplexParam c3 = new ComplexParam();
        c3.setLogic(ComplexParam.OR);
        // 履约中+已冻结+已终止+已结束
        c3.getParams().put("performance_status", new Parameter(QueryParam.IN, Arrays.asList(3, 6)));
        c3.getParams().put("settlement_date", new Parameter(QueryParam.GE, startDate));
        c1.getComplexParams().add(c3);
        contractParam.getComplexParams().add(c1);
        return super.queryList(contractParam, false);
    }


    /**
     * 查询组织权限
     * 数据权限范围：
     * 通过当前上下文组织查询本上是否设置价格保密（从价格库权限设置中查询）。
     * 查到本上第一个设置价格保密的组织，以这个组织查询本下数据。
     * 如没有查到设置价格保密的组织，那么以根组织查询本下数据；
     *
     * @return 权限列表
     */
    private List<Long> queryOrgIdList() {
        CommonResponse<List<Long>> orgIdListResponse = priceDepotPowerSetApi
                .queryOrgList(InvocationInfoProxy.getOrgId());
        logger.info("查询组织权限，查询结果：{}", JSONObject.toJSONString(orgIdListResponse));
        if (!orgIdListResponse.isSuccess()) {
            throw new BusinessException("查询组织权限失败:" + orgIdListResponse.getMsg());
        }
        return orgIdListResponse.getData();
    }


    /**
     * 计算税率（（含税/无税 - 1）*100）
     *
     * @param taxMny 含税金额
     * @param mny    无税金额
     * @return 税率
     */
    private BigDecimal calculationTaxRate(BigDecimal taxMny, BigDecimal mny) {
        BigDecimal b = new BigDecimal("100");
        if (mny.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        return taxMny.divide(mny, 4, BigDecimal.ROUND_HALF_UP).subtract(BigDecimal.ONE).multiply(b);
    }

    /**
     * 查询公司指导价
     *
     * @param libMap 价格库信息
     */
    private void queryPriceGuide(Map<Long, PriceLibVO> libMap) {
        if (libMap.isEmpty()) return;
        List<Long> docIdList = new ArrayList<>(libMap.keySet());
        List<PriceGuideDetailEntity> list = priceGuideDetailService.queryPriceGuideDetailByDocIds(docIdList);
        if (CollectionUtils.isEmpty(list)) return;
        Map<Long, PriceGuideDetailEntity> guideMap = list.stream().collect(Collectors
                .toMap(PriceGuideDetailEntity::getDocId, Function.identity(), (key1, key2) -> key1));
        for (Map.Entry<Long, PriceLibVO> entry : libMap.entrySet()) {
            Long docId = entry.getKey();
            PriceLibVO vo = entry.getValue();
            if (guideMap.containsKey(docId)) {
                PriceGuideDetailEntity guide = guideMap.get(docId);
                BigDecimal min = guide.getMinPrice() == null ? BigDecimal.ZERO : guide.getMinPrice();
                BigDecimal max = guide.getMaxPrice() == null ? BigDecimal.ZERO : guide.getMaxPrice();
                min = min.divide(BigDecimal.ONE, 4, BigDecimal.ROUND_HALF_UP);
                max = max.divide(BigDecimal.ONE, 4, BigDecimal.ROUND_HALF_UP);
                vo.setGuidePriceArea(min + "-" + max);
            }
        }
    }
}
