/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pricelib.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.pricelib.bean.PriceContractEntity;
import com.ejianc.business.pricelib.bean.PriceGuideDetailEntity;
import com.ejianc.business.pricelib.enums.PriceSourceTypeEnum;
import com.ejianc.business.pricelib.mapper.PriceContractMapper;
import com.ejianc.business.pricelib.service.IPriceContractService;
import com.ejianc.business.pricelib.service.IPriceGuideDetailService;
import com.ejianc.business.pricelib.vo.PriceContractVO;
import com.ejianc.business.pricelib.vo.PriceLibVO;
import com.ejianc.business.pricelib.vo.PriceTrendVo;
import com.ejianc.business.proequipmentcorppur.purchase.api.IContractCorpPurchaseApi;
import com.ejianc.business.purchase.bean.EquipmentDetailedEntity;
import com.ejianc.business.purchase.bean.PurchaseContractEntity;
import com.ejianc.business.purchase.enums.OutFlagEnum;
import com.ejianc.business.purchase.service.IPurchaseContractService;
import com.ejianc.business.settle.enums.SettleTypeEnum;
import com.ejianc.business.settlement.bean.PurchaseSettlementEntity;
import com.ejianc.business.settlement.service.IPurchaseSettlementService;
import com.ejianc.business.utils.DateUtils;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.api.IPriceDepotPowerSetApi;
import com.ejianc.foundation.share.api.IProjectSetApi;
import com.ejianc.foundation.share.api.IShareEquipmentApi;
import com.ejianc.foundation.share.vo.EquipmentCategoryVO;
import com.ejianc.foundation.share.vo.EquipmentVO;
import com.ejianc.foundation.share.vo.dto.ProjectPoolDTO;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="priceContractService")
public class PriceContractServiceImpl
extends BaseServiceImpl<PriceContractMapper, PriceContractEntity>
implements IPriceContractService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IPriceDepotPowerSetApi priceDepotPowerSetApi;
    @Autowired
    private IPriceGuideDetailService priceGuideDetailService;
    @Autowired
    private IPurchaseContractService contractService;
    @Autowired
    private IShareEquipmentApi shareEquipmentApi;
    @Autowired
    private IProjectSetApi projectSetApi;
    @Autowired
    private IPurchaseSettlementService settleService;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private IContractCorpPurchaseApi contractCorpPurchaseApi;
    private static final String PRICE_LIB_CHECK_TYPE = "P-5ukonG0162";

    @Override
    public IPage<PriceLibVO> queryPriceLibListByTime(QueryParam param) {
        this.logger.info("\u67e5\u8be2\u4ef7\u683c\u5e93\uff0c\u67e5\u8be2\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)param));
        Map paramMap = param.getParams();
        if (!paramMap.containsKey("startDate") || !paramMap.containsKey("endDate")) {
            throw new BusinessException("\u67e5\u8be2\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Date startDate = DateUtils.createDate(((Parameter)paramMap.get("startDate")).getValue().toString());
        Date endDate = DateUtils.createDate(((Parameter)paramMap.get("endDate")).getValue().toString());
        paramMap.remove("startDate");
        paramMap.remove("endDate");
        List<Long> orgIdList = this.queryOrgIdList();
        List<PriceLibVO> priceLibList = this.queryPriceLibListAll(startDate, endDate, orgIdList, param);
        Page pageDate = new Page((long)param.getPageIndex(), (long)param.getPageSize(), (long)priceLibList.size());
        pageDate.setRecords(priceLibList.stream().skip((param.getPageIndex() - 1) * param.getPageSize()).limit(param.getPageSize()).collect(Collectors.toList()));
        return pageDate;
    }

    @Override
    public void savePriceContractByTiming(Date date) {
        List<PurchaseContractEntity> contractEntityList;
        this.logger.info("========================\u4ef7\u683c\u5e93\u5408\u540c\u660e\u7ec6\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u5f00\u59cb===========================");
        QueryParam queryParam = new QueryParam();
        String outLogDate = "";
        if (date != null) {
            Date qDate = DateUtils.calculationDay(date, -1);
            outLogDate = DateUtils.transformationDefaultDate(date);
            this.logger.info("\u6267\u884c\u5b9a\u65f6\u4efb\u52a1\uff0c\u67e5\u8be2\u53c2\u6570\uff1a{}", (Object)qDate);
            contractEntityList = ((PriceContractMapper)this.baseMapper).getContractListByTime(qDate);
        } else {
            queryParam.getComplexParams().add(ComplexParam.getApprovedComplexParam((String)"and"));
            contractEntityList = this.contractService.queryList(queryParam, false);
        }
        this.logger.info("\u6267\u884c\u65e5\u671f\uff1a{}\uff0c\u67e5\u8be2\u5408\u540c\u7ed3\u679c\uff1a{}", (Object)outLogDate, (Object)JSONObject.toJSONString((Object)contractEntityList));
        if (CollectionUtils.isEmpty(contractEntityList)) {
            return;
        }
        List<Long> contractIdList = contractEntityList.stream().map(BaseEntity::getId).collect(Collectors.toList());
        List<EquipmentDetailedEntity> allDocDetailEntityList = ((PriceContractMapper)this.baseMapper).getContractDetailListByContractId(contractIdList);
        Map<Long, String> detailDocMap = allDocDetailEntityList.stream().collect(Collectors.toMap(BaseEntity::getId, EquipmentDetailedEntity::getEquipmentName, (key1, key2) -> key2));
        List detailEntityList = allDocDetailEntityList.stream().filter(e -> null != e.getDocId() && null != e.getEquipmentName()).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(detailEntityList)) {
            return;
        }
        QueryParam settleParam = new QueryParam();
        settleParam.getParams().put("contract_id", new Parameter("in", contractIdList));
        settleParam.getParams().put("bill_state", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        settleParam.getParams().put("signature_type", new Parameter("eq", (Object)SettleTypeEnum.\u5b8c\u5de5.getCode()));
        List settleList = this.settleService.queryList(settleParam);
        Map<Object, Object> settleDateMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)settleList)) {
            settleDateMap = settleList.stream().collect(Collectors.toMap(PurchaseSettlementEntity::getContractId, PurchaseSettlementEntity::getSettlementDate, (key1, key2) -> key2));
        }
        List docCategoryIdList = detailEntityList.stream().map(EquipmentDetailedEntity::getDocCategoryId).distinct().collect(Collectors.toList());
        List docIs = detailEntityList.stream().filter(item -> null != item.getPurchaseNum()).map(EquipmentDetailedEntity::getDocId).distinct().collect(Collectors.toList());
        CommonResponse equipmentDocResponse = this.shareEquipmentApi.queryCategoryListByIds(docCategoryIdList);
        Map<Object, Object> docCategoryMap = new HashMap();
        Map<Object, Object> docItemMap = new HashMap();
        this.logger.info("\u67e5\u8be2\u8bbe\u5907\u6863\u6848\u5185\u7801\uff0c\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)equipmentDocResponse));
        if (equipmentDocResponse.isSuccess()) {
            List equipmentDocCategoryVOList = (List)equipmentDocResponse.getData();
            docCategoryMap = equipmentDocCategoryVOList.stream().collect(Collectors.toMap(EquipmentCategoryVO::getId, EquipmentCategoryVO::getInnerCode, (key1, key2) -> key2));
            CommonResponse equipmentDocItemResponse = this.shareEquipmentApi.queryEquipmentItemByIds(docIs);
            if (equipmentDocItemResponse.isSuccess()) {
                this.logger.info("\u67e5\u8be2\u8bbe\u5907\u6863\u6848\u6e05\u5355\u5217\u8868\uff1a{}", (Object)JSONObject.toJSONString((Object)equipmentDocItemResponse.getData()));
                docItemMap = ((List)equipmentDocItemResponse.getData()).stream().collect(Collectors.toMap(EquipmentVO::getId, p -> p));
            } else {
                this.logger.error("\u67e5\u8be2\u8bbe\u5907\u6863\u6848\u4fe1\u606f\u5931\u8d25\uff0c{}", (Object)JSONObject.toJSONString((Object)equipmentDocItemResponse));
            }
        } else {
            this.logger.error("\u67e5\u8be2\u8bbe\u5907\u6863\u6848\u4fe1\u5206\u7c7b\u606f\u5931\u8d25\uff0c{}", (Object)JSONObject.toJSONString((Object)equipmentDocResponse));
        }
        List projectIdList = contractEntityList.stream().map(PurchaseContractEntity::getProjectId).distinct().collect(Collectors.toList());
        CommonResponse projectResponse = this.projectSetApi.getProjectListIds(projectIdList);
        this.logger.info("\u67e5\u8be2\u9879\u76ee\u5730\u5740\uff0c\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)projectResponse));
        Map<Object, Object> projectAreaMap = new HashMap();
        Map<Object, Object> projectAreaNameMap = new HashMap();
        if (projectResponse.isSuccess()) {
            List projectPoolList = (List)projectResponse.getData();
            projectAreaMap = projectPoolList.stream().filter(t -> StringUtils.isNotEmpty((CharSequence)t.getArea())).collect(Collectors.toMap(BaseVO::getId, ProjectPoolDTO::getArea, (key1, key2) -> key2));
            projectAreaNameMap = projectPoolList.stream().filter(t -> StringUtils.isNotEmpty((CharSequence)t.getAreaName())).collect(Collectors.toMap(BaseVO::getId, ProjectPoolDTO::getAreaName, (key1, key2) -> key2));
        }
        Map<Long, List<EquipmentDetailedEntity>> detailMap = detailEntityList.stream().collect(Collectors.groupingBy(EquipmentDetailedEntity::getContractId));
        ArrayList<Object> saveEntityList = new ArrayList<Object>();
        for (PurchaseContractEntity entity : contractEntityList) {
            List<EquipmentDetailedEntity> entityDetailList = detailMap.get(entity.getId());
            if (CollectionUtils.isEmpty(entityDetailList)) continue;
            for (EquipmentDetailedEntity detailEntity : entityDetailList) {
                if (detailEntity.getDocId() == null) continue;
                PriceContractEntity priceContractEntity = (PriceContractEntity)((Object)BeanMapper.map((Object)((Object)entity), PriceContractEntity.class));
                priceContractEntity.setSettlementDate((Date)settleDateMap.get(entity.getId()));
                priceContractEntity.setContractId(entity.getId());
                priceContractEntity.setContractName(entity.getContractName());
                priceContractEntity.setContractCode(entity.getBillCode());
                priceContractEntity.setContractFlag(entity.getSupplementFlag());
                priceContractEntity.setSignDate(entity.getSignDate());
                priceContractEntity.setPerformanceStatus(entity.getContractPerformanceState());
                priceContractEntity.setPcCardUrl("/ejc-proequipmentp-frontend/#/machineryPurchaseContract/cardList?id=" + entity.getId());
                priceContractEntity.setArea((String)projectAreaMap.get(entity.getProjectId()));
                priceContractEntity.setAreaName((String)projectAreaNameMap.get(entity.getProjectId()));
                priceContractEntity.setTargetResultId(entity.getTargetResultId());
                priceContractEntity.setSourceId(detailEntity.getId());
                priceContractEntity.setSourceType(PriceSourceTypeEnum.\u8bbe\u5907\u8d2d\u7f6e\u5408\u540c.getCode());
                priceContractEntity.setContractTaxRate(detailEntity.getTaxRate());
                priceContractEntity.setContractNum(new BigDecimal(detailEntity.getPurchaseNum()));
                priceContractEntity.setContractPrice(null != detailEntity.getPurchasePricetNoTax() ? detailEntity.getPurchasePricetNoTax() : BigDecimal.ZERO);
                priceContractEntity.setContractTaxPrice(null != detailEntity.getPurchasePrice() ? detailEntity.getPurchasePrice() : BigDecimal.ZERO);
                priceContractEntity.setContractMny(null != detailEntity.getPurchaseAmountNoTax() ? detailEntity.getPurchaseAmountNoTax() : BigDecimal.ZERO);
                priceContractEntity.setContractTaxMny(null != detailEntity.getPurchaseAmount() ? detailEntity.getPurchaseAmount() : BigDecimal.ZERO);
                priceContractEntity.setMemo(detailEntity.getDetailMemo());
                priceContractEntity.setSpec(detailEntity.getSpec());
                priceContractEntity.setManufacturer(detailEntity.getManufacturer());
                priceContractEntity.setDocId(detailEntity.getDocId());
                priceContractEntity.setDocCode(detailEntity.getEquipmentCode());
                priceContractEntity.setDocName(detailEntity.getEquipmentName());
                priceContractEntity.setDocCategoryId(detailEntity.getDocCategoryId());
                priceContractEntity.setDocInnerCode((String)docCategoryMap.get(detailEntity.getDocCategoryId()));
                if (null != docItemMap && null != detailEntity.getDocId()) {
                    priceContractEntity.setEquipmentHeight(((EquipmentVO)docItemMap.get(detailEntity.getDocId())).getEquipmentHeight());
                }
                priceContractEntity.setUnitName(detailEntity.getCompany());
                priceContractEntity.setOutFlag(OutFlagEnum.\u672a\u79fb\u9664.getCode());
                priceContractEntity.setId(null);
                priceContractEntity.setCreateTime(null);
                priceContractEntity.setCreateUserCode(null);
                priceContractEntity.setUpdateTime(null);
                priceContractEntity.setUpdateUserCode(null);
                priceContractEntity.setDr(detailEntity.getDr());
                saveEntityList.add((Object)priceContractEntity);
            }
        }
        this.logger.info("\u83b7\u53d6\u8bbe\u5907\u516c\u53f8\u6570\u636e\u524d\u6570\u636e\u6761\u6570\uff1a" + saveEntityList.size());
        CommonResponse corpPurchaseResponse = this.contractCorpPurchaseApi.getPriceContractDataByCorpPurchase(date != null ? "1" : "0");
        this.logger.info("\u83b7\u53d6\u8bbe\u5907\u516c\u53f8\u8d2d\u7f6e\u5408\u540c\u6570\u636e\uff0c\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)corpPurchaseResponse));
        if (corpPurchaseResponse.isSuccess()) {
            List corpOutContractList = (List)corpPurchaseResponse.getData();
            saveEntityList.addAll(BeanMapper.mapList((Iterable)corpOutContractList, PriceContractEntity.class));
        }
        this.logger.info("\u83b7\u53d6\u8bbe\u5907\u516c\u53f8\u6570\u636e\u540e\u6570\u636e\u6761\u6570\uff1a" + saveEntityList.size());
        if (CollectionUtils.isEmpty(saveEntityList)) {
            return;
        }
        List sourceDetailIdList = saveEntityList.stream().map(PriceContractEntity::getSourceId).collect(Collectors.toList());
        QueryParam priceParam = new QueryParam();
        priceParam.getParams().put("sourceId", new Parameter("in", sourceDetailIdList));
        List queryPriceList = super.queryList(priceParam, false);
        if (CollectionUtils.isNotEmpty((Collection)queryPriceList)) {
            Map queryPriceMap = queryPriceList.stream().collect(Collectors.toMap(PriceContractEntity::getSourceId, Function.identity(), (key1, key2) -> key2));
            for (PriceContractEntity priceContractEntity : saveEntityList) {
                PriceContractEntity queryEntity = (PriceContractEntity)((Object)queryPriceMap.get(priceContractEntity.getSourceId()));
                if (queryEntity == null) continue;
                priceContractEntity.setId(queryEntity.getId());
                priceContractEntity.setOutFlag(queryEntity.getOutFlag());
            }
        }
        super.saveOrUpdateBatch(saveEntityList);
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.notIn((Object)"bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        super.remove((Wrapper)wrapper, false);
        List delIdList = saveEntityList.stream().filter(t -> t.getDr() != 0).map(BaseEntity::getId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(delIdList)) {
            super.removeByIds(delIdList, false);
        }
        this.logger.info("========================\u4ef7\u683c\u5e93\u5408\u540c\u660e\u7ec6\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u7ed3\u675f===========================");
    }

    @Override
    public PriceLibVO queryPriceLibDetail(QueryParam param) {
        Map<String, Date> checkMap = this.checkQueryParam(param);
        Date startDate = checkMap.get("startDate");
        Date endDate = checkMap.get("endDate");
        List<Long> orgIdList = this.queryOrgIdList();
        List<PriceLibVO> priceLibList = this.queryPriceLibListAll(startDate, endDate, orgIdList, param);
        return priceLibList.get(0);
    }

    @Override
    public List<PriceTrendVo> queryPriceTrendContractList(QueryParam param) {
        ArrayList<PriceTrendVo> rtnList;
        Map<String, Date> checkMap = this.checkQueryParam(param);
        Date startDate = checkMap.get("startDate");
        Date endDate = checkMap.get("endDate");
        List<Long> orgIdList = this.queryOrgIdList();
        HashMap<String, PriceTrendVo> trendMap = new HashMap<String, PriceTrendVo>();
        List<PriceContractEntity> priceContractList = this.queryPriceContractList(startDate, orgIdList, param);
        if (CollectionUtils.isNotEmpty(priceContractList)) {
            Map<Date, List<PriceContractEntity>> contractMap = priceContractList.stream().collect(Collectors.groupingBy(PriceContractEntity::getSignDate));
            for (Map.Entry<Date, List<PriceContractEntity>> entry : contractMap.entrySet()) {
                PriceTrendVo vo;
                String dateStr;
                List<PriceContractEntity> list = entry.getValue();
                if (CollectionUtils.isEmpty(list)) continue;
                PriceContractEntity priceContractEntity = list.get(0);
                List priceList = list.stream().map(PriceContractEntity::getContractPrice).collect(Collectors.toList());
                List taxPriceList = list.stream().map(PriceContractEntity::getContractTaxPrice).collect(Collectors.toList());
                BigDecimal num = BigDecimal.ZERO;
                BigDecimal mny = BigDecimal.ZERO;
                BigDecimal taxMny = BigDecimal.ZERO;
                BigDecimal avgPrice = BigDecimal.ZERO;
                BigDecimal taxAvgPrice = BigDecimal.ZERO;
                for (PriceContractEntity entity : list) {
                    num = num.add(entity.getContractNum());
                    mny = mny.add(entity.getContractMny());
                    taxMny = taxMny.add(entity.getContractTaxMny());
                }
                if (num.compareTo(BigDecimal.ZERO) != 0) {
                    avgPrice = mny.divide(num, 4, 4);
                    taxAvgPrice = taxMny.divide(num, 4, 4);
                }
                if (trendMap.containsKey(dateStr = DateUtils.transformationDefaultDate(entry.getKey()))) {
                    vo = (PriceTrendVo)trendMap.get(dateStr);
                } else {
                    vo = new PriceTrendVo();
                    trendMap.put(dateStr, vo);
                }
                vo.setContractPrice(priceContractEntity.getContractPrice());
                vo.setContractTaxPrice(priceContractEntity.getContractTaxPrice());
                vo.setContractNum(num);
                vo.setContractAvgPrice(avgPrice);
                vo.setContractMaxPrice(((BigDecimal)Collections.max(priceList)).divide(BigDecimal.ONE, 4, 4));
                vo.setContractMinPrice(((BigDecimal)Collections.min(priceList)).divide(BigDecimal.ONE, 4, 4));
                vo.setContractTaxAvgPrice(taxAvgPrice);
                vo.setContractTaxMaxPrice(((BigDecimal)Collections.max(taxPriceList)).divide(BigDecimal.ONE, 4, 4));
                vo.setContractTaxMinPrice(((BigDecimal)Collections.min(taxPriceList)).divide(BigDecimal.ONE, 4, 4));
                vo.setPriceDate(DateUtils.transformationDefaultDate(entry.getKey()));
            }
        }
        if (CollectionUtils.isNotEmpty(rtnList = new ArrayList<PriceTrendVo>(trendMap.values()))) {
            rtnList.sort(Comparator.comparing(PriceTrendVo::getPriceDate));
        }
        return rtnList;
    }

    @Override
    public void removePriceContractDetail(Long id) {
        PriceContractEntity entity = (PriceContractEntity)((Object)super.selectById((Serializable)id));
        if (entity == null) {
            throw new BusinessException("\u660e\u7ec6\u4e0d\u5b58\u5728");
        }
        entity.setOutFlag(OutFlagEnum.\u5df2\u79fb\u9664.getCode());
        super.saveOrUpdate((Object)entity, false);
    }

    @Override
    public IPage<PriceContractVO> queryPriceContractListDetail(QueryParam param) {
        Map<String, Date> checkMap = this.checkQueryParam(param);
        Date startDate = checkMap.get("startDate");
        Date endDate = checkMap.get("endDate");
        if (param.getOrderMap().isEmpty()) {
            param.getOrderMap().put("signDate", "desc");
            param.getOrderMap().put("contractMny", "desc");
        }
        List<Long> orgIdList = this.queryOrgIdList();
        List<PriceContractEntity> priceContractList = this.queryPriceContractList(startDate, orgIdList, param);
        Page pageDate = new Page((long)param.getPageIndex(), (long)param.getPageSize(), (long)priceContractList.size());
        if (CollectionUtils.isEmpty(priceContractList)) {
            return pageDate;
        }
        List voList = BeanMapper.mapList(priceContractList, PriceContractVO.class);
        List<Long> myOrgList = this.getMyOrgList();
        for (PriceContractVO vo : voList) {
            if (myOrgList.contains(vo.getOrgId())) continue;
            vo.setPcCardUrl(null);
        }
        pageDate.setRecords(voList.stream().skip((param.getPageIndex() - 1) * param.getPageSize()).limit(param.getPageSize()).collect(Collectors.toList()));
        return pageDate;
    }

    private List<Long> getMyOrgList() {
        CommonResponse orgVOResp = this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId());
        if (!orgVOResp.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        List orgVOList = (List)orgVOResp.getData();
        if (CollectionUtils.isNotEmpty((Collection)orgVOList)) {
            return orgVOList.stream().map(BaseVO::getId).collect(Collectors.toList());
        }
        return new ArrayList<Long>();
    }

    private Map<String, Date> checkQueryParam(QueryParam param) {
        Map paramMap = param.getParams();
        if (!paramMap.containsKey("startDate") || !paramMap.containsKey("endDate")) {
            throw new BusinessException("\u67e5\u8be2\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Date startDate = DateUtils.createDate(((Parameter)paramMap.get("startDate")).getValue().toString());
        Date endDate = DateUtils.createDate(((Parameter)paramMap.get("endDate")).getValue().toString());
        paramMap.remove("startDate");
        paramMap.remove("endDate");
        if (!paramMap.containsKey("docId")) {
            throw new BusinessException("\u67e5\u8be2\u6863\u6848id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        HashMap<String, Date> rtnMap = new HashMap<String, Date>();
        rtnMap.put("startDate", startDate);
        rtnMap.put("endDate", endDate);
        return rtnMap;
    }

    private List<PriceLibVO> queryPriceLibListAll(Date startDate, Date endDate, List<Long> orgIdList, QueryParam param) {
        HashMap<Long, PriceLibVO> map = new HashMap<Long, PriceLibVO>();
        this.queryPriceContractGroupByDocId(map, startDate, orgIdList, param);
        this.queryPriceGuide(map);
        ArrayList<PriceLibVO> priceLibList = new ArrayList<PriceLibVO>(map.values());
        if (CollectionUtils.isNotEmpty(priceLibList)) {
            priceLibList.sort(Comparator.comparing(PriceLibVO::getDocCode, Comparator.nullsLast(String::compareTo)));
        }
        return priceLibList;
    }

    private void queryPriceContractGroupByDocId(Map<Long, PriceLibVO> libMap, Date startDate, List<Long> orgIdList, QueryParam param) {
        List<PriceContractEntity> priceContractList = this.queryPriceContractList(startDate, orgIdList, param);
        if (CollectionUtils.isEmpty(priceContractList)) {
            return;
        }
        Map<Long, List<PriceContractEntity>> priceContractMap = priceContractList.stream().collect(Collectors.groupingBy(PriceContractEntity::getDocId));
        for (Map.Entry<Long, List<PriceContractEntity>> entry : priceContractMap.entrySet()) {
            PriceLibVO priceLibVO;
            Long key = entry.getKey();
            List<PriceContractEntity> value = entry.getValue();
            List<BigDecimal> priceList = value.stream().map(PriceContractEntity::getContractPrice).collect(Collectors.toList());
            List<BigDecimal> taxPriceList = value.stream().map(PriceContractEntity::getContractTaxPrice).collect(Collectors.toList());
            BigDecimal highFrequencyPrice = this.getHighFrequencyPrice(priceList);
            BigDecimal highFrequencyTaxPrice = this.getHighFrequencyPrice(taxPriceList);
            PriceContractEntity priceContract = value.get(0);
            if (priceContract == null) continue;
            BigDecimal num = BigDecimal.ZERO;
            BigDecimal mny = BigDecimal.ZERO;
            BigDecimal taxRate = BigDecimal.ZERO;
            BigDecimal taxMny = BigDecimal.ZERO;
            BigDecimal avgPrice = BigDecimal.ZERO;
            BigDecimal maxPrice = Collections.max(priceList).divide(BigDecimal.ONE, 4, 4);
            BigDecimal minPrice = Collections.min(priceList).divide(BigDecimal.ONE, 4, 4);
            String priceArea = minPrice + "-" + maxPrice;
            BigDecimal taxAvgPrice = BigDecimal.ZERO;
            BigDecimal taxMaxPrice = Collections.max(taxPriceList).divide(BigDecimal.ONE, 4, 4);
            BigDecimal taxMinPrice = Collections.min(taxPriceList).divide(BigDecimal.ONE, 4, 4);
            String taxPriceArea = taxMinPrice + "-" + taxMaxPrice;
            for (PriceContractEntity entity : value) {
                num = num.add(entity.getContractNum());
                mny = mny.add(entity.getContractMny());
                taxMny = taxMny.add(entity.getContractTaxMny());
            }
            if (num.compareTo(BigDecimal.ZERO) != 0) {
                avgPrice = mny.divide(num, 4, 4);
                taxAvgPrice = taxMny.divide(num, 4, 4);
            }
            taxRate = this.calculationTaxRate(taxMny, mny);
            if (libMap.containsKey(key)) {
                priceLibVO = libMap.get(key);
            } else {
                priceLibVO = new PriceLibVO();
                priceLibVO.setDocId(priceContract.getDocId());
                priceLibVO.setDocCode(priceContract.getDocCode());
                priceLibVO.setDocName(priceContract.getDocName());
                priceLibVO.setDocCategoryId(priceContract.getDocCategoryId());
                priceLibVO.setDocCategoryName(priceContract.getDocCategoryName());
                priceLibVO.setUnitId(priceContract.getUnitId());
                priceLibVO.setUnitName(priceContract.getUnitName());
                priceLibVO.setDocInnerCode(priceContract.getDocInnerCode());
                priceLibVO.setUnitName(priceContract.getUnitName());
                priceLibVO.setSpec(priceContract.getSpec());
                libMap.put(priceContract.getDocId(), priceLibVO);
            }
            priceLibVO.setContractNum(num);
            priceLibVO.setContractMny(mny);
            priceLibVO.setContractTaxRate(taxRate);
            priceLibVO.setContractTaxMny(taxMny);
            priceLibVO.setContractAvgPrice(avgPrice);
            priceLibVO.setContractMaxPrice(maxPrice);
            priceLibVO.setContractMinPrice(minPrice);
            priceLibVO.setContractPriceArea(priceArea);
            priceLibVO.setContractTaxAvgPrice(taxAvgPrice);
            priceLibVO.setContractTaxMaxPrice(taxMaxPrice);
            priceLibVO.setContractTaxMinPrice(taxMinPrice);
            priceLibVO.setContractTaxPriceArea(taxPriceArea);
            priceLibVO.setId(priceLibVO.getDocId());
            priceLibVO.setEquipmentHeight(priceContract.getEquipmentHeight());
            priceLibVO.setHigjFrequencyPrice(highFrequencyPrice);
            priceLibVO.setHigjFrequencyTaxPrice(highFrequencyTaxPrice);
            priceLibVO.setTax(taxMny.subtract(mny));
        }
    }

    public BigDecimal getHighFrequencyPrice(List<BigDecimal> priceList) {
        HashMap map = Maps.newHashMap();
        Integer MaxNum = 0;
        BigDecimal HighFrequencyPrice = null;
        for (BigDecimal price : priceList) {
            if (map.containsKey(price)) {
                Integer num = (Integer)map.get(price) + 1;
                map.put(price, num);
                if (num <= MaxNum) continue;
                MaxNum = num;
                HighFrequencyPrice = price;
                continue;
            }
            map.put(price, 1);
        }
        return HighFrequencyPrice;
    }

    private List<PriceContractEntity> queryPriceContractList(Date startDate, List<Long> orgIdList, QueryParam param) {
        QueryParam contractParam = new QueryParam();
        List fuzzyFields = contractParam.getFuzzyFields();
        fuzzyFields.add("docCode");
        fuzzyFields.add("docName");
        fuzzyFields.add("unitName");
        fuzzyFields.add("area");
        fuzzyFields.add("areaName");
        contractParam.setSearchText(param.getSearchText());
        contractParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        contractParam.getParams().put("outFlag", new Parameter("eq", (Object)OutFlagEnum.\u672a\u79fb\u9664.getCode()));
        if (CollectionUtils.isNotEmpty(orgIdList)) {
            contractParam.getParams().put("orgId", new Parameter("in", orgIdList));
        }
        if (param != null) {
            contractParam.getParams().putAll(param.getParams());
            if (CollectionUtils.isNotEmpty((Collection)param.getComplexParams())) {
                contractParam.getComplexParams().addAll(param.getComplexParams());
            }
            if (!param.getOrderMap().isEmpty()) {
                contractParam.getOrderMap().putAll(param.getOrderMap());
            }
        }
        ComplexParam c1 = new ComplexParam();
        c1.setLogic("and");
        ComplexParam c2 = new ComplexParam();
        c2.setLogic("or");
        c2.getParams().put("performance_status", new Parameter("in", Arrays.asList(2, 5)));
        c1.getComplexParams().add(c2);
        ComplexParam c3 = new ComplexParam();
        c3.setLogic("or");
        c3.getParams().put("performance_status", new Parameter("in", Arrays.asList(3, 6)));
        c3.getParams().put("settlement_date", new Parameter("ge", (Object)startDate));
        c1.getComplexParams().add(c3);
        contractParam.getComplexParams().add(c1);
        return super.queryList(contractParam, false);
    }

    private List<Long> queryOrgIdList() {
        CommonResponse orgIdListResponse = this.priceDepotPowerSetApi.queryOrgList(InvocationInfoProxy.getOrgId());
        this.logger.info("\u67e5\u8be2\u7ec4\u7ec7\u6743\u9650\uff0c\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)orgIdListResponse));
        if (!orgIdListResponse.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u7ec4\u7ec7\u6743\u9650\u5931\u8d25:" + orgIdListResponse.getMsg());
        }
        return (List)orgIdListResponse.getData();
    }

    private BigDecimal calculationTaxRate(BigDecimal taxMny, BigDecimal mny) {
        BigDecimal b = new BigDecimal("100");
        if (mny.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        return taxMny.divide(mny, 4, 4).subtract(BigDecimal.ONE).multiply(b);
    }

    private void queryPriceGuide(Map<Long, PriceLibVO> libMap) {
        if (libMap.isEmpty()) {
            return;
        }
        ArrayList<Long> docIdList = new ArrayList<Long>(libMap.keySet());
        List<PriceGuideDetailEntity> list = this.priceGuideDetailService.queryPriceGuideDetailByDocIds(docIdList);
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        Map guideMap = list.stream().collect(Collectors.toMap(PriceGuideDetailEntity::getDocId, Function.identity(), (key1, key2) -> key1));
        for (Map.Entry<Long, PriceLibVO> entry : libMap.entrySet()) {
            Long docId = entry.getKey();
            PriceLibVO vo = entry.getValue();
            if (!guideMap.containsKey(docId)) continue;
            PriceGuideDetailEntity guide = (PriceGuideDetailEntity)((Object)guideMap.get(docId));
            BigDecimal min = guide.getMinPrice() == null ? BigDecimal.ZERO : guide.getMinPrice();
            BigDecimal max = guide.getMaxPrice() == null ? BigDecimal.ZERO : guide.getMaxPrice();
            min = min.divide(BigDecimal.ONE, 4, 4);
            max = max.divide(BigDecimal.ONE, 4, 4);
            vo.setGuidePriceArea(min + "-" + max);
        }
    }
}

