/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.acceptance.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.acceptance.bean.PurchaseAcceptanceEntity;
import com.ejianc.business.acceptance.bean.PurchaseAcceptanceSubEntity;
import com.ejianc.business.acceptance.service.IPurchaseAcceptanceService;
import com.ejianc.business.acceptance.service.IPurchaseAcceptanceSubService;
import com.ejianc.business.asset.bean.AssetEntity;
import com.ejianc.business.asset.service.IAssetService;
import com.ejianc.business.purchase.bean.EquipmentDetailedEntity;
import com.ejianc.business.purchase.bean.PurchaseContractEntity;
import com.ejianc.business.purchase.service.IEquipmentDetailedService;
import com.ejianc.business.purchase.service.IPurchaseContractService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="purchaseAcceptance")
public class PurchaseAcceptanceBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IPurchaseAcceptanceService service;
    @Autowired
    private IPurchaseContractService contractService;
    @Autowired
    private IEquipmentDetailedService equipmentDetailedService;
    @Autowired
    private IPurchaseAcceptanceSubService subService;
    @Autowired
    private IAssetService assetService;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"purchase_acceptance_id", (Object)billId);
        List list = this.assetService.list((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)list)) {
            this.assetService.pushAsset(billId);
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        PurchaseAcceptanceEntity e = (PurchaseAcceptanceEntity)((Object)this.service.selectById(billId));
        QueryParam params = new QueryParam();
        params.getParams().put("pid", new Parameter("eq", (Object)billId));
        List subEntityList = this.subService.queryList(params);
        this.logger.info("11111111111111---------->: {}", (Object)JSONObject.toJSONString((Object)subEntityList));
        PurchaseAcceptanceSubEntity subEntity = (PurchaseAcceptanceSubEntity)((Object)subEntityList.get(0));
        this.logger.info("22222222222222---------->: {}", (Object)JSONObject.toJSONString((Object)((Object)subEntity)));
        UserContext userContext = this.sessionManager.getUserContext();
        PurchaseContractEntity contractEntity = (PurchaseContractEntity)((Object)this.contractService.selectById(e.getContractId()));
        this.logger.info("333333333333333---------->: {}", (Object)JSONObject.toJSONString((Object)((Object)contractEntity)));
        QueryParam param = new QueryParam();
        param.getParams().put("contractId", new Parameter("eq", (Object)contractEntity.getId()));
        param.getParams().put("docCategoryId", new Parameter("eq", (Object)subEntity.getEquipmentTypeId()));
        param.getParams().put("docId", new Parameter("eq", (Object)subEntity.getEquipmentId()));
        List equipmentList = this.equipmentDetailedService.queryList(param);
        this.logger.info("4444444444444444---------->: {}", (Object)JSONObject.toJSONString((Object)equipmentList));
        EquipmentDetailedEntity equipmentDetailedEntity = (EquipmentDetailedEntity)((Object)equipmentList.get(0));
        this.logger.info("555555555555555555---------->: {}", (Object)JSONObject.toJSONString((Object)((Object)equipmentDetailedEntity)));
        if (equipmentDetailedEntity.getAcceptanceQuantity() == null) {
            equipmentDetailedEntity.setAcceptanceQuantity(1);
        } else {
            equipmentDetailedEntity.setAcceptanceQuantity(equipmentDetailedEntity.getAcceptanceQuantity() + 1);
        }
        this.equipmentDetailedService.saveOrUpdate((Object)equipmentDetailedEntity);
        return CommonResponse.success((String)"\u4f7f\u7528\u8bb0\u5f55\u5ba1\u6279\u56de\u8c03\u5904\u7406\u6210\u529f\uff01");
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        CommonResponse resp = this.billTypeApi.checkQuote(billTypeCode, billId);
        if (!resp.isSuccess()) {
            return CommonResponse.error((String)("\u65e0\u6cd5\u64a4\u56de\uff01" + resp.getMsg()));
        }
        PurchaseAcceptanceEntity e = (PurchaseAcceptanceEntity)((Object)this.service.selectById(billId));
        QueryParam params = new QueryParam();
        params.getParams().put("pid", new Parameter("eq", (Object)billId));
        List subEntityList = this.subService.queryList(params);
        this.logger.info("11111111111111---------->: {}", (Object)JSONObject.toJSONString((Object)subEntityList));
        PurchaseAcceptanceSubEntity subEntity = (PurchaseAcceptanceSubEntity)((Object)subEntityList.get(0));
        this.logger.info("22222222222222---------->: {}", (Object)JSONObject.toJSONString((Object)((Object)subEntity)));
        UserContext userContext = this.sessionManager.getUserContext();
        PurchaseContractEntity contractEntity = (PurchaseContractEntity)((Object)this.contractService.selectById(e.getContractId()));
        this.logger.info("333333333333333---------->: {}", (Object)JSONObject.toJSONString((Object)((Object)contractEntity)));
        QueryParam param = new QueryParam();
        param.getParams().put("contractId", new Parameter("eq", (Object)contractEntity.getId()));
        param.getParams().put("docCategoryId", new Parameter("eq", (Object)subEntity.getEquipmentTypeId()));
        param.getParams().put("docId", new Parameter("eq", (Object)subEntity.getEquipmentId()));
        List equipmentList = this.equipmentDetailedService.queryList(param);
        this.logger.info("4444444444444444---------->: {}", (Object)JSONObject.toJSONString((Object)equipmentList));
        EquipmentDetailedEntity equipmentDetailedEntity = (EquipmentDetailedEntity)((Object)equipmentList.get(0));
        this.logger.info("555555555555555555---------->: {}", (Object)JSONObject.toJSONString((Object)((Object)equipmentDetailedEntity)));
        if (equipmentDetailedEntity.getAcceptanceQuantity() == null) {
            equipmentDetailedEntity.setAcceptanceQuantity(0);
        } else {
            equipmentDetailedEntity.setAcceptanceQuantity(equipmentDetailedEntity.getAcceptanceQuantity() - 1);
        }
        this.equipmentDetailedService.saveOrUpdate((Object)equipmentDetailedEntity);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"purchase_acceptance_id", (Object)billId);
        List list = this.assetService.list((Wrapper)queryWrapper);
        AssetEntity assetEntity = (AssetEntity)((Object)list.get(0));
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            CommonResponse response = this.billTypeApi.checkQuote("EJCBT202206000070", assetEntity.getId());
            if (!response.isSuccess()) {
                return CommonResponse.error((String)("\u9a8c\u6536\u751f\u6210\u7684\u56fa\u5b9a\u8d44\u4ea7\u5361\u7247\u88ab\u4e0b\u6e38\u5f15\u7528\u65e0\u6cd5\u64a4\u56de\uff01" + resp.getMsg()));
            }
            this.assetService.removeById(assetEntity.getId());
        }
        return CommonResponse.success((String)"\u91c7\u8d2d\u9a8c\u6536\u5904\u7406\u6210\u529f\uff01");
    }
}

