package com.ejianc.business.purchase.service.impl;

import cn.hutool.http.HttpRequest;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.purchase.bean.ChangePurchaseContractEntity;
import com.ejianc.business.purchase.enums.DraftTypeEnum;
import com.ejianc.business.purchase.service.IChangePurchaseContractService;
import com.ejianc.business.purchase.service.IContractChangeAsyncService;
import com.ejianc.business.signaturemanage.vo.*;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.google.common.base.Stopwatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.Recover;
import org.springframework.retry.annotation.Retryable;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

/**
 * @author baipengyan
 * @date 2022/5/20
 * @description 合同加水印异步http请求
 */
@Service("ContractChangeAsyncService")
public class ContractChangeAsyncServiceImpl implements IContractChangeAsyncService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Value("${common.env.base-host}")
    private String BaseHost;

    @Value("${qiyuesuo.contract.categoryId}")
    private Long categoryId;// 用印流程ID
    @Autowired
    private IChangePurchaseContractService service;

    /**
     * 获取水印文件附件信息
     *
     * @param watermarkVO 水印配置参数
     * @return 水印文件信息
     */
    @Override
    @Async(value = "commonTask")
    @Retryable(maxAttempts = 3, backoff = @Backoff(delay = 2000, multiplier = 1.5), stateful = true)
    public void fetchWatermarkAttachment(HashMap<String, String> headers, WatermarkVO watermarkVO) {
        logger.info("异步获取水印文件附件信息开始，入参：{}", JSON.toJSONString(watermarkVO, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue));
        Stopwatch start = Stopwatch.createStarted();
        String body = HttpRequest.post(BaseHost + "ejc-signaturemanage-web/common/fetchWatermarkAttachment")
                .addHeaders(headers)
                .body(JSON.toJSONString(watermarkVO))
                .timeout(60000)
                .execute().body();
        AttachmentVO attachmentVO = JSON.parseObject(body, AttachmentVO.class);
        logger.info("异步获取水印文件附件信息结束，请求签章中心耗时「{}」秒，文件中心的水印文件信息：{}", start.stop().elapsed(TimeUnit.SECONDS), JSON.toJSONString(attachmentVO, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue));

        start.reset().start();
        // 更新合同水印文件id
        UpdateWrapper<ChangePurchaseContractEntity> updateWrapper = new UpdateWrapper<>();
        updateWrapper.eq("id", watermarkVO.getBillId());
        updateWrapper.set("watermark_contract_file_id", attachmentVO.getId());
        boolean flag = service.update(updateWrapper);
        if (flag) {
            logger.info("获取水印文件附件信息并更新合同成功，写入数据库耗时「{}」秒，合同id：{}，原合同文件id：{}，水印合同文件id：{}", start.stop().elapsed(TimeUnit.SECONDS), watermarkVO.getBillId(), watermarkVO.getFileId(), attachmentVO.getId());
        }

        //另行签署会发起签章
        ChangePurchaseContractEntity entity = service.getById(watermarkVO.getBillId());
        sendSignature(entity.getDraftType(),watermarkVO.getBillId(),entity.getBillCode(),
                entity.getContractName(),entity.getWatermarkContractFileId(),watermarkVO.getBillType(),headers);
    }

    @Recover
    public void recordWatermark(Exception e, HashMap<String, String> headers, WatermarkVO watermarkVO) {
        logger.error("获取水印文件附件信息并更新合同失败，请求参数：{}", JSON.toJSONString(watermarkVO, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue));
    }

    public void sendSignature(String draftType,Long billId,String billCode,String contractName,Long watermarkContractFileId,String billType ,
                              HashMap<String, String> headers){
        logger.info("另行签署合同进入无外观签章流程！-------------------------------------------");
        //另行签署的新增无外观签章
        if (DraftTypeEnum.线下签订.getCode().toString().equals(draftType) || DraftTypeEnum.线上起草不使用电子签章.getCode().toString().equals(draftType)){
            logger.info("另行签署合同进入无外观签章流程 ！draftType :{}-------------------------------------------",draftType);
            InitSignatureVO initSignatureVO = new InitSignatureVO();
            initSignatureVO.setBillId(billId);//业务id不能为空
            initSignatureVO.setBillType(billType);//来源业务单据类型不能为空 BT220216000000003专业 BT211108000000002劳务
            initSignatureVO.setBillCode(billCode);//单据编码不能为空
            initSignatureVO.setContractName(contractName);//合同名称不能为空！
            initSignatureVO.setBillRefCode("proSubContract");//refcode不能为空！
            initSignatureVO.setBillDocId(watermarkContractFileId);//业务文件id不能为空！
            initSignatureVO.setBillDocumentName(contractName);//业务文件名称不能为空！
            initSignatureVO.setTenantName("郑州一建集团有限公司");//发起方名称不能为空！
            initSignatureVO.setCategoryId(categoryId);

            List<InitSignatoryVO> list = new ArrayList<>();


            List<SealInfoVO> sealList = new ArrayList<>();
            SealInfoVO sealInfoVO = new SealInfoVO();
            sealInfoVO.setSignActionType("CORPORATE");//签署动作类型不能为空!
            sealInfoVO.setName("企业签章");//签署动作名称不能为空!
            sealInfoVO.setSealSignOrder(1);//签章顺序不能为空!
            // sealInfoVO.setSealId("2946971611872677909");//

            List<OldSignatoryVO> signatoryList = new ArrayList<>();
            OldSignatoryVO oldSignatoryVO = new OldSignatoryVO();
            oldSignatoryVO.setSignatureName("孙晓一");
            oldSignatoryVO.setSignatureId(1502571539046862850L);
            //oldSignatoryVO.setSignatureId( 553224391165485096L);
            oldSignatoryVO.setSignatureContact("16637272109");
            signatoryList.add(oldSignatoryVO);

            sealInfoVO.setSignatoryVOList(signatoryList);
            sealList.add(sealInfoVO);


            InitSignatoryVO initSignatoryVO = new InitSignatoryVO();
            initSignatoryVO.setTenantName("郑州一建集团有限公司");//签约主体名称不能为空！
            initSignatoryVO.setTenantType("COMPANY");//签约主体类型不能为空！
            initSignatoryVO.setSignatureType(0);//签署方类型不能为空！
            initSignatoryVO.setSignOrder(1);//签署顺序不能为空！
            initSignatoryVO.setSignatureList(sealList);//签章信息不能为空！

            list.add(initSignatoryVO);

            initSignatureVO.setSignMgrSignatoryEntities(list);//签署方信息不能为空！;

            //CommonResponse<Long> longCommonResponse = signatureManageApi.initiateSignature(initSignatureVO);
            String body = HttpRequest.post(BaseHost + "ejc-signaturemanage-web/api/signaturemanage/sendSignatureZzyj")
                    .addHeaders(headers)
                    .body(JSON.toJSONString(initSignatureVO))
                    .timeout(60000)
                    .execute().body();
            logger.info("另行签署合同无外观签章流程结束,body:{} ！",body);
        }

    }
}
