package com.ejianc.business.acceptance.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.acceptance.vo.PurchaseAcceptanceVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.acceptance.mapper.PurchaseAcceptanceMapper;
import com.ejianc.business.acceptance.bean.PurchaseAcceptanceEntity;
import com.ejianc.business.acceptance.service.IPurchaseAcceptanceService;

import java.util.Date;
import java.util.List;

/**
 * 购置验收表
 * 
 * @author generator
 * 
 */
@Service("purchaseAcceptanceService")
public class PurchaseAcceptanceServiceImpl extends BaseServiceImpl<PurchaseAcceptanceMapper, PurchaseAcceptanceEntity> implements IPurchaseAcceptanceService{

    @Override
    public IPage<PurchaseAcceptanceVO> refPurchaseAcceptanceData(QueryParam param, Long contractId, Integer pageNumber, Integer pageSize) {
        IPage<PurchaseAcceptanceVO> page = new Page<>(param.getPageIndex(), param.getPageSize());
        List<PurchaseAcceptanceVO> list = baseMapper.refPurchaseAcceptanceData(changeToQueryWrapper(param),contractId, page);
        IPage<PurchaseAcceptanceVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(list);
        return pageData;
    }


    /**
     * 根据项目id、验收日期查询设备采购单据数量
     *
     * @param projectId 项目id
     * @param checkDate 验收日期
     *
     * @return Integer
     */
    @Override
    public Integer countBillNum(Long projectId, Date checkDate) {
        LambdaQueryWrapper<PurchaseAcceptanceEntity> lambdaQuery = Wrappers.lambdaQuery();
        lambdaQuery.eq(PurchaseAcceptanceEntity::getProjectId, projectId)
                .eq(PurchaseAcceptanceEntity::getAcceptanceDate, checkDate);
        return super.count(lambdaQuery);
    }

    @Override
    public List<PurchaseAcceptanceVO> queryListByContract(Long contractId){
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter(QueryParam.EQ, contractId));
        List<PurchaseAcceptanceEntity> rentCalculateEntities = super.queryList(queryParam, false);
        List<PurchaseAcceptanceVO> purchaseAcceptanceVOS = BeanMapper.mapList(rentCalculateEntities, PurchaseAcceptanceVO.class);
        for (PurchaseAcceptanceVO record : purchaseAcceptanceVOS) {
            PurchaseAcceptanceEntity entity = this.selectById(record.getId());
            record.setEquipmentCode(entity.getPurchaseAcceptanceSubList().get(0).getEquipmentCode());
            record.setEquipmentType(entity.getPurchaseAcceptanceSubList().get(0).getEquipmentType());
            record.setEquipmentName(entity.getPurchaseAcceptanceSubList().get(0).getEquipmentName());
            record.setSpec(entity.getPurchaseAcceptanceSubList().get(0).getSpec());
            record.setCompany(entity.getPurchaseAcceptanceSubList().get(0).getCompany());
            record.setPurchasePrice(entity.getPurchaseAcceptanceSubList().get(0).getPurchasePrice());
            record.setContractNum(entity.getPurchaseAcceptanceSubList().get(0).getContractNum());
        }

        return purchaseAcceptanceVOS;
    }
}
