package com.ejianc.business.settlement.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.contractbase.pool.enums.ContractPerformanceStateEnum;
import com.ejianc.business.contractbase.pool.enums.ContractTypeEnum;
import com.ejianc.business.contractbase.pool.enums.SettleSourceTypeEnum;
import com.ejianc.business.contractbase.pool.settlepool.api.ISettlePoolApi;
import com.ejianc.business.contractbase.pool.settlepool.vo.SettlePoolVO;
import com.ejianc.business.contractpub.util.BeanConvertorUtil;
import com.ejianc.business.purchase.bean.EquipmentDetailedEntity;
import com.ejianc.business.purchase.bean.PurchaseContractEntity;
import com.ejianc.business.purchase.enums.ChangeTypeEnum;
import com.ejianc.business.purchase.service.IPurchaseContractService;
import com.ejianc.business.settlement.bean.PurchaseSettlementDetailEntity;
import com.ejianc.business.settlement.bean.PurchaseSettlementEntity;
import com.ejianc.business.settlement.mapper.PurchaseSettlementMapper;
import com.ejianc.business.settlement.service.IPurchaseSettlementService;
import com.ejianc.business.settlement.vo.*;
import com.ejianc.business.targetcost.vo.ParamsCheckDsVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.utils.FileUtil;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

import javax.servlet.http.HttpServletRequest;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 设备采购结算表
 * 
 * @author generator
 * 
 */
@Service("purchaseSettlementService")
public class PurchaseSettlementServiceImpl extends BaseServiceImpl<PurchaseSettlementMapper, PurchaseSettlementEntity> implements IPurchaseSettlementService{

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IPurchaseContractService contractService;//合同
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IParamConfigApi paramConfigApi;
    //参数控制
    private static final String CHECK_PARAM_CODE_GC = "P-ogZh3516";//结算金额控制-过程
    private static final String CHECK_PARAM_CODE_ZZ = "P-4PVv940155";//结算金额控制-最终
    @Autowired
    private IProSupplierApi proSupplierApi;
    @Autowired
    private JedisPool jedisPool;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IContractPoolApi contractPoolApi;
    @Autowired
    private IPurchaseSettlementService settlementService;
    @Autowired
    private ISettlePoolApi settlePoolApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "EQUIPMENTPJS-CODE";//此处需要根据实际修改
    private static final String BILL_TYPE = "EJCBT202204000012";//此处需要根据实际修改
    private final String  OPERATE= "PURCHASE_SETTLE";
    //TODO  推送接口待修改
    private final String PUSH_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/purchaseSettlement/savePurchaseSettlement";
    private final String DELPUSH_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/purchaseSettlement/deletePurchaseSettlement";
    @Autowired
    private ISystemDataPushService systemDataPushService;

    @Override
    public CommonResponse<PurchaseSettlementVO> saveOrUpdate(PurchaseSettlementVO saveOrUpdateVO) {
        // parentOrgCode如果是空的，则需要查询赋值
        if (StringUtils.isEmpty(saveOrUpdateVO.getParentOrgCode()) && saveOrUpdateVO.getParentOrgId() != null) {
            CommonResponse<OrgVO> orgResponse = iOrgApi.getOneById(saveOrUpdateVO.getParentOrgId());
            if (orgResponse.isSuccess()) {
                OrgVO orgVO = orgResponse.getData();
                saveOrUpdateVO.setParentOrgCode(orgVO.getCode());
            }
        }
        // OrgCode如果是空的，则需要查询赋值
        if (StringUtils.isEmpty(saveOrUpdateVO.getOrgCode()) && saveOrUpdateVO.getOrgId() != null) {
            CommonResponse<OrgVO> orgResponse = iOrgApi.getOneById(saveOrUpdateVO.getOrgId());
            if (orgResponse.isSuccess()) {
                OrgVO orgVO = orgResponse.getData();
                saveOrUpdateVO.setOrgCode(orgVO.getCode());
            }
        }
        PurchaseSettlementEntity entity = BeanMapper.map(saveOrUpdateVO, PurchaseSettlementEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            if (null!=entity.getContractId() && this.queryExist(entity.getContractId())){
                throw new BusinessException("该合同下有未生效的结算单！");
            }
            //保存初始化签章，签字状态
            entity.setSignStatus(0);
            entity.setSignatureStatus(0);
            entity.setBillPushFlag(BillPushStatusEnum.未成功推送.getStatus());
        }
        if(entity.getContractId()!=null){//有合同同保存
            PurchaseContractEntity contractEntity = contractService.selectById(entity.getContractId());
            List<EquipmentDetailedEntity> contractDetailList = contractEntity.getDetailList();
            List<Long> collect = contractDetailList.stream().filter(t -> t.getDocCategoryId() != null && !ChangeTypeEnum.中止.toString().equals(t.getChangeType())).map(EquipmentDetailedEntity::getDocCategoryId).collect(Collectors.toList());
            for (PurchaseSettlementDetailEntity detail : entity.getPurchaseSettlementDetailList()) {
                if(!collect.contains(detail.getMaterialTypeId())){//结算明细不属于合同分类 或 在合同明细中
                    throw new BusinessException("材料【"+detail.getMaterialName()+"】在合同【"+entity.getContractName()+"】中不存在，请变更合同后再结算");
                }
            }
        }
        super.saveOrUpdate(entity, false);
        PurchaseSettlementVO vo = BeanMapper.map(entity, PurchaseSettlementVO.class);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }
    /*是否有为生效的结算单*/
    public boolean queryExist(Long contractId){
        LambdaQueryWrapper<PurchaseSettlementEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(PurchaseSettlementEntity::getContractId, contractId);
        wrapper.notIn(PurchaseSettlementEntity::getBillState, 1,3);//未生效条件
        List<PurchaseSettlementEntity> list = super.list(wrapper);
        if(CollectionUtils.isNotEmpty(list)){//有数据表示有未生效的结算单
            return true;
        }
        return false;
    }
    /*获取最近一次含本期结算金额和结算日期 */
    @Override
    public CommonResponse<Map> getDateMny(Long contractId) {
        Map<String, Object> map = new HashMap<>();
        BigDecimal currentTaxMny = BigDecimal.ZERO; // 结算金额
        BigDecimal currentMny = BigDecimal.ZERO; // 结算金额(无税)
        String sTDate  = null;
        LambdaQueryWrapper<PurchaseSettlementEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.orderByDesc(PurchaseSettlementEntity::getCreateTime);
        wrapper.in(PurchaseSettlementEntity::getBillState, 1,3);//防止修改时获取本单据的数据
        wrapper.eq(PurchaseSettlementEntity::getDr, 0);
        wrapper.eq(PurchaseSettlementEntity::getContractId, contractId);
        List<PurchaseSettlementEntity> list = super.list(wrapper);
        if(CollectionUtils.isNotEmpty(list)){
            sTDate = DateFormatUtil.formatDate("yyyy-MM-dd", list.get(0).getSettlementDate());
            currentTaxMny = list.stream().filter(e -> null != e.getSettlementTaxMny()).map(PurchaseSettlementEntity::getSettlementTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            currentMny = list.stream().filter(e -> null != e.getSettlementMny()).map(PurchaseSettlementEntity::getSettlementMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        map.put("currentTaxMny",currentTaxMny);
        map.put("currentMny",currentMny);
        map.put("sTDate",sTDate);
        map.put("settlementNum",list.size());
        return CommonResponse.success("获取金额和时间、结算次数成功！",map);
    }
    /*删除*/
    @Override
    public CommonResponse<String> delete(List<PurchaseSettlementVO> vos) {
        PurchaseSettlementEntity PurchaseSettlementEntity = super.selectById( vos.get(0).getId());
        return CommonResponse.success("删除成功！");
    }
    /*推送供方*/
    @Override
    public boolean pushBillToSupCenter(PurchaseSettlementEntity entity, String billTypeCode) {
        boolean locked = false, syncFlag = false;
        Jedis jedis = jedisPool.getResource();
        String key = billTypeCode + "::" + entity.getId().toString();

        //设置单据当前系统信息
        CommonResponse<String> ejcCloudSystemCode = proSupplierApi.getEjcCloudSystemCode();
        if (!ejcCloudSystemCode.isSuccess()) {
            logger.error("推送计量单据-{}失败，获取当前系统编码失败,{}", entity.getId(), ejcCloudSystemCode.getMsg());
            return false;
        }
        //设置当前系统ID
        entity.setSystemId(ejcCloudSystemCode.getData());

        try {
            //对单据进行加锁
            locked = RedisTool.tryLock(jedis, key, OPERATE, 600);

            if(!locked) {
                logger.error("单据推送失败，单据锁获取失败！");
                releaseLock(jedis, false, key, OPERATE);
                return false;
            }

            Map<String, String> paramMap = new HashMap<>();
            SupPurchaseSettlementVO supSettlementVO = BeanMapper.map(entity, SupPurchaseSettlementVO.class);
            List<SupPurchaseSettlementDetailVO> supSettlementDetailVOS = BeanMapper.mapList(entity.getPurchaseSettlementDetailList(), SupPurchaseSettlementDetailVO.class);
            List<SupPurchaseSettlementFeeVO> supSettlementFeeVOS = BeanMapper.mapList(entity.getPurchaseSettlementFeeList(), SupPurchaseSettlementFeeVO.class);
            supSettlementVO.setPurchaseSettlementDetailList(supSettlementDetailVOS);
            supSettlementVO.setPurchaseSettlementFeeList(supSettlementFeeVOS);
            paramMap.put("transData", JSONObject.toJSONString(supSettlementVO));

            //查询单据附件信息并下载
            CommonResponse<List<AttachmentVO>> fileResp = attachmentApi.queryListBySourceId(entity.getId(), billTypeCode, "projectMangerSign", null);
            if (fileResp.isSuccess()) {
                Map<String, Map<String, InputStream>> files = new HashMap<>();
                List<AttachmentVO> fileList = fileResp.getData();
                List<Long> fileIds = new ArrayList<>();
                //从附件信息列表获取到： 1、附件名对应附件业务类型Map,2、获取到附件Id列表
                for (AttachmentVO attach : fileList) {
                    fileIds.add(attach.getId());
                }
                //当前单据携带有附件信息
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty(fileList)) {
                    Map<String, InputStream> fileMap = FileUtil.getInstance().batchDownFileFlow(fileIds, true);
                    fileMap.keySet().stream().forEach(fileKey -> {
                        Map<String, InputStream> file = new HashMap<>(1);
                        file.put(fileKey, fileMap.get(fileKey));
                        files.put("file", file);
                    });
                }
                logger.info("向供应商-{}推送附件参数-{}", entity.getSupplierId(), JSONObject.toJSONString(files));
                logger.info("向供应商-{}推送计量单据参数-{}", entity.getSupplierId(), JSONObject.toJSONString(paramMap));

                //推送单据到指定的供方
                CommonResponse<String> syncReqResp = systemDataPushService.exchangeDataAndFilesWithEachLinkSystem(PUSH_BILL_SERVER_URL,
                        paramMap,
                        entity.getSupplierId().toString(),
                        files);
//                syncFlag = CommonUtils.checkCommonResponse(syncReqResp, logger);
                if (syncReqResp.isSuccess()) {
                    CommonResponse<String> billPushResp = JSONObject.parseObject(syncReqResp.getData(), CommonResponse.class);
                    if (billPushResp.isSuccess()) {
                        syncFlag = true;
                    } else {
                        logger.error("供方id-{}处理推送订单单据id-{}失败, {}", entity.getSupplierId(), entity.getId(), billPushResp.getMsg());
                    }
                } else {
                    logger.error("发送请求推送订单单据id-{}给供方id-{}失败, {}", entity.getId(), entity.getSupplierId(), syncReqResp.getMsg());
                }
            } else {
                logger.error("获取订单单据id-{}对应附件信息失败, {}", entity.getId(), fileResp.getMsg());
            }

        } catch (Exception e) {
            logger.error("推送订单单据id-{}给供方id-{} 异常，", entity.getId(), entity.getSupplierId(), e);
//            throw e;
        } finally {
            //释放单据锁
            releaseLock(jedis, locked, key, OPERATE);
        }

        return syncFlag;
    }

    /*
     * 撤回推送供方
     *  */
    @Override
    public CommonResponse<String> updatePushBill(PurchaseSettlementEntity entity, String billTypeCode) {
        boolean locked = false;
        Jedis jedis = jedisPool.getResource();
        String key = billTypeCode + "::" + entity.getId().toString();
        //设置单据当前系统信息
        CommonResponse<String> ejcCloudSystemCode = proSupplierApi.getEjcCloudSystemCode();
        if (!ejcCloudSystemCode.isSuccess()) {
            logger.error("推送单据-{}失败，获取当前系统编码失败,{}", entity.getId(), ejcCloudSystemCode.getMsg());
            return CommonResponse.error("推送供方异常!");
        }
        //设置当前系统ID
        entity.setSystemId(ejcCloudSystemCode.getData());
        entity.setSignStatus(0);
        baseMapper.updateById(entity);
        logger.info("修改签字信息：{}", JSONObject.toJSONString(entity));
        try {
            jedis = jedisPool.getResource();
            //对单据进行加锁
            locked = RedisTool.tryLock(jedis, key, OPERATE, 600);

            if(!locked) {
                logger.error("单据作废失败，单据锁获取失败！");
                releaseLock(jedis, false, key, OPERATE);
                return CommonResponse.error("单据作废失败，单据锁获取失败!");
            }

            Map<String, String> paramMap = new HashMap<>();
            paramMap.put("id", entity.getId().toString());
            paramMap.put("systemId", entity.getSystemId());
            logger.info("单据id-{}弃审，通知供方-{}单据作废!", entity.getSupplierId(), entity.getId());
            //推送单据到指定的供方
            CommonResponse<String> syncReqResp = systemDataPushService.exchangeDataWithEachLinkSystem(DELPUSH_BILL_SERVER_URL,
                    RequestMethod.POST,
                    JSONObject.toJSONString(paramMap),
                    entity.getSupplierId().toString());

            if (syncReqResp.isSuccess()) {
                CommonResponse<String> supHandleResp = JSONObject.parseObject(syncReqResp.getData(), CommonResponse.class);
                if (supHandleResp.isSuccess()) {
                    return supHandleResp;
                } else {
                    logger.error("供方-{}处理作废单据id-{}作废失败, {}", entity.getSupplierId(), entity.getId(), supHandleResp.getMsg());
                    throw new BusinessException(supHandleResp.getMsg());
                }
            } else {
                logger.error("发送请求通知供方-{} 单据id-{}作废失败, {}", entity.getSupplierId(), entity.getId(), syncReqResp.getMsg());
                throw new BusinessException(syncReqResp.getMsg());
            }

        } catch (Exception e) {
            logger.error("通知供方单据id-{}作废异常，", entity.getId(), e);
            throw new BusinessException("推送供方异常!");
        } finally {
            releaseLock(jedis, locked, key, OPERATE);
        }
    }
    /*供方签字确认*/
    @Override
    public String updateBillSupSignSyncInfo(HttpServletRequest request) {
        String authority = request.getHeader("authority");
        String msg = null;

        Jedis jedis = null;
        boolean locked = false;

        String billId = request.getParameter("billId");
        String supOperatorName = request.getParameter("supOperatorName");
        String supOperatorPhone = request.getParameter("supOperatorPhone");
        String supOperatorUserCode = request.getParameter("supOperatorUserCode");
        Date supOperateTime = new Date(Long.parseLong(request.getParameter("supOperateTime")));
        String nameSourceTypeMapping = request.getParameter("nameSourceTypeMapping");
        Map<String, String> mp = JSONObject.parseObject(nameSourceTypeMapping, Map.class);

        PurchaseSettlementEntity purchaseSettlementEntity = super.selectById(billId);
        logger.info("billId----{}",billId);
        logger.info("----"+JSONObject.toJSONString(purchaseSettlementEntity));
        //设置供方签字信息
        purchaseSettlementEntity.setSupOperateTime(supOperateTime);
        purchaseSettlementEntity.setSupOperatorName(supOperatorName);
        purchaseSettlementEntity.setSupOperatorPhone(supOperatorPhone);
        purchaseSettlementEntity.setSupOperatorUserCode(supOperatorUserCode);

        String key = BILL_TYPE + "::" + purchaseSettlementEntity.getId().toString();

        try {
            jedis = jedisPool.getResource();
            //对单据进行加锁
            locked = RedisTool.tryLock(jedis, key, OPERATE, 600);

            if(!locked) {
                logger.error("单据id-{}签字信息回写加锁失败！", purchaseSettlementEntity.getId());
                releaseLock(jedis, false, key, OPERATE);
                return "单据签字信息回写加锁失败";
            }

            //保存单据中附件并获取到上传后附件的Id
            Map<String, List<Long>> attachIdsMap = FileUtil.getInstance().handleReqFile((MultipartHttpServletRequest) request,
                    mp, BILL_TYPE, authority, purchaseSettlementEntity.getId().toString());

            List<Long> attchIdsList = new ArrayList<>();
            for (List<Long> attachIds : attachIdsMap.values()) {
                if (CollectionUtils.isNotEmpty(attachIds)) {
                    attchIdsList.addAll(attachIds);
                }
            }
            //将附件关联在单据中
            purchaseSettlementEntity.setAttachIds(attchIdsList);
            //将单据设置为乙方已签字状态 签字状态：0-未签字 1-已签字
            // 乙方已签字状态即待甲方签字
            purchaseSettlementEntity.setSignStatus(1);
            //更新单据
            super.saveOrUpdate(purchaseSettlementEntity, false);

//            //向单据制单人和经办人推送该消息
//            String msgSendResult = sendMsg(checkEntity, "供方已签字提醒", "结算单据[" + settleEntity.getBillCode() + "]供方已签字完成");
//            if (null != msgSendResult) {
//                logger.error("向用户-{}发送单据id-{}签字提醒失败，原因：{}", StringUtils.join(settleEntity.getCreateUserId(), settleEntity.getEmployeeId()),
//                        settleEntity.getId(), msgSendResult);
//            }

        } catch (Exception e) {
            logger.error("单据id-{}签字信息回写异常，", purchaseSettlementEntity.getId(), e);
            msg = "单据签字信息回写失败！";
            throw e;
        } finally {
            releaseLock(jedis, locked, key, OPERATE);
        }

        return msg;
    }
    public void releaseLock(Jedis jedis, boolean locked, String key, String OPERATE) {
        try {
            if(locked) {
                RedisTool.releaseLock(jedis, key, OPERATE);
            }
        } finally {
            if(null != jedis) {
                jedis.close();
            }
        }
    }

    /*提交推送结算池*/
    @Override
    public boolean pushSettleToPool(PurchaseSettlementVO vo) {
        SettlePoolVO spv = new SettlePoolVO();
        boolean flag = false;
        try {
            logger.info("结算单对象 -> 结算池对象自动转换开始-----"+JSONObject.toJSONString(vo));
            // 对象自动转换
            BeanConvertorUtil.convert(vo, spv);
            logger.info("结算单对象 -> 结算池对象自动转换结束，下面开始手动转换");

            // 个别字段需要手动封装
            convertSettleVOToSettlePoolVO(vo, spv);
            spv.setBillCodeUrl("/ejc-proequipmentp-frontend/#/settlementList/settlementCard?id="+vo.getId());
            logger.info("推送参数----"+JSONObject.toJSONString(spv));
            CommonResponse<SettlePoolVO> res = settlePoolApi.saveOrUpdateSettle(spv);
            logger.info("结算单推送结算池结束---"+JSONObject.toJSONString(res));
            if(res.isSuccess()){
                flag = true;
                logger.info("结算单推送合同池成功---{}", res.getMsg());
            }else {
                logger.error("结算单推送合同池失败！结算单id-{}，{}",vo.getId(), res.getMsg());
                throw new BusinessException("结算单弃审推送合同池失败!");
            }
        } catch (Exception e) {
            logger.error("结算单推送合同池失败！结算单id-{}", vo.getId(), e);
            throw new BusinessException("结算单推送合同池异常!");
        }
        return flag;
    }

    /*弃审删除结算池*/
// 从结算池中删除数据
    @Override
    public boolean delSettleFromPool(Long id) {
        SettlePoolVO spv = new SettlePoolVO();
        boolean flag = false;
        spv.setSourceId(id);
        try {
            logger.info("结算单弃审推送结算池开始,结算单id-{}",id);
            CommonResponse<SettlePoolVO> res = settlePoolApi.deleteSettle(spv);
            logger.info("结算单推送结算池结束---"+JSONObject.toJSONString(res));
            if(res.isSuccess()){
                flag = true;
                logger.info("结算单弃审推送合同池成功---{}", res.getMsg());
            }else {
                logger.error("结算单推送合同池失败！结算单id-{}，{}",id, res.getMsg());
                throw new BusinessException("结算单弃审推送合同池失败!");
            }
        }catch (Exception e){
            logger.error("结算单弃审推送合同池失败！结算单id-{}", id, e);
            throw new BusinessException("结算单弃审推送合同池异常!");
        }
        return flag;
    }


    // 将SettlementVO转换成settlePoolVO
    private void convertSettleVOToSettlePoolVO(PurchaseSettlementVO vo, SettlePoolVO spv) {
        if (null == vo || null == spv) {
            logger.error("将结算单推送至结算池失败！原因：结算单对象为空或结算池对象为空，结算单对象 -> 结算池对象无法转换！");
            return;
        }
        logger.info("结算单对象 -> 结算池对象手动转换开始");
        //单据类似  单据状态 ：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
        switch (vo.getBillState()){
            case 0: spv.setBillStateName("自由态");break;
            case 1: spv.setBillStateName("已提交");break;
            case 3: spv.setBillStateName("审批通过");break;
            case 4: spv.setBillStateName("审批驳回");break;
            default: spv.setBillStateName("审批中");break;
        }
        spv.setId(vo.getId());
        spv.setSourceType(SettleSourceTypeEnum.设备采购结算.getCode());
        spv.setSettlePropertyName("支出");
        spv.setSettleProperty(0);//属性类别，0支出，1收入
        spv.setSourceId(vo.getId());//结算单id
        spv.setCreateUserCode(vo.getCreateUserCode());//结算创建者账号
        spv.setCreateTime(vo.getCreateTime());//结算创建时间
        spv.setUpdateUserCode(vo.getUpdateUserCode());//结算修改者账号
        spv.setUpdateTime(vo.getUpdateTime());//结算修改时间
        spv.setContractFlag(0);// 是否有合同：1-是，0-否
        spv.setHandleType(0);
        if(vo.getContractId()!=null){//有合同需要推送的字段
            spv.setContractFlag(1);// 是否有合同：1-是，0-否
            //查询合同
            PurchaseContractEntity contractEntity = contractService.selectById(vo.getContractId());
            spv.setContractType(ContractTypeEnum.设备采购.getTypeCode());
            spv.setSupplementFlag(contractEntity.getSupplementFlag());//是否补充写协议
            spv.setMaiContractId(contractEntity.getMainContractId());//原合同id
            spv.setMaiContractName(contractEntity.getMainContractName());//原合同name
            spv.setMaiContractCode(contractEntity.getMainContractCode());//原合同code
            spv.setContractCode(contractEntity.getBillCode());//合同编码
            spv.setPartyaId(contractEntity.getFirstPartyId());//甲方id
            spv.setPartyaName(contractEntity.getFirstPartyName());//甲方name
            spv.setSignDate(contractEntity.getSignDate());//签订日期
            spv.setLastTaxMny(ComputeUtil.safeSub(vo.getCurrentSettlementTaxMny(),vo.getSettlementTaxMny()));//截止本期已结算金额（含税，不含本期）
            spv.setLastMny(ComputeUtil.safeSub(vo.getCurrentSettlementMny(),vo.getSettlementMny()));//截止本期已结算金额(无税，不含本期)
            spv.setLastTax(ComputeUtil.safeSub(spv.getLastTaxMny(),spv.getLastMny()));//截止本期税额（不含本期）
        }
        logger.info("结算单对象 -> 结算池对象手动转换完成，下面开始推送至结算池");
    }
    /**
     * 计算差值
     * @param a 变量a
     * @param b 变量b
     * @return 差值的绝对值，当其中一个变量为null时 或 计算出来的差值为null时 返回null
     */
    private BigDecimal getSubStractAbs(BigDecimal a, BigDecimal b) {
        if (a == null || b == null) {
            return null;
        }
        BigDecimal subtract = a.subtract(b);
        if (subtract == null) {
            return null;
        }
        return subtract.abs();
    }
//    @Override
//    public ExecutionVO targetCost(PurchaseSettlementVO settlementVO, String linkUrl) {
//        List<DetailExecutionVO> detailList = new ArrayList<>();
//        // 计算所有过程结算累计结算金额
//        LambdaQueryWrapper<PurchaseSettlementEntity> wrapper = new LambdaQueryWrapper<>();
//        wrapper.eq(PurchaseSettlementEntity::getContractId, settlementVO.getContractId());
//        wrapper.in(PurchaseSettlementEntity::getBillState, Arrays.asList(1, 3));
//        List<PurchaseSettlementEntity> list = settlementService.list(wrapper);
//        if (CollectionUtils.isEmpty(list)){
//            throw new BusinessException("结算数据不存在");
//        }
//        BigDecimal totalSettleTaxMny = list.stream().filter(e -> e.getSettlementTaxMny() != null).map(PurchaseSettlementEntity::getSettlementTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
//        BigDecimal totalSettleMny = list.stream().filter(e -> e.getSettlementMny() != null).map(PurchaseSettlementEntity::getSettlementMny).reduce(BigDecimal.ZERO, BigDecimal::add);
//
//        // 查询合同
//        PurchaseContractEntity contractEntity = contractService.getById(settlementVO.getContractId());
//        PurchaseContractVO contractVO = BeanMapper.map(contractEntity, PurchaseContractVO.class);
//
//        ExecutionVO executionVO = new ExecutionVO();
//        TotalExecutionVO totalVO = new TotalExecutionVO();
//        totalVO.setSourceId(settlementVO.getId());
//        totalVO.setTenantId(settlementVO.getTenantId());
//        totalVO.setBillCode(settlementVO.getBillCode());
//        totalVO.setBillType(BILL_TYPE);
//        totalVO.setBussinessType(BussinessTypeEnum.设备采购合同.getCode());
//        totalVO.setBillCategory(BillCategoryEnum.合同.getCode());
//        totalVO.setProjectId(settlementVO.getProjectId());
//        totalVO.setOrgId(settlementVO.getOrgId());
//        totalVO.setMoney(ComputeUtil.safeDiv(totalSettleMny, contractEntity.getContractMny()));
//        totalVO.setTaxMoney(ComputeUtil.safeDiv(totalSettleTaxMny, contractEntity.getContractTaxMny()));
//        totalVO.setLinkUrl(linkUrl);
//        //获取结算子表进行汇总
//        List<Long> settleIdList = list.stream().map(PurchaseSettlementEntity::getId).collect(Collectors.toList());
//        //根据结算单查询子表
//        LambdaQueryWrapper<PurchaseSettlementDetailEntity> detailWrapper = new LambdaQueryWrapper<>();
//        detailWrapper.in(PurchaseSettlementDetailEntity::getSettlementId, settleIdList);
//        List<PurchaseSettlementDetailEntity> settleDetailList = PurchaseSettlementDetailEntity.list(detailWrapper);
//        if(CollectionUtils.isNotEmpty(settleDetailList)){
//            //根据物资Id进行分组
//            Map<Long, List<PurchaseSettlementDetailEntity>> detailMaterialMap = settleDetailList.stream().collect(Collectors.groupingBy(SettlementDetailEntity::getMaterialId));
//            for (Long materialId : detailMaterialMap.keySet()) {
//                List<PurchaseSettlementDetailEntity> detailMaterialList = detailMaterialMap.get(materialId);
//                //进行数量，金额汇总
//                BigDecimal sumNum = detailMaterialList.stream().filter(e -> e.gt != null).map(PurchaseSettlementDetailEntity::getNum).reduce(BigDecimal.ZERO, BigDecimal::add);
//                BigDecimal sumMny = detailMaterialList.stream().filter(e -> e.getMny() != null).map(PurchaseSettlementDetailEntity::getMny).reduce(BigDecimal.ZERO, BigDecimal::add);
//                BigDecimal sumTaxMny = detailMaterialList.stream().filter(e -> e.getTaxMny() != null).map(PurchaseSettlementDetailEntity::getTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
//                PurchaseSettlementDetailEntity planDetailVO = detailMaterialList.get(0);
//                DetailExecutionVO detailExecutionVO = new DetailExecutionVO();
//                detailExecutionVO.setSourceId(planDetailVO.getId());
//                detailExecutionVO.setSourceBillId(planDetailVO.getSettlementId());
//                detailExecutionVO.setCategoryId(planDetailVO.getMaterialTypeId());
//                detailExecutionVO.setCategoryName(planDetailVO.getMaterialTypeName());
//                //判断是否是分类
//                if (planDetailVO.getMaterialId()==null){
//                    detailExecutionVO.setCategoryFlag(true);
//                    detailExecutionVO.setDocId(planDetailVO.getMaterialTypeId());
//                }else {
//                    detailExecutionVO.setCategoryFlag(false);
//                    detailExecutionVO.setDocId(planDetailVO.getMaterialId());
//                }
//                detailExecutionVO.setCode(planDetailVO.getMaterialCode());
//                detailExecutionVO.setCategoryContainFlag(false);
//                //根据分类ID查询物料分类信息
//                MaterialCategoryVO categoryVO = materialApi.queryCategoryById(planDetailVO.getMaterialTypeId()).getData();
//                if (categoryVO == null) {
//                    detailExecutionVO.setCategoryInnerCode(null);
//                    detailExecutionVO.setCategoryCode(null);
//                }
//                else {
//                    detailExecutionVO.setCategoryInnerCode(categoryVO.getInnerCode());
//                    detailExecutionVO.setCategoryCode(categoryVO.getCode());
//                }
//                detailExecutionVO.setDocType(DocTypeEnum.物料档案.getCode());
//                detailExecutionVO.setName(planDetailVO.getMaterialName());
//                detailExecutionVO.setUnitId(planDetailVO.getUnitId());
//                detailExecutionVO.setUnitName(planDetailVO.getUnit());
//                detailExecutionVO.setPrice(planDetailVO.getPrice());
//                detailExecutionVO.setTaxPrice(planDetailVO.getTaxPrice());
//                detailExecutionVO.setNum(sumNum);
//                detailExecutionVO.setMoney(sumMny);
//                detailExecutionVO.setSpec(planDetailVO.getSpec());
//                detailExecutionVO.setTaxMoney(sumTaxMny);
//                detailList.add(detailExecutionVO);
//            }
//        }
//        executionVO.setTotalVO(totalVO);
//        executionVO.setDetailList(detailList);
//        return executionVO;
//    }

    //单据参数控制
    @Override
    public ParamsCheckVO checkParams(PurchaseSettlementVO vo){
        List<ParamsCheckVO> paramsCheckVOS = new ArrayList<>();
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        /*参数控制区域*/
        //----start有合同预警域
        if(vo.getContractId()!=null) {
            PurchaseContractEntity contractEntity = contractService.selectById(vo.getContractId());
            paramsCheckVOS.addAll(this.checkParamsMny(contractEntity,vo));//金额
        }
        /*--end---参数控制区域*/
        Map<String, List<ParamsCheckDsVO>> map = new HashMap<>();
        String[] paramsArray = {"alert", "warn", "none"};
        if(CollectionUtils.isNotEmpty(paramsCheckVOS)){
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if(map.containsKey(warnType)){
                    List<ParamsCheckDsVO> checkDsVOS = map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType,checkDsVOS);
                }else {
                    map.put(warnType,checkVO.getDataSource());
                }
            }
        }
        for (String s : paramsArray) {
            if(map.containsKey(s)){
                paramsCheckVO.setWarnType(s);
                paramsCheckVO.setDataSource(map.get(s));
                if(CollectionUtils.isEmpty(paramsCheckVO.getDataSource())){
                    paramsCheckVO.setWarnType("none");
                }else {
                    return paramsCheckVO;
                }
            }
        }
        return paramsCheckVO;
    }
    /*
     *合同金额控结算金额
     */
    @Override
    public List<ParamsCheckVO> checkParamsMny(PurchaseContractEntity contractEntity, PurchaseSettlementVO vo) {
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        List<ParamsCheckVO> paramsCheckVOList = new ArrayList<>();

        String CHECK_PARAM_CODE = "";
        switch (vo.getSignatureType()){//结算类型，0-过程,1-最终
            case 0:CHECK_PARAM_CODE= CHECK_PARAM_CODE_GC;break;
            case 1:CHECK_PARAM_CODE= CHECK_PARAM_CODE_ZZ;break;
        }
        CommonResponse<List<BillParamVO>> billParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(CHECK_PARAM_CODE, vo.getOrgId());
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            List<BillParamVO> data = billParamByCode.getData();
            logger.info("结算金额控制信息返回："+JSONObject.toJSONString(data));
            if(CollectionUtils.isNotEmpty(data)){
                for (BillParamVO datum : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    List<ParamsCheckDsVO> checkDsVOS = new ArrayList<>();
                    BigDecimal roleValue = datum.getRoleValue();
                    BigDecimal totalSettleTaxMny = null==vo.getCurrentSettlementTaxMny()?BigDecimal.ZERO:vo.getCurrentSettlementTaxMny();
                    BigDecimal settleTaxMny = null==vo.getSettlementTaxMny()?BigDecimal.ZERO:vo.getSettlementTaxMny();
                    BigDecimal comMny = ComputeUtil.safeDiv(ComputeUtil.safeMultiply(contractEntity.getContractTaxMny(), roleValue), new BigDecimal("100")).setScale(2, BigDecimal.ROUND_HALF_UP);
                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    if (totalSettleTaxMny.compareTo(comMny) > 0) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setOrgName(datum.getOrgName());
                        paramsCheckDsVO.setWarnItem("合同超结");
                        paramsCheckDsVO.setWarnName("累计结算金额大于合同金额");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("本次结算金额：").append(settleTaxMny.toString())
                                .append("元，含本次累计结算金额：").append(totalSettleTaxMny)
                                .append("元，合同金额*").append(roleValue).append("%:").append(comMny)
                                .append("元。超出金额：").append(ComputeUtil.safeSub(totalSettleTaxMny, comMny)).append("元");
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOList.add(paramsCheckVO);
                }
            }

        } else {
            logger.info(billParamByCode.getMsg());
            throw new BusinessException("获取控制参数失败");
        }

        return paramsCheckVOList;
    }

    @Override
    public ContractSettlementRecordVO queryDetailRecord(Long contractId) {
        ContractSettlementRecordVO settleRecordVO = new ContractSettlementRecordVO();

        PurchaseContractEntity contract = contractService.selectById(contractId);
        settleRecordVO.setContractId(contract.getId());
        settleRecordVO.setContractTaxMny(contract.getContractTaxMny());
        settleRecordVO.setPerformanceStatus(contract.getContractPerformanceState());

        QueryWrapper<PurchaseSettlementEntity> listQuery = new QueryWrapper<>();
        listQuery.eq("contract_id", contractId);
        listQuery.in("bill_state", BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE
                .getBillStateCode());
        listQuery.orderByDesc("settlement_date");
        List<PurchaseSettlementEntity> list = super.list(listQuery);
        List<PurchaseSettlementVO> rentSettlementVOS = BeanMapper.mapList(list, PurchaseSettlementVO.class);
        settleRecordVO.setSettleList(rentSettlementVOS);

        //累计结算金额
        BigDecimal contractSettleMny = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty(list)) {
            contractSettleMny = list.stream().map(PurchaseSettlementEntity::getSettlementTaxMny)
                    .reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        settleRecordVO.setContractSettleMny(contractSettleMny);

        if (BigDecimal.ZERO.compareTo(settleRecordVO.getContractTaxMny()) == 0) {
            settleRecordVO.setSettleRate(BigDecimal.ZERO);
        }
        else {
            settleRecordVO.setSettleRate((settleRecordVO.getContractSettleMny().multiply(BigDecimal.valueOf(100)))
                    .divide(settleRecordVO.getContractTaxMny(), 8, RoundingMode.HALF_UP));
        }
        return settleRecordVO;
    }
    // 结算审批通过后/撤回后更新合同池累计结算金额（含税、无税、税额），type：是审批通过还是撤回标识，"true"审批通过后，"false"撤回后
    @Override
    public void updateContractPoolSettle(PurchaseSettlementVO vo, Boolean type) {
        if(null!=vo.getContractId()) {//有合同推送
            logger.info("ID为【" + vo.getContractId() + "】的合同 " + vo.getBillCode() + "结算" + (type ? "撤回" : "审批通过") + "后更新合同池累计结算金额（含税、无税、税额），settleEntity={}, 过程（0）/最终（1）={}, type={}", vo, vo.getSignatureType(), type);
            //计算累计计算金额
            BigDecimal totalSettleTaxMny = BigDecimal.ZERO;         // 累计结算金额含税初始化
            BigDecimal totalSettleMny = BigDecimal.ZERO;            // 累计结算金额无税初始化
            BigDecimal totalSettleTax = BigDecimal.ZERO;            // 累计结算税额初始化
            if (type) {
                totalSettleTaxMny = vo.getCurrentSettlementTaxMny() == null ? BigDecimal.ZERO : vo.getCurrentSettlementTaxMny();
                totalSettleMny = vo.getCurrentSettlementMny() == null ? BigDecimal.ZERO : vo.getCurrentSettlementMny();
                totalSettleTax = ComputeUtil.safeSub(totalSettleTaxMny, totalSettleMny);
            } else {//撤回删除本次结算金额
                totalSettleTaxMny = ComputeUtil.safeSub(vo.getCurrentSettlementTaxMny(), vo.getSettlementTaxMny());
                totalSettleMny = ComputeUtil.safeSub(vo.getCurrentSettlementMny(), vo.getSettlementMny());
                totalSettleTax = ComputeUtil.safeSub(totalSettleTaxMny, totalSettleMny);
            }
            // 封装
            ContractPoolVO contractPoolVO = new ContractPoolVO();
            contractPoolVO.setSourceId(vo.getContractId());
            contractPoolVO.setTotalSettleTaxMny(totalSettleTaxMny);        // 含税
            contractPoolVO.setTotalSettleMny(totalSettleMny);                 // 无税
            contractPoolVO.setTotalSettleTax(totalSettleTax);     // 税额
            if (1 == vo.getSignatureType()) {//signatureType; // 结算类型，0-过程,1-最终
                if (type) {//通过
                    contractPoolVO.setFinishSettleDate(new Date());
                    contractPoolVO.setPerformanceStatus(ContractPerformanceStateEnum.已终止.getStateCode());//performanceStatus
                } else {
                    contractPoolVO.setFinishSettleDate(null);
                    contractPoolVO.setPerformanceStatus(ContractPerformanceStateEnum.履约中.getStateCode());//performanceStatus
                }
            }
            logger.info("ID为【" + vo.getContractId() + "】的合同 " + vo.getBillCode() + "结算" + ("back".equals(type) ? "撤回" : "审批通过") + "后更新合同池累计结算金额（含税、无税、税额），结束，更新合同池接口入参：{}", JSONObject.toJSONString(contractPoolVO));
            CommonResponse<ContractPoolVO> updateConPoolRes = contractPoolApi.saveOrUpdateContract(contractPoolVO);
            logger.info("ID为【" + vo.getContractId() + "】的合同 " + vo.getBillCode() + "结算" + ("back".equals(type) ? "撤回" : "审批通过") + "后更新合同池累计结算金额（含税、无税、税额），结束，更新合同池接口返回结果：{}", JSONObject.toJSONString(updateConPoolRes));
        }
    }
}
