package com.ejianc.business.purchase.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.contractbase.pool.enums.ContractPerformanceStateEnum;
import com.ejianc.business.purchase.bean.ChangePurchaseContractEntity;
import com.ejianc.business.purchase.bean.PurchaseContractEntity;
import com.ejianc.business.purchase.enums.ChangeStatusEnum;
import com.ejianc.business.purchase.enums.DraftTypeEnum;
import com.ejianc.business.purchase.enums.SignatureStatusEnum;
import com.ejianc.business.purchase.service.IChangePurchaseContractService;
import com.ejianc.business.purchase.service.IPurchaseContractService;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

@Service("changePurchaseContract") 
public class ChangePurchaseContractBpmServiceImpl implements ICommonBusinessService {

	@Autowired
	private IChangePurchaseContractService changeService;

	@Autowired
	private IPurchaseContractService contractService;

	@Autowired
	private IProjectPoolApi projectPoolApi;

	@Autowired
	private SessionManager sessionManager;

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//设置单据提交人信息
		ChangePurchaseContractEntity e = changeService.selectById(billId);
		UserContext userContext = sessionManager.getUserContext();

		e.setCommitDate(new Date());
		e.setCommitUserCode(userContext.getUserCode());
		e.setCommitUserName(userContext.getUserName());
		changeService.saveOrUpdate(e, false);
		return CommonResponse.success("变更回调处理完成！");
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return bpmBackCheck(billId, state, billTypeCode);
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return doBpmBack(billId, state, billTypeCode);
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		/**更新变更的审批时间  begin */
		ChangePurchaseContractEntity changeEntity = changeService.selectById(billId);
		logger.info("变更单终审审批前变更表数据------------->: {}", JSONObject.toJSONString(changeEntity));
//		if (null != changeEntity && !(changeEntity.getBillState().equals(BillStateEnum.UNCOMMITED_STATE.getBillStateCode()) || changeEntity.getBillState().equals(BillStateEnum.UNAPPROVED.getBillStateCode()))){
//			return CommonResponse.error("该单据已被修改，请勿重复提交！");
//		}
		return CommonResponse.success("变更单终审审批前回调处理成功！");
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		/**更新变更的审批时间  begin */
		ChangePurchaseContractEntity changeEntity = changeService.selectById(billId);
		logger.info("更新合同表数据成功,contractEntity---------->: {}", JSONObject.toJSONString(changeEntity));
		Boolean commitState = false;
		if(state.equals(BillStateEnum.COMMITED_STATE.getBillStateCode())) {
			commitState = true;
			//直审设置单据提交人信息
			changeEntity.setCommitDate(new Date());
			changeEntity.setCommitUserCode(sessionManager.getUserContext().getUserCode());
			changeEntity.setCommitUserName(sessionManager.getUserContext().getUserName());
			logger.info("更新合同表数据成功1,contractEntity---------->: {}", JSONObject.toJSONString(changeEntity));
		}
		if (DraftTypeEnum.线下签订.getCode().toString().equals(changeEntity.getChangeDraftType())){
			//调用生效回写服务
			logger.info("更新合同表数据成功2,contractEntity---------->: {}", JSONObject.toJSONString(changeEntity));
			CommonResponse<String> rsp = changeService.effectiveSaveWriteContract(billId, billTypeCode, commitState, false);
			if (!rsp.isSuccess()) {
				throw new BusinessException("审批回写失败!失败原因：" + rsp.getMsg());
			}
		}else {
			//变更单更新
			if (commitState){
				changeService.saveOrUpdate(changeEntity);
			}
			//回写主合同信息
			PurchaseContractEntity contractEntity = contractService.selectById(changeEntity.getContractId());
			contractEntity.setChangeStatus(ChangeStatusEnum.变更单据审批通过.getCode());
			contractService.saveOrUpdate(contractEntity, false);
			logger.info("更新合同表数据成功,contractEntity---------->: {}", JSONObject.toJSONString(contractEntity));
		}
		changeService.asyncWatermarkById(billId);
		return CommonResponse.success("审批回调合同成功！");
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return bpmBackCheck(billId, state, billTypeCode);
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		return doBpmBack(billId, state, billTypeCode);
	}
	/**
	 * @param billId
	 * @param state
	 * @param billTypeCode
	 * @return
	 */
	@Transactional(rollbackFor = Exception.class)
	public CommonResponse<String> doBpmBack(Long billId, Integer state, String billTypeCode) {
		CommonResponse<String> resp = null;
		//提交通过、且未签章则可弃审
		ChangePurchaseContractEntity changeEntity = changeService.selectById(billId);

		if (!(SignatureStatusEnum.未签章.getCode().equals(changeEntity.getSignatureStatus()))){
			return CommonResponse.error("当前单据已有签章流程，不能撤回！");
		}
		changeEntity.setCommitDate(null);
		changeEntity.setCommitUserCode(null);
		changeEntity.setCommitUserName(null);
		changeService.saveOrUpdate(changeEntity);
//		logger.info("撤回更新变更表数据成功,contractEntity---------->: {}", JSONObject.toJSONString(changeEntity));

		PurchaseContractEntity contractEntity = contractService.selectById(changeEntity.getContractId());
		contractEntity.setChangeStatus(ChangeStatusEnum.变更中.getCode());
		contractService.saveOrUpdate(contractEntity, false);
//		logger.info("撤回更新合同表数据成功,contractEntity---------->: {}", JSONObject.toJSONString(contractEntity));

		return CommonResponse.success("执行变更单撤回回调逻辑成功！");
	}
	private CommonResponse<String> bpmBackCheck(Long billId, Integer state, String billTypeCode) {
		ChangePurchaseContractEntity contractChangeEntity = changeService.selectById(billId);
		// 审批可以撤回的签章状态集合
		ArrayList<String> statusList = new ArrayList<>();
		statusList.add(SignatureStatusEnum.未签章.getCode());
		statusList.add(SignatureStatusEnum.已退回.getCode());
		statusList.add(SignatureStatusEnum.已撤回.getCode());
		statusList.add(SignatureStatusEnum.已过期.getCode());

		//使用电子签章且已有签章流程则不允许撤回
		if (!DraftTypeEnum.线下签订.getCode().toString().equals(contractChangeEntity.getChangeDraftType())
				&& !statusList.contains(contractChangeEntity.getSignatureStatus())) {
			return CommonResponse.error("当前单据已有签章流程，不能撤回！");
		}
		else if (SignatureStatusEnum.已签章.getCode().equals(contractChangeEntity.getSignatureStatus())) {
			contractChangeEntity.setSignatureStatus(SignatureStatusEnum.未签章.getCode());
			contractChangeEntity.setContractPerformanceState(ContractPerformanceStateEnum.未签订.getStateCode());

		}
		contractChangeEntity.setCommitDate(null);
		contractChangeEntity.setCommitUserCode(null);
		contractChangeEntity.setCommitUserName(null);
		changeService.saveOrUpdate(contractChangeEntity);
		logger.info("撤回更新变更表数据成功,contractEntity---------->: {}", JSONObject.toJSONString(contractChangeEntity));

		PurchaseContractEntity contractEntity = contractService.selectById(contractChangeEntity.getContractId());
		contractEntity.setChangeStatus(ChangeStatusEnum.变更中.getCode());
		contractService.saveOrUpdate(contractEntity, false);

		logger.info("撤回更新合同表数据成功,contractEntity---------->: {}", JSONObject.toJSONString(contractEntity));

		return CommonResponse.success("弃审/撤回前校验回调成功！");
	}
	/**
	 * 审批--获取当前节点的审批人---从服务中选择
	 *
	 * @param billId 单据id
	 * @param billTypeCode 单据类型编码
	 * @param sign 节点标志
	 * @return
	 */
	@Override
	public CommonResponse<JSONArray> queryApproveUser(Long billId, String billTypeCode, String sign, Map<String, Object> other){
		JSONArray arr = new JSONArray();
		logger.info("sign:{}",sign);

		//根据标识判断是否（成本相关人员审批的）节点
		if ("choseCostUser".equals(sign)){
			//获取表单详情数据

			//根据项目id获取项目基本信息中的成本对接人信息
			ChangePurchaseContractEntity entity = changeService.selectById(billId);
			Long projectId = entity.getProjectId();

			JSONObject jsonObject = new JSONObject();
			CommonResponse<JSONArray> commonResponse = projectPoolApi.queryProjectPoolById(projectId);


			if(!commonResponse.isSuccess()){
				throw new BusinessException("查询项目失败!");
			}
			JSONArray array = commonResponse.getData();
			List<ProjectPoolSetVO> vos = JSONObject.parseArray(array.toJSONString(), ProjectPoolSetVO.class);

			logger.info("vos:{}",JSONObject.toJSONString(vos));

			ProjectPoolSetVO vo = vos.get(0);
			Long costAdapter = vo.getCostAdapter();
			String costAdapterName = vo.getCostAdapterName();

			logger.info("userId:{}",costAdapter);
			logger.info("userName:{}",costAdapterName);


			jsonObject.put("userId",costAdapter);
			jsonObject.put("userName",costAdapterName);

			arr.add(jsonObject);

		}
		return CommonResponse.success(arr);
	}
}
