/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.acceptance.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.acceptance.bean.PurchaseAcceptanceEntity;
import com.ejianc.business.acceptance.bean.PurchaseAcceptanceSubEntity;
import com.ejianc.business.acceptance.service.IPurchaseAcceptanceService;
import com.ejianc.business.acceptance.service.IPurchaseAcceptanceSubService;
import com.ejianc.business.asset.bean.AssetEntity;
import com.ejianc.business.asset.service.IAssetService;
import com.ejianc.business.purchase.bean.EquipmentDetailedEntity;
import com.ejianc.business.purchase.bean.PurchaseContractEntity;
import com.ejianc.business.purchase.service.IEquipmentDetailedService;
import com.ejianc.business.purchase.service.IPurchaseContractService;
import com.ejianc.business.rent.vo.RentParameterVO;
import com.ejianc.business.temporary.settlement.api.ITemporarySettlementApi;
import com.ejianc.foundation.share.api.IShareEquipmentApi;
import com.ejianc.foundation.share.vo.EquipmentVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="purchaseAcceptance")
public class PurchaseAcceptanceBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IPurchaseAcceptanceService service;
    @Autowired
    private IPurchaseContractService contractService;
    @Autowired
    private IEquipmentDetailedService equipmentDetailedService;
    @Autowired
    private IPurchaseAcceptanceSubService subService;
    @Autowired
    private IAssetService assetService;
    @Autowired
    private IShareEquipmentApi shareEquipmentApi;
    @Autowired
    private ITemporarySettlementApi temporarySettlementApi;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"purchase_acceptance_id", (Object)billId);
        List list = this.assetService.list((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)list)) {
            this.assetService.pushAsset(billId);
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        PurchaseAcceptanceEntity e = (PurchaseAcceptanceEntity)((Object)this.service.selectById(billId));
        QueryParam params = new QueryParam();
        params.getParams().put("pid", new Parameter("eq", (Object)billId));
        List subEntityList = this.subService.queryList(params);
        this.logger.info("11111111111111---------->: {}", (Object)JSONObject.toJSONString((Object)subEntityList));
        PurchaseAcceptanceSubEntity subEntity = (PurchaseAcceptanceSubEntity)((Object)subEntityList.get(0));
        this.logger.info("22222222222222---------->: {}", (Object)JSONObject.toJSONString((Object)((Object)subEntity)));
        UserContext userContext = this.sessionManager.getUserContext();
        PurchaseContractEntity contractEntity = (PurchaseContractEntity)((Object)this.contractService.selectById(e.getContractId()));
        this.logger.info("333333333333333---------->: {}", (Object)JSONObject.toJSONString((Object)((Object)contractEntity)));
        QueryParam param = new QueryParam();
        param.getParams().put("contractId", new Parameter("eq", (Object)contractEntity.getId()));
        param.getParams().put("docCategoryId", new Parameter("eq", (Object)subEntity.getEquipmentTypeId()));
        param.getParams().put("docId", new Parameter("eq", (Object)subEntity.getEquipmentId()));
        List equipmentList = this.equipmentDetailedService.queryList(param);
        this.logger.info("4444444444444444---------->: {}", (Object)JSONObject.toJSONString((Object)equipmentList));
        EquipmentDetailedEntity equipmentDetailedEntity = (EquipmentDetailedEntity)((Object)equipmentList.get(0));
        this.logger.info("555555555555555555---------->: {}", (Object)JSONObject.toJSONString((Object)((Object)equipmentDetailedEntity)));
        if (equipmentDetailedEntity.getAcceptanceQuantity() == null) {
            equipmentDetailedEntity.setAcceptanceQuantity(1);
        } else {
            equipmentDetailedEntity.setAcceptanceQuantity(equipmentDetailedEntity.getAcceptanceQuantity() + 1);
        }
        this.equipmentDetailedService.saveOrUpdate((Object)equipmentDetailedEntity);
        return CommonResponse.success((String)"\u4f7f\u7528\u8bb0\u5f55\u5ba1\u6279\u56de\u8c03\u5904\u7406\u6210\u529f\uff01");
    }

    private void pushRentParameter(PurchaseAcceptanceEntity entity) {
        ArrayList<RentParameterVO> parameterList = new ArrayList<RentParameterVO>();
        List<PurchaseAcceptanceSubEntity> acceptanceSubList = entity.getPurchaseAcceptanceSubList();
        PurchaseContractEntity contractEntity = (PurchaseContractEntity)((Object)this.contractService.selectById(entity.getContractId()));
        List equipmentIds = acceptanceSubList.stream().map(PurchaseAcceptanceSubEntity::getEquipmentId).collect(Collectors.toList());
        CommonResponse listCommonResponse = this.shareEquipmentApi.queryEquipmentItemByIds(equipmentIds);
        this.logger.info("\u83b7\u53d6\u8bbe\u5907\u6863\u6848\u4fe1\u606f\u5f00\u59cb:{}", (Object)JSONObject.toJSONString((Object)listCommonResponse));
        List equipmentVOList = new ArrayList();
        if (listCommonResponse.getCode() == 0) {
            this.logger.info("\u83b7\u53d6\u8bbe\u5907\u6863\u6848\u4fe1\u606f\u6210\u529f\uff01");
            equipmentVOList = (List)listCommonResponse.getData();
        }
        for (PurchaseAcceptanceSubEntity e : acceptanceSubList) {
            RentParameterVO parameter = new RentParameterVO();
            parameter.setContractId(entity.getContractId());
            parameter.setContractName(entity.getContractName());
            parameter.setEngineeringId(entity.getProjectId());
            parameter.setEngineeringName(entity.getProjectName());
            parameter.setSupplierId(entity.getSupplierId());
            parameter.setSupplierName(entity.getSupplierName());
            parameter.setProjectId(entity.getProjectId());
            parameter.setProjectCode(entity.getProjectCode());
            parameter.setProjectName(entity.getProjectName());
            parameter.setAcceptanceId(entity.getId());
            parameter.setAcceptanceDate(entity.getAcceptanceDate());
            parameter.setSourceId(entity.getId());
            if (contractEntity != null) {
                parameter.setOrgId(contractEntity.getOrgId());
                parameter.setOrgName(contractEntity.getOrgName());
                parameter.setParentOrgId(contractEntity.getParentOrgId());
                parameter.setParentOrgCode(contractEntity.getParentOrgCode());
                parameter.setParentOrgName(contractEntity.getParentOrgName());
            } else {
                parameter.setOrgId(entity.getOrgId());
                parameter.setOrgName(entity.getOrgName());
                parameter.setParentOrgId(entity.getParentOrgId());
                parameter.setParentOrgCode(entity.getParentOrgCode());
                parameter.setParentOrgName(entity.getParentOrgName());
            }
            parameter.setFactoryCode(e.getEquipmentCode());
            parameter.setCategoryId(e.getEquipmentTypeId());
            parameter.setCategoryName(e.getEquipmentType());
            parameter.setSpec(e.getSpec());
            parameter.setUnitName(e.getCompany());
            parameter.setStartDate(entity.getAcceptanceDate());
            parameter.setProductionManufactor(e.getManufacturer());
            parameter.setMemo(e.getDetailMemo());
            parameter.setEquipmentCode(e.getEquipmentCode());
            parameter.setEquipmentId(e.getEquipmentId());
            parameter.setName(e.getEquipmentName());
            parameter.setNum(Integer.valueOf(e.getContractNum().intValue()));
            parameter.setAcceptanceDetailId(e.getId());
            parameter.setEquipmentName(e.getEquipmentName());
            parameter.setPrice(e.getPurchasePrice());
            parameter.setOperationDate(new Date());
            parameter.setEquipmentState(Integer.valueOf(2));
            if (equipmentVOList.size() > 0) {
                for (EquipmentVO equipmentVO : equipmentVOList) {
                    if (!equipmentVO.getId().equals(e.getEquipmentId())) continue;
                    if (equipmentVO.getIsLargeEquipment() != null) {
                        parameter.setIsLargeEquipment(equipmentVO.getIsLargeEquipment());
                        continue;
                    }
                    parameter.setIsLargeEquipment("2");
                }
            }
            parameter.setSourceType("\u8d2d\u7f6e");
            parameterList.add(parameter);
        }
        this.logger.info("\u5904\u7406\u53f0\u8d26\u4e3b\u8868\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString(parameterList));
        this.temporarySettlementApi.pushRentParameterBatch(parameterList);
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        CommonResponse resp = this.billTypeApi.checkQuote(billTypeCode, billId);
        if (!resp.isSuccess()) {
            return CommonResponse.error((String)("\u65e0\u6cd5\u64a4\u56de\uff01" + resp.getMsg()));
        }
        PurchaseAcceptanceEntity e = (PurchaseAcceptanceEntity)((Object)this.service.selectById(billId));
        QueryParam params = new QueryParam();
        params.getParams().put("pid", new Parameter("eq", (Object)billId));
        List subEntityList = this.subService.queryList(params);
        this.logger.info("11111111111111---------->: {}", (Object)JSONObject.toJSONString((Object)subEntityList));
        PurchaseAcceptanceSubEntity subEntity = (PurchaseAcceptanceSubEntity)((Object)subEntityList.get(0));
        this.logger.info("22222222222222---------->: {}", (Object)JSONObject.toJSONString((Object)((Object)subEntity)));
        UserContext userContext = this.sessionManager.getUserContext();
        PurchaseContractEntity contractEntity = (PurchaseContractEntity)((Object)this.contractService.selectById(e.getContractId()));
        this.logger.info("333333333333333---------->: {}", (Object)JSONObject.toJSONString((Object)((Object)contractEntity)));
        QueryParam param = new QueryParam();
        param.getParams().put("contractId", new Parameter("eq", (Object)contractEntity.getId()));
        param.getParams().put("docCategoryId", new Parameter("eq", (Object)subEntity.getEquipmentTypeId()));
        param.getParams().put("docId", new Parameter("eq", (Object)subEntity.getEquipmentId()));
        List equipmentList = this.equipmentDetailedService.queryList(param);
        this.logger.info("4444444444444444---------->: {}", (Object)JSONObject.toJSONString((Object)equipmentList));
        EquipmentDetailedEntity equipmentDetailedEntity = (EquipmentDetailedEntity)((Object)equipmentList.get(0));
        this.logger.info("555555555555555555---------->: {}", (Object)JSONObject.toJSONString((Object)((Object)equipmentDetailedEntity)));
        if (equipmentDetailedEntity.getAcceptanceQuantity() == null) {
            equipmentDetailedEntity.setAcceptanceQuantity(0);
        } else {
            equipmentDetailedEntity.setAcceptanceQuantity(equipmentDetailedEntity.getAcceptanceQuantity() - 1);
        }
        this.equipmentDetailedService.saveOrUpdate((Object)equipmentDetailedEntity);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"purchase_acceptance_id", (Object)billId);
        List list = this.assetService.list((Wrapper)queryWrapper);
        AssetEntity assetEntity = (AssetEntity)((Object)list.get(0));
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            CommonResponse response = this.billTypeApi.checkQuote("EJCBT202206000070", assetEntity.getId());
            if (!response.isSuccess()) {
                return CommonResponse.error((String)("\u9a8c\u6536\u751f\u6210\u7684\u56fa\u5b9a\u8d44\u4ea7\u5361\u7247\u88ab\u4e0b\u6e38\u5f15\u7528\u65e0\u6cd5\u64a4\u56de\uff01" + resp.getMsg()));
            }
            this.assetService.removeById(assetEntity.getId());
        }
        return CommonResponse.success((String)"\u91c7\u8d2d\u9a8c\u6536\u5904\u7406\u6210\u529f\uff01");
    }
}

