package com.ejianc.business.acceptance.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.acceptance.bean.PurchaseAcceptanceEntity;
import com.ejianc.business.acceptance.bean.PurchaseAcceptanceSubEntity;
import com.ejianc.business.acceptance.service.IPurchaseAcceptanceService;
import com.ejianc.business.acceptance.service.IPurchaseAcceptanceSubService;
import com.ejianc.business.asset.bean.AssetEntity;
import com.ejianc.business.asset.service.IAssetService;
import com.ejianc.business.purchase.bean.EquipmentDetailedEntity;
import com.ejianc.business.purchase.bean.PurchaseContractEntity;
import com.ejianc.business.purchase.service.IEquipmentDetailedService;
import com.ejianc.business.purchase.service.IPurchaseContractService;
import com.ejianc.business.rent.vo.RentParameterDetailVO;
import com.ejianc.business.rent.vo.RentParameterVO;
import com.ejianc.business.temporary.settlement.api.ITemporarySettlementApi;
import com.ejianc.foundation.share.api.IShareEquipmentApi;
import com.ejianc.foundation.share.vo.EquipmentVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

@Service("purchaseAcceptance") 
public class PurchaseAcceptanceBpmServiceImpl implements ICommonBusinessService {
	private Logger logger = LoggerFactory.getLogger(this.getClass());
	@Autowired
	private IBillTypeApi billTypeApi;
	@Autowired
	private SessionManager sessionManager;
	@Autowired
	private IPurchaseAcceptanceService service;
	@Autowired
	private IPurchaseContractService contractService;
	@Autowired
	private IEquipmentDetailedService equipmentDetailedService;
	@Autowired
	private IPurchaseAcceptanceSubService subService;
	@Autowired
	private IAssetService assetService;
	@Autowired
	private IShareEquipmentApi shareEquipmentApi;
	@Autowired
	private ITemporarySettlementApi temporarySettlementApi;
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		//这个地方写推送 固定资产 和其他的业务区分开
		QueryWrapper<AssetEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("purchase_acceptance_id",billId);
		List<AssetEntity> list = assetService.list(queryWrapper);
		if (CollectionUtils.isEmpty(list)){
			assetService.pushAsset(billId);
		}
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		PurchaseAcceptanceEntity e = service.selectById(billId);
		QueryParam params = new QueryParam();
		params.getParams().put("pid",new Parameter(QueryParam.EQ,billId));
		List<PurchaseAcceptanceSubEntity> subEntityList = subService.queryList(params);
		logger.info("11111111111111---------->: {}", JSONObject.toJSONString(subEntityList));
		PurchaseAcceptanceSubEntity subEntity = subEntityList.get(0);
		logger.info("22222222222222---------->: {}", JSONObject.toJSONString(subEntity));
		UserContext userContext = sessionManager.getUserContext();
		PurchaseContractEntity contractEntity = contractService.selectById(e.getContractId());
		logger.info("333333333333333---------->: {}", JSONObject.toJSONString(contractEntity));
		QueryParam param = new QueryParam();
		param.getParams().put("contractId",new Parameter(QueryParam.EQ,contractEntity.getId()));
		param.getParams().put("docCategoryId",new Parameter(QueryParam.EQ,subEntity.getEquipmentTypeId()));
		param.getParams().put("docId",new Parameter(QueryParam.EQ,subEntity.getEquipmentId()));
		List<EquipmentDetailedEntity> equipmentList = equipmentDetailedService.queryList(param);
		logger.info("4444444444444444---------->: {}", JSONObject.toJSONString(equipmentList));
		EquipmentDetailedEntity equipmentDetailedEntity = equipmentList.get(0);
		logger.info("555555555555555555---------->: {}", JSONObject.toJSONString(equipmentDetailedEntity));
		if(equipmentDetailedEntity.getAcceptanceQuantity() == null){
			equipmentDetailedEntity.setAcceptanceQuantity(1);
		}else{
			equipmentDetailedEntity.setAcceptanceQuantity(equipmentDetailedEntity.getAcceptanceQuantity()+1);
		}
		equipmentDetailedService.saveOrUpdate(equipmentDetailedEntity);


		//推送设备记录表-不再推送
//		pushRentParameter(e);
		return CommonResponse.success("使用记录审批回调处理成功！");
	}

	private void pushRentParameter(PurchaseAcceptanceEntity entity) {
		List<RentParameterVO> parameterList = new ArrayList<>();
		List<PurchaseAcceptanceSubEntity> acceptanceSubList = entity.getPurchaseAcceptanceSubList();
		PurchaseContractEntity contractEntity = contractService.selectById(entity.getContractId());
		//获取是否大型设备
		List<Long> equipmentIds = acceptanceSubList.stream().map(PurchaseAcceptanceSubEntity::getEquipmentId).collect(Collectors.toList());
		CommonResponse<List<EquipmentVO>> listCommonResponse = shareEquipmentApi.queryEquipmentItemByIds(equipmentIds);

		logger.info("获取设备档案信息开始:{}",JSONObject.toJSONString(listCommonResponse));
		List<EquipmentVO> equipmentVOList=new ArrayList<>();
		if (listCommonResponse.getCode() == 0){
			logger.info("获取设备档案信息成功！");
			equipmentVOList = listCommonResponse.getData();
		}

		for (PurchaseAcceptanceSubEntity e : acceptanceSubList) {
			RentParameterVO parameter = new RentParameterVO();
			// 验收信息
			parameter.setContractId(entity.getContractId());//合同id
			parameter.setContractName(entity.getContractName()); // 合同名称
			parameter.setEngineeringId(entity.getProjectId()); // 工程id
			parameter.setEngineeringName(entity.getProjectName()); // 工程名称
			parameter.setSupplierId(entity.getSupplierId()); // 供应商id
			parameter.setSupplierName(entity.getSupplierName()); // 供应商名称
			parameter.setProjectId(entity.getProjectId()); // 项目id
			parameter.setProjectCode(entity.getProjectCode()); // 项目code
			parameter.setProjectName(entity.getProjectName()); // 项目名称
			parameter.setAcceptanceId(entity.getId()); // 验收单id
			parameter.setAcceptanceDate(entity.getAcceptanceDate()); // 验收日期
			parameter.setSourceId(entity.getId()); // 来源id
			// 合同信息
			if (contractEntity != null) {//存在无合同验收的情况
				parameter.setOrgId(contractEntity.getOrgId()); // 组织id
				parameter.setOrgName(contractEntity.getOrgName()); // 组织名称
				parameter.setParentOrgId(contractEntity.getParentOrgId());
				parameter.setParentOrgCode(contractEntity.getParentOrgCode());
				parameter.setParentOrgName(contractEntity.getParentOrgName());
//				parameter.setRentHarborType(contractEntity.getRentHarborType().equals("内租") ? 1 : 2);
			}else {
				parameter.setOrgId(entity.getOrgId()); // 组织id
				parameter.setOrgName(entity.getOrgName()); // 组织名称
				parameter.setParentOrgId(entity.getParentOrgId());
				parameter.setParentOrgCode(entity.getParentOrgCode());
				parameter.setParentOrgName(entity.getParentOrgName());
			}
			// 设备信息
			parameter.setFactoryCode(e.getEquipmentCode()); // 设备出厂编码
			parameter.setCategoryId(e.getEquipmentTypeId()); // 设备类别id
			parameter.setCategoryName(e.getEquipmentType()); // 设备类别名称
			parameter.setSpec(e.getSpec()); // 规格型号
			parameter.setUnitName(e.getCompany()); // 计量单位

			parameter.setStartDate(entity.getAcceptanceDate());

//			parameter.setPlanIntoDate(e.getPlanIntoDate()); // 计划进厂日期
//			parameter.setPlanOutDate(e.getPlanOutDate()); // 计划出厂日期
			parameter.setProductionManufactor(e.getManufacturer()); // 生产厂家
			parameter.setMemo(e.getDetailMemo()); // 备注
			parameter.setEquipmentCode(e.getEquipmentCode()); // 设备编号
			parameter.setEquipmentId(e.getEquipmentId()); // 设备id
			parameter.setName(e.getEquipmentName()); // 设备id
			parameter.setNum(e.getContractNum().intValue());
//			parameter.setRentNum(e.getNum()); // 租赁数量
//			parameter.setRentTypeId(e.getRentTypeId()); // 租赁方式id
//			parameter.setRentTypeName(e.getRentTypeName()); // 租赁方式名称
			parameter.setAcceptanceDetailId(e.getId()); // 验收单明细id
			parameter.setEquipmentName(e.getEquipmentName()); // 设备名称
			parameter.setPrice(e.getPurchasePrice()); // 有税单价
//			parameter.setNotTaxPrice(e.getPurchasePrice()); // 无税单价
//			parameter.setMeterRentDate(e.getMeterRentDate()); // 计租日期
			parameter.setOperationDate(new Date()); // 操作日期
			parameter.setEquipmentState(2);//RentEquipmentStateEnum.启用.getCode()
//			parameter.setQuantitiesNum(e.getQuantitiesNum() == null ? BigDecimal.ZERO : e.getQuantitiesNum());
//			parameter.setEquipmentCost(); // 设备费用
			//是否特种设备
			if (equipmentVOList.size()>0){
				for (EquipmentVO equipmentVO : equipmentVOList) {
					if (equipmentVO.getId().equals(e.getEquipmentId())){
						if (equipmentVO.getIsLargeEquipment() != null) {
							parameter.setIsLargeEquipment(equipmentVO.getIsLargeEquipment());
						}else {
							parameter.setIsLargeEquipment("2");
						}
					}
				}
			}
			parameter.setSourceType("购置");
//			RentParameterDetailVO detailEntity = new RentParameterDetailVO();
//			detailEntity.setEquipmentState(2);//RentEquipmentStateEnum.启用.getCode()
//			detailEntity.setOperationDate(e.getMeterRentDate());
//			detailEntity.setSourceId(rentAcceptanceEntity.getId());
//			detailEntity.setSourceType(RentParameterTypeEnum.验收单.getCode());
//			List<RentParameterDetailEntity> detailEntityList = new ArrayList<>();
//			detailEntityList.add(detailEntity);
//
//			parameter.setRentParameterDetailList(detailEntityList);
			parameterList.add(parameter);
		}
		logger.info("处理台账主表数据：{}", JSONObject.toJSONString(parameterList));
		temporarySettlementApi.pushRentParameterBatch(parameterList);
							//		List<RentParameterDetailEntity> addParameterDetailList = new ArrayList<>();
							//		for (RentParameterEntity entity : parameterList) {
							//			List<RentParameterDetailEntity> detailEntityList = entity.getRentParameterDetailList();
							//			for (RentParameterDetailEntity detailEntity : detailEntityList) {
							//				detailEntity.setParameterId(entity.getId());
							//			}
							//			addParameterDetailList.addAll(detailEntityList);
							//		}
							//		logger.info("处理台账子表数据：{}", JSONObject.toJSONString(addParameterDetailList));
							//		parameterDetailService.saveOrUpdateBatch(addParameterDetailList);
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//		 参数是单据类型编码字符串 根据需求是否打开下面代码
        CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
        if(!resp.isSuccess()){
            return CommonResponse.error("无法撤回！"+resp.getMsg());
        }
		PurchaseAcceptanceEntity e = service.selectById(billId);
		QueryParam params = new QueryParam();
		params.getParams().put("pid",new Parameter(QueryParam.EQ,billId));
		List<PurchaseAcceptanceSubEntity> subEntityList = subService.queryList(params);
		logger.info("11111111111111---------->: {}", JSONObject.toJSONString(subEntityList));
		PurchaseAcceptanceSubEntity subEntity = subEntityList.get(0);
		logger.info("22222222222222---------->: {}", JSONObject.toJSONString(subEntity));
		UserContext userContext = sessionManager.getUserContext();
		PurchaseContractEntity contractEntity = contractService.selectById(e.getContractId());
		logger.info("333333333333333---------->: {}", JSONObject.toJSONString(contractEntity));
		QueryParam param = new QueryParam();
		param.getParams().put("contractId",new Parameter(QueryParam.EQ,contractEntity.getId()));
		param.getParams().put("docCategoryId",new Parameter(QueryParam.EQ,subEntity.getEquipmentTypeId()));
		param.getParams().put("docId",new Parameter(QueryParam.EQ,subEntity.getEquipmentId()));
		List<EquipmentDetailedEntity> equipmentList = equipmentDetailedService.queryList(param);
		logger.info("4444444444444444---------->: {}", JSONObject.toJSONString(equipmentList));
		EquipmentDetailedEntity equipmentDetailedEntity = equipmentList.get(0);
		logger.info("555555555555555555---------->: {}", JSONObject.toJSONString(equipmentDetailedEntity));
		if(equipmentDetailedEntity.getAcceptanceQuantity() == null){
			equipmentDetailedEntity.setAcceptanceQuantity(0);
		}else{
			equipmentDetailedEntity.setAcceptanceQuantity(equipmentDetailedEntity.getAcceptanceQuantity()-1);
		}
		equipmentDetailedService.saveOrUpdate(equipmentDetailedEntity);
        //弃审删除固定资产卡片
		QueryWrapper<AssetEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("purchase_acceptance_id",billId);
		List<AssetEntity> list = assetService.list(queryWrapper);
		AssetEntity assetEntity = list.get(0);
	    if (CollectionUtils.isNotEmpty(list)){
			CommonResponse<String> response = billTypeApi.checkQuote("EJCBT202206000070", assetEntity.getId());
			if(!response.isSuccess()){
				return CommonResponse.error("验收生成的固定资产卡片被下游引用无法撤回！"+resp.getMsg());
			}else {
				assetService.removeById(assetEntity.getId());
			}
		}
		return CommonResponse.success("采购验收处理成功！");
	}

}
